/*
 * Decompiled with CFR 0.152.
 */
package com.informix.jdbc;

import com.informix.jdbc.IfmxComplexSQLInput;
import com.informix.jdbc.IfxArray;
import com.informix.jdbc.IfxCollection;
import com.informix.jdbc.IfxColumnInfo;
import com.informix.jdbc.IfxComplex;
import com.informix.jdbc.IfxComplexOutput;
import com.informix.jdbc.IfxConnection;
import com.informix.jdbc.IfxObject;
import com.informix.jdbc.IfxSQLInput;
import com.informix.jdbc.IfxSqliConnect;
import com.informix.jdbc.IfxStruct;
import com.informix.jdbc.IfxUDTInfo;
import com.informix.jdbc.IfxValue;
import com.informix.jdbc.IfxVarChar;
import com.informix.lang.IfxToJavaType;
import com.informix.lang.IfxTypes;
import com.informix.lang.Interval;
import com.informix.lang.JavaToIfxType;
import com.informix.util.IfxErrMsg;
import com.informix.util.Trace;
import com.informix.util.TraceFlag;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.RowId;
import java.sql.SQLData;
import java.sql.SQLException;
import java.sql.SQLXML;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public class IfxComplexInput
extends IfxSQLInput
implements IfmxComplexSQLInput {
    private static final Object logger = Trace.getLoggerForClass(IfxComplexInput.class);
    private List<IfxColumnInfo> parentTypeInfoVector = null;
    private List<IfxColumnInfo> typeInfoVector = null;
    private List<Integer> elementOffsetVector = null;
    private int typeIndex = -1;
    private boolean isRow = false;
    private boolean isStruct = false;
    private int currentIfxType;
    private int currentExtendedId;
    private String currentExtendedName;
    private int currentIfxLength;
    private int currentSourceType;
    private Map<String, Class<?>> typeMap = null;
    private boolean isNested = false;
    private List<IfxObject> ifxObjectVector = null;

    IfxComplexInput(byte[] b, int index, int length, List<IfxColumnInfo> typeInfo, boolean isNested, IfxConnection conn) throws SQLException {
        super(conn, b, index, length);
        this.isNested = isNested;
        this.parentTypeInfoVector = typeInfo;
        IfxColumnInfo colInfo = typeInfo.get(0);
        if (colInfo.SQLtype == 22) {
            this.isRow = true;
        } else {
            this.isRow = false;
            this.typeIndex = 0;
        }
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 1, "IfxComplexInput: index: " + index + "  length " + length);
            this.trace.writeTrace(logger, 1, " parent type: " + colInfo.SQLtype);
        }
        this.typeInfoVector = this.parentTypeInfoVector.get((int)0).child;
        colInfo = this.typeInfoVector.get(0);
        this.currentIfxType = colInfo.SQLtype;
        this.currentExtendedId = colInfo.ExtendedId;
        this.currentExtendedName = colInfo.ExtendedName;
        this.currentIfxLength = colInfo.ColLength;
        this.currentSourceType = colInfo.SourceType;
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 2, " child type: " + colInfo.SQLtype);
        }
        this.ifxObjectVector = new ArrayList<IfxObject>(typeInfo.size());
        for (int i = 0; i < this.typeInfoVector.size(); ++i) {
            colInfo = this.typeInfoVector.get(i);
            if (TraceFlag.isTraceEnabled()) {
                this.trace.writeTrace(logger, 2, "    Allocating IfxObject for type: " + colInfo.SQLtype + " with Extended id " + colInfo.ExtendedId);
                this.trace.writeTrace(logger, 2, "    index: " + i);
                colInfo.dumpInfo(this.trace, 4);
            }
            this.ifxObjectVector.add(IfxValue.makeInstance(conn, colInfo));
        }
        if (this.isRow || IfxTypes.isUDT(this.currentIfxType) || IfxTypes.isComplexType(this.currentIfxType) || this.currentIfxType == 13) {
            if (TraceFlag.isTraceEnabled()) {
                this.trace.writeTrace(logger, 2, "   IfxComplexInput() length:" + length);
                this.trace.writeTrace(logger, 2, "   IfxComplexInput() index:" + index);
                if (b != null) {
                    this.trace.writeTrace(logger, 2, "   IfxComplexInput() b.length:" + b.length);
                }
            }
            if (b != null && length > 0) {
                byte[] bInt = new byte[4];
                int position = index + length - 4;
                if (TraceFlag.isTraceEnabled()) {
                    byte[] dump = new byte[length];
                    System.arraycopy(b, index, dump, 0, length);
                    this.trace.writeTrace(logger, 2, "   IfxComplexInput() data:");
                    this.trace.writeTrace(logger, 2, dump, 'B');
                }
                this.elementOffsetVector = new ArrayList<Integer>();
                while (position > 0) {
                    System.arraycopy(b, position, bInt, 0, 4);
                    int offset = IfxToJavaType.IfxToJavaInt(bInt);
                    if (TraceFlag.isTraceEnabled()) {
                        this.trace.writeTrace(logger, 3, "  offset position at " + position + " is " + offset);
                    }
                    if (offset == -1) break;
                    this.elementOffsetVector.add(offset);
                    position -= 4;
                }
                if (TraceFlag.isTraceEnabled()) {
                    this.trace.writeTrace(logger, 2, "  ***** dump offset array begin ****");
                    this.trace.writeTrace(logger, 2, "    size of offset array: " + this.elementOffsetVector.size());
                    for (int i = 0; i < this.elementOffsetVector.size(); ++i) {
                        this.trace.writeTrace(logger, 2, "      value: " + this.elementOffsetVector.get(i).toString());
                    }
                    this.trace.writeTrace(logger, 2, "  ***** dump offset array end ****");
                }
            }
        }
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 1, "IfxComplexInput() constructor exited");
        }
    }

    void setTypeMap(Map<String, Class<?>> map) {
        this.typeMap = map;
    }

    @Override
    public Blob readBlob() throws SQLException {
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 1, "IfxComplexInput.readBlob() entered");
        }
        if (this.isRow && !this.isStruct) {
            this.getNextType();
        }
        if (this.currentExtendedId != 10) {
            IfxComplex.badTypeException(this.currentIfxType, (short)102, this.trace, null);
        }
        IfxObject ifxObject = this.convLob();
        Blob blob = null;
        if (!ifxObject.isNull()) {
            blob = ifxObject.toBlob();
        }
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 1, "IfxComplexInput.readBlob() exited");
        }
        return blob;
    }

    @Override
    public Clob readClob() throws SQLException {
        String locale = null;
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 1, "IfxComplexInput.readClob() entered");
        }
        if (this.conn != null) {
            locale = this.conn.getclLocale();
        }
        if (this.isRow && !this.isStruct) {
            this.getNextType();
        }
        if (this.currentExtendedId != 11) {
            IfxComplex.badTypeException(this.currentIfxType, (short)101, this.trace, locale);
        }
        Clob clob = null;
        IfxObject ifxObject = this.convLob();
        if (!ifxObject.isNull()) {
            clob = ifxObject.toClob();
        }
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 1, "IfxComplexInput.readClob() exited");
        }
        return clob;
    }

    @Override
    public byte readByte() throws SQLException {
        throw IfxErrMsg.getSQLException(-79700, ": IfxComplexInput.readByte().");
    }

    @Override
    public Date readDate() throws SQLException {
        Date val = null;
        String locale = null;
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 1, "IfxComplexInput.readDate() called");
        }
        if (this.conn != null) {
            locale = this.conn.getclLocale();
        }
        if (this.isRow && !this.isStruct) {
            this.getNextType();
        }
        if (this.currentIfxType == 7) {
            val = super.readDate();
        } else {
            IfxComplex.badTypeException(this.currentIfxType, (short)7, this.trace, locale);
        }
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 2, "  Date val: " + val);
        }
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 1, "IfxComplexInput.readDate() exited");
        }
        return val;
    }

    @Override
    public double readDouble() throws SQLException {
        double val = 0.0;
        String locale = null;
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 1, "IfxComplexInput.readDouble() called");
        }
        if (this.conn != null) {
            locale = this.conn.getclLocale();
        }
        if (this.isRow && !this.isStruct) {
            this.getNextType();
        }
        if (this.currentIfxType == 3) {
            val = super.readDouble();
        } else {
            IfxComplex.badTypeException(this.currentIfxType, (short)3, this.trace, locale);
        }
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 2, "  Double val: " + val);
        }
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 1, "IfxComplexInput.readDouble() exited");
        }
        return val;
    }

    @Override
    public float readFloat() throws SQLException {
        float val = 0.0f;
        String locale = null;
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 1, "IfxComplexInput.readFloat() called");
        }
        if (this.conn != null) {
            locale = this.conn.getclLocale();
        }
        if (this.isRow && !this.isStruct) {
            this.getNextType();
        }
        if (this.currentIfxType == 4) {
            val = super.readFloat();
        } else {
            IfxComplex.badTypeException(this.currentIfxType, (short)4, this.trace, locale);
        }
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 2, "  Float val: " + val);
        }
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 1, "IfxComplexInput.readFloat() exited");
        }
        return val;
    }

    @Override
    public int readInt() throws SQLException {
        int val = 0;
        String locale = null;
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 1, "IfxComplexInput.readInt() called");
        }
        if (this.conn != null) {
            locale = this.conn.getclLocale();
        }
        if (this.isRow && !this.isStruct) {
            this.getNextType();
        }
        if (this.currentIfxType == 2 || this.currentIfxType == 6) {
            val = super.readInt();
        } else {
            IfxComplex.badTypeException(this.currentIfxType, (short)2, this.trace, locale);
        }
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 2, "  Integer val: " + val);
        }
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 1, "IfxComplexInput.readInt() exited");
        }
        return val;
    }

    @Override
    public long readLong() throws SQLException {
        long val = 0L;
        String locale = null;
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 1, "IfxComplexInput.readLong() called");
        }
        if (this.conn != null) {
            locale = this.conn.getclLocale();
        }
        if (this.isRow && !this.isStruct) {
            this.getNextType();
        }
        if (this.currentIfxType == 17 || this.currentIfxType == 18) {
            val = super.readLong();
        } else {
            IfxComplex.badTypeException(this.currentIfxType, (short)17, this.trace, locale);
        }
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 2, "  Long val: " + val);
        }
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 1, "IfxComplexInput.readLong() exited");
        }
        return val;
    }

    @Override
    public long readLongBigint() throws SQLException {
        long val = 0L;
        String locale = null;
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 1, "IfxComplexInput.readLongBigint() called");
        }
        if (this.conn != null) {
            locale = this.conn.getclLocale();
        }
        if (this.isRow && !this.isStruct) {
            this.getNextType();
        }
        if (this.currentIfxType == 52 || this.currentIfxType == 53) {
            val = super.readLongBigint();
        } else {
            IfxComplex.badTypeException(this.currentIfxType, (short)52, this.trace, locale);
        }
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 2, "  Long val: " + val);
        }
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 1, "IfxComplexInput.readLongBigint() exited");
        }
        return val;
    }

    @Override
    public short readShort() throws SQLException {
        short val = 0;
        String locale = null;
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 1, "IfxComplexInput.readShort() called");
        }
        if (this.conn != null) {
            locale = this.conn.getclLocale();
        }
        if (this.isRow && !this.isStruct) {
            this.getNextType();
        }
        if (this.currentIfxType == 1) {
            val = super.readShort();
        } else {
            IfxComplex.badTypeException(this.currentIfxType, (short)1, this.trace, locale);
        }
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 2, "  Short val: " + val);
        }
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 1, "IfxComplexInput.readShort() exited");
        }
        return val;
    }

    @Override
    public Time readTime() throws SQLException {
        byte[] b = null;
        int len = 0;
        String locale = null;
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 1, "IfxComplexInput.readTime() called");
        }
        if (this.conn != null) {
            locale = this.conn.getclLocale();
        }
        if (this.isRow && !this.isStruct) {
            this.getNextType();
        }
        IfxObject ifxObject = this.ifxObjectVector.get(this.typeIndex);
        if (this.currentIfxType == 10) {
            len = this.getLength(this.currentIfxLength);
            if (TraceFlag.isTraceEnabled()) {
                this.trace.writeTrace(logger, 2, "   ifxObject class: " + ifxObject.getClass().getName());
                this.trace.writeTrace(logger, 2, "   currentIfxLength: " + this.currentIfxLength);
                this.trace.writeTrace(logger, 2, "   real length: " + len);
            }
            b = new byte[len];
            this.bStream.read(b, 0, len);
            ifxObject.fromIfx(b, (short)this.currentIfxLength);
            this.isNull = ifxObject.isNull();
        } else {
            IfxComplex.badTypeException(this.currentIfxType, (short)10, this.trace, locale);
        }
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 1, "IfxComplexInput.readTime() exited");
        }
        return ifxObject.toTime();
    }

    @Override
    public Timestamp readTimestamp() throws SQLException {
        String locale = null;
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 1, "IfxComplexInput.readTimestamp() called");
        }
        if (this.conn != null) {
            locale = this.conn.getclLocale();
        }
        byte[] b = null;
        int len = 0;
        if (this.isRow && !this.isStruct) {
            this.getNextType();
        }
        IfxObject ifxObject = this.ifxObjectVector.get(this.typeIndex);
        if (this.currentIfxType == 10) {
            len = this.getLength(this.currentIfxLength);
            if (TraceFlag.isTraceEnabled()) {
                this.trace.writeTrace(logger, 2, "   ifxObject class: " + ifxObject.getClass().getName());
                this.trace.writeTrace(logger, 2, "   currentIfxLength: " + this.currentIfxLength);
                this.trace.writeTrace(logger, 2, "   real length: " + len);
            }
            b = new byte[len];
            this.bStream.read(b, 0, len);
            ifxObject.fromIfx(b, (short)this.currentIfxLength);
            this.isNull = ifxObject.isNull();
        } else {
            IfxComplex.badTypeException(this.currentIfxType, (short)10, this.trace, locale);
        }
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 1, "IfxComplexInput.readTimestamp() exited");
        }
        return ifxObject.toTimestamp();
    }

    private int getLength(int encodedLength) {
        return ((encodedLength >> 8 & 0xFF) + (encodedLength & 0xFF & 1) + 3) / 2;
    }

    @Override
    public Interval readInterval() throws SQLException {
        String locale = null;
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 1, "IfxComplexInput.readInterval() called");
        }
        if (this.conn != null) {
            locale = this.conn.getclLocale();
        }
        if (this.isRow && !this.isStruct) {
            this.getNextType();
        }
        IfxObject ifxObject = this.ifxObjectVector.get(this.typeIndex);
        if (this.currentIfxType == 14) {
            byte[] b = null;
            int len = 0;
            len = this.getLength(this.currentIfxLength);
            if (TraceFlag.isTraceEnabled()) {
                this.trace.writeTrace(logger, 2, "   ifxObject class: " + ifxObject.getClass().getName());
                this.trace.writeTrace(logger, 2, "   currentIfxLength: " + this.currentIfxLength);
                this.trace.writeTrace(logger, 2, "   real length: " + len);
            }
            b = new byte[len];
            this.bStream.read(b, 0, len);
            ifxObject.fromIfx(b, (short)this.currentIfxLength);
            if (TraceFlag.isTraceEnabled()) {
                this.trace.writeTrace(logger, 2, "   data: " + ifxObject.toString());
            }
            this.isNull = ifxObject.isNull();
        } else {
            IfxComplex.badTypeException(this.currentIfxType, (short)14, this.trace, locale);
        }
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 1, "IfxComplexInput.readInterval() exited");
        }
        return (Interval)ifxObject.toObject();
    }

    @Override
    public BigDecimal readBigDecimal() throws SQLException {
        String locale = null;
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 1, "IfxComplexInput.readBigDecimal() called");
        }
        if (this.conn != null) {
            locale = this.conn.getclLocale();
        }
        byte[] b = null;
        int len = 0;
        if (this.isRow && !this.isStruct) {
            this.getNextType();
        }
        IfxObject ifxObject = this.ifxObjectVector.get(this.typeIndex);
        if (this.currentIfxType == 5 || this.currentIfxType == 8) {
            len = this.getLength(this.currentIfxLength);
            if (TraceFlag.isTraceEnabled()) {
                this.trace.writeTrace(logger, 2, "   ifxObject class: " + ifxObject.getClass().getName());
                this.trace.writeTrace(logger, 2, "   currentIfxLength: " + this.currentIfxLength);
                this.trace.writeTrace(logger, 2, "   real length: " + len);
            }
            b = new byte[len];
            this.bStream.read(b, 0, len);
            ifxObject.fromIfx(b, (short)this.currentIfxLength);
            this.isNull = ifxObject.isNull();
        } else {
            IfxComplex.badTypeException(this.currentIfxType, (short)5, this.trace, locale);
        }
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 1, "IfxComplexInput.readBigDecimal() exited");
        }
        return (BigDecimal)ifxObject.toObject();
    }

    @Override
    public boolean readBoolean() throws SQLException {
        String locale = null;
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 1, "IfxComplexInput.readBoolean() called");
        }
        if (this.conn != null) {
            locale = this.conn.getclLocale();
        }
        byte[] b = null;
        if (this.isRow && !this.isStruct) {
            this.getNextType();
        }
        IfxObject ifxObject = this.ifxObjectVector.get(this.typeIndex);
        if (this.currentIfxType == 45 || this.currentIfxType == 41 && this.currentExtendedId == 5) {
            b = new byte[6];
            this.bStream.read(b, 0, 6);
            ifxObject.fromIfx(b);
            this.isNull = ifxObject.isNull();
        } else {
            IfxComplex.badTypeException(this.currentIfxType, (short)45, this.trace, locale);
        }
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 1, "IfxComplexInput.readBoolean() exited");
        }
        return ifxObject.toBoolean();
    }

    @Override
    public String readString() throws SQLException {
        String locale = null;
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 1, "IfxComplexInput.readString() called");
        }
        if (this.conn != null) {
            locale = this.conn.getclLocale();
        }
        if (this.isRow && !this.isStruct) {
            this.getNextType();
        }
        if (this.currentIfxType == 40 && (this.currentSourceType == 1 || this.currentExtendedId == 1)) {
            if (TraceFlag.isTraceEnabled()) {
                this.trace.writeTrace(logger, 2, "    readString() calling readUDT() for lvarchar");
            }
            return (String)this.readUDT(true);
        }
        String val = null;
        byte[] b = null;
        IfxObject ifxObject = this.ifxObjectVector.get(this.typeIndex);
        if (this.currentIfxType == 13 || this.currentIfxType == 16) {
            if (TraceFlag.isTraceEnabled()) {
                this.trace.writeTrace(logger, 2, "    readString() it's an VARCHAR");
                this.trace.writeTrace(logger, 2, "   currentIfxLength: " + this.currentIfxLength);
            }
            b = new byte[1];
            this.bStream.read(b, 0, 1);
            int size = b[0] & 0xFF;
            b = new byte[size + 1];
            b[0] = (byte)size;
            this.bStream.read(b, 1, size);
        } else if (this.currentIfxType == 0 || this.currentIfxType == 15) {
            if (TraceFlag.isTraceEnabled()) {
                this.trace.writeTrace(logger, 2, "    readString() it's an CHAR");
                this.trace.writeTrace(logger, 2, "   currentIfxLength: " + this.currentIfxLength);
            }
            b = new byte[this.currentIfxLength];
            this.bStream.read(b, 0, this.currentIfxLength);
        } else {
            IfxComplex.badTypeException(this.currentIfxType, (short)0, this.trace, locale);
        }
        ifxObject.fromIfx(b);
        val = ifxObject.toString();
        this.isNull = ifxObject.isNull();
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 2, "  String val: '" + val + "'");
            this.trace.writeTrace(logger, 1, "IfxComplexInput.readString() exited");
        }
        return val;
    }

    @Override
    public Object readObject() throws SQLException {
        Object obj;
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 1, "IfxComplexInput.readObject() called");
        }
        int nextIfxType = this.currentIfxType;
        int nextExtendedId = this.currentExtendedId;
        String nextExtendedName = this.currentExtendedName;
        int nextIfxLength = this.currentIfxLength;
        int nextSourceType = this.currentSourceType;
        if (this.isRow && !this.isStruct) {
            if (this.typeIndex + 1 < this.typeInfoVector.size()) {
                IfxColumnInfo colInfo = this.typeInfoVector.get(this.typeIndex + 1);
                nextIfxType = colInfo.SQLtype;
                nextExtendedId = colInfo.ExtendedId;
                nextExtendedName = colInfo.ExtendedName;
                nextIfxLength = colInfo.ColLength;
                nextSourceType = colInfo.SourceType;
            } else {
                throw IfxErrMsg.getSQLException(-79773);
            }
        }
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 2, "    readObject() Informx type: " + nextIfxType);
        }
        switch (nextIfxType) {
            case 40: 
            case 41: {
                if (nextExtendedId <= 11) {
                    throw IfxErrMsg.getSQLException(-79777);
                }
                obj = this.readUDT(false);
                break;
            }
            case 19: 
            case 20: 
            case 21: 
            case 22: {
                obj = this.readNestedComplex().toObject();
                break;
            }
            case 14: {
                obj = this.readInterval();
                break;
            }
            default: {
                throw IfxErrMsg.getSQLException(-79777);
            }
        }
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 1, "IfxComplexInput.readObject() exited");
        }
        return obj;
    }

    public String readString(Collection<String> collObj) throws SQLException {
        String locale = null;
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 1, "IfxComplexInput.readString() called");
        }
        if (this.conn != null) {
            locale = this.conn.getclLocale();
        }
        if (this.isRow && !this.isStruct) {
            this.getNextType();
        }
        if (this.currentIfxType == 40 && (this.currentSourceType == 1 || this.currentExtendedId == 1)) {
            if (TraceFlag.isTraceEnabled()) {
                this.trace.writeTrace(logger, 2, "    readString() calling readUDT() for lvarchar");
            }
            String str = (String)this.readUDT(true);
            collObj.add(str);
            return str;
        }
        String val = null;
        byte[] b = null;
        IfxObject ifxObject = this.ifxObjectVector.get(this.typeIndex);
        if (this.currentIfxType == 13 || this.currentIfxType == 16) {
            if (TraceFlag.isTraceEnabled()) {
                this.trace.writeTrace(logger, 2, "    readString() it's an VARCHAR");
                this.trace.writeTrace(logger, 2, "   currentIfxLength: " + this.currentIfxLength);
            }
            byte[] b0 = new byte[1];
            this.bStream.read(b0, 0, 1);
            int size = b0[0] & 0xFF;
            b = new byte[size + 1];
            b[0] = b0[0];
            int cnt = this.bStream.read(b, 1, size);
            if (b0[0] != -1 || cnt < 3 || b[1] != -1 || b[2] != -1 || b[3] != -1) {
                if (ifxObject instanceof IfxVarChar) {
                    ifxObject.fromIfx(b, ((IfxSqliConnect)this.conn).getclEncoding());
                } else {
                    ifxObject.fromIfx(b);
                }
                val = ifxObject.toString();
                collObj.add(val);
            } else {
                int len = this.bStream.available();
                if (len > 0) {
                    b = new byte[len];
                    this.bStream.read(b, 0, len);
                }
            }
        } else if (this.currentIfxType == 0 || this.currentIfxType == 15) {
            if (TraceFlag.isTraceEnabled()) {
                this.trace.writeTrace(logger, 2, "    readString() it's an CHAR");
                this.trace.writeTrace(logger, 2, "   currentIfxLength: " + this.currentIfxLength);
            }
            b = new byte[this.currentIfxLength];
            this.bStream.read(b, 0, this.currentIfxLength);
            ifxObject.fromIfx(b);
            val = ifxObject.toString();
            collObj.add(val);
        } else {
            IfxComplex.badTypeException(this.currentIfxType, (short)0, this.trace, locale);
        }
        this.isNull = ifxObject.isNull();
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 2, "  String val: '" + val + "'");
            this.trace.writeTrace(logger, 1, "IfxComplexInput.readString() exited");
        }
        return val;
    }

    private IfxObject readNestedComplex() throws SQLException {
        boolean isCTNull;
        Object obj = null;
        byte[] b = null;
        byte[] bInt = new byte[4];
        byte[] bShort = new byte[2];
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 1, "IfxComplexInput.readNestedComplex() entered");
        }
        if (this.isRow && !this.isStruct) {
            this.getNextType();
        }
        IfxComplex ifxObject = (IfxComplex)this.ifxObjectVector.get(this.typeIndex);
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 2, "   bStream.available() " + this.bStream.available());
        }
        this.bStream.read(bShort, 0, 2);
        short size = IfxToJavaType.IfxToJavaSmallInt(bShort);
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 2, "   size: " + size);
        }
        if (size > 0) {
            isCTNull = false;
            if (size > 1) {
                int off = IfxComplexOutput.getUDToffset(this.currentPosition() - 2, this.trace);
                if (TraceFlag.isTraceEnabled()) {
                    this.trace.writeTrace(logger, 2, "   udt offset: " + off);
                }
                b = new byte[off + 2];
                size = (short)(size - (off += 2));
                this.bStream.read(b, 0, off);
                this.bStream.read(bInt, 0, 4);
                int flags = IfxToJavaType.IfxToJavaInt(bInt);
                size = (short)(size - 4);
                if (TraceFlag.isTraceEnabled()) {
                    this.trace.writeTrace(logger, 2, "   flags: " + flags);
                }
            } else {
                isCTNull = true;
            }
            b = new byte[size];
            this.bStream.read(b, 0, size);
            if (TraceFlag.isTraceEnabled()) {
                this.trace.writeTrace(logger, 2, "Collection data");
                this.trace.writeTrace(logger, 2, b, 'B');
            }
        } else {
            throw IfxErrMsg.getSQLException(-79716);
        }
        ifxObject.fromIfx(b, this.typeInfoVector.get(this.typeIndex), isCTNull);
        ifxObject.setTypeMap(this.typeMap);
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 1, "IfxComplexInput.readNestedComplex() exited");
        }
        return ifxObject;
    }

    private Object readUDT(boolean comingFromReadObject) throws SQLException {
        Object obj = null;
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 1, "IfxComplexInput.readUDT() entered");
        }
        if (this.isRow && !this.isStruct && !comingFromReadObject) {
            this.getNextType();
        }
        IfxObject ifxObject = this.ifxObjectVector.get(this.typeIndex);
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 1, "IfxComplexInput.readUDT() classname " + ifxObject.getClass().getName() + "typeIndex is " + this.typeIndex);
        }
        byte[] bFlag = new byte[1];
        this.bStream.read(bFlag, 0, 1);
        byte[] bLen = new byte[4];
        this.bStream.read(bLen, 0, 4);
        if (this.currentIfxType == 40 && bFlag[0] == 1) {
            bLen[3] = 0;
        }
        if (this.currentIfxType == 41 && bFlag[0] == 1) {
            bLen = JavaToIfxType.JavaToIfxInt(ifxObject.getEncodedLength());
        }
        int size = IfxToJavaType.IfxToJavaInt(bLen);
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 1, "IfxComplexInput.readUDT() bFlag " + bFlag + " size " + size);
        }
        byte[] b = new byte[5 + size];
        System.arraycopy(bFlag, 0, b, 0, 1);
        System.arraycopy(bLen, 0, b, 1, 4);
        this.bStream.read(b, 5, size);
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 2, "   readUDT() data:");
            this.trace.writeTrace(logger, 2, b, 'B');
        }
        if (this.currentExtendedId == 1) {
            ifxObject.fromIfx(b, ((IfxSqliConnect)this.conn).getclEncoding());
        } else {
            ifxObject.fromIfx(b);
        }
        this.isNull = ifxObject.isNull();
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 2, "   isNull: " + this.isNull);
        }
        if (this.isNull) {
            obj = null;
        } else {
            if (TraceFlag.isTraceEnabled()) {
                this.trace.writeTrace(logger, 1, " readUDT type is " + ifxObject.toString());
            }
            obj = ifxObject.toObject(true);
        }
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 1, "IfxComplexInput.readUDT() exited");
        }
        return obj;
    }

    Object readRow() throws SQLException {
        Class<?> rowClass;
        Object obj = null;
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 1, "IfxComplexInput.readRow() entered colinfo " + this.parentTypeInfoVector.get(0) + " dbtype is " + this.conn.getDatabaseType());
        }
        if ((rowClass = this.getTypeClass(this.typeMap, this.parentTypeInfoVector.get(0), this.conn.getDatabaseType())) == null) {
            if (TraceFlag.isTraceEnabled()) {
                this.trace.writeTrace(logger, 1, "   readRow() readStruct() called");
            }
            obj = this.readStruct();
        } else {
            try {
                SQLData rowObject = (SQLData)rowClass.newInstance();
                rowObject.readSQL(this, this.parentTypeInfoVector.get((int)0).ExtendedName);
                obj = rowObject;
            }
            catch (SQLException e) {
                throw e;
            }
            catch (Exception e) {
                throw IfxErrMsg.getSQLException(e, -79716);
            }
        }
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 1, "IfxComplexInput.readRow() exited");
        }
        return obj;
    }

    Collection<?> readCollection() throws SQLException {
        Collection collObj;
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 1, "IfxComplexInput.readCollection() entered");
        }
        IfxColumnInfo colInfo = this.parentTypeInfoVector.get(0);
        Class<?> collClass = this.getTypeClass(this.typeMap, colInfo, this.conn.getDatabaseType());
        int ifxType = colInfo.SQLtype;
        if (collClass != null) {
            Object obj;
            if (TraceFlag.isTraceEnabled()) {
                this.trace.writeTrace(logger, 2, "  readCollection() class found: " + collClass.getName());
            }
            try {
                obj = collClass.newInstance();
            }
            catch (Exception e) {
                if (TraceFlag.isTraceEnabled()) {
                    this.trace.writeTrace(logger, 2, "  readCollection() newInstance() failed");
                }
                throw IfxErrMsg.getSQLException(e, -79716);
            }
            if (!(obj instanceof Collection)) {
                if (TraceFlag.isTraceEnabled()) {
                    this.trace.writeTrace(logger, 2, "  readCollection() class not a collection");
                }
                throw IfxErrMsg.getSQLException(-79778);
            }
            collObj = (Collection)obj;
        } else {
            collObj = ifxType == 21 || ifxType == 20 ? new ArrayList() : new HashSet();
        }
        IfxColumnInfo elementColInfo = this.typeInfoVector.get(0);
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 2, "readCollection() isNested: " + this.isNested);
            this.trace.writeTrace(logger, 2, "readCollection() element type: " + elementColInfo.SQLtype);
            this.trace.writeTrace(logger, 2, "readCollection() element xid: " + elementColInfo.ExtendedId);
        }
        if (this.elementOffsetVector != null) {
            int size = this.elementOffsetVector.size();
            if (TraceFlag.isTraceEnabled()) {
                this.trace.writeTrace(logger, 2, "  elementOffsetVector != null");
                this.trace.writeTrace(logger, 2, "  size: " + size);
            }
            for (int i = 0; i < size; ++i) {
                int position = this.currentPosition();
                int offset = this.elementOffsetVector.get(i);
                if (TraceFlag.isTraceEnabled()) {
                    this.trace.writeTrace(logger, 2, "  position: " + position);
                    this.trace.writeTrace(logger, 2, "  offset: " + offset);
                }
                try {
                    if (position < offset) {
                        this.is.skipBytes(offset - position);
                    }
                }
                catch (Exception e) {
                    throw IfxErrMsg.getSQLException(e, -79716);
                }
                this.readElement(collObj);
            }
        } else {
            while (this.bStream.available() > 0) {
                this.readElement(collObj);
            }
        }
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 1, "IfxComplexInput.readCollection() exited");
        }
        return collObj;
    }

    Object[] readStructAttributes() throws SQLException {
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 1, "IfxComplexInput.readStructAttributes() entered");
        }
        this.isStruct = true;
        ArrayList coll = new ArrayList();
        do {
            this.getNextType();
            this.readElement(coll);
        } while (this.typeIndex + 1 < this.typeInfoVector.size());
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 1, "IfxComplexInput.readStructAttributes() exited");
        }
        return coll.toArray();
    }

    Object readArrayElements(int JDBCtype) throws SQLException {
        int i;
        Object[] obj = null;
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 1, "IfxComplexInput.readArrayElements(int) entered");
            this.trace.writeTrace(logger, 2, "  readArrayElements(int) bStream.available(): " + this.bStream.available());
        }
        ArrayList coll = new ArrayList();
        if (this.bStream.available() > 0) {
            IfxColumnInfo elementColInfo = this.typeInfoVector.get(0);
            if (TraceFlag.isTraceEnabled()) {
                this.trace.writeTrace(logger, 2, "readArrayElements() isNested: " + this.isNested);
                this.trace.writeTrace(logger, 2, "readArrayElements() element type: " + elementColInfo.SQLtype);
                this.trace.writeTrace(logger, 2, "readArrayElements() element xid: " + elementColInfo.ExtendedId);
            }
            if (this.elementOffsetVector != null) {
                int size = this.elementOffsetVector.size();
                for (i = 0; i < size; ++i) {
                    int position = this.currentPosition();
                    int offset = this.elementOffsetVector.get(i);
                    try {
                        if (position < offset) {
                            this.is.skipBytes(offset - position);
                        }
                    }
                    catch (Exception e) {
                        throw IfxErrMsg.getSQLException(e, -79716);
                    }
                    this.readElement(coll);
                }
            } else {
                while (this.bStream.available() > 0) {
                    this.readElement(coll);
                }
            }
        }
        Object[] objArray = coll.toArray();
        int count = objArray.length;
        if (TraceFlag.isTraceEnabled() && objArray != null) {
            this.trace.writeTrace(logger, 2, "    readArrayElements(int). count: " + count);
        }
        switch (JDBCtype) {
            case 5: {
                short[] shortArray = new short[count];
                for (i = 0; i < count; ++i) {
                    shortArray[i] = (Short)objArray[i];
                }
                obj = shortArray;
                break;
            }
            case 4: {
                int[] intArray = new int[count];
                for (i = 0; i < count; ++i) {
                    intArray[i] = (Integer)objArray[i];
                }
                obj = intArray;
                break;
            }
            case -5: {
                long[] longArray = new long[count];
                for (i = 0; i < count; ++i) {
                    longArray[i] = (Long)objArray[i];
                }
                obj = longArray;
                break;
            }
            case 6: {
                float[] floatArray = new float[count];
                for (i = 0; i < count; ++i) {
                    floatArray[i] = ((Float)objArray[i]).floatValue();
                }
                obj = floatArray;
                break;
            }
            case 8: {
                double[] doubleArray = new double[count];
                for (i = 0; i < count; ++i) {
                    doubleArray[i] = (Double)objArray[i];
                }
                obj = doubleArray;
                break;
            }
            case 1111: {
                String elementClassName = null;
                if (objArray.length > 1 && (elementClassName = objArray[0].getClass().getName()).equals("java.lang.Boolean")) {
                    boolean[] booleanArray = new boolean[count];
                    for (i = 0; i < count; ++i) {
                        booleanArray[i] = (Boolean)objArray[i];
                    }
                    obj = booleanArray;
                    break;
                }
            }
            default: {
                obj = objArray;
                if (!TraceFlag.isTraceEnabled() || objArray == null || objArray.length <= 0 || objArray[0] == null) break;
                this.trace.writeTrace(logger, 2, "    objArray[0] class: " + objArray[0].getClass().getName());
            }
        }
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 1, "IfxComplexInput.readArrayElements(int) exited");
        }
        return obj;
    }

    private void readElement(Collection collObj) throws SQLException {
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 1, "IfxComplexInput.readElement(Collection) entered");
            this.trace.writeTrace(logger, 2, " currentIfxType: " + this.currentIfxType);
            this.trace.writeTrace(logger, 2, " bStream.available(): " + this.bStream.available());
        }
        switch (this.currentIfxType) {
            case 0: 
            case 13: 
            case 15: 
            case 16: 
            case 43: {
                String obj = this.readString(collObj);
                break;
            }
            case 1: {
                Short obj = this.readShort();
                if (this.isNull) {
                    obj = null;
                }
                collObj.add(obj);
                break;
            }
            case 2: 
            case 6: {
                Integer obj = this.readInt();
                if (this.isNull) {
                    obj = null;
                }
                collObj.add(obj);
                break;
            }
            case 3: {
                Double obj = this.readDouble();
                if (this.isNull) {
                    obj = null;
                }
                collObj.add(obj);
                break;
            }
            case 4: {
                Float obj = Float.valueOf(this.readFloat());
                if (this.isNull) {
                    obj = null;
                }
                collObj.add(obj);
                break;
            }
            case 5: 
            case 8: {
                BigDecimal obj = this.readBigDecimal();
                collObj.add(obj);
                break;
            }
            case 7: {
                Date obj = this.readDate();
                collObj.add(obj);
                break;
            }
            case 10: {
                java.util.Date obj = (byte)((this.currentIfxLength & 0xFF) >> 4 & 0xF) < 6 ? this.readTimestamp() : this.readTime();
                collObj.add(obj);
                break;
            }
            case 14: {
                Interval obj = this.readInterval();
                collObj.add(obj);
                break;
            }
            case 17: 
            case 18: {
                Long obj = this.readLong();
                if (this.isNull) {
                    obj = null;
                }
                collObj.add(obj);
                break;
            }
            case 52: 
            case 53: {
                Long obj = this.readLongBigint();
                if (this.isNull) {
                    obj = null;
                }
                collObj.add(obj);
                break;
            }
            case 19: 
            case 20: 
            case 21: 
            case 22: {
                Object obj = this.readNestedComplex().toObject();
                collObj.add(obj);
                break;
            }
            case 40: 
            case 41: {
                Object obj;
                if (this.currentExtendedId == 5) {
                    obj = this.readBoolean();
                    if (this.isNull) {
                        obj = null;
                    }
                } else {
                    obj = this.currentExtendedId == 10 ? this.readBlob() : (this.currentExtendedId == 11 ? this.readClob() : this.readUDT(false));
                }
                collObj.add(obj);
                break;
            }
            case 45: {
                Boolean obj = this.readBoolean();
                if (this.isNull) {
                    obj = null;
                }
                collObj.add(obj);
                break;
            }
            default: {
                throw IfxErrMsg.getSQLException(-9970);
            }
        }
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 1, "IfxComplexInput.readElement(Collection) entered");
        }
    }

    @Override
    public Array readArray() throws SQLException {
        IfxObject obj;
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 1, "IfxComplexInput.readArray(void) called");
        }
        if (!((obj = this.readNestedComplex()) instanceof IfxCollection)) {
            ClassCastException e = new ClassCastException();
            throw new SQLException(e.toString());
        }
        return ((IfxCollection)obj).toArray();
    }

    IfxArray readIfxArray() throws SQLException {
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 1, "IfxComplexInput.readIfxArray(void) entered");
        }
        byte[] b = new byte[this.bStream.available()];
        this.bStream.read(b, 0, this.bStream.available());
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 2, "Row data in readIfxArray()");
            this.trace.writeTrace(logger, 2, b, 'B');
        }
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 1, "IfxComplexInput.readIfxArray(void) exited");
        }
        return new IfxArray(b, this.parentTypeInfoVector, this.conn);
    }

    Object readStruct() throws SQLException {
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 1, "IfxComplexInput.readStruct(void) entered");
        }
        byte[] b = new byte[this.bStream.available()];
        this.bStream.read(b, 0, this.bStream.available());
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 2, "Row data in readStruct()");
            this.trace.writeTrace(logger, 2, b, 'B');
        }
        IfxStruct struct = new IfxStruct(b, this.parentTypeInfoVector, this.conn);
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 1, "IfxComplexInput.readStruct(void) exited");
        }
        return struct;
    }

    private void getNextType() throws SQLException {
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 1, "IfxComplexInput.getNextType(void) entered");
            this.trace.writeTrace(logger, 2, "    getNextType current type: " + this.currentIfxType);
            this.trace.writeTrace(logger, 2, "    getNextType isRow: " + this.isRow);
            this.trace.writeTrace(logger, 2, "    getNextType typeIndex: " + this.typeIndex);
        }
        if (this.isRow) {
            ++this.typeIndex;
            if (this.typeIndex < this.typeInfoVector.size()) {
                IfxColumnInfo colInfo = this.typeInfoVector.get(this.typeIndex);
                this.currentIfxType = colInfo.SQLtype;
                this.currentExtendedId = colInfo.ExtendedId;
                this.currentExtendedName = colInfo.ExtendedName;
                this.currentIfxLength = colInfo.ColLength;
                this.currentSourceType = colInfo.SourceType;
            } else {
                throw IfxErrMsg.getSQLException(-79773);
            }
        }
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 2, "    getNextType new type: " + this.currentIfxType);
            this.trace.writeTrace(logger, 2, "    getNextType new extendedId: " + this.currentExtendedId);
            this.trace.writeTrace(logger, 2, "    getNextType new extended name: " + this.currentExtendedName);
            this.trace.writeTrace(logger, 2, "    getNextType new index: " + this.typeIndex);
            this.trace.writeTrace(logger, 2, "    getNextType new source: " + this.currentSourceType);
            this.trace.writeTrace(logger, 1, "IfxComplexInput.getNextType(void) exited");
        }
    }

    private Class<?> getTypeClass(Map<String, Class<?>> map, IfxColumnInfo colInfo, int databaseType) {
        Class<?> classObj = null;
        String name = null;
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 1, "IfxComplexInput.getTypeClass(Map, IfxColumnInfo) entered");
        }
        if (map == null) {
            if (TraceFlag.isTraceEnabled()) {
                this.trace.writeTrace(logger, 2, "    getTypeClass: map is NULL");
            }
            return null;
        }
        if (IfxTypes.isCollection(colInfo.SQLtype)) {
            if (TraceFlag.isTraceEnabled()) {
                this.trace.writeTrace(logger, 2, "    this is a collection");
            }
            name = IfxTypes.IfxTypeToName(colInfo.SQLtype);
        } else if (colInfo.IsNamedRow) {
            if (TraceFlag.isTraceEnabled()) {
                this.trace.writeTrace(logger, 2, "    this is a named row");
            }
            name = colInfo.ExtendedName;
        }
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 2, "  Looking for name: " + name);
        }
        if (name != null && (classObj = map.get(name)) == null && databaseType == 1) {
            if (TraceFlag.isTraceEnabled()) {
                this.trace.writeTrace(logger, 2, "   getTypeClass: using owner name");
            }
            classObj = map.get(colInfo.ExtendedOwner + "." + name);
        }
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 2, "   getTypeClass: classObj = " + classObj);
        }
        if (TraceFlag.isTraceEnabled() && classObj != null) {
            this.trace.writeTrace(logger, 2, "  Found class: " + classObj.getName());
        }
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 1, "IfxComplexInput.getTypeClass(Map, IfxColumnInfo) exited");
        }
        return classObj;
    }

    private IfxObject convLob() throws SQLException {
        String locale = null;
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 1, "IfxComplexInput.convLob() called");
        }
        if (this.conn != null) {
            locale = this.conn.getclLocale();
        }
        byte[] b = null;
        IfxObject ifxObject = this.ifxObjectVector.get(this.typeIndex);
        if (this.currentExtendedId == 10 || this.currentExtendedId == 11) {
            int len = 77;
            b = new byte[len];
            this.bStream.read(b, 0, len);
            ifxObject.fromIfx(b);
            this.isNull = ifxObject.isNull();
        } else {
            IfxComplex.badTypeException(this.currentIfxType, (short)102, this.trace, locale);
        }
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 1, "IfxComplexInput.convLob() exited");
        }
        return ifxObject;
    }

    @Override
    public IfxUDTInfo getUDTInfo(int xid) throws SQLException {
        return this.conn.getUDTInfo(xid);
    }

    @Override
    public IfxUDTInfo getUDTInfo(String name, String owner) throws SQLException {
        return this.conn.getUDTInfo(name, owner);
    }

    @Override
    public URL readURL() throws SQLException {
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 2, "IfxComplexInput:readURL() not supported");
        }
        throw IfxErrMsg.getSQLException(-79700, ": IfxComplexInput.readURL()", this.conn);
    }

    @Override
    public NClob readNClob() throws SQLException {
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 2, "IfxComplexInput:readNClob() not supported");
        }
        throw IfxErrMsg.getSQLException(-79700, ": IfxComplexInput.readNClob()", this.conn);
    }

    @Override
    public String readNString() throws SQLException {
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 2, "IfxComplexInput:readNString() not supported");
        }
        throw IfxErrMsg.getSQLException(-79700, ": IfxComplexInput.readNString()", this.conn);
    }

    @Override
    public RowId readRowId() throws SQLException {
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 2, "IfxComplexInput:readRowId() not supported");
        }
        throw IfxErrMsg.getSQLException(-79700, ": IfxComplexInput.readRowId()", this.conn);
    }

    @Override
    public SQLXML readSQLXML() throws SQLException {
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 2, "IfxComplexInput:readSQLXML() not supported");
        }
        throw IfxErrMsg.getSQLException(-79700, ": IfxComplexInput.readSQLXML()", this.conn);
    }
}

