/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.jdbc.field;

import java.math.BigDecimal;
import java.sql.SQLException;
import org.firebirdsql.gds.ng.fields.FieldDescriptor;
import org.firebirdsql.jdbc.field.FBField;
import org.firebirdsql.jdbc.field.FieldDataProvider;
import org.firebirdsql.jdbc.field.TypeConversionException;

final class FBFloatField
extends FBField {
    private static final BigDecimal BD_MAX_FLOAT = new BigDecimal(3.4028234663852886E38);
    private static final BigDecimal BD_MIN_FLOAT = new BigDecimal(-3.4028234663852886E38);

    FBFloatField(FieldDescriptor fieldDescriptor, FieldDataProvider dataProvider, int requiredType) throws SQLException {
        super(fieldDescriptor, dataProvider, requiredType);
    }

    @Override
    public byte getByte() throws SQLException {
        if (this.isNull()) {
            return 0;
        }
        float value = this.getDatatypeCoder().decodeFloat(this.getFieldData());
        if (value > 127.0f || value < -128.0f) {
            throw new TypeConversionException("Error converting to byte. " + value);
        }
        return (byte)value;
    }

    @Override
    public short getShort() throws SQLException {
        if (this.isNull()) {
            return 0;
        }
        float value = this.getDatatypeCoder().decodeFloat(this.getFieldData());
        if (value > 32767.0f || value < -32768.0f) {
            throw new TypeConversionException("Error converting to short. " + value);
        }
        return (short)value;
    }

    @Override
    public int getInt() throws SQLException {
        if (this.isNull()) {
            return 0;
        }
        float value = this.getDatatypeCoder().decodeFloat(this.getFieldData());
        if (value > 2.1474836E9f || value < -2.1474836E9f) {
            throw new TypeConversionException("Error converting to int. " + value);
        }
        return (int)value;
    }

    @Override
    public long getLong() throws SQLException {
        if (this.isNull()) {
            return 0L;
        }
        float value = this.getDatatypeCoder().decodeFloat(this.getFieldData());
        if (value > 9.223372E18f || value < -9.223372E18f) {
            throw new TypeConversionException("Error converting to long. " + value);
        }
        return (long)value;
    }

    @Override
    public float getFloat() throws SQLException {
        if (this.isNull()) {
            return 0.0f;
        }
        return this.getDatatypeCoder().decodeFloat(this.getFieldData());
    }

    @Override
    public double getDouble() throws SQLException {
        if (this.isNull()) {
            return 0.0;
        }
        return this.getDatatypeCoder().decodeFloat(this.getFieldData());
    }

    @Override
    public BigDecimal getBigDecimal() throws SQLException {
        if (this.isNull()) {
            return null;
        }
        return new BigDecimal(this.getDatatypeCoder().decodeFloat(this.getFieldData()));
    }

    @Override
    public boolean getBoolean() throws SQLException {
        if (this.isNull()) {
            return false;
        }
        return this.getDatatypeCoder().decodeFloat(this.getFieldData()) == 1.0f;
    }

    @Override
    public String getString() throws SQLException {
        if (this.isNull()) {
            return null;
        }
        return String.valueOf(this.getDatatypeCoder().decodeFloat(this.getFieldData()));
    }

    @Override
    public void setString(String value) throws SQLException {
        if (value == null) {
            this.setNull();
            return;
        }
        try {
            this.setFloat(Float.parseFloat(value));
        }
        catch (NumberFormatException nfex) {
            throw new TypeConversionException("Error converting to float. " + value);
        }
    }

    @Override
    public void setShort(short value) throws SQLException {
        this.setFloat(value);
    }

    @Override
    public void setBoolean(boolean value) throws SQLException {
        this.setFloat(value ? 1.0f : 0.0f);
    }

    @Override
    public void setFloat(float value) throws SQLException {
        this.setFieldData(this.getDatatypeCoder().encodeFloat(value));
    }

    @Override
    public void setDouble(double value) throws SQLException {
        if (value == Double.NEGATIVE_INFINITY) {
            this.setFloat(Float.NEGATIVE_INFINITY);
        } else if (value == Double.POSITIVE_INFINITY) {
            this.setFloat(Float.POSITIVE_INFINITY);
        } else {
            if (value > 3.4028234663852886E38 || value < -3.4028234663852886E38) {
                throw new TypeConversionException("Error converting to float. " + value);
            }
            this.setFloat((float)value);
        }
    }

    @Override
    public void setLong(long value) throws SQLException {
        this.setFloat(value);
    }

    @Override
    public void setInteger(int value) throws SQLException {
        this.setFloat(value);
    }

    @Override
    public void setByte(byte value) throws SQLException {
        this.setFloat(value);
    }

    @Override
    public void setBigDecimal(BigDecimal value) throws SQLException {
        if (value == null) {
            this.setNull();
            return;
        }
        if (value.compareTo(BD_MAX_FLOAT) > 0 || value.compareTo(BD_MIN_FLOAT) < 0) {
            throw new TypeConversionException("Error converting to big decimal. " + value);
        }
        this.setFloat(value.floatValue());
    }
}

