/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc;

import java.sql.ParameterMetaData;
import java.sql.SQLException;
import net.snowflake.client.core.MetaDataOfBinds;
import net.snowflake.client.core.SFBaseSession;
import net.snowflake.client.core.SFStatementMetaData;
import net.snowflake.client.jdbc.SnowflakeLoggedFeatureNotSupportedException;
import net.snowflake.client.jdbc.SnowflakeType;

class SnowflakeParameterMetadata
implements ParameterMetaData {
    private SFStatementMetaData statementMetaData;
    private SFBaseSession session;

    SnowflakeParameterMetadata(SFStatementMetaData sfStatementMetaData, SFBaseSession session) {
        this.statementMetaData = sfStatementMetaData;
        this.session = session;
    }

    @Override
    public int getParameterCount() throws SQLException {
        return this.statementMetaData.getNumberOfBinds();
    }

    @Override
    public int isNullable(int param) throws SQLException {
        MetaDataOfBinds paramInfo = this.statementMetaData.getMetaDataForBindParam(param);
        if (paramInfo.isNullable()) {
            return 1;
        }
        return 0;
    }

    @Override
    public boolean isSigned(int param) throws SQLException {
        throw new SnowflakeLoggedFeatureNotSupportedException(this.session);
    }

    @Override
    public int getPrecision(int param) throws SQLException {
        MetaDataOfBinds paramInfo = this.statementMetaData.getMetaDataForBindParam(param);
        return paramInfo.getPrecision();
    }

    @Override
    public int getScale(int param) throws SQLException {
        MetaDataOfBinds paramInfo = this.statementMetaData.getMetaDataForBindParam(param);
        return paramInfo.getScale();
    }

    @Override
    public int getParameterType(int param) throws SQLException {
        MetaDataOfBinds paramInfo = this.statementMetaData.getMetaDataForBindParam(param);
        return SnowflakeType.convertStringToType(paramInfo.getTypeName());
    }

    @Override
    public String getParameterTypeName(int param) throws SQLException {
        MetaDataOfBinds paramInfo = this.statementMetaData.getMetaDataForBindParam(param);
        return paramInfo.getTypeName();
    }

    @Override
    public String getParameterClassName(int param) throws SQLException {
        throw new SnowflakeLoggedFeatureNotSupportedException(this.session);
    }

    @Override
    public int getParameterMode(int param) throws SQLException {
        throw new SnowflakeLoggedFeatureNotSupportedException(this.session);
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        if (!this.isWrapperFor(iface)) {
            throw new SQLException(this.getClass().getName() + " not unwrappable from " + iface.getName());
        }
        return (T)this;
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return iface.isInstance(this);
    }
}

