/*
 * Decompiled with CFR 0.152.
 */
package scala.tools.nsc.interpreter.jline;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStream;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.util.logging.ConsoleHandler;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jline.builtins.InputRC;
import org.jline.keymap.KeyMap;
import org.jline.reader.Completer;
import org.jline.reader.CompletionMatcher;
import org.jline.reader.History;
import org.jline.reader.LineReader;
import org.jline.reader.LineReaderBuilder;
import org.jline.reader.Parser;
import org.jline.reader.Reference;
import org.jline.reader.impl.history.DefaultHistory;
import org.jline.terminal.Terminal;
import org.jline.terminal.TerminalBuilder;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.StringOps$;
import scala.io.Codec$;
import scala.io.Source$;
import scala.package$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.internal.util.OwnerOnlyChmod$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyRef;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;
import scala.tools.nsc.interpreter.Repl;
import scala.tools.nsc.interpreter.jline.Completion;
import scala.tools.nsc.interpreter.jline.Reader;
import scala.tools.nsc.interpreter.jline.Reader$ScalaShowType$1$;
import scala.tools.nsc.interpreter.jline.Reader$customCompletionMatcher$1$;
import scala.tools.nsc.interpreter.shell.Accumulator;
import scala.tools.nsc.interpreter.shell.ShellConfig;
import scala.util.Using;
import scala.util.Using$;
import scala.util.control.NonFatal$;

public final class Reader$ {
    public static final Reader$ MODULE$ = new Reader$();

    public Reader apply(ShellConfig config, Repl repl, scala.tools.nsc.interpreter.shell.Completion completion, Accumulator accumulator) {
        LazyRef inputrcFileContents$lzy = new LazyRef();
        LazyRef customCompletionMatcher$module = new LazyRef();
        LazyRef ScalaShowType$module = new LazyRef();
        Predef$.MODULE$.require(repl != null);
        if (config.isReplDebug()) {
            this.initLogging(config.isReplTrace());
        }
        System.setProperty("org.jline.reader.support.parsedline", Boolean.TRUE.toString());
        Terminal jlineTerminal = TerminalBuilder.builder().jna(true).build();
        Completion completer = new Completion(completion);
        Reader.ReplParser parser = new Reader.ReplParser(repl);
        DefaultHistory history = new DefaultHistory();
        LineReaderBuilder builder = LineReaderBuilder.builder().appName("scala").completer((Completer)completer).history((History)history).parser((Parser)parser).terminal(jlineTerminal);
        Predef$.MODULE$.locally((Object)builder.option(LineReader.Option.AUTO_GROUP, false).option(LineReader.Option.LIST_PACKED, true).option(LineReader.Option.INSERT_TAB, true).variable("history-file", (Object)config.historyFile()).variable("secondary-prompt-pattern", (Object)config.encolor(config.continueText())).variable("WORDCHARS", (Object)StringOps$.MODULE$.filterNot$extension(Predef$.MODULE$.augmentString("*?_-.[]~=/&;!#$%^(){}<>"), (Function1)Predef$.MODULE$.wrapString("*?.[]~=/&;!#%^(){}<>").toSet())).option(LineReader.Option.DISABLE_EVENT_EXPANSION, true).option(LineReader.Option.COMPLETE_MATCHER_CAMELCASE, true).option(LineReader.Option.COMPLETE_MATCHER_TYPO, true));
        builder.completionMatcher((CompletionMatcher)this.customCompletionMatcher$2(customCompletionMatcher$module));
        LineReader reader = builder.build();
        try {
            Reader$.inputrcFileContents$1(inputrcFileContents$lzy).foreach((Function1 & Serializable)f -> {
                Reader$.$anonfun$apply$9(reader, f);
                return BoxedUnit.UNIT;
            });
        }
        catch (Throwable throwable) {
            Option option;
            Throwable throwable2 = throwable;
            if (throwable2 != null && !(option = NonFatal$.MODULE$.unapply(throwable2)).isEmpty()) {
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            }
            throw throwable;
        }
        KeyMap keyMap = (KeyMap)reader.getKeyMaps().get("main");
        reader.getWidgets().put(this.ScalaShowType$2(ScalaShowType$module, reader, completer).Name(), () -> this.ScalaShowType$2(ScalaShowType$module, reader, completer).apply());
        String keymap = config.viMode() ? "viins" : "emacs";
        reader.getKeyMaps().put("main", reader.getKeyMaps().get(keymap));
        keyMap.bind((Object)new Reference(this.ScalaShowType$2(ScalaShowType$module, reader, completer).Name()), (CharSequence)KeyMap.alt((String)KeyMap.ctrl((char)'t')));
        Predef$.MODULE$.locally((Object)BoxedUnit.UNIT);
        Reader$.secure$1(Paths.get(config.historyFile(), new String[0]), config);
        try {
            history.attach(reader);
        }
        catch (Throwable throwable) {
            IllegalArgumentException illegalArgumentException;
            Throwable throwable3 = throwable;
            if (throwable3 instanceof IllegalArgumentException && (illegalArgumentException = (IllegalArgumentException)throwable3).getMessage().contains("Bad history file syntax")) {
                Reader$.backupHistory$1(config);
                history.attach(reader);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            }
            if (throwable3 instanceof NumberFormatException) {
                Reader$.backupHistory$1(config);
                history.attach(reader);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            }
            throw throwable;
        }
        return new Reader(config, reader, accumulator, completer, jlineTerminal);
    }

    private void initLogging(boolean trace) {
        Logger logger = Logger.getLogger("org.jline");
        ConsoleHandler handler = new ConsoleHandler();
        Level level = trace ? Level.FINEST : Level.FINE;
        logger.setLevel(level);
        handler.setLevel(level);
        logger.addHandler(handler);
    }

    private static final Option inputrcFileUrl$1() {
        return scala.sys.package$.MODULE$.props().get("jline.inputrc").flatMap((Function1 & Serializable)path -> {
            Some some;
            try {
                some = new Some((Object)new URL((String)path));
            }
            catch (MalformedURLException malformedURLException) {
                some = new Some((Object)new File((String)path).toURI().toURL());
            }
            return some;
        }).orElse((Function0 & Serializable)() -> scala.sys.package$.MODULE$.props().get("user.home").map((Function1 & Serializable)home -> {
            File f = new File((String)home).toPath().resolve(".inputrc").toFile();
            return (f.isFile() ? f : new File("/etc/inputrc")).toURI().toURL();
        }));
    }

    public static final /* synthetic */ byte $anonfun$apply$7(int x$2) {
        return (byte)x$2;
    }

    private static final byte[] urlByteArray$1(URL url) {
        return (byte[])Using$.MODULE$.resource((Object)Source$.MODULE$.fromURL(url, Codec$.MODULE$.fallbackSystemCodec()).bufferedReader(), (Function1 & Serializable)bufferedReader -> (byte[])package$.MODULE$.LazyList().continually((Function0)(JFunction0.mcI.sp & Serializable)() -> bufferedReader.read()).takeWhile((Function1)(JFunction1.mcZI.sp & Serializable)x$1 -> x$1 != -1).map((Function1 & Serializable)x$2 -> BoxesRunTime.boxToByte((byte)Reader$.$anonfun$apply$7(BoxesRunTime.unboxToInt((Object)x$2)))).toArray((ClassTag)ClassTag$.MODULE$.Byte()), (Using.Releasable)Using.Releasable$.AutoCloseableIsReleasable$.MODULE$);
    }

    private static final /* synthetic */ Option inputrcFileContents$lzycompute$1(LazyRef inputrcFileContents$lzy$1) {
        Option option;
        LazyRef lazyRef = inputrcFileContents$lzy$1;
        synchronized (lazyRef) {
            option = inputrcFileContents$lzy$1.initialized() ? (Option)inputrcFileContents$lzy$1.value() : (Option)inputrcFileContents$lzy$1.initialize((Object)Reader$.inputrcFileUrl$1().map((Function1 & Serializable)in -> Reader$.urlByteArray$1(in)));
        }
        return option;
    }

    private static final Option inputrcFileContents$1(LazyRef inputrcFileContents$lzy$1) {
        return inputrcFileContents$lzy$1.initialized() ? (Option)inputrcFileContents$lzy$1.value() : Reader$.inputrcFileContents$lzycompute$1(inputrcFileContents$lzy$1);
    }

    private static final /* synthetic */ Reader$customCompletionMatcher$1$ customCompletionMatcher$lzycompute$1(LazyRef customCompletionMatcher$module$1) {
        Reader$customCompletionMatcher$1$ reader$customCompletionMatcher$1$;
        LazyRef lazyRef = customCompletionMatcher$module$1;
        synchronized (lazyRef) {
            reader$customCompletionMatcher$1$ = customCompletionMatcher$module$1.initialized() ? (Reader$customCompletionMatcher$1$)((Object)customCompletionMatcher$module$1.value()) : (Reader$customCompletionMatcher$1$)((Object)customCompletionMatcher$module$1.initialize((Object)new Reader$customCompletionMatcher$1$()));
        }
        return reader$customCompletionMatcher$1$;
    }

    private final Reader$customCompletionMatcher$1$ customCompletionMatcher$2(LazyRef customCompletionMatcher$module$1) {
        return customCompletionMatcher$module$1.initialized() ? (Reader$customCompletionMatcher$1$)((Object)customCompletionMatcher$module$1.value()) : Reader$.customCompletionMatcher$lzycompute$1(customCompletionMatcher$module$1);
    }

    public static final /* synthetic */ void $anonfun$apply$9(LineReader reader$1, byte[] f) {
        InputRC.configure((LineReader)reader$1, (InputStream)new ByteArrayInputStream(f));
    }

    private static final /* synthetic */ Reader$ScalaShowType$1$ ScalaShowType$lzycompute$1(LazyRef ScalaShowType$module$1, LineReader reader$1, Completion completer$1) {
        Reader$ScalaShowType$1$ reader$ScalaShowType$1$;
        LazyRef lazyRef = ScalaShowType$module$1;
        synchronized (lazyRef) {
            reader$ScalaShowType$1$ = ScalaShowType$module$1.initialized() ? (Reader$ScalaShowType$1$)ScalaShowType$module$1.value() : (Reader$ScalaShowType$1$)ScalaShowType$module$1.initialize((Object)new Reader$ScalaShowType$1$(reader$1, completer$1));
        }
        return reader$ScalaShowType$1$;
    }

    private final Reader$ScalaShowType$1$ ScalaShowType$2(LazyRef ScalaShowType$module$1, LineReader reader$1, Completion completer$1) {
        return ScalaShowType$module$1.initialized() ? (Reader$ScalaShowType$1$)ScalaShowType$module$1.value() : Reader$.ScalaShowType$lzycompute$1(ScalaShowType$module$1, reader$1, completer$1);
    }

    private static final void secure$1(Path p, ShellConfig config$1) {
        try {
            OwnerOnlyChmod$.MODULE$.chmodFileOrCreateEmpty(p);
        }
        catch (Throwable throwable) {
            Option option;
            Throwable throwable2 = throwable;
            if (throwable2 != null && !(option = NonFatal$.MODULE$.unapply(throwable2)).isEmpty()) {
                Throwable e = (Throwable)option.get();
                if (config$1.isReplDebug()) {
                    e.printStackTrace();
                }
                config$1.replinfo((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(75).append("Warning: history file ").append(p).append("'s permissions could not be restricted to owner-only.").toString());
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            }
            throw throwable;
        }
    }

    private static final void backupHistory$1(ShellConfig config$1) {
        Path hf = Paths.get(config$1.historyFile(), new String[0]);
        Path bk = Paths.get(new StringBuilder(3).append(config$1.historyFile()).append(".bk").toString(), new String[0]);
        Files.move(hf, bk, StandardCopyOption.REPLACE_EXISTING);
        Reader$.secure$1(bk, config$1);
    }

    private Reader$() {
    }
}

