/*
 * Decompiled with CFR 0.152.
 */
package scala.collection.immutable;

import java.util.NoSuchElementException;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.Tuple4;
import scala.collection.Iterator;
import scala.collection.immutable.RedBlackTree;
import scala.collection.immutable.RedBlackTree$partitioner$1$;
import scala.math.Ordering;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyRef;
import scala.runtime.Nothing$;
import scala.runtime.Null$;
import scala.sys.package$;

public final class RedBlackTree$ {
    public static final RedBlackTree$ MODULE$ = new RedBlackTree$();
    private static final Tuple2<Null$, Null$> null2 = new Tuple2<Object, Object>(null, null);

    public boolean isEmpty(RedBlackTree.Tree<?, ?> tree) {
        return tree == null;
    }

    public <A> boolean contains(RedBlackTree.Tree<A, ?> tree, A x, Ordering<A> evidence$1) {
        return this.lookup(tree, x, evidence$1) != null;
    }

    public <A, B> Option<B> get(RedBlackTree.Tree<A, B> tree, A x, Ordering<A> evidence$2) {
        RedBlackTree.Tree<A, B> tree2 = this.lookup(tree, x, evidence$2);
        Option option = tree2 == null ? None$.MODULE$ : new Some<B>(tree2.value());
        return option;
    }

    public <A, B> RedBlackTree.Tree<A, B> lookup(RedBlackTree.Tree<A, B> tree, A x, Ordering<A> ordering) {
        RedBlackTree.Tree<A, B> tree2;
        block3: {
            while (true) {
                if (tree == null) {
                    tree2 = null;
                    break block3;
                }
                int cmp = ordering.compare(x, tree.key());
                if (cmp < 0) {
                    tree = tree.left();
                    continue;
                }
                if (cmp <= 0) break;
                tree = tree.right();
            }
            tree2 = tree;
        }
        return tree2;
    }

    public int count(RedBlackTree.Tree<?, ?> tree) {
        return tree == null ? 0 : tree.count();
    }

    public <A, B, B1> RedBlackTree.Tree<A, B1> update(RedBlackTree.Tree<A, B> tree, A k, B1 v, boolean overwrite, Ordering<A> evidence$3) {
        return this.blacken(this.upd(tree, k, v, overwrite, evidence$3));
    }

    public <A, B> RedBlackTree.Tree<A, B> delete(RedBlackTree.Tree<A, B> tree, A k, Ordering<A> evidence$4) {
        return this.blacken(this.del(tree, k, evidence$4));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public <A, B> RedBlackTree.Tree<A, B> rangeImpl(RedBlackTree.Tree<A, B> tree, Option<A> from, Option<A> until, Ordering<A> evidence$5) {
        Tuple2<Option<A>, Option<A>> tuple2 = new Tuple2<Option<A>, Option<A>>(from, until);
        if (tuple2 != null) {
            Option<A> option = tuple2._1();
            Option<A> option2 = tuple2._2();
            if (option instanceof Some) {
                Some some = (Some)option;
                Object from2 = some.value();
                if (option2 instanceof Some) {
                    Some some2 = (Some)option2;
                    Object until2 = some2.value();
                    return this.range(tree, from2, until2, evidence$5);
                }
            }
        }
        if (tuple2 != null) {
            Option<A> option = tuple2._1();
            Option<A> option3 = tuple2._2();
            if (option instanceof Some) {
                Some some = (Some)option;
                Object from3 = some.value();
                if (None$.MODULE$.equals(option3)) {
                    return this.from(tree, from3, evidence$5);
                }
            }
        }
        if (tuple2 != null) {
            Option<A> option = tuple2._1();
            Option<A> option4 = tuple2._2();
            if (None$.MODULE$.equals(option) && option4 instanceof Some) {
                Some some = (Some)option4;
                Object until3 = some.value();
                return this.until(tree, until3, evidence$5);
            }
        }
        if (tuple2 == null) throw new MatchError(tuple2);
        Option<A> option = tuple2._1();
        Option<A> option5 = tuple2._2();
        if (!None$.MODULE$.equals(option)) throw new MatchError(tuple2);
        if (!None$.MODULE$.equals(option5)) throw new MatchError(tuple2);
        return tree;
    }

    public <A, B> RedBlackTree.Tree<A, B> range(RedBlackTree.Tree<A, B> tree, A from, A until, Ordering<A> evidence$6) {
        return this.blacken(this.doRange(tree, from, until, evidence$6));
    }

    public <A, B> RedBlackTree.Tree<A, B> from(RedBlackTree.Tree<A, B> tree, A from, Ordering<A> evidence$7) {
        return this.blacken(this.doFrom(tree, from, evidence$7));
    }

    public <A, B> RedBlackTree.Tree<A, B> to(RedBlackTree.Tree<A, B> tree, A to, Ordering<A> evidence$8) {
        return this.blacken(this.doTo(tree, to, evidence$8));
    }

    public <A, B> RedBlackTree.Tree<A, B> until(RedBlackTree.Tree<A, B> tree, A key, Ordering<A> evidence$9) {
        return this.blacken(this.doUntil(tree, key, evidence$9));
    }

    public <A, B> RedBlackTree.Tree<A, B> drop(RedBlackTree.Tree<A, B> tree, int n, Ordering<A> evidence$10) {
        return this.blacken(this.doDrop(tree, n));
    }

    public <A, B> RedBlackTree.Tree<A, B> take(RedBlackTree.Tree<A, B> tree, int n, Ordering<A> evidence$11) {
        return this.blacken(this.doTake(tree, n));
    }

    public <A, B> RedBlackTree.Tree<A, B> slice(RedBlackTree.Tree<A, B> tree, int from, int until, Ordering<A> evidence$12) {
        return this.blacken(this.doSlice(tree, from, until));
    }

    /*
     * WARNING - void declaration
     */
    public <A, B> RedBlackTree.Tree<A, B> smallest(RedBlackTree.Tree<A, B> tree) {
        void var2_2;
        if (tree == null) {
            throw new NoSuchElementException("empty tree");
        }
        RedBlackTree.Tree<A, B> result = tree;
        while (result.left() != null) {
            result = result.left();
        }
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    public <A, B> RedBlackTree.Tree<A, B> greatest(RedBlackTree.Tree<A, B> tree) {
        void var2_2;
        if (tree == null) {
            throw new NoSuchElementException("empty tree");
        }
        RedBlackTree.Tree<A, B> result = tree;
        while (result.right() != null) {
            result = result.right();
        }
        return var2_2;
    }

    public <A, B> RedBlackTree.Tree<A, B> tail(RedBlackTree.Tree<A, B> tree) {
        return this.blacken(this._tail$1(tree));
    }

    public <A, B> RedBlackTree.Tree<A, B> init(RedBlackTree.Tree<A, B> tree) {
        return this.blacken(this._init$1(tree));
    }

    public <A, B> RedBlackTree.Tree<A, B> minAfter(RedBlackTree.Tree<A, B> tree, A x, Ordering<A> ordering) {
        RedBlackTree.Tree<A, B> tree2;
        while (true) {
            if (tree == null) {
                tree2 = null;
                break;
            }
            int cmp = ordering.compare(x, tree.key());
            if (cmp == 0) {
                tree2 = tree;
                break;
            }
            if (cmp < 0) {
                RedBlackTree.Tree<A, B> l = this.minAfter(tree.left(), x, ordering);
                if (l != null) {
                    tree2 = l;
                    break;
                }
                tree2 = tree;
                break;
            }
            tree = tree.right();
        }
        return tree2;
    }

    public <A, B> RedBlackTree.Tree<A, B> maxBefore(RedBlackTree.Tree<A, B> tree, A x, Ordering<A> ordering) {
        RedBlackTree.Tree<A, B> tree2;
        block2: {
            while (true) {
                if (tree == null) {
                    tree2 = null;
                    break block2;
                }
                int cmp = ordering.compare(x, tree.key());
                if (cmp > 0) break;
                tree = tree.left();
            }
            RedBlackTree.Tree<A, B> r = this.maxBefore(tree.right(), x, ordering);
            tree2 = r != null ? r : tree;
        }
        return tree2;
    }

    public <A, B, U> void foreach(RedBlackTree.Tree<A, B> tree, Function1<Tuple2<A, B>, U> f) {
        block0: {
            if (tree == null) break block0;
            this._foreach(tree, f);
        }
    }

    public <A, X, Y> boolean keysEqual(RedBlackTree.Tree<A, X> a, RedBlackTree.Tree<A, Y> b, Ordering<A> evidence$13) {
        return a == b ? true : (a == null ? false : (b == null ? false : a.count() == b.count() && new RedBlackTree.EqualsIterator<A, Y>(a, evidence$13).sameKeys(new RedBlackTree.EqualsIterator<A, Y>(b, evidence$13))));
    }

    public <A, X, Y> boolean valuesEqual(RedBlackTree.Tree<A, X> a, RedBlackTree.Tree<A, Y> b, Ordering<A> evidence$14) {
        return a == b ? true : (a == null ? false : (b == null ? false : a.count() == b.count() && new RedBlackTree.EqualsIterator<A, Y>(a, evidence$14).sameValues(new RedBlackTree.EqualsIterator<A, Y>(b, evidence$14))));
    }

    public <A, X, Y> boolean entriesEqual(RedBlackTree.Tree<A, X> a, RedBlackTree.Tree<A, Y> b, Ordering<A> evidence$15) {
        return a == b ? true : (a == null ? false : (b == null ? false : a.count() == b.count() && new RedBlackTree.EqualsIterator<A, Y>(a, evidence$15).sameEntries(new RedBlackTree.EqualsIterator<A, Y>(b, evidence$15))));
    }

    private <A, B, U> void _foreach(RedBlackTree.Tree<A, B> tree, Function1<Tuple2<A, B>, U> f) {
        while (true) {
            if (tree.left() != null) {
                this._foreach(tree.left(), f);
            }
            f.apply(new Tuple2<A, B>(tree.key(), tree.value()));
            if (tree.right() == null) break;
            tree = tree.right();
        }
    }

    public <A, U> void foreachKey(RedBlackTree.Tree<A, ?> tree, Function1<A, U> f) {
        block0: {
            if (tree == null) break block0;
            this._foreachKey(tree, f);
        }
    }

    private <A, U> void _foreachKey(RedBlackTree.Tree<A, ?> tree, Function1<A, U> f) {
        while (true) {
            if (tree.left() != null) {
                this._foreachKey(tree.left(), f);
            }
            f.apply(tree.key());
            if (tree.right() == null) break;
            tree = tree.right();
        }
    }

    public <A, B, U> void foreachEntry(RedBlackTree.Tree<A, B> tree, Function2<A, B, U> f) {
        block0: {
            if (tree == null) break block0;
            this._foreachEntry(tree, f);
        }
    }

    private <A, B, U> void _foreachEntry(RedBlackTree.Tree<A, B> tree, Function2<A, B, U> f) {
        while (true) {
            if (tree.left() != null) {
                this._foreachEntry(tree.left(), f);
            }
            f.apply(tree.key(), tree.value());
            if (tree.right() == null) break;
            tree = tree.right();
        }
    }

    public <A, B> Iterator<Tuple2<A, B>> iterator(RedBlackTree.Tree<A, B> tree, Option<A> start, Ordering<A> evidence$16) {
        return new RedBlackTree.EntriesIterator<A, B>(tree, start, evidence$16);
    }

    public <A, B> None$ iterator$default$2() {
        return None$.MODULE$;
    }

    public <A> Iterator<A> keysIterator(RedBlackTree.Tree<A, ?> tree, Option<A> start, Ordering<A> evidence$17) {
        return new RedBlackTree.KeysIterator(tree, start, evidence$17);
    }

    public <A> None$ keysIterator$default$2() {
        return None$.MODULE$;
    }

    public <A, B> Iterator<B> valuesIterator(RedBlackTree.Tree<A, B> tree, Option<A> start, Ordering<A> evidence$18) {
        return new RedBlackTree.ValuesIterator<A, B>(tree, start, evidence$18);
    }

    public <A, B> None$ valuesIterator$default$2() {
        return None$.MODULE$;
    }

    public <A, B> RedBlackTree.Tree<A, B> nth(RedBlackTree.Tree<A, B> tree, int n) {
        while (true) {
            int count;
            if (n < (count = this.count(tree.left()))) {
                tree = tree.left();
                continue;
            }
            if (n <= count) break;
            n = n - count - 1;
            tree = tree.right();
        }
        return tree;
    }

    public boolean isBlack(RedBlackTree.Tree<?, ?> tree) {
        return tree == null || tree.isBlack();
    }

    public boolean scala$collection$immutable$RedBlackTree$$isRedTree(RedBlackTree.Tree<?, ?> tree) {
        return tree != null && tree.isRed();
    }

    private boolean isBlackTree(RedBlackTree.Tree<?, ?> tree) {
        return tree != null && tree.isBlack();
    }

    private <A, B> RedBlackTree.Tree<A, B> blacken(RedBlackTree.Tree<A, B> t) {
        return t == null ? null : t.black();
    }

    private <A, B> RedBlackTree.Tree<A, B> maybeBlacken(RedBlackTree.Tree<A, B> t) {
        return this.isBlack(t) ? t : (this.scala$collection$immutable$RedBlackTree$$isRedTree(t.left()) || this.scala$collection$immutable$RedBlackTree$$isRedTree(t.right()) ? t.black() : t);
    }

    private <A, B> RedBlackTree.Tree<A, Nothing$> mkTree(boolean isBlack, A key, B value, RedBlackTree.Tree<A, B> left, RedBlackTree.Tree<A, B> right) {
        int sizeAndColour = this.sizeOf(left) + this.sizeOf(right) + 1 | (isBlack ? Integer.MIN_VALUE : 0);
        return new RedBlackTree.Tree(key, value, left, right, sizeAndColour);
    }

    private <A, B1> RedBlackTree.Tree<A, B1> balanceLeft(RedBlackTree.Tree<A, B1> tree, RedBlackTree.Tree<A, B1> newLeft) {
        RedBlackTree.Tree<A, B1> tree2;
        if (tree.left() == newLeft) {
            tree2 = tree;
        } else if (newLeft.isRed()) {
            RedBlackTree.Tree<A, B1> newLeft_left = newLeft.left();
            RedBlackTree.Tree<A, B1> newLeft_right = newLeft.right();
            if (this.scala$collection$immutable$RedBlackTree$$isRedTree(newLeft_left)) {
                RedBlackTree.Tree<A, B1> resultLeft = newLeft_left.black();
                RedBlackTree.Tree<A, B1> resultRight = tree.blackWithLeft(newLeft_right);
                tree2 = newLeft.withLeftRight(resultLeft, resultRight);
            } else if (this.scala$collection$immutable$RedBlackTree$$isRedTree(newLeft_right)) {
                RedBlackTree.Tree<A, B1> newLeft_right_right = newLeft_right.right();
                RedBlackTree.Tree<A, B1> resultLeft = newLeft.blackWithRight(newLeft_right.left());
                RedBlackTree.Tree<A, B1> resultRight = tree.blackWithLeft(newLeft_right_right);
                tree2 = newLeft_right.withLeftRight(resultLeft, resultRight);
            } else {
                tree2 = tree.withLeft(newLeft);
            }
        } else {
            tree2 = tree.withLeft(newLeft);
        }
        return tree2;
    }

    private <A, B1> RedBlackTree.Tree<A, B1> balanceRight(RedBlackTree.Tree<A, B1> tree, RedBlackTree.Tree<A, B1> newRight) {
        RedBlackTree.Tree<A, B1> tree2;
        if (tree.right() == newRight) {
            tree2 = tree;
        } else if (newRight.isRed()) {
            RedBlackTree.Tree<A, B1> newRight_left = newRight.left();
            if (this.scala$collection$immutable$RedBlackTree$$isRedTree(newRight_left)) {
                RedBlackTree.Tree<A, B1> resultLeft = tree.blackWithRight(newRight_left.left());
                RedBlackTree.Tree<A, B1> resultRight = newRight.blackWithLeft(newRight_left.right());
                tree2 = newRight_left.withLeftRight(resultLeft, resultRight);
            } else {
                RedBlackTree.Tree<A, B1> newRight_right = newRight.right();
                if (this.scala$collection$immutable$RedBlackTree$$isRedTree(newRight_right)) {
                    RedBlackTree.Tree<A, B1> resultLeft = tree.blackWithRight(newRight_left);
                    RedBlackTree.Tree<A, B1> resultRight = newRight_right.black();
                    tree2 = newRight.withLeftRight(resultLeft, resultRight);
                } else {
                    tree2 = tree.withRight(newRight);
                }
            }
        } else {
            tree2 = tree.withRight(newRight);
        }
        return tree2;
    }

    private <A, B, B1> RedBlackTree.Tree<A, B1> upd(RedBlackTree.Tree<A, B> tree, A k, B1 v, boolean overwrite, Ordering<A> ordering) {
        int cmp;
        RedBlackTree.Tree<A, Object> tree2 = tree == null ? this.RedTree(k, v, null, null) : (k == tree.key() ? (overwrite ? tree.withV(v) : tree) : ((cmp = ordering.compare(k, tree.key())) < 0 ? this.balanceLeft(tree, this.upd(tree.left(), k, v, overwrite, ordering)) : (cmp > 0 ? this.balanceRight(tree, this.upd(tree.right(), k, v, overwrite, ordering)) : (overwrite && v != tree.value() ? tree.withV(v) : tree))));
        return tree2;
    }

    private <A, B, B1> RedBlackTree.Tree<A, B1> updNth(RedBlackTree.Tree<A, B> tree, int idx, A k, B1 v) {
        int rank;
        return tree == null ? this.RedTree(k, v, null, null) : (idx < (rank = this.count(tree.left()) + 1) ? this.balanceLeft(tree, this.updNth(tree.left(), idx, k, v)) : (idx > rank ? this.balanceRight(tree, this.updNth(tree.right(), idx - rank, k, v)) : tree));
    }

    private <A, B> RedBlackTree.Tree<A, B> doFrom(RedBlackTree.Tree<A, B> tree, A from, Ordering<A> ordering) {
        if (tree == null) {
            return null;
        }
        if (ordering.lt(tree.key(), from)) {
            return this.doFrom(tree.right(), from, ordering);
        }
        RedBlackTree.Tree<A, B> newLeft = this.doFrom(tree.left(), from, ordering);
        return newLeft == tree.left() ? tree : (newLeft == null ? this.upd(tree.right(), tree.key(), tree.value(), false, ordering) : this.scala$collection$immutable$RedBlackTree$$join(newLeft, tree.key(), tree.value(), tree.right()));
    }

    private <A, B> RedBlackTree.Tree<A, B> doTo(RedBlackTree.Tree<A, B> tree, A to, Ordering<A> ordering) {
        if (tree == null) {
            return null;
        }
        if (ordering.lt(to, tree.key())) {
            return this.doTo(tree.left(), to, ordering);
        }
        RedBlackTree.Tree<A, B> newRight = this.doTo(tree.right(), to, ordering);
        return newRight == tree.right() ? tree : (newRight == null ? this.upd(tree.left(), tree.key(), tree.value(), false, ordering) : this.scala$collection$immutable$RedBlackTree$$join(tree.left(), tree.key(), tree.value(), newRight));
    }

    private <A, B> RedBlackTree.Tree<A, B> doUntil(RedBlackTree.Tree<A, B> tree, A until, Ordering<A> ordering) {
        if (tree == null) {
            return null;
        }
        if (ordering.lteq(until, tree.key())) {
            return this.doUntil(tree.left(), until, ordering);
        }
        RedBlackTree.Tree<A, B> newRight = this.doUntil(tree.right(), until, ordering);
        return newRight == tree.right() ? tree : (newRight == null ? this.upd(tree.left(), tree.key(), tree.value(), false, ordering) : this.scala$collection$immutable$RedBlackTree$$join(tree.left(), tree.key(), tree.value(), newRight));
    }

    private <A, B> RedBlackTree.Tree<A, B> doRange(RedBlackTree.Tree<A, B> tree, A from, A until, Ordering<A> ordering) {
        if (tree == null) {
            return null;
        }
        if (ordering.lt(tree.key(), from)) {
            return this.doRange(tree.right(), from, until, ordering);
        }
        if (ordering.lteq(until, tree.key())) {
            return this.doRange(tree.left(), from, until, ordering);
        }
        RedBlackTree.Tree<A, B> newLeft = this.doFrom(tree.left(), from, ordering);
        RedBlackTree.Tree<A, B> newRight = this.doUntil(tree.right(), until, ordering);
        return newLeft == tree.left() && newRight == tree.right() ? tree : (newLeft == null ? this.upd(newRight, tree.key(), tree.value(), false, ordering) : (newRight == null ? this.upd(newLeft, tree.key(), tree.value(), false, ordering) : this.scala$collection$immutable$RedBlackTree$$join(newLeft, tree.key(), tree.value(), newRight)));
    }

    private <A, B> RedBlackTree.Tree<A, B> doDrop(RedBlackTree.Tree<A, B> tree, int n) {
        RedBlackTree.Tree<A, B> tree2;
        block3: {
            int l;
            while (true) {
                if (tree == null || n <= 0) {
                    tree2 = tree;
                    break block3;
                }
                if (n >= tree.count()) {
                    tree2 = null;
                    break block3;
                }
                l = this.count(tree.left());
                if (n <= l) break;
                n = n - l - 1;
                tree = tree.right();
            }
            tree2 = n == l ? this.scala$collection$immutable$RedBlackTree$$join(null, tree.key(), tree.value(), tree.right()) : this.scala$collection$immutable$RedBlackTree$$join(this.doDrop(tree.left(), n), tree.key(), tree.value(), tree.right());
        }
        return tree2;
    }

    private <A, B> RedBlackTree.Tree<A, B> doTake(RedBlackTree.Tree<A, B> tree, int n) {
        RedBlackTree.Tree<A, B> tree2;
        block3: {
            int l;
            while (true) {
                if (tree == null || n <= 0) {
                    tree2 = null;
                    break block3;
                }
                if (n >= tree.count()) {
                    tree2 = tree;
                    break block3;
                }
                l = this.count(tree.left());
                if (n > l) break;
                tree = tree.left();
            }
            tree2 = n == l + 1 ? this.maybeBlacken(this.updNth(tree.left(), n, tree.key(), tree.value())) : this.scala$collection$immutable$RedBlackTree$$join(tree.left(), tree.key(), tree.value(), this.doTake(tree.right(), n - l - 1));
        }
        return tree2;
    }

    private <A, B> RedBlackTree.Tree<A, B> doSlice(RedBlackTree.Tree<A, B> tree, int from, int until) {
        RedBlackTree.Tree<A, B> tree2;
        block4: {
            int l;
            while (true) {
                if (tree == null || from >= until || from >= tree.count() || until <= 0) {
                    tree2 = null;
                    break block4;
                }
                if (from <= 0 && until >= tree.count()) {
                    tree2 = tree;
                    break block4;
                }
                l = this.count(tree.left());
                if (until <= l) {
                    tree = tree.left();
                    continue;
                }
                if (from <= l) break;
                until = until - l - 1;
                from = from - l - 1;
                tree = tree.right();
            }
            tree2 = this.scala$collection$immutable$RedBlackTree$$join(this.doDrop(tree.left(), from), tree.key(), tree.value(), this.doTake(tree.right(), until - l - 1));
        }
        return tree2;
    }

    public final int colourBit() {
        return Integer.MIN_VALUE;
    }

    public final int colourMask() {
        return Integer.MAX_VALUE;
    }

    public final int initialBlackCount() {
        return Integer.MIN_VALUE;
    }

    public final int initialRedCount() {
        return 0;
    }

    public <A, B> RedBlackTree.Tree<A, B> mutableRedTree(A key, B value, RedBlackTree.Tree<A, B> left, RedBlackTree.Tree<A, B> right) {
        return new RedBlackTree.Tree(key, value, left, right, 0);
    }

    public <A, B> RedBlackTree.Tree<A, B> mutableBlackTree(A key, B value, RedBlackTree.Tree<A, B> left, RedBlackTree.Tree<A, B> right) {
        return new RedBlackTree.Tree(key, value, left, right, Integer.MIN_VALUE);
    }

    public <A, B> RedBlackTree.Tree<A, B> RedTree(A key, B value, RedBlackTree.Tree<A, B> left, RedBlackTree.Tree<A, B> right) {
        int size = this.sizeOf(left) + this.sizeOf(right) + 1;
        return new RedBlackTree.Tree(key, value, left, right, 0 | size);
    }

    public <A, B> RedBlackTree.Tree<A, B> BlackTree(A key, B value, RedBlackTree.Tree<A, B> left, RedBlackTree.Tree<A, B> right) {
        int size = this.sizeOf(left) + this.sizeOf(right) + 1;
        return new RedBlackTree.Tree(key, value, left, right, Integer.MIN_VALUE | size);
    }

    private int sizeOf(RedBlackTree.Tree<?, ?> tree) {
        return tree == null ? 0 : tree.count();
    }

    public <A> RedBlackTree.Tree<A, Null$> fromOrderedKeys(Iterator<A> xs, int size) {
        int maxUsedDepth = 32 - Integer.numberOfLeadingZeros(size);
        return this.f$1(1, size, maxUsedDepth, xs);
    }

    public <A, B> RedBlackTree.Tree<A, B> fromOrderedEntries(Iterator<Tuple2<A, B>> xs, int size) {
        int maxUsedDepth = 32 - Integer.numberOfLeadingZeros(size);
        return this.f$2(1, size, xs, maxUsedDepth);
    }

    public <A, B, C> RedBlackTree.Tree<A, C> transform(RedBlackTree.Tree<A, B> t, Function2<A, B, C> f) {
        RedBlackTree.Tree<A, Object> tree;
        if (t == null) {
            tree = null;
        } else {
            A k = t.key();
            B v = t.value();
            RedBlackTree.Tree<A, B> l = t.left();
            RedBlackTree.Tree<A, B> r = t.right();
            RedBlackTree.Tree<A, C> l2 = this.transform(l, f);
            C v2 = f.apply(k, v);
            RedBlackTree.Tree<A, C> r2 = this.transform(r, f);
            tree = v2 == v && l2 == l && r2 == r ? t : this.mkTree(t.isBlack(), k, v2, l2, r2);
        }
        return tree;
    }

    public <A, B> RedBlackTree.Tree<A, B> filterEntries(RedBlackTree.Tree<A, B> t, Function2<A, B, Object> f) {
        return t == null ? null : this.blacken(this.fk$1(t, f));
    }

    public <A, B> Tuple2<RedBlackTree.Tree<A, B>, RedBlackTree.Tree<A, B>> partitionEntries(RedBlackTree.Tree<A, B> t, Function2<A, B, Object> p) {
        Tuple2 tuple2;
        if (t == null) {
            tuple2 = new Tuple2(null, null);
        } else if (t == null) {
            tuple2 = null2;
        } else {
            LazyRef partitioner$module = new LazyRef();
            this.partitioner$2(partitioner$module, p).fk(t);
            tuple2 = new Tuple2(this.blacken(this.partitioner$2(partitioner$module, p).tmpk()), this.blacken(this.partitioner$2(partitioner$module, p).tmpd()));
        }
        return tuple2;
    }

    private <A, B> RedBlackTree.Tree<A, B> del(RedBlackTree.Tree<A, B> tree, A k, Ordering<A> ordering) {
        RedBlackTree.Tree<A, B> newRight;
        RedBlackTree.Tree<A, B> newLeft;
        int cmp;
        RedBlackTree.Tree<A, B> tree2 = tree == null ? null : ((cmp = ordering.compare(k, tree.key())) < 0 ? ((newLeft = this.del(tree.left(), k, ordering)) == tree.left() ? tree : (this.isBlackTree(tree.left()) ? this.balLeft(tree, newLeft, tree.right()) : tree.redWithLeft(newLeft))) : (cmp > 0 ? ((newRight = this.del(tree.right(), k, ordering)) == tree.right() ? tree : (this.isBlackTree(tree.right()) ? this.balRight(tree, tree.left(), newRight) : tree.redWithRight(newRight))) : this.append(tree.left(), tree.right())));
        return tree2;
    }

    private <A, B> RedBlackTree.Tree<A, B> balance(RedBlackTree.Tree<A, B> tree, RedBlackTree.Tree<A, B> tl, RedBlackTree.Tree<A, B> tr) {
        return this.scala$collection$immutable$RedBlackTree$$isRedTree(tl) ? (this.scala$collection$immutable$RedBlackTree$$isRedTree(tr) ? tree.redWithLeftRight(tl.black(), tr.black()) : (this.scala$collection$immutable$RedBlackTree$$isRedTree(tl.left()) ? tl.withLeftRight(tl.left().black(), tree.blackWithLeftRight(tl.right(), tr)) : (this.scala$collection$immutable$RedBlackTree$$isRedTree(tl.right()) ? tl.right().withLeftRight(tl.blackWithRight(tl.right().left()), tree.blackWithLeftRight(tl.right().right(), tr)) : tree.blackWithLeftRight(tl, tr)))) : (this.scala$collection$immutable$RedBlackTree$$isRedTree(tr) ? (this.scala$collection$immutable$RedBlackTree$$isRedTree(tr.right()) ? tr.withLeftRight(tree.blackWithLeftRight(tl, tr.left()), tr.right().black()) : (this.scala$collection$immutable$RedBlackTree$$isRedTree(tr.left()) ? tr.left().withLeftRight(tree.blackWithLeftRight(tl, tr.left().left()), tr.blackWithLeftRight(tr.left().right(), tr.right())) : tree.blackWithLeftRight(tl, tr))) : tree.blackWithLeftRight(tl, tr));
    }

    private <A, B> RedBlackTree.Tree<A, B> balLeft(RedBlackTree.Tree<A, B> tree, RedBlackTree.Tree<A, B> tl, RedBlackTree.Tree<A, B> tr) {
        RedBlackTree.Tree<A, B> tree2;
        if (this.scala$collection$immutable$RedBlackTree$$isRedTree(tl)) {
            tree2 = tree.redWithLeftRight(tl.black(), tr);
        } else if (this.isBlackTree(tr)) {
            tree2 = this.balance(tree, tl, tr.red());
        } else if (this.scala$collection$immutable$RedBlackTree$$isRedTree(tr) && this.isBlackTree(tr.left())) {
            tree2 = tr.left().redWithLeftRight(tree.blackWithLeftRight(tl, tr.left().left()), this.balance(tr, tr.left().right(), tr.right().red()));
        } else {
            throw package$.MODULE$.error("Defect: invariance violation");
        }
        return tree2;
    }

    private <A, B> RedBlackTree.Tree<A, B> balRight(RedBlackTree.Tree<A, B> tree, RedBlackTree.Tree<A, B> tl, RedBlackTree.Tree<A, B> tr) {
        RedBlackTree.Tree<A, B> tree2;
        if (this.scala$collection$immutable$RedBlackTree$$isRedTree(tr)) {
            tree2 = tree.redWithLeftRight(tl, tr.black());
        } else if (this.isBlackTree(tl)) {
            tree2 = this.balance(tree, tl.red(), tr);
        } else if (this.scala$collection$immutable$RedBlackTree$$isRedTree(tl) && this.isBlackTree(tl.right())) {
            tree2 = tl.right().redWithLeftRight(this.balance(tl, tl.left().red(), tl.right().left()), tree.blackWithLeftRight(tl.right().right(), tr));
        } else {
            throw package$.MODULE$.error("Defect: invariance violation");
        }
        return tree2;
    }

    private <A, B> RedBlackTree.Tree<A, B> append(RedBlackTree.Tree<A, B> tl, RedBlackTree.Tree<A, B> tr) {
        RedBlackTree.Tree<A, B> bc;
        RedBlackTree.Tree<A, B> bc2;
        RedBlackTree.Tree<A, B> tree = tl == null ? tr : (tr == null ? tl : (tl.isRed() ? (tr.isRed() ? (this.scala$collection$immutable$RedBlackTree$$isRedTree(bc2 = this.append(tl.right(), tr.left())) ? bc2.withLeftRight(tl.withRight(bc2.left()), tr.withLeft(bc2.right())) : tl.withRight(tr.withLeft(bc2))) : tl.withRight(this.append(tl.right(), tr))) : (tr.isBlack() ? (this.scala$collection$immutable$RedBlackTree$$isRedTree(bc = this.append(tl.right(), tr.left())) ? bc.withLeftRight(tl.withRight(bc.left()), tr.withLeft(bc.right())) : this.balLeft(tl, tl.left(), tr.withLeft(bc))) : tr.withLeft(this.append(tl, tr.left())))));
        return tree;
    }

    public <A, B> RedBlackTree.Tree<A, B> union(RedBlackTree.Tree<A, B> t1, RedBlackTree.Tree<A, B> t2, Ordering<A> ordering) {
        return this.blacken(this._union(t1, t2, ordering));
    }

    public <A, B> RedBlackTree.Tree<A, B> intersect(RedBlackTree.Tree<A, B> t1, RedBlackTree.Tree<A, B> t2, Ordering<A> ordering) {
        return this.blacken(this._intersect(t1, t2, ordering));
    }

    public <A, B> RedBlackTree.Tree<A, B> difference(RedBlackTree.Tree<A, B> t1, RedBlackTree.Tree<A, ?> t2, Ordering<A> ordering) {
        return this.blacken(this._difference(t1, t2, ordering));
    }

    private int rank(RedBlackTree.Tree<?, ?> t, int bh) {
        return t == null ? 0 : (t.isBlack() ? 2 * (bh - 1) : 2 * bh - 1);
    }

    private <A, B> RedBlackTree.Tree<A, B> joinRight(RedBlackTree.Tree<A, B> tl, A k, B v, RedBlackTree.Tree<A, B> tr, int bhtl, int rtr) {
        RedBlackTree.Tree<A, Object> tree;
        int rtl = this.rank(tl, bhtl);
        if (rtl == rtr / 2 * 2) {
            tree = this.RedTree(k, v, tl, tr);
        } else {
            boolean tlBlack = this.isBlackTree(tl);
            int bhtlr = tlBlack ? bhtl - 1 : bhtl;
            RedBlackTree.Tree<A, B> ttr = this.joinRight(tl.right(), k, v, tr, bhtlr, rtr);
            tree = tlBlack && this.scala$collection$immutable$RedBlackTree$$isRedTree(ttr) && this.scala$collection$immutable$RedBlackTree$$isRedTree(ttr.right()) ? this.RedTree(ttr.key(), ttr.value(), this.BlackTree(tl.key(), tl.value(), tl.left(), ttr.left()), ttr.right().black()) : this.mkTree(tlBlack, tl.key(), tl.value(), tl.left(), ttr);
        }
        return tree;
    }

    private <A, B> RedBlackTree.Tree<A, B> joinLeft(RedBlackTree.Tree<A, B> tl, A k, B v, RedBlackTree.Tree<A, B> tr, int rtl, int bhtr) {
        RedBlackTree.Tree<A, Object> tree;
        int rtr = this.rank(tr, bhtr);
        if (rtr == rtl / 2 * 2) {
            tree = this.RedTree(k, v, tl, tr);
        } else {
            boolean trBlack = this.isBlackTree(tr);
            int bhtrl = trBlack ? bhtr - 1 : bhtr;
            RedBlackTree.Tree<A, B> ttl = this.joinLeft(tl, k, v, tr.left(), rtl, bhtrl);
            tree = trBlack && this.scala$collection$immutable$RedBlackTree$$isRedTree(ttl) && this.scala$collection$immutable$RedBlackTree$$isRedTree(ttl.left()) ? this.RedTree(ttl.key(), ttl.value(), ttl.left().black(), this.BlackTree(tr.key(), tr.value(), ttl.right(), tr.right())) : this.mkTree(trBlack, tr.key(), tr.value(), ttl, tr.right());
        }
        return tree;
    }

    public <A, B> RedBlackTree.Tree<A, B> scala$collection$immutable$RedBlackTree$$join(RedBlackTree.Tree<A, B> tl, A k, B v, RedBlackTree.Tree<A, B> tr) {
        RedBlackTree.Tree<A, B> tt;
        RedBlackTree.Tree<A, B> tt2;
        int bhtr;
        int bhtl = this.h$1(tl, 0);
        RedBlackTree.Tree<A, Object> tree = bhtl > (bhtr = this.h$1(tr, 0)) ? (this.scala$collection$immutable$RedBlackTree$$isRedTree(tt2 = this.joinRight(tl, k, v, tr, bhtl, this.rank(tr, bhtr))) && this.scala$collection$immutable$RedBlackTree$$isRedTree(tt2.right()) ? tt2.black() : tt2) : (bhtr > bhtl ? (this.scala$collection$immutable$RedBlackTree$$isRedTree(tt = this.joinLeft(tl, k, v, tr, this.rank(tl, bhtl), bhtr)) && this.scala$collection$immutable$RedBlackTree$$isRedTree(tt.left()) ? tt.black() : tt) : this.mkTree(this.scala$collection$immutable$RedBlackTree$$isRedTree(tl) || this.scala$collection$immutable$RedBlackTree$$isRedTree(tr), k, v, tl, tr));
        return tree;
    }

    private <A, B> Tuple4<RedBlackTree.Tree<A, B>, RedBlackTree.Tree<A, B>, RedBlackTree.Tree<A, B>, A> split(RedBlackTree.Tree<A, B> t, A k2, Ordering<A> ordering) {
        Tuple4<RedBlackTree.Tree<A, B>, RedBlackTree.Tree<A, B>, RedBlackTree.Tree<A, B>, A> tuple4;
        if (t == null) {
            tuple4 = new Tuple4<RedBlackTree.Tree<A, B>, RedBlackTree.Tree<A, B>, RedBlackTree.Tree<A, B>, A>(null, null, null, k2);
        } else {
            int cmp = ordering.compare(k2, t.key());
            if (cmp == 0) {
                tuple4 = new Tuple4<RedBlackTree.Tree<A, B>, RedBlackTree.Tree<A, B>, RedBlackTree.Tree<A, B>, A>(t.left(), t, t.right(), t.key());
            } else if (cmp < 0) {
                Tuple4<RedBlackTree.Tree<A, B>, RedBlackTree.Tree<A, B>, RedBlackTree.Tree<A, B>, A> tuple42 = this.split(t.left(), k2, ordering);
                if (tuple42 == null) {
                    throw new MatchError(tuple42);
                }
                RedBlackTree.Tree<A, B> ll = tuple42._1();
                RedBlackTree.Tree<A, B> b = tuple42._2();
                RedBlackTree.Tree<A, B> lr = tuple42._3();
                A k1 = tuple42._4();
                Tuple4<RedBlackTree.Tree<A, B>, RedBlackTree.Tree<A, B>, RedBlackTree.Tree<A, B>, A> tuple43 = new Tuple4<RedBlackTree.Tree<A, B>, RedBlackTree.Tree<A, B>, RedBlackTree.Tree<A, B>, A>(ll, b, lr, k1);
                Tuple4<RedBlackTree.Tree<A, B>, RedBlackTree.Tree<A, B>, RedBlackTree.Tree<A, B>, A> tuple44 = tuple43;
                RedBlackTree.Tree<A, B> ll2 = tuple44._1();
                RedBlackTree.Tree<A, B> b2 = tuple44._2();
                RedBlackTree.Tree<A, B> lr2 = tuple44._3();
                A k12 = tuple44._4();
                tuple4 = new Tuple4<RedBlackTree.Tree<A, B>, RedBlackTree.Tree<A, B>, RedBlackTree.Tree<A, B>, A>(ll2, b2, this.scala$collection$immutable$RedBlackTree$$join(lr2, t.key(), t.value(), t.right()), k12);
            } else {
                Tuple4<RedBlackTree.Tree<A, B>, RedBlackTree.Tree<A, B>, RedBlackTree.Tree<A, B>, A> tuple45 = this.split(t.right(), k2, ordering);
                if (tuple45 == null) {
                    throw new MatchError(tuple45);
                }
                RedBlackTree.Tree<A, B> rl = tuple45._1();
                RedBlackTree.Tree<A, B> b = tuple45._2();
                RedBlackTree.Tree<A, B> rr = tuple45._3();
                A k1 = tuple45._4();
                Tuple4<RedBlackTree.Tree<A, B>, RedBlackTree.Tree<A, B>, RedBlackTree.Tree<A, B>, A> tuple46 = new Tuple4<RedBlackTree.Tree<A, B>, RedBlackTree.Tree<A, B>, RedBlackTree.Tree<A, B>, A>(rl, b, rr, k1);
                Tuple4<RedBlackTree.Tree<A, B>, RedBlackTree.Tree<A, B>, RedBlackTree.Tree<A, B>, A> tuple47 = tuple46;
                RedBlackTree.Tree<A, B> rl2 = tuple47._1();
                RedBlackTree.Tree<A, B> b3 = tuple47._2();
                RedBlackTree.Tree<A, B> rr2 = tuple47._3();
                A k13 = tuple47._4();
                tuple4 = new Tuple4<RedBlackTree.Tree<A, B>, RedBlackTree.Tree<A, B>, RedBlackTree.Tree<A, B>, A>(this.scala$collection$immutable$RedBlackTree$$join(t.left(), t.key(), t.value(), rl2), b3, rr2, k13);
            }
        }
        return tuple4;
    }

    private <A, B> Tuple3<RedBlackTree.Tree<A, B>, A, B> splitLast(RedBlackTree.Tree<A, B> t) {
        Tuple3<RedBlackTree.Tree<A, B>, A, B> tuple3;
        if (t.right() == null) {
            tuple3 = new Tuple3<RedBlackTree.Tree<A, B>, A, B>(t.left(), t.key(), t.value());
        } else {
            Tuple3<RedBlackTree.Tree<A, B>, A, B> tuple32 = this.splitLast(t.right());
            if (tuple32 == null) {
                throw new MatchError(tuple32);
            }
            RedBlackTree.Tree<A, B> tt = tuple32._1();
            A kk = tuple32._2();
            B vv = tuple32._3();
            Tuple3<RedBlackTree.Tree<A, B>, A, B> tuple33 = new Tuple3<RedBlackTree.Tree<A, B>, A, B>(tt, kk, vv);
            Tuple3<RedBlackTree.Tree<A, B>, A, B> tuple34 = tuple33;
            RedBlackTree.Tree<A, B> tt2 = tuple34._1();
            A kk2 = tuple34._2();
            B vv2 = tuple34._3();
            tuple3 = new Tuple3<RedBlackTree.Tree<A, B>, A, B>(this.scala$collection$immutable$RedBlackTree$$join(t.left(), t.key(), t.value(), tt2), kk2, vv2);
        }
        return tuple3;
    }

    public <A, B> RedBlackTree.Tree<A, B> scala$collection$immutable$RedBlackTree$$join2(RedBlackTree.Tree<A, B> tl, RedBlackTree.Tree<A, B> tr) {
        RedBlackTree.Tree<A, B> tree;
        if (tl == null) {
            tree = tr;
        } else if (tr == null) {
            tree = tl;
        } else {
            Tuple3<RedBlackTree.Tree<A, B>, A, B> tuple3 = this.splitLast(tl);
            if (tuple3 == null) {
                throw new MatchError(tuple3);
            }
            RedBlackTree.Tree<A, B> ttl = tuple3._1();
            A k = tuple3._2();
            B v = tuple3._3();
            Tuple3<RedBlackTree.Tree<A, B>, A, B> tuple32 = new Tuple3<RedBlackTree.Tree<A, B>, A, B>(ttl, k, v);
            Tuple3<RedBlackTree.Tree<A, B>, A, B> tuple33 = tuple32;
            RedBlackTree.Tree<A, B> ttl2 = tuple33._1();
            A k2 = tuple33._2();
            B v2 = tuple33._3();
            tree = this.scala$collection$immutable$RedBlackTree$$join(ttl2, k2, v2, tr);
        }
        return tree;
    }

    private <A, B> RedBlackTree.Tree<A, B> _union(RedBlackTree.Tree<A, B> t1, RedBlackTree.Tree<A, B> t2, Ordering<A> ordering) {
        RedBlackTree.Tree<A, B> tree;
        if (t1 == null || t1 == t2) {
            tree = t2;
        } else if (t2 == null) {
            tree = t1;
        } else {
            Tuple4<RedBlackTree.Tree<A, B>, RedBlackTree.Tree<A, B>, RedBlackTree.Tree<A, B>, A> tuple4 = this.split(t1, t2.key(), ordering);
            if (tuple4 == null) {
                throw new MatchError(tuple4);
            }
            RedBlackTree.Tree<A, B> l1 = tuple4._1();
            RedBlackTree.Tree<A, B> r1 = tuple4._3();
            A k1 = tuple4._4();
            Tuple3<RedBlackTree.Tree<A, B>, RedBlackTree.Tree<A, B>, A> tuple3 = new Tuple3<RedBlackTree.Tree<A, B>, RedBlackTree.Tree<A, B>, A>(l1, r1, k1);
            Tuple3<RedBlackTree.Tree<A, B>, RedBlackTree.Tree<A, B>, A> tuple32 = tuple3;
            RedBlackTree.Tree<A, B> l12 = tuple32._1();
            RedBlackTree.Tree<A, B> r12 = tuple32._2();
            A k12 = tuple32._3();
            RedBlackTree.Tree<A, B> tl = this._union(l12, t2.left(), ordering);
            RedBlackTree.Tree<A, B> tr = this._union(r12, t2.right(), ordering);
            tree = this.scala$collection$immutable$RedBlackTree$$join(tl, k12, t2.value(), tr);
        }
        return tree;
    }

    private <A, B> RedBlackTree.Tree<A, B> _intersect(RedBlackTree.Tree<A, B> t1, RedBlackTree.Tree<A, B> t2, Ordering<A> ordering) {
        RedBlackTree.Tree<A, B> tree;
        if (t1 == null || t2 == null) {
            tree = null;
        } else if (t1 == t2) {
            tree = t1;
        } else {
            Tuple4<RedBlackTree.Tree<A, B>, RedBlackTree.Tree<A, B>, RedBlackTree.Tree<A, B>, A> tuple4 = this.split(t1, t2.key(), ordering);
            if (tuple4 == null) {
                throw new MatchError(tuple4);
            }
            RedBlackTree.Tree<A, B> l1 = tuple4._1();
            RedBlackTree.Tree<A, B> b = tuple4._2();
            RedBlackTree.Tree<A, B> r1 = tuple4._3();
            A k1 = tuple4._4();
            Tuple4<RedBlackTree.Tree<A, B>, RedBlackTree.Tree<A, B>, RedBlackTree.Tree<A, B>, A> tuple42 = new Tuple4<RedBlackTree.Tree<A, B>, RedBlackTree.Tree<A, B>, RedBlackTree.Tree<A, B>, A>(l1, b, r1, k1);
            Tuple4<RedBlackTree.Tree<A, B>, RedBlackTree.Tree<A, B>, RedBlackTree.Tree<A, B>, A> tuple43 = tuple42;
            RedBlackTree.Tree<A, B> l12 = tuple43._1();
            RedBlackTree.Tree<A, B> b2 = tuple43._2();
            RedBlackTree.Tree<A, B> r12 = tuple43._3();
            A k12 = tuple43._4();
            RedBlackTree.Tree<A, B> tl = this._intersect(l12, t2.left(), ordering);
            RedBlackTree.Tree<A, B> tr = this._intersect(r12, t2.right(), ordering);
            tree = b2 != null ? this.scala$collection$immutable$RedBlackTree$$join(tl, k12, t2.value(), tr) : this.scala$collection$immutable$RedBlackTree$$join2(tl, tr);
        }
        return tree;
    }

    private <A, B> RedBlackTree.Tree<A, B> _difference(RedBlackTree.Tree<A, B> t1, RedBlackTree.Tree<A, B> t2, Ordering<A> ordering) {
        RedBlackTree.Tree<A, B> tree;
        if (t1 == null || t2 == null) {
            tree = t1;
        } else if (t1 == t2) {
            tree = null;
        } else {
            Tuple4<RedBlackTree.Tree<A, B>, RedBlackTree.Tree<A, B>, RedBlackTree.Tree<A, B>, A> tuple4 = this.split(t1, t2.key(), ordering);
            if (tuple4 == null) {
                throw new MatchError(tuple4);
            }
            RedBlackTree.Tree<A, B> l1 = tuple4._1();
            RedBlackTree.Tree<A, B> r1 = tuple4._3();
            A k1 = tuple4._4();
            Tuple3<RedBlackTree.Tree<A, B>, RedBlackTree.Tree<A, B>, A> tuple3 = new Tuple3<RedBlackTree.Tree<A, B>, RedBlackTree.Tree<A, B>, A>(l1, r1, k1);
            Tuple3<RedBlackTree.Tree<A, B>, RedBlackTree.Tree<A, B>, A> tuple32 = tuple3;
            RedBlackTree.Tree<A, B> l12 = tuple32._1();
            RedBlackTree.Tree<A, B> r12 = tuple32._2();
            A k12 = tuple32._3();
            RedBlackTree.Tree<A, B> tl = this._difference(l12, t2.left(), ordering);
            RedBlackTree.Tree<A, B> tr = this._difference(r12, t2.right(), ordering);
            tree = this.scala$collection$immutable$RedBlackTree$$join2(tl, tr);
        }
        return tree;
    }

    private final RedBlackTree.Tree _tail$1(RedBlackTree.Tree tree) {
        if (tree == null) {
            throw new NoSuchElementException("empty tree");
        }
        RedBlackTree.Tree tl = tree.left();
        return tl == null ? tree.right() : (tl.isBlack() ? this.balLeft(tree, this._tail$1(tl), tree.right()) : tree.redWithLeft(this._tail$1(tree.left())));
    }

    private final RedBlackTree.Tree _init$1(RedBlackTree.Tree tree) {
        if (tree == null) {
            throw new NoSuchElementException("empty tree");
        }
        RedBlackTree.Tree tr = tree.right();
        return tr == null ? tree.left() : (tr.isBlack() ? this.balRight(tree, tree.left(), this._init$1(tr)) : tree.redWithRight(this._init$1(tr)));
    }

    private final RedBlackTree.Tree f$1(int level, int size, int maxUsedDepth$1, Iterator xs$1) {
        RedBlackTree.Tree tree;
        int n = size;
        switch (n) {
            case 0: {
                tree = null;
                break;
            }
            case 1: {
                tree = this.mkTree(level != maxUsedDepth$1 || level == 1, xs$1.next(), null, null, null);
                break;
            }
            default: {
                int leftSize = (size - 1) / 2;
                RedBlackTree.Tree left = this.f$1(level + 1, leftSize, maxUsedDepth$1, xs$1);
                Object x = xs$1.next();
                RedBlackTree.Tree right = this.f$1(level + 1, size - 1 - leftSize, maxUsedDepth$1, xs$1);
                tree = this.BlackTree(x, null, left, right);
                break;
            }
        }
        return tree;
    }

    private final RedBlackTree.Tree f$2(int level, int size, Iterator xs$2, int maxUsedDepth$2) {
        RedBlackTree.Tree tree;
        int n = size;
        switch (n) {
            case 0: {
                tree = null;
                break;
            }
            case 1: {
                Tuple2 tuple2 = (Tuple2)xs$2.next();
                if (tuple2 == null) {
                    throw new MatchError(tuple2);
                }
                Object k = tuple2._1();
                Object v = tuple2._2();
                Tuple2 tuple22 = new Tuple2(k, v);
                Tuple2 tuple23 = tuple22;
                Object k2 = tuple23._1();
                Object v2 = tuple23._2();
                tree = this.mkTree(level != maxUsedDepth$2 || level == 1, k2, v2, null, null);
                break;
            }
            default: {
                int leftSize = (size - 1) / 2;
                RedBlackTree.Tree left = this.f$2(level + 1, leftSize, xs$2, maxUsedDepth$2);
                Tuple2 tuple2 = (Tuple2)xs$2.next();
                if (tuple2 == null) {
                    throw new MatchError(tuple2);
                }
                Object k = tuple2._1();
                Object v = tuple2._2();
                Tuple2 tuple24 = new Tuple2(k, v);
                Tuple2 tuple25 = tuple24;
                Object k3 = tuple25._1();
                Object v3 = tuple25._2();
                RedBlackTree.Tree right = this.f$2(level + 1, size - 1 - leftSize, xs$2, maxUsedDepth$2);
                tree = this.BlackTree(k3, v3, left, right);
                break;
            }
        }
        return tree;
    }

    private final RedBlackTree.Tree fk$1(RedBlackTree.Tree t, Function2 f$3) {
        RedBlackTree.Tree r2;
        Object k = t.key();
        Object v = t.value();
        RedBlackTree.Tree l = t.left();
        RedBlackTree.Tree r = t.right();
        RedBlackTree.Tree l2 = l == null ? null : this.fk$1(l, f$3);
        boolean keep = BoxesRunTime.unboxToBoolean(f$3.apply(k, v));
        RedBlackTree.Tree tree = r2 = r == null ? null : this.fk$1(r, f$3);
        return !keep ? this.scala$collection$immutable$RedBlackTree$$join2(l2, r2) : (l2 == l && r2 == r ? t : this.scala$collection$immutable$RedBlackTree$$join(l2, k, v, r2));
    }

    private static final /* synthetic */ RedBlackTree$partitioner$1$ partitioner$lzycompute$1(LazyRef partitioner$module$1, Function2 p$1) {
        RedBlackTree$partitioner$1$ redBlackTree$partitioner$1$;
        LazyRef lazyRef = partitioner$module$1;
        synchronized (lazyRef) {
            redBlackTree$partitioner$1$ = partitioner$module$1.initialized() ? (RedBlackTree$partitioner$1$)partitioner$module$1.value() : partitioner$module$1.initialize(new RedBlackTree$partitioner$1$(p$1));
        }
        return redBlackTree$partitioner$1$;
    }

    private final RedBlackTree$partitioner$1$ partitioner$2(LazyRef partitioner$module$1, Function2 p$1) {
        return partitioner$module$1.initialized() ? (RedBlackTree$partitioner$1$)partitioner$module$1.value() : RedBlackTree$.partitioner$lzycompute$1(partitioner$module$1, p$1);
    }

    private final int h$1(RedBlackTree.Tree t, int i) {
        while (t != null) {
            i = t.isBlack() ? i + 1 : i;
            t = t.left();
        }
        return i + 1;
    }

    private RedBlackTree$() {
    }
}

