#!/usr/bin/env python
# coding: utf-8

# In[1]:


x, y = var('x y')
W = plot3d(sin(pi*((x)^2 + (y)^2))/2, (x, -1, 1), (y, -1, 1), frame=False, color='purple', opacity=0.8)
S = sphere((0, 0, 0), size=0.3, color='red', aspect_ratio=[1,1,1])
show(W + S, figsize=8)


# In[2]:


def f(x,y):
    return math.sin(y^2 + x^2)/math.sqrt(x^2 + y^2 + 0.0001)
P = plot3d(f, (-3, 3), (-3, 3), adaptive=True, color=rainbow(60, 'rgbtuple'), max_bend=.1, max_depth=15)
P.show()


# In[3]:


def f(x,y):
    return math.exp(x/5)*math.sin(y)

P = plot3d(f, (-5, 5), (-5, 5), adaptive=True, color=['red', 'yellow'])
from sage.plot.plot3d.plot3d import axes
S = P + axes(6, color='black')
S.show()


# In[4]:


x, y = var('x y')
cm = colormaps.hsv
def c(x, y): return float((x + y + x*y)/15) % 1
plot3d(x*x + y*y, (x, -4, 4), (y, -4, 4), color=(c, cm))


# In[5]:


S = sphere(size=.5, color='yellow')
from sage.plot.plot3d.shapes import Cone
S += Cone(.5, .5, color='red').translate(0,0,.3)
S += sphere((.45, -.1, .15), size=.1, color='white') + sphere((.51,-.1,.17), size=.05, color='black')
S += sphere((.45, .1, .15), size=.1, color='white') + sphere((.51, .1,.17), size=.05, color='black')
S += sphere((.5, 0, -.2), size=.1, color='yellow')
def f(x,y): return math.exp(x/5)*math.cos(y)
P = plot3d(f, (-5, 5), (-5, 5), adaptive=True, color=['red','yellow'], max_depth=10)
cape_man = P.scale(.2) + S.translate(1, 0, 0)
cape_man.show(aspect_ratio=[1, 1, 1])


# In[6]:


plot3d(pi, (-1,1), (-1,1))


# In[7]:


T = Cylindrical('height', ['radius', 'azimuth'])
r, theta, z = var('r theta z')
plot3d(9-r**2, (r, 0, 3), (theta, 0, pi), transformation=T)


# In[8]:


S = Cylindrical('radius', ['azimuth', 'height'])
theta, z = var('theta, z')
plot3d(3, (theta, 0, 2*pi), (z, -2, 2), transformation=S)


# In[9]:


r, phi, theta = var('r phi theta')
T = Spherical('radius', ['azimuth', 'inclination'])
plot3d(phi * theta, (theta, 0, pi), (phi, 0, 1), transformation=T)


# In[10]:


S = Spherical('inclination', ['radius', 'azimuth'])
r, theta = var('r,theta')
plot3d(r-r+3, (r,0,3), (theta, 0, 2*pi), transformation=S)


# In[11]:


T = SphericalElevation('radius', ['azimuth', 'elevation'])
r, theta, phi = var('r theta phi')
plot3d(phi * theta, (theta, 0, pi), (phi, 0, 1), transformation=T)


# In[12]:


SE = SphericalElevation('elevation', ['radius', 'azimuth'])
r, theta = var('r,theta')
plot3d(3+r-r, (r,0,3), (theta, 0, 2*pi), transformation=SE)


# In[13]:


r, theta = var('r,theta')
SE = SphericalElevation('elevation', ['radius', 'azimuth'])
P1 = plot3d( (pi/12)*sin(8*theta), (r,0.99,1), (theta, 0, 2*pi), transformation=SE, plot_points=(10,200))
P2 = sphere(center=(0,0,0), size=1, color='red', opacity=0.3)
P1 + P2


# In[14]:


r, phi, theta = var('r phi theta')
SE = SphericalElevation('elevation', ['radius', 'azimuth'])
S = Spherical('inclination', ['radius', 'azimuth'])
angles = [pi/18, pi/12, pi/6]
P1=Graphics()
P2=Graphics()
for a in angles:
    P1 += plot3d( a, (r,0,3), (theta, 0, 2*pi), transformation=SE, opacity=0.85, color='blue')
    P2 += plot3d( a, (r,0,3), (theta, 0, 2*pi), transformation=S, opacity=0.85, color='red')
P1+P2


# In[15]:


from sage.plot.plot3d.plot3d import axes
S = axes(6, color='black'); S


# In[16]:


from sage.plot.plot3d.plot3d import axes
T = axes(2, .5); T


# In[17]:


r, u, v = var('r,u,v')
f = u*v; urange = (u, 0, pi); vrange = (v, 0, pi)
T = (r*cos(u), r*sin(u), v, [u, v])
plot3d(f, urange, vrange, transformation=T)


# In[18]:


theta, z = var('theta,z')
cylindrical_plot3d(2, (theta, 0, 3*pi/2), (z, -2, 2))


# In[19]:


theta, z = var('theta,z')
cylindrical_plot3d(cosh(z), (theta, 0, 2*pi), (z, -2, 2))


# In[20]:


theta, z = var('theta,z')
cylindrical_plot3d(e^(-z^2)*(cos(4*theta) + 2) + 1, (theta, 0, 2*pi), (z, -2, 2), plot_points=[80, 80]).show(aspect_ratio=(1, 1, 1))


# In[21]:


plot3d(lambda x, y: x**2 + y**2, (-2,2), (-2,2))


# In[22]:


plot3d(lambda x, y: x**2 + y**2, (-2,2), (-2,2), adaptive=True)


# In[23]:


plot3d(lambda x, y: x**2 + y**2, (-2,2), (-2,2), adaptive=True, initial_depth=5)


# In[24]:


var('x y')
plot3d(x**2 + y**2, (x,-2,2), (y,-2,2))


# In[25]:


var('x y')
plot3d(sin(x*y), (x, -pi, pi), (y, -pi, pi))


# In[26]:


var('x y')
plot3d(sin(x^2 + y^2),(x,-5,5),(y,-5,5), plot_points=200)


# In[27]:


var('x y')
plot3d(sin(x^2 + y^2), (x, -5, 5), (y, -5, 5), plot_points=[10, 100])


# In[28]:


var('x,y')
plot3d(sin(x - y)*y*cos(x), (x, -3, 3), (y, -3, 3), mesh=True)


# In[29]:


x,y = var('x,y')
P = plot3d(x + y + sin(x*y), (x, -10, 10), (y, -10, 10), opacity=0.87, color='blue')
Q = plot3d(x - 2*y - cos(x*y),(x, -10, 10), (y, -10, 10), opacity=0.3, color='red')
P + Q


# In[30]:


L = plot3d(lambda x,y: 0, (-5,5), (-5,5), color="lightblue", opacity=0.8)
P = plot3d(lambda x,y: 4 - x^3 - y^2, (-2,2), (-2,2), color='green')
Q = plot3d(lambda x,y: x^3 + y^2 - 4, (-2,2), (-2,2), color='orange')
L + P + Q


# In[31]:


x, y = var('x y')
plot3d(sin(pi*(x^2 + y^2))/2, (x, -1, 1), (y, -1, 1))


# In[32]:


x, y = var('x y')
plot3d(4*x*exp(-x^2 - y^2), (x, -2, 2), (y, -2, 2))


# In[33]:


r, phi, z = var('r phi z')
trans = (r*cos(phi), r*sin(phi), z)
plot3d(cos(r), (r, 0, 17*pi/2), (phi, 0, 2*pi), transformation=trans, opacity=0.87).show(aspect_ratio=(1,1,2), frame=False)


# In[34]:


r, theta, z = var('r theta z')
cylindrical(r, theta, z) = [r*cos(theta), r*sin(theta), z]
plot3d(3, (theta, 0, pi/2), (z, 0, pi/2), transformation=cylindrical)


# In[35]:


from sage.plot.plot3d.plot3d import plot3d_adaptive
x, y = var('x,y')
plot3d_adaptive(sin(x*y), (x, -pi, pi), (y, -pi, pi), initial_depth=5)


# In[36]:


x,y = var('x,y')
spherical_plot3d(2, (x, 0, 2*pi), (y, 0, pi))


# In[37]:


phi, theta = var('phi, theta')
Y = spherical_harmonic(2, 1, theta, phi)
rea = spherical_plot3d(abs(real(Y)), (phi, 0, 2*pi), (theta, 0, pi), color='blue', opacity=0.6)
ima = spherical_plot3d(abs(imag(Y)), (phi, 0, 2*pi), (theta, 0, pi), color='red', opacity=0.6)
(rea + ima).show(aspect_ratio=1)  # long time (4s on sage.math, 2011)


# In[38]:


x,y = var('x,y')
spherical_plot3d(e^-y, (x, 0, 2*pi), (y, 0, pi), opacity=0.5).show(frame=False)


# In[39]:


x,y = var('x,y')
spherical_plot3d((2 + cos(2*x))*(y + 1), (x, 0, 2*pi), (y, 0, pi), rgbcolor=(1, .1, .1))


# In[40]:


x,y = var('x,y')
spherical_plot3d(1 + sin(5*x)/5, (x, 0, 2*pi), (y, 0, pi), rgbcolor=(1, 0.5, 0), plot_points=(80, 80), opacity=0.7)


# In[41]:


x, y = var('x,y')
spherical_plot3d(1 + 2*cos(2*y), (x, 0, 3*pi/2), (y, 0, pi)).show(aspect_ratio=(1, 1, 1))

