;(function(g){'use strict';
/*
 *      bignumber.js v6.0.0
 *      A JavaScript library for arbitrary-precision arithmetic.
 *      https://github.com/MikeMcl/bignumber.js
 *      Copyright (c) 2018 Michael Mclaughlin <M8ch88l@gmail.com>
 *      MIT Licensed.
 *
 *      BigNumber.prototype methods     |  BigNumber methods
 *                                      |
 *      absoluteValue            abs    |  clone
 *      comparedTo                      |  config               set
 *      decimalPlaces            dp     |      DECIMAL_PLACES
 *      dividedBy                div    |      ROUNDING_MODE
 *      dividedToIntegerBy       idiv   |      EXPONENTIAL_AT
 *      exponentiatedBy          pow    |      RANGE
 *      integerValue                    |      CRYPTO
 *      isEqualTo                eq     |      MODULO_MODE
 *      isFinite                        |      POW_PRECISION
 *      isGreaterThan            gt     |      FORMAT
 *      isGreaterThanOrEqualTo   gte    |      ALPHABET
 *      isInteger                       |  isBigNumber
 *      isLessThan               lt     |  maximum              max
 *      isLessThanOrEqualTo      lte    |  minimum              min
 *      isNaN                           |  random
 *      isNegative                      |
 *      isPositive                      |
 *      isZero                          |
 *      minus                           |
 *      modulo                   mod    |
 *      multipliedBy             times  |
 *      negated                         |
 *      plus                            |
 *      precision                sd     |
 *      shiftedBy                       |
 *      squareRoot               sqrt   |
 *      toExponential                   |
 *      toFixed                         |
 *      toFormat                        |
 *      toFraction                      |
 *      toJSON                          |
 *      toNumber                        |
 *      toPrecision                     |
 *      toString                        |
 *      valueOf                         |
 *
 */
var B,f=/^-?(?:\d+(?:\.\d*)?|\.\d+)(?:e[+-]?\d+)?$/i,h=Math.ceil,o=Math.floor,u='[BigNumber Error] ',w=u+'Number primitive has more than 15 significant digits: ',A=1e14,L=14,M=0x1fffffffffffff,C=[1,10,100,1e3,1e4,1e5,1e6,1e7,1e8,1e9,1e10,1e11,1e12,1e13],S=1e7,D=1E9;function E(l){var O,Q,R,P=B.prototype,T=new B(1),U=20,V=4,W=-7,X=21,Y=-1e7,Z=1e7,$=false,_=1,a1=0,b1={decimalSeparator:'.',groupSeparator:',',groupSize:3,secondaryGroupSize:0,fractionGroupSeparator:'\xA0',fractionGroupSize:0},c1='0123456789abcdefghijklmnopqrstuvwxyz';function B(n,b){var a,c,e,i,d,j,s,x=this;if(!(x instanceof B)){return new B(n,b);}if(b==null){if(n instanceof B){x.s=n.s;x.e=n.e;x.c=(n=n.c)?n.slice():n;return;}d=typeof n=='number';if(d&&n*0==0){x.s=1/n<0?(n=-n,-1):1;if(n===~~n){for(e=0,i=n;i>=10;i/=10,e++);x.e=e;x.c=[n];return;}s=n+'';}else{if(!f.test(s=n+''))return R(x,s,d);x.s=s.charCodeAt(0)==45?(s=s.slice(1),-1):1;}}else{I(b,2,c1.length,'Base');s=n+'';if(b==10){x=new B(n instanceof B?n:s);return i1(x,U+x.e+1,V);}d=typeof n=='number';if(d){if(n*0!=0)return R(x,s,d,b);x.s=1/n<0?(s=s.slice(1),-1):1;if(s.replace(/^0\.0*|\./,'').length>15){throw Error(w+n);}d=false;}else{x.s=s.charCodeAt(0)===45?(s=s.slice(1),-1):1;if(b>10&&b<37)s=s.toLowerCase();}a=c1.slice(0,b);e=i=0;for(j=s.length;i<j;i++){if(a.indexOf(c=s.charAt(i))<0){if(c=='.'){if(i>e){e=j;continue;}}return R(x,n+'',d,b);}}s=Q(s,b,10,x.s);}if((e=s.indexOf('.'))>-1)s=s.replace('.','');if((i=s.search(/e/i))>0){if(e<0)e=i;e+= +s.slice(i+1);s=s.substring(0,i);}else if(e<0){e=s.length;}for(i=0;s.charCodeAt(i)===48;i++);for(j=s.length;s.charCodeAt(--j)===48;);s=s.slice(i,j+1);if(s){j=s.length;if(d&&j>15&&(n>M||n!==o(n))){throw Error(w+(x.s*n));}e=e-i-1;if(e>Z){x.c=x.e=null;}else if(e<Y){x.c=[x.e=0];}else{x.e=e;x.c=[];i=(e+1)%L;if(e<0)i+=L;if(i<j){if(i)x.c.push(+s.slice(0,i));for(j-=L;i<j;){x.c.push(+s.slice(i,i+=L));}s=s.slice(i);i=L-s.length;}else{i-=j;}for(;i--;s+='0');x.c.push(+s);}}else{x.c=[x.e=0];}}B.clone=E;B.ROUND_UP=0;B.ROUND_DOWN=1;B.ROUND_CEIL=2;B.ROUND_FLOOR=3;B.ROUND_HALF_UP=4;B.ROUND_HALF_DOWN=5;B.ROUND_HALF_EVEN=6;B.ROUND_HALF_CEIL=7;B.ROUND_HALF_FLOOR=8;B.EUCLID=9;B.config=B.set=function(a){var p,v;if(a!=null){if(typeof a=='object'){if(a.hasOwnProperty(p='DECIMAL_PLACES')){v=a[p];I(v,0,D,p);U=v;}if(a.hasOwnProperty(p='ROUNDING_MODE')){v=a[p];I(v,0,8,p);V=v;}if(a.hasOwnProperty(p='EXPONENTIAL_AT')){v=a[p];if(J(v)){I(v[0],-D,0,p);I(v[1],0,D,p);W=v[0];X=v[1];}else{I(v,-D,D,p);W=-(X=v<0?-v:v);}}if(a.hasOwnProperty(p='RANGE')){v=a[p];if(J(v)){I(v[0],-D,-1,p);I(v[1],1,D,p);Y=v[0];Z=v[1];}else{I(v,-D,D,p);if(v){Y=-(Z=v<0?-v:v);}else{throw Error(u+p+' cannot be zero: '+v);}}}if(a.hasOwnProperty(p='CRYPTO')){v=a[p];if(v===!!v){if(v){if(typeof crypto!='undefined'&&crypto&&(crypto.getRandomValues||crypto.randomBytes)){$=v;}else{$=!v;throw Error(u+'crypto unavailable');}}else{$=v;}}else{throw Error(u+p+' not true or false: '+v);}}if(a.hasOwnProperty(p='MODULO_MODE')){v=a[p];I(v,0,9,p);_=v;}if(a.hasOwnProperty(p='POW_PRECISION')){v=a[p];I(v,0,D,p);a1=v;}if(a.hasOwnProperty(p='FORMAT')){v=a[p];if(typeof v=='object')b1=v;else throw Error(u+p+' not an object: '+v);}if(a.hasOwnProperty(p='ALPHABET')){v=a[p];if(typeof v=='string'&&!/^.$|\.|(.).*\1/.test(v)){c1=v;}else{throw Error(u+p+' invalid: '+v);}}}else{throw Error(u+'Object expected: '+a);}}return{DECIMAL_PLACES:U,ROUNDING_MODE:V,EXPONENTIAL_AT:[W,X],RANGE:[Y,Z],CRYPTO:$,MODULO_MODE:_,POW_PRECISION:a1,FORMAT:b1,ALPHABET:c1};};B.isBigNumber=function(v){return v instanceof B||v&&v._isBigNumber===true||false;};B.maximum=B.max=function(){return f1(arguments,P.lt);};B.minimum=B.min=function(){return f1(arguments,P.gt);};B.random=(function(){var p=0x20000000000000;var r=(Math.random()*p)&0x1fffff?function(){return o(Math.random()*p);}:function(){return((Math.random()*0x40000000|0)*0x800000)+(Math.random()*0x800000|0);};return function(d){var a,b,e,k,v,i=0,c=[],j=new B(T);if(d==null)d=U;else I(d,0,D);k=h(d/L);if($){if(crypto.getRandomValues){a=crypto.getRandomValues(new Uint32Array(k*=2));for(;i<k;){v=a[i]*0x20000+(a[i+1]>>>11);if(v>=9e15){b=crypto.getRandomValues(new Uint32Array(2));a[i]=b[0];a[i+1]=b[1];}else{c.push(v%1e14);i+=2;}}i=k/2;}else if(crypto.randomBytes){a=crypto.randomBytes(k*=7);for(;i<k;){v=((a[i]&31)*0x1000000000000)+(a[i+1]*0x10000000000)+(a[i+2]*0x100000000)+(a[i+3]*0x1000000)+(a[i+4]<<16)+(a[i+5]<<8)+a[i+6];if(v>=9e15){crypto.randomBytes(7).copy(a,i);}else{c.push(v%1e14);i+=7;}}i=k/7;}else{$=false;throw Error(u+'crypto unavailable');}}if(!$){for(;i<k;){v=r();if(v<9e15)c[i++]=v%1e14;}}k=c[--i];d%=L;if(k&&d){v=C[L-d];c[i]=o(k/v)*v;}for(;c[i]===0;c.pop(),i--);if(i<0){c=[e=0];}else{for(e=-1;c[0]===0;c.splice(0,1),e-=L);for(i=1,v=c[0];v>=10;v/=10,i++);if(i<L)e-=L-i;}j.e=e;j.c=c;return j;};})();Q=(function(){var a='0123456789';function t(s,b,c,d){var j,e=[0],k,i=0,m=s.length;for(;i<m;){for(k=e.length;k--;e[k]*=b);e[0]+=d.indexOf(s.charAt(i++));for(j=0;j<e.length;j++){if(e[j]>c-1){if(e[j+1]==null)e[j+1]=0;e[j+1]+=e[j]/c|0;e[j]%=c;}}}return e.reverse();}return function(s,b,c,j,m){var n,d,e,k,r,x,p,y,i=s.indexOf('.'),q=U,v=V;if(i>=0){k=a1;a1=0;s=s.replace('.','');y=new B(b);x=y.pow(s.length-i);a1=k;y.c=t(N(G(x.c),x.e,'0'),10,c,a);y.e=y.c.length;}p=t(s,b,c,m?(n=c1,a):(n=a,c1));e=k=p.length;for(;p[--k]==0;p.pop());if(!p[0])return n.charAt(0);if(i<0){--e;}else{x.c=p;x.e=e;x.s=j;x=O(x,y,q,v,c);p=x.c;r=x.r;e=x.e;}d=e+q+1;i=p[d];k=c/2;r=r||d<0||p[d+1]!=null;r=v<4?(i!=null||r)&&(v==0||v==(x.s<0?3:2)):i>k||i==k&&(v==4||r||v==6&&p[d-1]&1||v==(x.s<0?8:7));if(d<1||!p[0]){s=r?N(n.charAt(1),-q,n.charAt(0)):n.charAt(0);}else{p.length=d;if(r){for(--c;++p[--d]>c;){p[d]=0;if(!d){++e;p=[1].concat(p);}}}for(k=p.length;!p[--k];);for(i=0,s='';i<=k;s+=n.charAt(p[i++]));s=N(s,e,n.charAt(0));}return s;};})();O=(function(){function c(x,k,b){var m,t,a,e,j=0,i=x.length,n=k%S,p=k/S|0;for(x=x.slice();i--;){a=x[i]%S;e=x[i]/S|0;m=p*a+e*n;t=n*a+((m%S)*S)+j;j=(t/b|0)+(m/S|0)+p*e;x[i]=t%b;}if(j)x=[j].concat(x);return x;}function H(a,b,e,j){var i,k;if(e!=j){k=e>j?1:-1;}else{for(i=k=0;i<e;i++){if(a[i]!=b[i]){k=a[i]>b[i]?1:-1;break;}}}return k;}function d(a,b,e,j){var i=0;for(;e--;){a[e]-=i;i=a[e]<b[e]?1:0;a[e]=i*j+a[e]-b[e];}for(;!a[0]&&a.length>1;a.splice(0,1));}return function(x,y,a,r,b){var j,e,i,m,n,p,k,q,t,v,z,d1,xi,xL,g1,yL,yz,s=x.s==y.s?1:-1,xc=x.c,yc=y.c;if(!xc||!xc[0]||!yc||!yc[0]){return new B(!x.s||!y.s||(xc?yc&&xc[0]==yc[0]:!yc)?NaN:xc&&xc[0]==0||!yc?s*0:s/0);}q=new B(s);t=q.c=[];e=x.e-y.e;s=a+e+1;if(!b){b=A;e=F(x.e/L)-F(y.e/L);s=s/L|0;}for(i=0;yc[i]==(xc[i]||0);i++);if(yc[i]>(xc[i]||0))e--;if(s<0){t.push(1);m=true;}else{xL=xc.length;yL=yc.length;i=0;s+=2;n=o(b/(yc[0]+1));if(n>1){yc=c(yc,n,b);xc=c(xc,n,b);yL=yc.length;xL=xc.length;}xi=yL;v=xc.slice(0,yL);z=v.length;for(;z<yL;v[z++]=0);yz=yc.slice();yz=[0].concat(yz);g1=yc[0];if(yc[1]>=b/2)g1++;do{n=0;j=H(yc,v,yL,z);if(j<0){d1=v[0];if(yL!=z)d1=d1*b+(v[1]||0);n=o(d1/g1);if(n>1){if(n>=b)n=b-1;p=c(yc,n,b);k=p.length;z=v.length;while(H(p,v,k,z)==1){n--;d(p,yL<k?yz:yc,k,b);k=p.length;j=1;}}else{if(n==0){j=n=1;}p=yc.slice();k=p.length;}if(k<z)p=[0].concat(p);d(v,p,z,b);z=v.length;if(j==-1){while(H(yc,v,yL,z)<1){n++;d(v,yL<z?yz:yc,z,b);z=v.length;}}}else if(j===0){n++;v=[0];}t[i++]=n;if(v[0]){v[z++]=xc[xi]||0;}else{v=[xc[xi]];z=1;}}while((xi++<xL||v[0]!=null)&&s--);m=v[0]!=null;if(!t[0])t.splice(0,1);}if(b==A){for(i=1,s=t[0];s>=10;s/=10,i++);i1(q,a+(q.e=i+e*L-1)+1,r,m);}else{q.e=e;q.r=+m;}return q;};})();function e1(n,i,r,a){var c,e,b,d,s;if(r==null)r=V;else I(r,0,8);if(!n.c)return n.toString();c=n.c[0];b=n.e;if(i==null){s=G(n.c);s=a==1||a==2&&b<=W?K(s,b):N(s,b,'0');}else{n=i1(new B(n),i,r);e=n.e;s=G(n.c);d=s.length;if(a==1||a==2&&(i<=e||e<=W)){for(;d<i;s+='0',d++);s=K(s,e);}else{i-=b;s=N(s,e,'0');if(e+1>d){if(--i>0)for(s+='.';i--;s+='0');}else{i+=e-d;if(i>0){if(e+1==d)s+='.';for(;i--;s+='0');}}}}return n.s<0&&c?'-'+s:s;}function f1(a,b){var m,n,i=0;if(J(a[0]))a=a[0];m=new B(a[0]);for(;++i<a.length;){n=new B(a[i]);if(!n.s){m=n;break;}else if(b.call(m,n)){m=n;}}return m;}function h1(n,c,e){var i=1,j=c.length;for(;!c[--j];c.pop());for(j=c[0];j>=10;j/=10,i++);if((e=i+e*L-1)>Z){n.c=n.e=null;}else if(e<Y){n.c=[n.e=0];}else{n.e=e;n.c=c;}return n;}R=(function(){var a=/^(-?)0([xbo])(?=\w[\w.]*$)/i,d=/^([^.]+)\.$/,c=/^\.([^.]+)$/,i=/^-?(Infinity|NaN)$/,e=/^\s*\+(?=[\w.])|^\s+|\s+$/g;return function(x,j,k,b){var n,s=k?j:j.replace(e,'');if(i.test(s)){x.s=isNaN(s)?null:s<0?-1:1;x.c=x.e=null;}else{if(!k){s=s.replace(a,function(m,p,q){n=(q=q.toLowerCase())=='x'?16:q=='b'?2:8;return!b||b==n?p:m;});if(b){n=b;s=s.replace(d,'$1').replace(c,'0.$1');}if(j!=s)return new B(s,n);}throw Error(u+'Not a'+(b?' base '+b:'')+' number: '+j);}}})();function i1(x,s,a,r){var d,i,j,k,n,b,c,e=x.c,p=C;if(e){out:{for(d=1,k=e[0];k>=10;k/=10,d++);i=s-d;if(i<0){i+=L;j=s;n=e[b=0];c=n/p[d-j-1]%10|0;}else{b=h((i+1)/L);if(b>=e.length){if(r){for(;e.length<=b;e.push(0));n=c=0;d=1;i%=L;j=i-L+1;}else{break out;}}else{n=k=e[b];for(d=1;k>=10;k/=10,d++);i%=L;j=i-L+d;c=j<0?0:n/p[d-j-1]%10|0;}}r=r||s<0||e[b+1]!=null||(j<0?n:n%p[d-j-1]);r=a<4?(c||r)&&(a==0||a==(x.s<0?3:2)):c>5||c==5&&(a==4||r||a==6&&((i>0?j>0?n/p[d-j]:0:e[b-1])%10)&1||a==(x.s<0?8:7));if(s<1||!e[0]){e.length=0;if(r){s-=x.e+1;e[0]=p[(L-s%L)%L];x.e=-s||0;}else{e[0]=x.e=0;}return x;}if(i==0){e.length=b;k=1;b--;}else{e.length=b+1;k=p[L-i];e[b]=j>0?o(n/p[d-j]%p[j])*k:0;}if(r){for(;;){if(b==0){for(i=1,j=e[0];j>=10;j/=10,i++);j=e[0]+=k;for(k=1;j>=10;j/=10,k++);if(i!=k){x.e++;if(e[0]==A)e[0]=1;}break;}else{e[b]+=k;if(e[b]!=A)break;e[b--]=0;k=1;}}}for(i=e.length;e[--i]===0;e.pop());}if(x.e>Z){x.c=x.e=null;}else if(x.e<Y){x.c=[x.e=0];}}return x;}P.absoluteValue=P.abs=function(){var x=new B(this);if(x.s<0)x.s=1;return x;};P.comparedTo=function(y,b){return H(this,new B(y,b));};P.decimalPlaces=P.dp=function(d,r){var c,n,v,x=this;if(d!=null){I(d,0,D);if(r==null)r=V;else I(r,0,8);return i1(new B(x),d+x.e+1,r);}if(!(c=x.c))return null;n=((v=c.length-1)-F(this.e/L))*L;if(v=c[v])for(;v%10==0;v/=10,n--);if(n<0)n=0;return n;};P.dividedBy=P.div=function(y,b){return O(this,new B(y,b),U,V);};P.dividedToIntegerBy=P.idiv=function(y,b){return O(this,new B(y,b),0,1);};P.isEqualTo=P.eq=function(y,b){return H(this,new B(y,b))===0;};P.integerValue=function(r){var n=new B(this);if(r==null)r=V;else I(r,0,8);return i1(n,n.e+1,r);};P.isGreaterThan=P.gt=function(y,b){return H(this,new B(y,b))>0;};P.isGreaterThanOrEqualTo=P.gte=function(y,b){return(b=H(this,new B(y,b)))===1||b===0;};P.isFinite=function(){return!!this.c;};P.isInteger=function(){return!!this.c&&F(this.e/L)>this.c.length-2;};P.isNaN=function(){return!this.s;};P.isNegative=function(){return this.s<0;};P.isPositive=function(){return this.s>0;};P.isZero=function(){return!!this.c&&this.c[0]==0;};P.isLessThan=P.lt=function(y,b){return H(this,new B(y,b))<0;};P.isLessThanOrEqualTo=P.lte=function(y,b){return(b=H(this,new B(y,b)))===-1||b===0;};P.minus=function(y,b){var i,j,t,c,x=this,a=x.s;y=new B(y,b);b=y.s;if(!a||!b)return new B(NaN);if(a!=b){y.s=-b;return x.plus(y);}var d=x.e/L,e=y.e/L,k=x.c,m=y.c;if(!d||!e){if(!k||!m)return k?(y.s=-b,y):new B(m?x:NaN);if(!k[0]||!m[0]){return m[0]?(y.s=-b,y):new B(k[0]?x:V==3?-0:0);}}d=F(d);e=F(e);k=k.slice();if(a=d-e){if(c=a<0){a=-a;t=k;}else{e=d;t=m;}t.reverse();for(b=a;b--;t.push(0));t.reverse();}else{j=(c=(a=k.length)<(b=m.length))?a:b;for(a=b=0;b<j;b++){if(k[b]!=m[b]){c=k[b]<m[b];break;}}}if(c)t=k,k=m,m=t,y.s=-y.s;b=(j=m.length)-(i=k.length);if(b>0)for(;b--;k[i++]=0);b=A-1;for(;j>a;){if(k[--j]<m[j]){for(i=j;i&&!k[--i];k[i]=b);--k[i];k[j]+=A;}k[j]-=m[j];}for(;k[0]==0;k.splice(0,1),--e);if(!k[0]){y.s=V==3?-1:1;y.c=[y.e=0];return y;}return h1(y,k,e);};P.modulo=P.mod=function(y,b){var q,s,x=this;y=new B(y,b);if(!x.c||!y.s||y.c&&!y.c[0]){return new B(NaN);}else if(!y.c||x.c&&!x.c[0]){return new B(x);}if(_==9){s=y.s;y.s=1;q=O(x,y,0,3);y.s=s;q.s*=s;}else{q=O(x,y,0,_);}return x.minus(q.times(y));};P.multipliedBy=P.times=function(y,b){var c,e,i,j,k,m,a,d,n,p,q,r,z,s,t,x=this,v=x.c,yc=(y=new B(y,b)).c;if(!v||!yc||!v[0]||!yc[0]){if(!x.s||!y.s||v&&!v[0]&&!yc||yc&&!yc[0]&&!v){y.c=y.e=y.s=null;}else{y.s*=x.s;if(!v||!yc){y.c=y.e=null;}else{y.c=[0];y.e=0;}}return y;}e=F(x.e/L)+F(y.e/L);y.s*=x.s;a=v.length;p=yc.length;if(a<p)z=v,v=yc,yc=z,i=a,a=p,p=i;for(i=a+p,z=[];i--;z.push(0));s=A;t=S;for(i=p;--i>=0;){c=0;q=yc[i]%t;r=yc[i]/t|0;for(k=a,j=i+k;j>i;){d=v[--k]%t;n=v[k]/t|0;m=r*d+n*q;d=q*d+((m%t)*t)+z[j]+c;c=(d/s|0)+(m/t|0)+r*n;z[j--]=d%s;}z[j]=c;}if(c){++e;}else{z.splice(0,1);}return h1(y,z,e);};P.negated=function(){var x=new B(this);x.s=-x.s||null;return x;};P.plus=function(y,b){var t,x=this,a=x.s;y=new B(y,b);b=y.s;if(!a||!b)return new B(NaN);if(a!=b){y.s=-b;return x.minus(y);}var c=x.e/L,d=y.e/L,e=x.c,i=y.c;if(!c||!d){if(!e||!i)return new B(a/0);if(!e[0]||!i[0])return i[0]?y:new B(e[0]?x:a*0);}c=F(c);d=F(d);e=e.slice();if(a=c-d){if(a>0){d=c;t=i;}else{a=-a;t=e;}t.reverse();for(;a--;t.push(0));t.reverse();}a=e.length;b=i.length;if(a-b<0)t=i,i=e,e=t,b=a;for(a=0;b;){a=(e[--b]=e[b]+i[b]+a)/A|0;e[b]=A===e[b]?0:e[b]%A;}if(a){e=[a].concat(e);++d;}return h1(y,e,d);};P.precision=P.sd=function(s,r){var c,n,v,x=this;if(s!=null&&s!==!!s){I(s,1,D);if(r==null)r=V;else I(r,0,8);return i1(new B(x),s,r);}if(!(c=x.c))return null;v=c.length-1;n=v*L+1;if(v=c[v]){for(;v%10==0;v/=10,n--);for(v=c[0];v>=10;v/=10,n++);}if(s&&x.e+1>n)n=x.e+1;return n;};P.shiftedBy=function(k){I(k,-M,M);return this.times('1e'+k);};P.squareRoot=P.sqrt=function(){var m,n,r,a,t,x=this,c=x.c,s=x.s,e=x.e,d=U+4,b=new B('0.5');if(s!==1||!c||!c[0]){return new B(!s||s<0&&(!c||c[0])?NaN:c?x:1/0);}s=Math.sqrt(+x);if(s==0||s==1/0){n=G(c);if((n.length+e)%2==0)n+='0';s=Math.sqrt(n);e=F((e+1)/2)-(e<0||e%2);if(s==1/0){n='1e'+e;}else{n=s.toExponential();n=n.slice(0,n.indexOf('e')+1)+e;}r=new B(n);}else{r=new B(s+'');}if(r.c[0]){e=r.e;s=e+d;if(s<3)s=0;for(;;){t=r;r=b.times(t.plus(O(x,t,d,1)));if(G(t.c).slice(0,s)===(n=G(r.c)).slice(0,s)){if(r.e<e)--s;n=n.slice(s-3,s+1);if(n=='9999'||!a&&n=='4999'){if(!a){i1(t,t.e+U+2,0);if(t.times(t).eq(x)){r=t;break;}}d+=4;s+=4;a=1;}else{if(!+n||!+n.slice(1)&&n.charAt(0)=='5'){i1(r,r.e+U+2,1);m=!r.times(r).eq(x);}break;}}}}return i1(r,r.e+U+1,V,m);};P.toExponential=function(d,r){if(d!=null){I(d,0,D);d++;}return e1(this,d,r,1);};P.toFixed=function(d,r){if(d!=null){I(d,0,D);d=d+this.e+1;}return e1(this,d,r);};P.toFormat=function(d,r){var s=this.toFixed(d,r);if(this.c){var i,a=s.split('.'),b=+b1.groupSize,c=+b1.secondaryGroupSize,e=b1.groupSeparator,j=a[0],k=a[1],m=this.s<0,n=m?j.slice(1):j,p=n.length;if(c)i=b,b=c,c=i,p-=i;if(b>0&&p>0){i=p%b||b;j=n.substr(0,i);for(;i<p;i+=b){j+=e+n.substr(i,b);}if(c>0)j+=e+n.slice(i);if(m)j='-'+j;}s=k?j+b1.decimalSeparator+((c=+b1.fractionGroupSize)?k.replace(new RegExp('\\d{'+c+'}\\B','g'),'$&'+b1.fractionGroupSeparator):k):j;}return s;};P.toFraction=function(m){var a,d,b,c,i,e,j,n,k,p,q,s,x=this,r=x.c;if(m!=null){n=new B(m);if(!n.isInteger()||n.lt(T)){throw Error(u+'Argument '+(n.isInteger()?'out of range: ':'not an integer: ')+m);}}if(!r)return x.toString();d=new B(T);p=b=new B(T);c=k=new B(T);s=G(r);e=d.e=s.length-x.e-1;d.c[0]=C[(j=e%L)<0?L+j:j];m=!m||n.comparedTo(d)>0?(e>0?d:p):n;j=Z;Z=1/0;n=new B(s);k.c[0]=0;for(;;){q=O(n,d,0,1);i=b.plus(q.times(c));if(i.comparedTo(m)==1)break;b=c;c=i;p=k.plus(q.times(i=p));k=i;d=n.minus(q.times(i=d));n=i;}i=O(m.minus(b),c,0,1);k=k.plus(i.times(p));b=b.plus(i.times(c));k.s=p.s=x.s;e*=2;a=O(p,c,e,V).minus(x).abs().comparedTo(O(k,b,e,V).minus(x).abs())<1?[p.toString(),c.toString()]:[k.toString(),b.toString()];Z=j;return a;};P.toNumber=function(){return+this;};P.exponentiatedBy=P.pow=function(n,m){var i,k,y,z,x=this;I(n,-M,M);if(m!=null)m=new B(m);if(m){if(n>1&&x.gt(T)&&x.isInteger()&&m.gt(T)&&m.isInteger()){x=x.mod(m);}else{z=m;m=null;}}else if(a1){k=h(a1/L+2);}y=new B(T);for(i=o(n<0?-n:n);;){if(i%2){y=y.times(x);if(!y.c)break;if(k){if(y.c.length>k)y.c.length=k;}else if(m){y=y.mod(m);}}i=o(i/2);if(!i)break;x=x.times(x);if(k){if(x.c&&x.c.length>k)x.c.length=k;}else if(m){x=x.mod(m);}}if(m)return y;if(n<0)y=T.div(y);return z?y.mod(z):k?i1(y,a1,V):y;};P.toPrecision=function(s,r){if(s!=null)I(s,1,D);return e1(this,s,r,2);};P.toString=function(b){var a,n=this,s=n.s,e=n.e;if(e===null){if(s){a='Infinity';if(s<0)a='-'+a;}else{a='NaN';}}else{a=G(n.c);if(b==null){a=e<=W||e>=X?K(a,e):N(a,e,'0');}else{I(b,2,c1.length,'Base');a=Q(N(a,e,'0'),10,b,s,true);}if(s<0&&n.c[0])a='-'+a;}return a;};P.valueOf=P.toJSON=function(){var s,n=this,e=n.e;if(e===null)return n.toString();s=G(n.c);s=e<=W||e>=X?K(s,e):N(s,e,'0');return n.s<0?'-'+s:s;};P._isBigNumber=true;if(l!=null)B.set(l);return B;}function F(n){var i=n|0;return n>0||n===i?i:i-1;}function G(a){var s,z,i=1,j=a.length,r=a[0]+'';for(;i<j;){s=a[i++]+'';z=L-s.length;for(;z--;s='0'+s);r+=s;}for(j=r.length;r.charCodeAt(--j)===48;);return r.slice(0,j+1||1);}function H(x,y){var a,b,c=x.c,d=y.c,i=x.s,j=y.s,k=x.e,l=y.e;if(!i||!j)return null;a=c&&!c[0];b=d&&!d[0];if(a||b)return a?b?0:-j:i;if(i!=j)return i;a=i<0;b=k==l;if(!c||!d)return b?0:!c^a?1:-1;if(!b)return k>l^a?1:-1;j=(k=c.length)<(l=d.length)?k:l;for(i=0;i<j;i++)if(c[i]!=d[i])return c[i]>d[i]^a?1:-1;return k==l?0:k>l^a?1:-1;}function I(n,m,a,b){if(n<m||n>a||n!==(n<0?h(n):o(n))){throw Error(u+(b||'Argument')+(typeof n=='number'?n<m||n>a?' out of range: ':' not an integer: ':' not a primitive number: ')+n);}}function J(a){return Object.prototype.toString.call(a)=='[object Array]';}function K(s,e){return(s.length>1?s.charAt(0)+'.'+s.slice(1):s)+(e<0?'e':'e+')+e;}function N(s,e,z){var l,a;if(e<0){for(a=z+'.';++e;a+=z);s=a+s;}else{l=s.length;if(++e>l){for(a=z,e-=l;--e;a+=z);s+=a;}else if(e<l){s=s.slice(0,e)+'.'+s.slice(e);}}return s;}B=E();B['default']=B.BigNumber=B;if(typeof define=='function'&&define.amd){define(function(){return B;});}else if(typeof module!='undefined'&&module.exports){module.exports=B;}else{if(!g){g=typeof self!='undefined'?self:Function('return this')();}g.BigNumber=B;}})(this);
