/*!
 * OpenUI5
 * (c) Copyright 2009-2020 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["sap/ui/base/Object","sap/ui/thirdparty/jquery","sap/ui/testrecorder/CommunicationBus","sap/ui/testrecorder/CommunicationChannels","sap/ui/testrecorder/mutationObservers/AppMutationObserver","sap/ui/testrecorder/mutationObservers/ElementMutationObserver","sap/ui/support/supportRules/ui/external/Highlighter","sap/ui/test/_ControlFinder","sap/ui/testrecorder/inspector/ControlAPI","sap/ui/testrecorder/inspector/ControlInspectorRepo","sap/ui/testrecorder/Constants","sap/ui/testrecorder/DialectRegistry","sap/ui/testrecorder/Dialects","sap/ui/testrecorder/controlSelectors/ControlSelectorGenerator","sap/ui/testrecorder/codeSnippets/POMethodUtil","sap/ui/testrecorder/codeSnippets/RawSnippetUtil","sap/ui/testrecorder/codeSnippets/CodeSnippetProvider","sap/ui/testrecorder/ui/models/SharedModel"],function(B,$,C,a,A,E,H,_,b,c,d,D,e,f,P,R,g,S){"use strict";var o=null;var h=new H(d.HIGHLIGHTER_ID);var s=Object.assign({},S.getData().settings);var i=B.extend("sap.ui.testrecorder.inspector.ControlInspector",{constructor:function(){if(!o){Object.apply(this,arguments);this._appObserver=new A(this.getAllControlData.bind(this));this._selectedElementObserver=new E(this.getControlData.bind(this));}else{return o;}}});i.prototype.init=function(){this._appObserver.start();C.subscribe(a.REQUEST_ALL_CONTROLS_DATA,this.getAllControlData.bind(this));C.subscribe(a.REQUEST_CONTROL_DATA,this.getControlData.bind(this));C.subscribe(a.REQUEST_CODE_SNIPPET,this.getCodeSnippet.bind(this));C.subscribe(a.HIGHLIGHT_CONTROL,this.highlightControl.bind(this));C.subscribe(a.SET_DIALECT,this.setDialect.bind(this));C.subscribe(a.UPDATE_SETTINGS,this.updateSettings.bind(this));C.subscribe(a.CLEAR_SNIPPETS,this.clearSnippets.bind(this));};i.prototype.getAllControlData=function(){C.publish(a.RECEIVE_ALL_CONTROLS_DATA,{renderedControls:b.getAllControlData().renderedControls,framework:b.getFrameworkData().framework});c.clear();};i.prototype.getControlData=function(m){var k=m.domElementId?document.getElementById(m.domElementId):sap.ui.getCore().byId(m.controlId).getDomRef();this._selectedElementObserver.stop();this._selectedElementObserver.start(k);var l=b.getControlData(m);C.publish(a.RECEIVE_CONTROL_DATA,l);};i.prototype.getCodeSnippet=function(m){var k=Object.assign({},m,{settings:s});var l=c.findSelector(m.domElementId);var n=l?Promise.resolve(l):f.getSelector(k);return n.then(function(p){l=p;return g.getSnippet({controlSelector:p,action:k.action,settings:s});}).then(function(p){c.save(m,l,p);var q=s.multipleSnippets?c.getSnippets():[p];if(D.getActiveDialect()===e.RAW){return R.getJSON(q,s);}else{return P.getPOMethod(q,s);}}).then(function(p){C.publish(a.RECEIVE_CODE_SNIPPET,{codeSnippet:p});}).catch(function(p){C.publish(a.RECEIVE_CODE_SNIPPET,{error:"Could not generate code snippet for "+JSON.stringify(m)+". Details: "+p,domElementId:k.domElementId});});};i.prototype.highlightControl=function(m){if(m.domElementId){h.highlight(m.domElementId);}else if(m.controlId){var k=_._findElements({id:m.controlId})[0];if(k){h.highlight(k.id);}}};i.prototype.setDialect=function(k){if(D.getActiveDialect()!==k){D.setActiveDialect(k);C.publish(a.DIALECT_CHANGED,{dialect:k});c.getRequests().forEach(this.getCodeSnippet.bind(this));}};i.prototype.updateSettings=function(m){Object.assign(s,m);var r=c.getRequests();if(j(m,"multipleSnippets")){this.clearSnippets();if(r.length){this.getCodeSnippet(r[r.length-1]);}}if(j(m,["preferViewId"])){c.clear();}if(j(m,["formatAsPOMethod","preferViewId"])){if(s.multipleSnippets){r.forEach(this.getCodeSnippet.bind(this));}else if(r.length){this.getCodeSnippet(r[r.length-1]);}}};i.prototype.clearSnippets=function(){c.clear();C.publish(a.RECEIVE_CODE_SNIPPET,{codeSnippet:""});};i.prototype.stop=function(){this._appObserver.stop();this._selectedElementObserver.stop();};function j(m,k){var K=$.isArray(k)?k:[k];return K.filter(function(l){return m[l]!==null&&m[l]!==undefined;}).length;}o=new i();return o;},true);
