/*!
 * OpenUI5
 * (c) Copyright 2009-2020 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["./ExtensionBase","../utils/TableUtils","../library","sap/ui/Device","sap/ui/performance/trace/Interaction","sap/base/Log","sap/ui/thirdparty/jquery"],function(E,T,l,D,I,L,q){"use strict";var S=l.SharedDomRef;var H=T.Hook.Keys;var M=1000000;var V=2;var c={HORIZONAL:"HORIZONTAL",VERTICAL:"VERTICAL",BOTH:"BOTH"};function d(s,t){L.debug("sap.ui.table.extensions.Scrolling",s,t);}function e(a){return typeof a.isConnected==="boolean"&&a.isConnected||document.body.contains(a);}function P(a,b){var r=true;var C=false;var s=[];var t={cancel:function(){if(this.isCancelled()||!this.isRunning()){return;}C=true;for(var i=0;i<s.length;i++){s[i]();}d("Process cancelled: "+b.id);},isCancelled:function(){return C;},addCancelListener:function(i){s.push(i);},isRunning:function(){return r;},getInfo:function(){return b;},onPromiseCreated:function(i){}};var u;d("Process started: "+b.id);if(typeof a==="function"){u=new Promise(function(){a.apply(this,Array.prototype.slice.call(arguments).concat(t));});}else{u=Promise.resolve();}Object.assign(u,t);u.then(function(){if(t.isCancelled()){d("Process finished due to cancellation: "+b.id);}else{d("Process finished: "+b.id);}r=false;});t.onPromiseCreated(u);return u;}function f(){this.iIndex=0;this.nOffset=0;this.sOffsetType=f.OffsetType.Pixel;this.bIsInitial=true;}f.OffsetType={Pixel:"Pixel",Percentage:"Percentage",PercentageOfBuffer:"PercentageOfBuffer"};f.prototype.getIndex=function(){return this.iIndex;};f.prototype.getOffset=function(){return this.nOffset;};f.prototype.getOffsetType=function(){return this.sOffsetType;};f.prototype.isOffsetInPixel=function(){return this.sOffsetType===f.OffsetType.Pixel;};f.prototype.isInitial=function(){return this.bIsInitial;};f.prototype.setPosition=function(i,a,O){d("ScrollPosition#setPosition(index: "+i+", offset: "+a+", offsetType: "+O+")");if(!f._isPositiveNumber(i)){return;}if(!f._isPositiveNumber(a)){this.nOffset=0;}this.setIndex(i);this.setOffset(a,O);};f.prototype.setIndex=function(i){d("ScrollPosition#setIndex(index: "+i+")");if(!f._isPositiveNumber(i)){return;}this.bIsInitial=false;this.iIndex=i;};f.prototype.setOffset=function(a,O){d("ScrollPosition#setOffset(offset: "+a+", offsetType: "+O+")");if(!f._isPositiveNumber(a)){return;}this.bIsInitial=false;this.sOffsetType=O in f.OffsetType?O:f.OffsetType.Pixel;if(this.isOffsetInPixel()){this.nOffset=Math.round(a);}else{this.nOffset=Math.min(a,1);}};f.prototype.scrollRows=function(r){var N=this.getIndex()+r;var i=this.getOffset();if(!this.isOffsetInPixel()||N<0){i=0;}this.setPosition(Math.max(0,N),i);};f._isPositiveNumber=function(a){return typeof a==="number"&&!isNaN(a)&&a>=0;};var g=new window.WeakMap();var h=function(t){if(!t){return{};}if(!g.has(t)){g.set(t,{oHorizontalScrollbar:null,iHorizontalScrollPosition:null,oVerticalScrollbar:null,oVerticalScrollPosition:new f(t),pVerticalScrollUpdateProcess:null,oExternalVerticalScrollbar:null,bIsVerticalScrollbarExternal:false,mTimeouts:{},mAnimationFrames:{},mTouchSessionData:null,aOnRowsUpdatedPreprocessors:[]});}return g.get(t);};h.destroy=function(t){delete g.delete(t);};var j={UpdateFromFirstVisibleRow:{id:"UpdateFromFirstVisibleRow",rank:6},UpdateFromScrollPosition:{id:"UpdateFromScrollPosition",rank:5},RestoreScrollPosition:{id:"RestoreScrollPosition",rank:4},AdjustToTotalRowCount:{id:"AdjustToTotalRowCount",rank:3},OnRowsUpdated:{id:"OnRowsUpdated",rank:3},UpdateFromScrollbar:{id:"UpdateFromScrollbar",rank:2},UpdateFromViewport:{id:"UpdateFromViewport",rank:1},canStart:function(t,a){var b=h(t).pVerticalScrollUpdateProcess;var C=b?b.getInfo():null;if(b&&b.isRunning()&&C.rank>a.rank){d("Cannot start update process "+a.id+" - A higher-ranked update process is currently running ("+C.id+")",t);return false;}return true;},start:function(t,a,b){if(!j.canStart(t,a)){return;}if(h(t).pVerticalScrollUpdateProcess){h(t).pVerticalScrollUpdateProcess.cancel();}h(t).pVerticalScrollUpdateProcess=new P(b,a);}};var k={onScrollbarScroll:function(a){var N=a.target.scrollLeft;var O=a.target._scrollLeft;I.notifyScrollEvent&&I.notifyScrollEvent(a);if(N!==O){var s=k.getScrollAreas(this);a.target._scrollLeft=N;for(var i=0;i<s.length;i++){var b=s[i];if(b!==a.target&&b.scrollLeft!==N){b.scrollLeft=N;b._scrollLeft=N;}}h(this).iHorizontalScrollPosition=N;}},restoreScrollPosition:function(t){var s=t._getScrollExtension();var a=s.getHorizontalScrollbar();if(a&&h(t).iHorizontalScrollPosition!==null){var b=k.getScrollAreas(t);for(var i=0;i<b.length;i++){var r=b[i];delete r._scrollLeft;}if(a.scrollLeft!==h(t).iHorizontalScrollPosition){a.scrollLeft=h(t).iHorizontalScrollPosition;}else{var u=q.Event("scroll");u.target=a;k.onScrollbarScroll.call(t,u);}}},onScrollbarMouseDown:function(a){this._getKeyboardExtension().setActionMode(false);},addEventListeners:function(t){var s=t._getScrollExtension();var a=s.getHorizontalScrollbar();var b=k.getScrollAreas(t);if(!s._onHorizontalScrollEventHandler){s._onHorizontalScrollEventHandler=k.onScrollbarScroll.bind(t);}for(var i=0;i<b.length;i++){b[i].addEventListener("scroll",s._onHorizontalScrollEventHandler);}if(a){if(!s._onHorizontalScrollbarMouseDownEventHandler){s._onHorizontalScrollbarMouseDownEventHandler=k.onScrollbarMouseDown.bind(t);}a.addEventListener("mousedown",s._onHorizontalScrollbarMouseDownEventHandler);}},removeEventListeners:function(t){var s=t._getScrollExtension();var a=s.getHorizontalScrollbar();var b=k.getScrollAreas(t);if(s._onHorizontalScrollEventHandler){for(var i=0;i<b.length;i++){b[i].removeEventListener("scroll",s._onHorizontalScrollEventHandler);delete b[i]._scrollLeft;}delete s._onHorizontalScrollEventHandler;}if(a&&s._onHorizontalScrollbarMouseDownEventHandler){a.removeEventListener("mousedown",s._onHorizontalScrollbarMouseDownEventHandler);delete s._onHorizontalScrollbarMouseDownEventHandler;}},getScrollAreas:function(t){var a=t.getDomRef();var s;if(a){s=Array.prototype.slice.call(t.getDomRef().querySelectorAll(".sapUiTableCtrlScr"));}var b=[t._getScrollExtension().getHorizontalScrollbar()].concat(s);return b.filter(function(i){return i!=null;});}};var m={performUpdateFromFirstVisibleRow:function(t,b){d("VerticalScrollingHelper.performUpdateFromFirstVisibleRow",t);j.start(t,j.UpdateFromFirstVisibleRow,function(r,a,i){T.Hook.call(t,H.Signal,"StartTableUpdate");i.onPromiseCreated=function(s){s.finally(function(){T.Hook.call(t,H.Signal,"EndTableUpdate");});};if(b===true){var O=function(){d("VerticalScrollingHelper.performUpdateFromFirstVisibleRow (async: rows update)",t);m._performUpdateFromFirstVisibleRow(t,i).then(r);return false;};m.addOnRowsUpdatedPreprocessor(t,O);i.addCancelListener(function(){var R=m.removeOnRowsUpdatedPreprocessor(t,O);if(R){r();}});}else{m._performUpdateFromFirstVisibleRow(t,i).then(r);}});},_performUpdateFromFirstVisibleRow:function(t,a){return m.adjustScrollPositionToFirstVisibleRow(t,a).then(function(){if(m.isIndexInBuffer(t,t.getFirstVisibleRow())){return m.adjustFirstVisibleRowToScrollPositionInBuffer(t,null,a);}return Promise.resolve();}).then(function(){return Promise.all([m.scrollViewport(t,a),m.scrollScrollbar(t,a)]);});},performUpdateFromScrollPosition:function(t){d("VerticalScrollingHelper.performUpdateFromScrollPosition",t);j.start(t,j.UpdateFromScrollPosition,function(r,a,b){T.Hook.call(t,H.Signal,"StartTableUpdate");b.onPromiseCreated=function(i){i.finally(function(){T.Hook.call(t,H.Signal,"EndTableUpdate");});};m.adjustFirstVisibleRowToScrollPosition(t,null,b).then(function(){if(b.isCancelled()){return;}var s=h(t).oVerticalScrollPosition;d("VerticalScrollingHelper.performUpdateFromScrollPosition (async: firstVisibleRow update)",t);if(s.getIndex()>t.getFirstVisibleRow()){s.setIndex(t.getFirstVisibleRow());if(T.isVariableRowHeightEnabled(t)){s.setOffset(1,f.OffsetType.Percentage);}else{s.setOffset(0);}}}).then(function(){return Promise.all([m.scrollViewport(t,b),m.scrollScrollbar(t,b)]);}).then(r);});},performUpdateFromScrollbar:function(t){var _=h(t);d("VerticalScrollingHelper.performUpdateFromScrollbar",t);clearTimeout(_.mTimeouts.largeDataScrolling);delete _.mTimeouts.largeDataScrolling;j.start(t,j.UpdateFromScrollbar,function(r,a,b){T.Hook.call(t,H.Signal,"StartTableUpdate");b.onPromiseCreated=function(i){i.finally(function(){T.Hook.call(t,H.Signal,"EndTableUpdate");});};t._getKeyboardExtension().setActionMode(false);if(t._bLargeDataScrolling){_.mTimeouts.largeDataScrolling=setTimeout(function(){delete _.mTimeouts.largeDataScrolling;if(t._getScrollExtension().getVerticalScrollbar()!=null){d("VerticalScrollingHelper.performUpdateFromScrollbar (async: large data scrolling)",t);m._performUpdateFromScrollbar(t,b).then(r);}else{d("VerticalScrollingHelper.performUpdateFromScrollbar (async: large data scrolling): No scrollbar",t);}},300);b.addCancelListener(function(){if(_.mTimeouts.largeDataScrolling!=null){clearTimeout(_.mTimeouts.largeDataScrolling);delete _.mTimeouts.largeDataScrolling;r();}});}else{m._performUpdateFromScrollbar(t,b).then(r);}});},_performUpdateFromScrollbar:function(t,a){return m.adjustScrollPositionToScrollbar(t,a).then(function(){return m.adjustFirstVisibleRowToScrollPosition(t,null,a);}).then(function(){if(T.isVariableRowHeightEnabled(t)){return m.scrollViewport(t,a);}if(a.isCancelled()){return Promise.resolve();}var s=h(t).oVerticalScrollPosition;var i=s.getIndex();var b=t._getMaxFirstRenderedRowIndex();var r=t._aRowHeights;switch(s.getOffsetType()){case f.OffsetType.Percentage:var u=Math.max(0,Math.min(r.length-1,i-b));s.setOffset(r[u]*s.getOffset());break;case f.OffsetType.PercentageOfBuffer:s.setOffset(0);break;default:}return Promise.resolve();});},performUpdateFromViewport:function(t){d("VerticalScrollingHelper.performUpdateFromViewport",t);j.start(t,j.UpdateFromViewport,function(r,a,b){T.Hook.call(t,H.Signal,"StartTableUpdate");b.onPromiseCreated=function(i){i.finally(function(){T.Hook.call(t,H.Signal,"EndTableUpdate");});};m.adjustScrollPositionToViewport(t,b).then(function(){return m.adjustFirstVisibleRowToScrollPosition(t,true,b);}).then(function(){return m.scrollScrollbar(t,b);}).then(r);});},onScrollbarScroll:function(a){I.notifyScrollEvent&&I.notifyScrollEvent(a);var b=a.target.scrollTop;var i=a.target._scrollTop;var s=b!==i;delete a.target._scrollTop;if(b===0&&!e(a.target)){d("VerticalScrollingHelper.onScrollbarScroll: Scrollbar is not connected with the DOM",this);}else if(s){d("VerticalScrollingHelper.onScrollbarScroll: Scroll position changed to "+b+" by interaction",this);m.performUpdateFromScrollbar(this);}else{d("VerticalScrollingHelper.onScrollbarScroll: Scroll position changed to "+b+" by API",this);}},onViewportScroll:function(a){if(!j.canStart(this,j.UpdateFromViewport)){return;}var b=a.target.scrollTop;var i=a.target._scrollTop;delete a.target._scrollTop;if(b!==i){d("VerticalScrollingHelper.onViewportScroll: Scroll position changed to "+b+" by interaction",this);m.performUpdateFromViewport(this);}else{d("VerticalScrollingHelper.onViewportScroll: Scroll position changed to "+b+" by API",this);}},adjustFirstVisibleRowToScrollPosition:function(t,s,a){if(a&&a.isCancelled()){return Promise.resolve();}s=s===true;var b=h(t).oVerticalScrollPosition;var N=b.getIndex();var O=t.getFirstVisibleRow();var i=m.isIndexInBuffer(t,N);var r=i;d("VerticalScrollingHelper.adjustFirstVisibleRowToScrollPosition:"+" Set \"firstVisibleRow\" from "+O+" to "+N,t);var u=t._setFirstVisibleRowIndex(N,{onScroll:true,suppressEvent:r,suppressRendering:s});if(!u){if(i){return m.adjustFirstVisibleRowToScrollPositionInBuffer(t,true,a);}return Promise.resolve();}return new Promise(function(v){var w=function(x){d("VerticalScrollingHelper.adjustFirstVisibleRowToScrollPosition (async: rows updated):"+" Reason "+x.getParameters().reason,this);if(i){m.adjustFirstVisibleRowToScrollPositionInBuffer(t,true,a).then(v);}else{v();}return false;};m.addOnRowsUpdatedPreprocessor(t,w);if(a){a.addCancelListener(function(){var R=m.removeOnRowsUpdatedPreprocessor(t,w);if(R){v();}});}});},adjustFirstVisibleRowToScrollPositionInBuffer:function(t,F,a){if(a&&a.isCancelled()){return Promise.resolve();}F=F===true;var s=h(t).oVerticalScrollPosition;var i=s.getIndex();if(!m.isIndexInBuffer(t,i)){d("VerticalScrollingHelper.adjustFirstVisibleRowToScrollPositionInBuffer:"+" Aborted - Scroll position is not in buffer",t);return Promise.resolve();}var N=i;var v=m.getScrollRangeOfViewport(t);var b=t._getMaxFirstRenderedRowIndex();var r=t._aRowHeights;var R;d("VerticalScrollingHelper.adjustFirstVisibleRowToScrollPositionInBuffer");if(s.getOffsetType()===f.OffsetType.PercentageOfBuffer){var u=v*s.getOffset();N=b;for(R=0;R<r.length;R++){var w=u-r[R];if(w>=0){u=w;N++;}else{break;}}}else{var x=Math.max(0,Math.min(r.length-1,i-b));var y=0;for(R=0;R<x;R++){y+=r[R];if(y>v){N=b+R;break;}}}if(i!==N||F){d("VerticalScrollingHelper.adjustFirstVisibleRowToScrollPositionInBuffer: Set \"firstVisibleRow\" to "+N,t);t._setFirstVisibleRowIndex(N,{onScroll:true,forceEvent:F,suppressRendering:true});}return Promise.resolve();},adjustScrollPositionToFirstVisibleRow:function(t,a){if(a&&a.isCancelled()){return Promise.resolve();}d("VerticalScrollingHelper.adjustScrollPositionToFirstVisibleRow",t);h(t).oVerticalScrollPosition.setPosition(t.getFirstVisibleRow());return Promise.resolve();},adjustScrollPositionToScrollbar:function(t,a){if(a&&a.isCancelled()){return Promise.resolve();}var s=h(t).oVerticalScrollPosition;var b=m.getScrollPositionOfScrollbar(t);var i=m.getScrollRange(t);var r=m.getScrollRangeRowFraction(t);var N=0;var u=0;var v=f.OffsetType.Percentage;var w;d("VerticalScrollingHelper.adjustScrollPositionToScrollbar",t);if(T.isVariableRowHeightEnabled(t)){if(m.isScrollPositionOfScrollbarInBuffer(t)){var B=m.getScrollRangeBuffer(t);var x=i-B;var y=b-x;var z=y/B;N=t._getMaxFirstRenderedRowIndex();if(m.isIndexInBuffer(t,s.getIndex())){var A=m.getScrollRangeOfViewport(t);var C=A*z;var R=t._aRowHeights;for(var F=0;F<R.length;F++){var G=C-R[F];if(G>=0){C=G;N++;}else{u=Math.round(C);v=f.OffsetType.Pixel;break;}}}else{u=z;v=f.OffsetType.PercentageOfBuffer;}}else{w=b/r;N=Math.floor(w);u=w-N;}}else{var J=i-b;var K=J<1;if(K){N=t._getMaxFirstVisibleRowIndex();u=0;v=f.OffsetType.Pixel;}else{w=b/r;N=Math.floor(w);u=w-N;}}s.setPosition(N,u,v);return Promise.resolve();},adjustScrollPositionToViewport:function(t,a){if(a&&a.isCancelled()){return Promise.resolve();}var s=h(t).oVerticalScrollPosition;var r=t._aRowHeights;var N=t._iRenderedFirstVisibleRow;var i=0;var b=m.getScrollPositionOfViewport(t);d("VerticalScrollingHelper.adjustScrollPositionToViewport",t);for(var R=0;R<r.length;R++){var u=b-r[R];if(u>=0){b=u;N++;}else{i=Math.round(b);break;}}s.setPosition(N,i);return Promise.resolve();},scrollViewport:function(t,a){if(a&&a.isCancelled()){return Promise.resolve();}var s=h(t).oVerticalScrollPosition;var v=t.getDomRef("tableCCnt");var i=m.getScrollRangeOfViewport(t);var r=t._aRowHeights;if(!T.isVariableRowHeightEnabled(t)||!v||!t.getBinding("rows")){d("VerticalScrollingHelper.scrollViewport: Aborted - Guard clause not passed",t);return Promise.resolve();}if(t._getFirstRenderedRowIndex()!==t._iRenderedFirstVisibleRow){d("VerticalScrollingHelper.scrollViewport: Aborted - Rows will be updated",t);return Promise.resolve();}if(i===0){d("VerticalScrollingHelper.scrollViewport: No overflow in viewport - Scroll to 0",t);t._setFirstVisibleRowIndex(0,{onScroll:true});s.setPosition(0);v.scrollTop=0;return Promise.resolve();}var b=s.getIndex();var u=t._getMaxFirstRenderedRowIndex();var w=0;var x=0;var R;d("VerticalScrollingHelper.scrollViewport");switch(s.getOffsetType()){case f.OffsetType.Pixel:case f.OffsetType.Percentage:if(m.isIndexInBuffer(t,b)){var y=0;x=Math.max(0,Math.min(r.length-1,b-u));for(R=0;R<x;R++){y+=r[R];if(y>i){s.setPosition(u+R,i-w);x=R;break;}else{w=y;}}}if(s.isOffsetInPixel()){s.setOffset(Math.min(s.getOffset(),r[x]));}else{s.setOffset(r[x]*s.getOffset());}w+=s.getOffset();if(w>i){s.setOffset(s.getOffset()-(w-i));w=i;}break;case f.OffsetType.PercentageOfBuffer:if(!m.isIndexInBuffer(t,b)){s.setOffset(0);break;}var z=i*s.getOffset();w=Math.round(z);for(R=0;R<r.length;R++){var A=z-r[R];if(A>=0){z=A;x++;}else{s.setPosition(u+x,Math.round(z));break;}}break;default:}d("VerticalScrollingHelper.scrollViewport: Scroll from "+v.scrollTop+" to "+w,t);v.scrollTop=w;v._scrollTop=v.scrollTop;return Promise.resolve();},scrollScrollbar:function(t,a){if(a&&a.isCancelled()){return Promise.resolve();}var _=h(t);var s=_.oVerticalScrollPosition;var i=s.getIndex();var b=m.getScrollRangeBuffer(t);var r=m.getScrollRange(t);var u=r-b;var v=0;var w=0;var x=m.getScrollRangeOfViewport(t);var R=t._aRowHeights;var y;d("VerticalScrollingHelper.scrollScrollbar",t);if(r===0||R.length===0){d("VerticalScrollingHelper.scrollScrollbar: No scrollable content",t);return Promise.resolve();}switch(s.getOffsetType()){case f.OffsetType.Pixel:case f.OffsetType.Percentage:if(m.isIndexInBuffer(t,i)){var z=0;y=Math.max(0,Math.min(R.length-1,i-t._getMaxFirstRenderedRowIndex()));for(var A=0;A<y;A++){z+=R[A];}if(s.isOffsetInPixel()){z+=Math.min(R[y],s.getOffset());}else{z+=R[y]*s.getOffset();}var B=Math.min(z/x,1);var C=b*B;v=u+C;}else{var F=m.getScrollRangeRowFraction(t);v=i*F;if(s.isOffsetInPixel()){y=Math.max(0,Math.min(R.length-1,i-t._iRenderedFirstVisibleRow));v+=F*Math.min(s.getOffset()/R[y],1);}else{v+=F*s.getOffset();}}break;case f.OffsetType.PercentageOfBuffer:if(m.isIndexInBuffer(t,i)){v=u+Math.round(x*s.getOffset());}break;default:}if(v>0&&v<0.5){w=1;}else if(v>=r-0.5&&v<r){w=r-1;}else{w=Math.round(v);}var G=t._getScrollExtension().getVerticalScrollbar();if(G){d("VerticalScrollingHelper.scrollScrollbar: Scroll from "+G.scrollTop+" to "+w,t);G.scrollTop=w;G._scrollTop=G.scrollTop;}else{d("VerticalScrollingHelper.scrollScrollbar: Not scrolled - No scrollbar available",t);}return Promise.resolve();},getScrollRange:function(t){var s=t._getScrollExtension();var v=s.getVerticalScrollHeight()-s.getVerticalScrollbarHeight();return Math.max(0,v);},getScrollRangeBuffer:function(t){if(!T.isVariableRowHeightEnabled(t)){return 0;}return V*t._getBaseRowHeight();},getScrollPositionOfScrollbar:function(t){var s=t._getScrollExtension();if(s.isVerticalScrollbarVisible()){return s.getVerticalScrollbar().scrollTop;}else{return 0;}},getScrollPositionOfViewport:function(t){var v=t?t.getDomRef("tableCCnt"):null;return v?v.scrollTop:0;},getScrollRangeRowFraction:function(t){var s=t._getScrollExtension();var v=t._getTotalRowCount()-t._getRowCounts().count;var i;if(T.isVariableRowHeightEnabled(t)){i=m.getScrollRange(t)-m.getScrollRangeBuffer(t);var b=s.getVerticalScrollHeight()===M;if(!b){i+=t._getBaseRowHeight();}}else{i=m.getScrollRange(t);}return i/Math.max(1,v);},isScrollPositionOfScrollbarInBuffer:function(t){if(!T.isVariableRowHeightEnabled(t)){return false;}var s=m.getScrollRange(t);var a=m.getScrollPositionOfScrollbar(t);var i=m.getScrollRangeBuffer(t);return s-a<=i;},isIndexInBuffer:function(t,i){if(!T.isVariableRowHeightEnabled(t)){return false;}return i>=t._getMaxFirstRenderedRowIndex();},getScrollRangeOfViewport:function(t){if(!t||!t._aRowHeights){return 0;}var r=t._aRowHeights;var v=t._getBaseRowHeight()*t._getRowCounts().count;if(t._getRowCounts().count>=t._getTotalRowCount()){r=r.slice(0,t._getTotalRowCount());}var i=r.reduce(function(a,b){return a+b;},0)-v;if(i>0){i=Math.ceil(i);}return Math.max(0,i);},addOnRowsUpdatedPreprocessor:function(t,a){h(t).aOnRowsUpdatedPreprocessors.push(a);},removeOnRowsUpdatedPreprocessor:function(t,a){if(!a){h(t).aOnRowsUpdatedPreprocessors=[];return false;}var i=h(t).aOnRowsUpdatedPreprocessors.indexOf(a);if(i>-1){h(t).aOnRowsUpdatedPreprocessors.splice(i,1);return true;}return false;},onRowsUpdated:function(a){d("VerticalScrollingHelper.onRowsUpdated: Reason "+a.getParameters().reason,this);this._getScrollExtension().updateVerticalScrollbarVisibility();if(h(this).aOnRowsUpdatedPreprocessors.length>0){d("VerticalScrollingHelper.onRowsUpdated (preprocessors)",this);var b=h(this).aOnRowsUpdatedPreprocessors.reduce(function(b,i){var _=i.call(this,a);return!(b&&!_);},true);m.removeOnRowsUpdatedPreprocessor(this);if(!b){d("VerticalScrollingHelper.onRowsUpdated (preprocessors): Default prevented",this);return;}}if(!T.isVariableRowHeightEnabled(this)){d("VerticalScrollingHelper.onRowsUpdated: Aborted - Variable row heights not enabled",this);return;}var t=this;j.start(this,j.OnRowsUpdated,function(r,i,s){T.Hook.call(t,H.Signal,"StartTableUpdate");s.onPromiseCreated=function(u){u.finally(function(){T.Hook.call(t,H.Signal,"EndTableUpdate");});};m.scrollViewport(t,s).then(function(){return Promise.all([m.adjustFirstVisibleRowToScrollPosition(t,true,s),m.scrollScrollbar(t,s)]);}).then(r);});},restoreScrollPosition:function(t,b){d("VerticalScrollingHelper.restoreScrollPosition",t);j.start(t,j.RestoreScrollPosition,function(r,a,i){T.Hook.call(t,H.Signal,"StartTableUpdate");i.onPromiseCreated=function(s){s.then(function(){if(!i.isCancelled()){m._restoreScrollPosition(t);}}).finally(function(){T.Hook.call(t,H.Signal,"EndTableUpdate");});};if(b!==true){r();return;}var O=function(){d("VerticalScrollingHelper.restoreScrollPosition (async: rows updated)",t);r();return false;};m.addOnRowsUpdatedPreprocessor(t,O);i.addCancelListener(function(){var R=m.removeOnRowsUpdatedPreprocessor(t,O);if(R){r();}});});},_restoreScrollPosition:function(t){var s=h(t).oVerticalScrollPosition;var b=s.isInitial();d("VerticalScrollingHelper.restoreScrollPosition: "+"Scroll position is"+(b?" ":" not ")+"initial",t);if(b){m.performUpdateFromFirstVisibleRow(t);}else{m.performUpdateFromScrollPosition(t);}},adjustToTotalRowCount:function(t){d("VerticalScrollingHelper.adjustToTotalRowCount",t);var s=t._getScrollExtension();s.updateVerticalScrollbarVisibility();s.updateVerticalScrollHeight();j.start(t,j.AdjustToTotalRowCount,function(r,a,b){T.Hook.call(t,H.Signal,"StartTableUpdate");b.onPromiseCreated=function(i){i.then(function(){if(b.isCancelled()||h(t).oVerticalScrollPosition.isInitial()){return;}m.scrollViewport(t);m.performUpdateFromScrollPosition(t);}).finally(function(){T.Hook.call(t,H.Signal,"EndTableUpdate");});};if(h(t).oVerticalScrollPosition.isInitial()){r();}else{var O=function(){d("VerticalScrollingHelper.adjustToTotalRowCount (async: rows updated)",t);r();return false;};m.addOnRowsUpdatedPreprocessor(t,O);b.addCancelListener(function(){var R=m.removeOnRowsUpdatedPreprocessor(t,O);if(R){r();}});}});},addEventListeners:function(t){var s=t._getScrollExtension();var a=m.getScrollAreas(t);var v=t.getDomRef("tableCCnt");if(!s._onVerticalScrollEventHandler){s._onVerticalScrollEventHandler=m.onScrollbarScroll.bind(t);}for(var i=0;i<a.length;i++){a[i].addEventListener("scroll",s._onVerticalScrollEventHandler);}if(v){if(!s._onViewportScrollEventHandler){s._onViewportScrollEventHandler=m.onViewportScroll.bind(t);}v.addEventListener("scroll",s._onViewportScrollEventHandler);}t.attachEvent("_rowsUpdated",m.onRowsUpdated);},removeEventListeners:function(t){var s=t._getScrollExtension();var a=m.getScrollAreas(t);var v=t.getDomRef("tableCCnt");if(s._onVerticalScrollEventHandler){for(var i=0;i<a.length;i++){a[i].removeEventListener("scroll",s._onVerticalScrollEventHandler);}delete s._onVerticalScrollEventHandler;}if(v&&s._onViewportScrollEventHandler){v.removeEventListener("scroll",s._onViewportScrollEventHandler);delete s._onViewportScrollEventHandler;}t.detachEvent("_rowsUpdated",m.onRowsUpdated);},getScrollAreas:function(t){var s=[t._getScrollExtension().getVerticalScrollbar()];return s.filter(function(a){return a!=null;});}};var n={onMouseWheelScrolling:function(O,a){var s=this._getScrollExtension();var v=Math.abs(a.deltaY)>Math.abs(a.deltaX);var i=v?a.deltaY:a.deltaX;var b=v&&a.shiftKey||!v;var r=i>0;var t=false;if(i===0){return;}if(b&&(O.scrollDirection===c.HORIZONAL||O.scrollDirection===c.BOTH)){var u=s.getHorizontalScrollbar();if(a.deltaMode!==window.WheelEvent.DOM_DELTA_PIXEL){var w=T.Column.getMinColumnWidth();i=r?w:-w;}if(r){t=u.scrollLeft===u.scrollWidth-u.offsetWidth;}else{t=u.scrollLeft===0;}if(s.isHorizontalScrollbarVisible()&&!t){a.preventDefault();a.stopPropagation();this._getKeyboardExtension().setActionMode(false);u.scrollLeft=u.scrollLeft+i;}}else if(!b&&(O.scrollDirection===c.VERTICAL||O.scrollDirection===c.BOTH)){var x=s.getVerticalScrollbar();var y=h(this).oVerticalScrollPosition;if(r){t=x.scrollTop===x.scrollHeight-x.offsetHeight;}else{t=x.scrollTop===0;}if(!s.isVerticalScrollbarVisible()||t){return;}a.preventDefault();a.stopPropagation();if(a.deltaMode===window.WheelEvent.DOM_DELTA_PIXEL){var z=i/this._getDefaultRowHeight();if(z>=0){y.scrollRows(Math.max(1,Math.floor(z)));}else{y.scrollRows(Math.min(-1,Math.ceil(z)));}}else if(a.deltaMode===window.WheelEvent.DOM_DELTA_LINE){y.scrollRows(i);}else if(a.deltaMode===window.WheelEvent.DOM_DELTA_PAGE){y.scrollRows(i*this._getRowCounts().count);}this._getKeyboardExtension().setActionMode(false);m.performUpdateFromScrollPosition(this);}},onTouchStart:function(O,a){if(a.type==="touchstart"||a.pointerType==="touch"){var s=this._getScrollExtension();var b=s.getHorizontalScrollbar();var v=s.getVerticalScrollbar();var t=a.touches?a.touches[0]:a;h(this).mTouchSessionData={initialPageX:t.pageX,initialPageY:t.pageY,initialScrollTop:v?v.scrollTop:0,initialScrollLeft:b?b.scrollLeft:0,initialScrolledToEnd:null,touchMoveDirection:null};}},onTouchMoveScrolling:function(O,a){if(a.type!=="touchmove"&&a.pointerType!=="touch"){return;}var s=this._getScrollExtension();var t=h(this).mTouchSessionData;if(!t){return;}var b=a.touches?a.touches[0]:a;var i=(b.pageX-t.initialPageX);var r=(b.pageY-t.initialPageY);var u=false;if(!t.touchMoveDirection){if(i===0&&r===0){return;}t.touchMoveDirection=Math.abs(i)>Math.abs(r)?"horizontal":"vertical";}switch(t.touchMoveDirection){case"horizontal":var v=s.getHorizontalScrollbar();if(v&&(O.scrollDirection===c.HORIZONAL||O.scrollDirection===c.BOTH)){this._getKeyboardExtension().setActionMode(false);if(t.initialScrolledToEnd==null){if(i<0){t.initialScrolledToEnd=v.scrollLeft===v.scrollWidth-v.offsetWidth;}else{t.initialScrolledToEnd=v.scrollLeft===0;}}if(!t.initialScrolledToEnd){v.scrollLeft=t.initialScrollLeft-i;u=true;}}break;case"vertical":var w=s.getVerticalScrollbar();if(w&&(O.scrollDirection===c.VERTICAL||O.scrollDirection===c.BOTH)){this._getKeyboardExtension().setActionMode(false);if(t.initialScrolledToEnd==null){if(r<0){t.initialScrolledToEnd=w.scrollTop===w.scrollHeight-w.offsetHeight;}else{t.initialScrolledToEnd=w.scrollTop===0;}}if(!t.initialScrolledToEnd){w.scrollTop=t.initialScrollTop-r;u=true;}}break;default:}if(u){a.preventDefault();}},addEventListeners:function(t){var s=t._getScrollExtension();var a=n.getEventListenerTargets(t);s._mMouseWheelEventListener=this.addMouseWheelEventListener(a,t,{scrollDirection:c.BOTH});s._mTouchEventListener=this.addTouchEventListener(a,t,{scrollDirection:c.BOTH});},addMouseWheelEventListener:function(a,t,O){var b=n.onMouseWheelScrolling.bind(t,O);for(var i=0;i<a.length;i++){a[i].addEventListener("wheel",b);}return{wheel:b};},addTouchEventListener:function(a,t,O){var b=n.onTouchStart.bind(t,O);var r=n.onTouchMoveScrolling.bind(t,O);var s={};for(var i=0;i<a.length;i++){if(D.support.pointer&&D.system.desktop){a[i].addEventListener("pointerdown",b);a[i].addEventListener("pointermove",r,D.browser.chrome?{passive:true}:false);}else if(D.support.touch){a[i].addEventListener("touchstart",b);a[i].addEventListener("touchmove",r);}}if(D.support.pointer&&D.system.desktop){s={pointerdown:b,pointermove:r};}else if(D.support.touch){s={touchstart:b,touchmove:r};}return s;},removeEventListeners:function(t){var s=t._getScrollExtension();var a=n.getEventListenerTargets(t);function r(b,u){for(var v in u){var w=u[v];if(w){b.removeEventListener(v,w);}}}for(var i=0;i<a.length;i++){r(a[i],s._mMouseWheelEventListener);r(a[i],s._mTouchEventListener);}delete s._mMouseWheelEventListener;delete s._mTouchEventListener;},getEventListenerTargets:function(t){var a=[t.getDomRef("tableCCnt")];return a.filter(function(b){return b!=null;});}};var o={onBeforeRendering:function(a){this._getScrollExtension()._clearCache();},onAfterRendering:function(a){var s=this._getScrollExtension();var r=a!=null&&a.isMarked("renderRows");if(r){s.updateVerticalScrollbarHeight();s.updateVerticalScrollHeight();}else{m.restoreScrollPosition(this,this.getBinding("rows")!=null);}k.restoreScrollPosition(this);},onfocusin:function(a){var r;var C=T.getCellInfo(a.target);var b=this._getScrollExtension().getHorizontalScrollbar();if(C.isOfType(T.CELLTYPE.DATACELL)){r=this.getDomRef("sapUiTableCtrlScr");}else if(C.isOfType(T.CELLTYPE.COLUMNHEADER)){r=this.getDomRef("sapUiTableColHdrScr");}if(r&&b&&C.columnIndex>=this.getComputedFixedColumnCount()){var $=q(b);var i=C.cell[0];var s=this._bRtlMode?$.scrollLeftRTL():b.scrollLeft;var R=r.clientWidth;var t=i.offsetLeft;var u=t+i.offsetWidth;var O=t-s;var v=u-R-s;var N;if(O<0&&v<0){N=s+O;}else if(v>0&&O>0){N=s+v;}if(N!=null){if(this._bRtlMode){$.scrollLeftRTL(N);}else{b.scrollLeft=N;}}}var w=T.getParentCell(this,a.target);if(w){var x=this;var y=function(){var z=w.find(".sapUiTableCellInner");if(z.length>0){if(x._bRtlMode){z.scrollLeftRTL(z[0].scrollWidth-z[0].clientWidth);}else{z[0].scrollLeft=0;}z[0].scrollTop=0;}T.Hook.call(x,H.Signal,"EndFocusHandling");T.Hook.call(x,H.Signal,"EndTableUpdate");};T.Hook.call(this,H.Signal,"StartTableUpdate");T.Hook.call(this,H.Signal,"StartFocusHandling");Promise.resolve().then(function(){if(D.browser.safari){window.setTimeout(y,0);}else{y();}});}}};var p=E.extend("sap.ui.table.extensions.Scrolling",{_init:function(t,s,a){T.addDelegate(t,o,t);return"ScrollExtension";},_attachEvents:function(){var t=this.getTable();k.addEventListeners(t);m.addEventListeners(t);n.addEventListeners(t);},_detachEvents:function(){var t=this.getTable();k.removeEventListeners(t);m.removeEventListeners(t);n.removeEventListeners(t);},destroy:function(){var t=this.getTable();T.removeDelegate(t,o);this._clearCache();if(h(t).pVerticalScrollUpdateProcess){h(t).pVerticalScrollUpdateProcess.cancel();h(t).pVerticalScrollUpdateProcess=null;}h.destroy(t);E.prototype.destroy.apply(this,arguments);}});p.prototype.scrollVertically=function(b,a,A,B){var t=this.getTable();if(!t){return false;}b=b===true;a=a===true;A=A===true;var s=false;var i=t._getTotalRowCount();var r=t._getRowCounts();var F=t.getFirstVisibleRow();var u=a?r.scrollable:1;if(b){if(F+r.count<i){if(B){B();}if(A){setTimeout(function(){t.setFirstVisibleRow(Math.min(F+u,i-r.count));},0);}else{t.setFirstVisibleRow(Math.min(F+u,i-r.count));}s=true;}}else if(F>0){if(B){B();}if(A){setTimeout(function(){t.setFirstVisibleRow(Math.max(F-u,0));},0);}else{t.setFirstVisibleRow(Math.max(F-u,0));}s=true;}return s;};p.prototype.scrollVerticallyMax=function(b){var t=this.getTable();if(!t){return false;}b=b===true;var s=false;var F=t.getFirstVisibleRow();if(b){var i=t._getTotalRowCount()-T.getNonEmptyVisibleRowCount(t);if(F<i){t.setFirstVisibleRow(i);s=true;}}else if(F>0){t.setFirstVisibleRow(0);s=true;}return s;};p.prototype.getHorizontalScrollbar=function(){var t=this.getTable();if(t&&!t._bInvalid&&!h(t).oHorizontalScrollbar){h(t).oHorizontalScrollbar=t.getDomRef(S.HorizontalScrollBar);}return h(t).oHorizontalScrollbar||null;};p.prototype.getVerticalScrollbar=function(i){var t=this.getTable();var b=this.isVerticalScrollbarExternal();if(t&&!t._bInvalid&&!h(t).oVerticalScrollbar){h(t).oVerticalScrollbar=t.getDomRef(S.VerticalScrollBar);if(!h(t).oVerticalScrollbar&&b){h(t).oVerticalScrollbar=h(t).oExternalVerticalScrollbar;}}var s=h(t).oVerticalScrollbar;if(s&&!b&&!i&&!e(s)){return null;}return s||null;};p.prototype.isHorizontalScrollbarVisible=function(){var a=this.getHorizontalScrollbar();return a!=null&&!a.classList.contains("sapUiTableHidden");};p.prototype.isVerticalScrollbarVisible=function(){var v=this.getVerticalScrollbar();return v!=null&&!v.classList.contains("sapUiTableHidden");};p.prototype.isVerticalScrollbarExternal=function(){return h(this.getTable()).bIsVerticalScrollbarExternal;};p.prototype.markVerticalScrollbarAsExternal=function(s){if(s){h(this.getTable()).bIsVerticalScrollbarExternal=true;h(this.getTable()).oExternalVerticalScrollbar=s;}};p.prototype.updateHorizontalScrollbar=function(t){var a=this.getTable();var b=this.getHorizontalScrollbar();if(!a||!b||!t){return;}var $=a.$();var C=t.tableCtrlScrollWidth;if(D.browser.safari){C=Math.max(C,a._getColumnsWidth(a.getComputedFixedColumnCount()));}var i=C>t.tableCtrlScrWidth;if(i){if(!this.isHorizontalScrollbarVisible()){$.addClass("sapUiTableHScr");b.classList.remove("sapUiTableHidden");if(D.browser.safari){var r=$.find(".sapUiTableCtrlScroll, .sapUiTableColHdrScr > .sapUiTableColHdr");r.outerWidth(C);}}var s=t.tableCtrlFixedWidth;if($.find(".sapUiTableRowHdrScr").length>0){s+=t.tableRowHdrScrWidth;}if(a._bRtlMode){b.style.marginRight=s+"px";b.style.marginLeft="";}else{b.style.marginLeft=s+"px";b.style.marginRight="";}var u=a.getDomRef("hsb-content");if(u){u.style.width=C+"px";}}if(!i&&this.isHorizontalScrollbarVisible()){$.removeClass("sapUiTableHScr");b.classList.add("sapUiTableHidden");if(D.browser.safari){$.find(".sapUiTableCtrlScroll, .sapUiTableColHdr").css("width","");}}};p.prototype.updateVerticalScrollbarHeight=function(){var t=this.getTable();var v=this.getVerticalScrollbar();if(!t||!v){return;}v.style.maxHeight=this.getVerticalScrollbarHeight()+"px";v._scrollTop=v.scrollTop;};p.prototype.getVerticalScrollbarHeight=function(){var t=this.getTable();if(!t){return 0;}return t._getRowCounts().scrollable*t._getBaseRowHeight();};p.prototype.updateVerticalScrollbarPosition=function(){var t=this.getTable();var v=this.getVerticalScrollbar();if(!t||!v){return;}var a=t.getDomRef("tableCCnt");if(a){var i=a.offsetTop;var b=t.getDomRef("vsb-bg");if(b){b.style.top=i+"px";}if(t._getRowCounts().fixedTop>0){i+=t._iVsbTop;}v.style.top=i+"px";}};p.prototype.updateVerticalScrollPosition=function(b){var t=this.getTable();if(!t){return;}m.performUpdateFromFirstVisibleRow(t,b);};p.prototype.adjustToTotalRowCount=function(){m.adjustToTotalRowCount(this.getTable());};p.prototype.restoreVerticalScrollPosition=function(){m.restoreScrollPosition(this.getTable());};p.prototype.updateVerticalScrollHeight=function(){var v=this.getVerticalScrollbar();var a=v?v.firstChild:null;if(!a){return;}a.style.height=this.getVerticalScrollHeight()+"px";v._scrollTop=v.scrollTop;};p.prototype.getVerticalScrollHeight=function(b){var t=this.getTable();if(!t){return 0;}var i=t._getTotalRowCount();var v=t._getRowCounts().count;var B=t._getBaseRowHeight();var r;var s;if(T.isVariableRowHeightEnabled(t)){r=Math.max(i,v+1);s=B*(r-1)+m.getScrollRangeBuffer(t);}else{r=Math.max(i,v);s=B*r;}if(b===true){return s;}else{return Math.min(M,s);}};p.prototype.updateVerticalScrollbarVisibility=function(){var t=this.getTable();var a=t?t.getDomRef():null;var v=this.getVerticalScrollbar();if(!a||!v){return;}var b=this.isVerticalScrollbarRequired();if(b&&!this.isVerticalScrollbarVisible()){if(!this.isVerticalScrollbarExternal()){a.classList.add("sapUiTableVScr");}v.classList.remove("sapUiTableHidden");}if(!b&&this.isVerticalScrollbarVisible()){a.classList.remove("sapUiTableVScr");v.classList.add("sapUiTableHidden");}};p.prototype.isVerticalScrollbarRequired=function(){var t=this.getTable();if(!t){return false;}return T.isVariableRowHeightEnabled(t)&&m.getScrollRangeOfViewport(t)>0||t._getTotalRowCount()>t._getRowCounts().count;};p.prototype.registerForMouseWheel=function(a,O){var t=this.getTable();if(E.isEnrichedWith(t,"sap.ui.table.extensions.Synchronization")){return n.addMouseWheelEventListener(a,t,O);}else{L.error("This method can only be used with synchronization enabled.",t,"sap.ui.table.extensions.Scrolling#registerForMouseWheel");return null;}};p.prototype.registerForTouch=function(a,O){var t=this.getTable();if(E.isEnrichedWith(t,"sap.ui.table.extensions.Synchronization")){return n.addTouchEventListener(a,t,O);}else{L.error("This method can only be used with synchronization enabled.",t,"sap.ui.table.extensions.Scrolling#registerForTouch");return null;}};p.prototype._clearCache=function(){h(this.getTable()).oVerticalScrollbar=null;h(this.getTable()).oHorizontalScrollbar=null;};p.ScrollDirection=c;return p;});
