/*!
 * OpenUI5
 * (c) Copyright 2009-2020 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(['sap/ui/core/format/NumberFormat','sap/ui/model/CompositeType','sap/ui/model/FormatException','sap/ui/model/ParseException','sap/ui/model/ValidateException','sap/ui/core/LocaleData',"sap/base/strings/hash","sap/ui/thirdparty/jquery","sap/base/util/isEmptyObject"],function(N,C,F,P,V,L,h,q,i){"use strict";var U=C.extend("sap.ui.model.type.Unit",{constructor:function(f,c,d){C.apply(this,arguments);this.sName="Unit";this.bUseRawValues=true;this.aDynamicFormatOptionNames=d;}});U.prototype._getInstance=function(a,u){var f=this.createFormatOptions(a);if(u&&!this.oFormatOptions.customUnits&&!f.customUnits){var l=sap.ui.getCore().getConfiguration().getFormatSettings().getFormatLocale();var o=L.getInstance(l);var s=o.getUnitFromMapping(u)||u;var m=o.getUnitFormat(s);if(m){var b=q.extend({},m);b.decimals=(f.decimals!=undefined)?f.decimals:b.decimals;b.precision=(f.precision!=undefined)?f.precision:b.precision;f.customUnits={};f.customUnits[u]=b;}}var c=f;if(this.oFormatOptions){c=q.extend({},this.oFormatOptions,f);}if(this.getMetadata().getClass()!==U){var M=this.getMetadata();M._mTypeInstanceCache=M._mTypeInstanceCache||{};var H=h(JSON.stringify(c)||"");var d=M._mTypeInstanceCache[H];if(!d){d=N.getUnitInstance(c);M._mTypeInstanceCache[H]=d;}return d;}else{return N.getUnitInstance(c);}};U.prototype._clearInstances=function(){if(this.getMetadata().getClass()!==U){var m=this.getMetadata();if(m._mTypeInstanceCache){m._mTypeInstanceCache={};}}};U.prototype.createFormatOptions=function(v){var f={};if(this.aDynamicFormatOptionNames&&v.length>=this.aDynamicFormatOptionNames.length){this.aDynamicFormatOptionNames.forEach(function(d,I){if(d){f[d]=v[I];}});}return f;};U.prototype.extractArguments=function(v){return Array.isArray(v)&&v.length>2?v.slice(2):[];};U.prototype.formatValue=function(v,I){var a=v;if(v==undefined||v==null){return null;}if(this.oInputFormat){a=this.oInputFormat.parse(v);}if(!Array.isArray(a)){throw new F("Cannot format Unit: "+v+" has the wrong format");}if(a[0]==undefined||a[0]==null){return null;}switch(this.getPrimitiveType(I)){case"string":this.aDynamicValues=this.extractArguments(a);this.oOutputFormat=this._getInstance(this.aDynamicValues,a[1]);return this.oOutputFormat.format(a);case"int":case"float":case"any":default:throw new F("Don't know how to format Unit to "+I);}};U.prototype.parseValue=function(v,I){var r,b;switch(this.getPrimitiveType(I)){case"string":this.oOutputFormat=this._getInstance(this.aDynamicValues);r=this.oOutputFormat.parse(v);if(!Array.isArray(r)||isNaN(r[0])){b=sap.ui.getCore().getLibraryResourceBundle();throw new P(b.getText("Unit.Invalid",[v]));}break;case"int":case"float":default:throw new P("Don't know how to parse Unit from "+I);}if(this.oInputFormat){r=this.oInputFormat.format(r);}return r;};U.prototype.validateValue=function(v){if(this.oConstraints){var b=sap.ui.getCore().getLibraryResourceBundle(),a=[],m=[],c=v,d;if(this.oInputFormat){c=this.oInputFormat.parse(v);}d=c[0];q.each(this.oConstraints,function(n,o){switch(n){case"minimum":if(d<o){a.push("minimum");m.push(b.getText("Unit.Minimum",[o]));}break;case"maximum":if(d>o){a.push("maximum");m.push(b.getText("Unit.Maximum",[o]));}break;case"decimals":var t=N._shiftDecimalPoint(d,o);if(Math.floor(t)!==t){a.push("decimals");m.push(b.getText("Unit.Decimals",[o]));}break;}});if(a.length>0){throw new V(m.join(" "),a);}}};U.prototype.setFormatOptions=function(f){this.oFormatOptions=f;this._clearInstances();this._createInputFormat();};U.prototype._handleLocalizationChange=function(){this._clearInstances();this._createInputFormat();};U.prototype._createInputFormat=function(){var s=this.oFormatOptions.source;if(s){if(i(s)){s={groupingEnabled:false,groupingSeparator:",",decimalSeparator:"."};}this.oInputFormat=N.getUnitInstance(s);}};return U;});
