/*!
 * OpenUI5
 * (c) Copyright 2009-2020 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["sap/base/Log","sap/base/util/deepEqual","sap/base/util/isEmptyObject","sap/base/util/merge","sap/base/util/uid","sap/ui/base/SyncPromise","sap/ui/thirdparty/URI"],function(L,d,a,m,u,S,U){"use strict";var r=/&/g,c="sap.ui.model.odata.v4.lib._Helper",b=/\=/g,f=/%29/g,g=/%28/g,h=/%27/g,j=/#/g,_,k=/\([^/]*|\/-?\d+/g,l=/\+/g,n=/'/g;_={addByPath:function(M,p,i){if(i){if(!M[p]){M[p]=[i];}else if(M[p].indexOf(i)<0){M[p].push(i);}}},addChildrenWithAncestor:function(C,A,e){if(A.length){C.forEach(function(p){var s;if(A.indexOf(p)>=0){e[p]=true;return;}s=p.split("/");s.pop();while(s.length){if(A.indexOf(s.join("/"))>=0){e[p]=true;break;}s.pop();}});}},addToSelect:function(q,s){q.$select=q.$select||[];s.forEach(function(p){if(q.$select.indexOf(p)<0){q.$select.push(p);}});},aggregateQueryOptions:function(A,q){if(q.$select){_.addToSelect(A,q.$select);}if(q.$expand){A.$expand=A.$expand||{};Object.keys(q.$expand).forEach(function(p){if(A.$expand[p]){_.aggregateQueryOptions(A.$expand[p],q.$expand[p]);}else{A.$expand[p]=q.$expand[p];}});}},buildPath:function(){var i,p="",s;for(i=0;i<arguments.length;i+=1){s=arguments[i];if(s||s===0){if(p&&p!=="/"&&s[0]!=="("){p+="/";}p+=s;}}return p;},buildQuery:function(p){var K,q;if(!p){return"";}K=Object.keys(p);if(K.length===0){return"";}q=[];K.forEach(function(s){var v=p[s];if(Array.isArray(v)){v.forEach(function(i){q.push(_.encodePair(s,i));});}else{q.push(_.encodePair(s,v));}});return"?"+q.join("&");},clone:function clone(v,R){return v===undefined||v===Infinity||v===-Infinity||v!==v?v:JSON.parse(JSON.stringify(v,R));},createError:function(i,M,R,s){var B=i.responseText,C=i.getResponseHeader("Content-Type"),o=new Error(M+": "+i.status+" "+i.statusText);o.status=i.status;o.statusText=i.statusText;o.requestUrl=R;o.resourcePath=s;if(i.status===0){o.message="Network error";return o;}if(C){C=C.split(";")[0];}if(i.status===412){o.isConcurrentModification=true;}if(C==="application/json"){try{o.error=JSON.parse(B).error;o.message=o.error.message;if(typeof o.message==="object"){o.message=o.error.message.value;}}catch(e){L.warning(e.toString(),B,c);}}else if(C==="text/plain"){o.message=B;}return o;},createGetMethod:function(F,t){return function(){var s=this[F].apply(this,arguments);if(s.isFulfilled()){return s.getResult();}else if(t){if(s.isRejected()){s.caught();throw s.getResult();}else{throw new Error("Result pending");}}};},createRequestMethod:function(F){return function(){return Promise.resolve(this[F].apply(this,arguments));};},createTechnicalDetails:function(M){var C,o=M["@$ui5.originalMessage"]||M,t={};if(!(o instanceof Error)){Object.defineProperty(t,"originalMessage",{enumerable:true,get:function(){if(!C){C=_.publicClone(o);}return C;}});}return t;},deepEqual:d,deletePrivateAnnotation:function(o,A){var p=o["@$ui5._"];if(p){delete p[A];}},drillDown:function(D,p){return p.reduce(function(D,s){return(D&&s in D)?D[s]:undefined;},D);},encode:function(p,e){var E=encodeURI(p).replace(r,"%26").replace(j,"%23").replace(l,"%2B");if(e){E=E.replace(b,"%3D");}return E;},encodePair:function(K,v){return _.encode(K,true)+"="+_.encode(v,false);},extractMergeableQueryOptions:function(q){var e={};if("$expand"in q){e.$expand=q.$expand;q.$expand="~";}if("$select"in q){e.$select=q.$select;q.$select="~";}return e;},fetchPropertyAndType:function(F,M){return F(M).then(function(p){if(p&&p.$kind==="NavigationProperty"){return F(M+"/").then(function(){return p;});}return p;});},fireChange:function(C,p,v){var e=C[p],i;if(e){for(i=0;i<e.length;i+=1){e[i].onChange(v);}}},fireChanges:function(C,p,v,R){Object.keys(v).forEach(function(P){var s=_.buildPath(p,P),V=v[P];if(V&&typeof V==="object"){_.fireChanges(C,s,V,R);}else{_.fireChange(C,s,R?undefined:V);}});_.fireChange(C,p,R?undefined:v);},formatLiteral:function(v,t){if(v===undefined){throw new Error("Illegal value: undefined");}if(v===null){return"null";}switch(t){case"Edm.Binary":return"binary'"+v+"'";case"Edm.Boolean":case"Edm.Byte":case"Edm.Double":case"Edm.Int16":case"Edm.Int32":case"Edm.SByte":case"Edm.Single":return String(v);case"Edm.Date":case"Edm.DateTimeOffset":case"Edm.Decimal":case"Edm.Guid":case"Edm.Int64":case"Edm.TimeOfDay":return v;case"Edm.Duration":return"duration'"+v+"'";case"Edm.String":return"'"+v.replace(n,"''")+"'";default:throw new Error("Unsupported type: "+t);}},getKeyFilter:function(i,M,t,K){var F=[],s,e=_.getKeyProperties(i,M,t,K);if(!e){return undefined;}for(s in e){F.push(s+" eq "+e[s]);}return F.join(" and ");},getKeyPredicate:function(i,M,t,K,e){var o=_.getKeyProperties(i,M,t,K,true);if(!o){return undefined;}K=Object.keys(o).map(function(A,I,p){var v=encodeURIComponent(o[A]);return e||p.length>1?encodeURIComponent(A)+"="+v:v;});return"("+K.join(",")+")";},getKeyProperties:function(i,M,t,K,R){var F,e={};K=K||t[M].$Key;F=K.some(function(v){var s,o,p,P,T,V;if(typeof v==="string"){s=o=v;}else{s=Object.keys(v)[0];o=v[s];if(!R){s=o;}}p=o.split("/");V=_.drillDown(i,p);if(V===undefined){return true;}P=p.pop();T=t[_.buildPath(M,p.join("/"))];V=_.formatLiteral(V,T[P].$Type);e[s]=V;});return F?undefined:e;},getMetaPath:function(p){if(p[0]==="/"){return p.replace(k,"");}if(p[0]!=="("){p="/"+p;}return p.replace(k,"").slice(1);},getPrivateAnnotation:function(o,A){var p=o["@$ui5._"];return p&&p[A];},getQueryOptionsForPath:function(q,p){p=_.getMetaPath(p);if(p){p.split("/").some(function(s){q=q&&q.$expand&&q.$expand[s];if(!q||q===true){q={};return true;}});}return q||{};},getRelativePath:function(p,B){if(!p.startsWith(B)){return undefined;}p=p.slice(B.length);if(p){if(p[0]==="/"){return p.slice(1);}if(p[0]!=="("){return undefined;}}return p;},hasPrivateAnnotation:function(o,A){var p=o["@$ui5._"];return p?A in p:false;},informAll:function(C,p,o,N){if(N===o){return;}if(N&&typeof N==="object"){Object.keys(N).forEach(function(P){_.informAll(C,_.buildPath(p,P),o&&o[P],N[P]);});}else{_.fireChange(C,p,N===undefined?null:N);N={};}if(o&&typeof o==="object"){Object.keys(o).forEach(function(P){if(!N.hasOwnProperty(P)){_.informAll(C,_.buildPath(p,P),o[P],undefined);}});}},intersectQueryOptions:function(C,p,F,R,N,P,A){var e=[],E={},o,q,s,t={};function v(w,M){var x=M.split("/");return x.every(function(y,i){return i===0&&w||F(R+"/"+x.slice(0,i+1).join("/")).getResult().$kind==="Property";});}if(p.indexOf("")>=0){throw new Error("Unsupported empty navigation property path");}if(p.indexOf("*")>=0){s=C&&C.$select||[];}else if(C&&C.$select&&C.$select.indexOf("*")<0){_.addChildrenWithAncestor(p,C.$select,t);_.addChildrenWithAncestor(C.$select,p,t);s=Object.keys(t).filter(v.bind(null,true));}else{s=p.filter(v.bind(null,false));}if(C&&C.$expand){e=Object.keys(C.$expand);e.forEach(function(i){var w,M=R+"/"+i,x=_.buildPath(P,i),y={},z;_.addChildrenWithAncestor([i],p,y);if(!a(y)){if(F(M).getResult().$isCollection){N[x]=true;}E[i]=C.$expand[i];return;}z=_.stripPathPrefix(i,p);if(z.length){if(F(M).getResult().$isCollection){throw new Error("Unsupported collection-valued navigation property "+M);}w=_.intersectQueryOptions(C.$expand[i]||{},z,F,M,N,x);if(w){E[i]=w;}}});}if(!s.length&&a(E)){return null;}o=Object.assign({},C,{$select:s});q=F(R).getResult();if(q.$kind==="NavigationProperty"&&!q.$isCollection){_.selectKeyProperties(o,F(R+"/").getResult());}else if(!s.length&&!A){o.$select=Object.keys(E).slice(0,1);}if(a(E)){delete o.$expand;}else{o.$expand=E;}return o;},hasPathPrefix:function(p,B){return _.getRelativePath(p,B)!==undefined;},isSafeInteger:function(N){if(typeof N!=="number"||!isFinite(N)){return false;}N=Math.abs(N);return N<=9007199254740991&&Math.floor(N)===N;},makeAbsolute:function(s,B){return new U(s).absoluteTo(B).toString().replace(h,"'").replace(g,"(").replace(f,")");},merge:m,mergeQueryOptions:function(q,o,F){var R;function s(p,v){if(v&&(!q||q[p]!==v)){if(!R){R=q?_.clone(q):{};}R[p]=v;}}s("$orderby",o);if(F){s("$filter",F[0]);s("$$filterBeforeAggregate",F[1]);}return R||q;},namespace:function(N){var i;N=N.split("/")[0].split("(")[0];i=N.lastIndexOf(".");return i<0?"":N.slice(0,i);},parseLiteral:function(s,t,p){function e(i){if(!isFinite(i)){throw new Error(p+": Not a valid "+t+" literal: "+s);}return i;}if(s==="null"){return null;}switch(t){case"Edm.Boolean":return s==="true";case"Edm.Byte":case"Edm.Int16":case"Edm.Int32":case"Edm.SByte":return e(parseInt(s));case"Edm.Date":case"Edm.DateTimeOffset":case"Edm.Decimal":case"Edm.Guid":case"Edm.Int64":case"Edm.TimeOfDay":return s;case"Edm.Double":case"Edm.Single":return s==="INF"||s==="-INF"||s==="NaN"?s:e(parseFloat(s));default:throw new Error(p+": Unsupported type: "+t);}},publicClone:function(v){return _.clone(v,function(K,v){if(K!=="@$ui5._"){return v;}});},removeByPath:function(M,p,i){var I=M[p],e;if(I){e=I.indexOf(i);if(e>=0){if(I.length===1){delete M[p];}else{I.splice(e,1);}}}},resolveIfMatchHeader:function(H){var i=H&&H["If-Match"];if(i&&typeof i==="object"){i=i["@odata.etag"];H=Object.assign({},H);if(i===undefined){delete H["If-Match"];}else{H["If-Match"]=i;}}return H;},selectKeyProperties:function(q,t){if(t&&t.$Key){_.addToSelect(q,t.$Key.map(function(K){if(typeof K==="object"){return K[Object.keys(K)[0]];}return K;}));}},setPrivateAnnotation:function(o,A,v){var p=o["@$ui5._"];if(!p){p=o["@$ui5._"]={};}p[A]=v;},stripPathPrefix:function(p,P){var s=p+"/";if(p===""){return P;}return P.filter(function(e){return e===p||e.startsWith(s);}).map(function(e){return e.slice(s.length);});},toArray:function(e){if(e===undefined||e===null){return[];}if(Array.isArray(e)){return e;}return[e];},uid:u,updateAll:function(C,p,t,s,e){Object.keys(s).forEach(function(P){var i=_.buildPath(p,P),o,v=s[P],T,q=t[P];if(P==="@$ui5._"){o=_.getPrivateAnnotation(s,"predicate");if(e&&e(p)){T=_.getPrivateAnnotation(t,"predicate");if(o!==T){throw new Error("Key predicate of '"+p+"' changed from "+T+" to "+o);}}else{_.setPrivateAnnotation(t,"predicate",o);}}else if(Array.isArray(v)){t[P]=v;}else if(v&&typeof v==="object"){t[P]=_.updateAll(C,i,q||{},v,e);}else if(q!==v){t[P]=v;if(q&&typeof q==="object"){_.fireChanges(C,i,q,true);}else{_.fireChange(C,i,v);}}});return t;},updateExisting:function(C,p,o,N){if(!N){return;}Object.keys(o).forEach(function(P){var s=_.buildPath(p,P),O=o[P],v=N[P];if(P in N||P[0]==="#"){if(Array.isArray(v)){o[P]=v;}else if(v&&typeof v==="object"){if(O){_.updateExisting(C,s,O,v);}else{o[P]=v;_.fireChanges(C,s,v,false);}}else if(O!==v){o[P]=v;if(O&&typeof O==="object"){_.fireChanges(C,s,O,true);}else{_.fireChange(C,s,v);}}}});Object.keys(N).filter(function(P){return P[0]==="#";}).filter(function(A){return!(A in o);}).forEach(function(s){var v=N[s],P=_.buildPath(p,s);o[s]=v;_.fireChanges(C,P,v,false);});},updateSelected:function(C,p,o,N,s){var P;function e(i,q,t){var v=i.split("/");v.every(function(w,I){var x=q[w],T=t[w];if(Array.isArray(x)){t[w]=x;}else if(x&&typeof x==="object"){t=t[w]=T||{};q=x;return true;}else if(T!==x){t[w]=x;if(T&&typeof T==="object"){_.fireChanges(C,_.buildPath(p,v.slice(0,I+1).join("/")),T,true);}else if(I===v.length-1){_.fireChange(C,_.buildPath(p,i),x);}}return false;});}if(!s||s.indexOf("*")>=0){_.updateAll(C,p,o,N);return;}s=s.concat("@odata.etag");s.forEach(function(i){e(i,N,o);});P=_.getPrivateAnnotation(N,"predicate");if(P){_.setPrivateAnnotation(o,"predicate",P);}},updateTransientPaths:function(M,t,p){var P;for(P in M){if(P.includes(t)){M[P.replace(t,p)]=M[P];delete M[P];}}},wrapChildQueryOptions:function(B,C,e,F){var E="",i,M=C.split("/"),p,P=B,q={},Q=q;if(C===""){return e;}for(i=0;i<M.length;i+=1){P=_.buildPath(P,M[i]);E=_.buildPath(E,M[i]);p=F(P).getResult();if(p.$kind==="NavigationProperty"){Q.$expand={};Q=Q.$expand[E]=(i===M.length-1)?e:{};_.selectKeyProperties(Q,F(P+"/").getResult());E="";}else if(p.$kind!=="Property"){return undefined;}}if(p.$kind==="Property"){if(Object.keys(e).length>0){L.error("Failed to enhance query options for auto-$expand/$select as the"+" child binding has query options, but its path '"+C+"' points to a structural property",JSON.stringify(e),c);return undefined;}_.addToSelect(Q,[E]);}if("$apply"in e){L.debug("Cannot wrap $apply into $expand: "+C,JSON.stringify(e),c);return undefined;}return q;}};return _;},false);
