/*!
 * OpenUI5
 * (c) Copyright 2009-2020 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["./lib/_Helper","sap/base/Log","sap/ui/base/SyncPromise","sap/ui/model/Context"],function(_,L,S,B){"use strict";var c="sap.ui.model.odata.v4.Context",m,r=0,v=-9007199254740991;function f(o,p,e,b){var E,P=[o.fetchValue(p,null,b)],R=p[0]==="/"?p:_.buildPath(o.getPath(),p);if(e){P.push(o.oModel.getMetaModel().fetchUI5Type(R));}return S.all(P).then(function(a){var t=a[1],V=a[0];if(V&&typeof V==="object"){E=new Error("Accessed value is not primitive: "+R);E.isNotPrimitive=true;throw E;}return e?t.formatValue(V,"string"):V;});}var C=B.extend("sap.ui.model.odata.v4.Context",{constructor:function(M,b,p,i,o,R){if(p[0]!=="/"){throw new Error("Not an absolute path: "+p);}if(p.endsWith("/")){throw new Error("Unsupported trailing slash: "+p);}B.call(this,M,p);this.oBinding=b;this.oCreatePromise=o&&Promise.resolve(o).then(function(){});this.oSyncCreatePromise=o&&S.resolve(o);this.iIndex=i;this.bKeepAlive=false;this.iReturnValueContextId=R;}});C.prototype._delete=function(g,e){var t=this;if(this.isTransient()){return this.oBinding._delete(g,"n/a",this);}return this.fetchCanonicalPath().then(function(s){return t.oBinding._delete(g,s.slice(1),t,e);}).then(function(){t.bKeepAlive=false;});};C.prototype.adjustPredicate=function(t,p,P){var T=this.sPath;if(T.includes(t)){this.sPath=T.split("/").map(function(s){if(s.endsWith(t)){s=s.slice(0,-t.length)+p;}return s;}).join("/");if(P){P(T,this.sPath);}this.oModel.getDependentBindings(this).forEach(function(d){d.adjustPredicate(t,p);});}};C.prototype.checkUpdate=function(){return S.all(this.oModel.getDependentBindings(this).map(function(d){return d.checkUpdate();}));};C.prototype.created=function(){return this.oCreatePromise;};C.prototype.delete=function(g){var G,M=this.oModel,t=this;M.checkGroupId(g);this.oBinding.checkSuspended();if(this.isTransient()){g=g||"$direct";}else if(this.hasPendingChanges()){throw new Error("Cannot delete due to pending changes");}G=this.oBinding.lockGroup(g,true,true);return this._delete(G).then(function(){var R=t.sPath.slice(1);M.getAllBindings().forEach(function(b){b.removeCachesAndMessages(R,true);});}).catch(function(e){G.unlock(true);M.reportError("Failed to delete "+t,c,e);throw e;});};C.prototype.destroy=function(){this.oModel.getDependentBindings(this).forEach(function(d){d.setContext(undefined);});this.oBinding=undefined;this.oModel=undefined;B.prototype.destroy.call(this);};C.prototype.doSetProperty=function(p,V,g,s){var M=this.oModel.getMetaModel(),t=this;if(this.oModel.bAutoExpandSelect){p=M.getReducedPath(_.buildPath(this.sPath,p),this.oBinding.getBaseForPathReduction());}return this.withCache(function(o,a,b){return b.doSetProperty(a,V,g)||M.fetchUpdateData(p,t,!g).then(function(R){var e=_.getRelativePath(R.entityPath,b.oReturnValueContext?b.oReturnValueContext.getPath():t.oModel.resolve(b.sPath,b.oContext)),F=false;function d(E){t.oModel.reportError("Failed to update path "+t.oModel.resolve(p,t),c,E);h(false);}function h(j){if(F){b.firePatchCompleted(j);F=false;}}function i(){F=true;b.firePatchSent();}if(!g){return o.setProperty(R.propertyPath,V,e);}return o.update(g,R.propertyPath,V,s?undefined:d,R.editUrl,e,M.getUnitOrCurrencyPath(t.oModel.resolve(p,t)),b.isPatchWithoutSideEffects(),i).then(function(){h(true);},function(E){h(false);throw E;});});},p,false,true);};C.prototype.expand=function(){var t=this;switch(this.isExpanded()){case false:this.oBinding.expand(this).catch(function(e){t.oModel.reportError("Failed to expand "+t,c,e);});break;case true:throw new Error("Already expanded: "+this);default:throw new Error("Not expandable: "+this);}};C.prototype.fetchCanonicalPath=function(){return this.oModel.getMetaModel().fetchCanonicalPath(this);};C.prototype.fetchValue=function(p,l,b){if(this.iIndex===v){return S.resolve();}if(!p||p[0]!=="/"){p=_.buildPath(this.sPath,p);if(this.oModel.bAutoExpandSelect){p=this.oModel.getMetaModel().getReducedPath(p,this.oBinding.getBaseForPathReduction());}}return this.oBinding.fetchValue(p,l,b);};C.prototype.getBinding=function(){return this.oBinding;};C.prototype.getCanonicalPath=_.createGetMethod("fetchCanonicalPath",true);C.prototype.getGroupId=function(){return this.oBinding.getGroupId();};C.prototype.getIndex=function(){if(this.oBinding.bCreatedAtEnd){return this.iIndex<0?this.oBinding.iMaxLength-this.iIndex-1:this.iIndex;}return this.getModelIndex();};C.prototype.getModelIndex=function(){if(this.iIndex!==undefined&&this.oBinding.iCreatedContexts){return this.iIndex+this.oBinding.iCreatedContexts;}return this.iIndex;};C.prototype.getObject=function(p){return _.publicClone(this.getValue(p));};C.prototype.getProperty=function(p,e){var E,s;this.oBinding.checkSuspended();s=f(this,p,e,true);if(s.isRejected()){s.caught();E=s.getResult();if(E.isNotPrimitive){throw E;}else if(!E.$cached){L.warning(E.message,p,c);}}return s.isFulfilled()?s.getResult():undefined;};C.prototype.getReturnValueContextId=function(){if(this.iReturnValueContextId){return this.iReturnValueContextId;}if(this.oBinding.bRelative&&this.oBinding.oContext&&this.oBinding.oContext.getReturnValueContextId){return this.oBinding.oContext.getReturnValueContextId();}};C.prototype.getQueryOptionsForPath=function(p){return this.oBinding.getQueryOptionsForPath(p);};C.prototype.getUpdateGroupId=function(){return this.oBinding.getUpdateGroupId();};C.prototype.getValue=function(p){var s,t=this;this.oBinding.checkSuspended();s=this.fetchValue(p,null,true).catch(function(e){if(!e.$cached){t.oModel.reportError("Unexpected error",c,e);}});if(s.isFulfilled()){return s.getResult();}};C.prototype.hasPendingChanges=function(){return this.isTransient()||this.oModel.getDependentBindings(this).some(function(d){return d.hasPendingChanges();})||this.oModel.withUnresolvedBindings("hasPendingChangesInCaches",this.sPath.slice(1));};C.prototype.isExpanded=function(){return this.getProperty("@$ui5.node.isExpanded");};C.prototype.isKeepAlive=function(){return this.bKeepAlive;};C.prototype.isTransient=function(){return this.oSyncCreatePromise&&this.oSyncCreatePromise.isPending();};C.prototype.patch=function(d){return this.withCache(function(o,p){o.patch(p,d);},"");};C.prototype.refresh=function(g,a){this.oModel.checkGroupId(g);this.oBinding.checkSuspended();if(this.hasPendingChanges()){throw new Error("Cannot refresh entity due to pending changes: "+this);}if(this.oBinding.refreshSingle){this.oBinding.refreshSingle(this,this.oBinding.lockGroup(g,true),a);}else{if(arguments.length>1){throw new Error("Unsupported parameter bAllowRemoval: "+a);}if(!this.oBinding.refreshReturnValueContext(this,g)){this.oBinding.refresh(g);}}this.oModel.withUnresolvedBindings("removeCachesAndMessages",this.sPath.slice(1));};C.prototype.requestCanonicalPath=_.createRequestMethod("fetchCanonicalPath");C.prototype.requestObject=function(p){this.oBinding.checkSuspended();return Promise.resolve(this.fetchValue(p)).then(_.publicClone);};C.prototype.requestProperty=function(p,e){var P=Array.isArray(p)?p:[p],t=this;this.oBinding.checkSuspended();return Promise.all(P.map(function(s){return t.oBinding.fetchIfChildCanUseCache(t,s,S.resolve({})).then(function(R){if(R){return f(t,R,e);}L.error("Not a valid property path: "+s,undefined,c);});})).then(function(V){return Array.isArray(p)?V:V[0];});};C.prototype.requestSideEffects=function(p,g){var M=this.oModel.getMetaModel(),P=[],a=[],R,s,t=this;function i(b){if(!b){return false;}if(b==="*"){return true;}if(b.endsWith("/*")){b=b.slice(0,-2);}return!b.includes("*");}this.oBinding.checkSuspended();this.oModel.checkGroupId(g);if(this.isTransient()){throw new Error("Unsupported context: "+this);}if(!p||!p.length){throw new Error("Missing edm:(Navigation)PropertyPath expressions");}if(!this.oBinding.isResolved()){throw new Error("Cannot request side effects of unresolved binding's context: "+this);}p.map(function(o){if(o&&typeof o==="object"){if(i(o.$PropertyPath)){return o.$PropertyPath;}if(typeof o.$NavigationPropertyPath==="string"&&!o.$NavigationPropertyPath.includes("*")){return o.$NavigationPropertyPath;}}throw new Error("Not an edm:(Navigation)PropertyPath expression: "+JSON.stringify(o));}).forEach(function(b){if(b[0]==="/"){a.push(b);}else{P.push(b);}});R=this.oBinding.getRootBinding();s=this.oModel.resolve(R.getPath(),R.getContext());P=P.reduce(function(b,d){return b.concat(M.getAllPathReductions(_.buildPath(t.getPath(),d),s));},[]);g=g||this.getUpdateGroupId();return Promise.resolve(S.resolve(this.oModel.isAutoGroup(g)&&this.oModel.oRequestor.waitForRunningChangeRequests(g).then(function(){t.oModel.oRequestor.relocateAll("$parked."+g,g);})).then(function(){return S.all([t.oModel.requestSideEffects(g,a),t.requestSideEffectsInternal(P,g)]);})).then(function(){});};C.prototype.requestSideEffectsInternal=function(a,g){var t=this,b,o=t,d,O=[],p,P=[],s,e=[];for(;;){b=o.getBinding();s=b.getPath();p=b.getContext();if(b.oCache&&(!d||b.oCache.hasChangeListeners())){d=o;}if(d&&s){break;}if(!b.getBoundContext){throw new Error("Not a context binding: "+b);}o=p;}b=d.getBinding();a.forEach(function(A){var R=_.getRelativePath(A,d.getPath());if(R===undefined){P.push(A);}else{O.push(R);}});if(P.length){e.push(b.getContext().requestSideEffectsInternal(P,g));}if(O.length&&b.oCache!==undefined){e.push(b.requestSideEffects(g,O,d));}return S.all(e);};C.prototype.setKeepAlive=function(k){if(this.isTransient()){throw new Error("Unsupported transient context "+this);}if(!_.getPrivateAnnotation(this.getValue(),"predicate")){throw new Error("No key predicate known at "+this);}this.oBinding.checkKeepAlive(this);this.bKeepAlive=k;};C.prototype.setProperty=function(p,V,g){var G=null;this.oBinding.checkSuspended();if(typeof V==="function"||(V&&typeof V==="object")){throw new Error("Not a primitive value");}if(g!==null){this.oModel.checkGroupId(g);G=this.oBinding.lockGroup(g,true,true);}return Promise.resolve(this.doSetProperty(p,V,G,true)).catch(function(e){if(G){G.unlock(true);}throw e;});};C.prototype.toString=function(){var i="";if(this.iIndex!==undefined){i="["+this.iIndex+(this.isTransient()?"|transient":"")+"]";}return this.sPath+i;};C.prototype.withCache=function(p,P,s,w){if(this.iIndex===v){return S.resolve();}return this.oBinding.withCache(p,P[0]==="/"?P:_.buildPath(this.sPath,P),s,w);};m={create:function(M,b,p,i,o){return new C(M,b,p,i,o);},createReturnValueContext:function(M,b,p){r+=1;return new C(M,b,p,undefined,undefined,r);}};Object.defineProperty(m,"VIRTUAL",{value:v});return m;},false);
