/*!
 * OpenUI5
 * (c) Copyright 2009-2020 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(['sap/ui/mdc/condition/ConditionModelPropertyBinding','sap/ui/model/json/JSONModel','sap/ui/model/Filter','sap/ui/model/ChangeReason','sap/ui/mdc/condition/FilterOperatorUtil','sap/base/util/merge','sap/base/util/deepEqual','sap/base/Log','sap/ui/mdc/condition/Condition',"sap/ui/mdc/condition/FilterConverter"],function(C,J,F,b,c,m,d,L,e,f){"use strict";var g=J.extend("sap.ui.mdc.condition.ConditionModel",{constructor:function(){J.apply(this,arguments);this.setSizeLimit(1000);if(!this.getProperty("/conditions")){this.setProperty("/conditions",{});}if(!this.getProperty("/fieldPath")){this.setProperty("/fieldPath",{});}}});g.prototype.bindProperty=function(p,o,P){var E=p;if(p.startsWith("/conditions/")){var s=p.slice(12);this._getFieldPathProperty(s);s=h.call(this,s);E="/conditions/"+s;}var B=new C(this,E,o,P);B._sOriginapPath=p;return B;};g.prototype.getContext=function(p){if(p.startsWith("/conditions/")){var s=p.slice(12);s=h.call(this,s);p="/conditions/"+s;}return J.prototype.getContext.apply(this,[p]);};g.prototype.bindList=function(p,o,s,a,P){var B=J.prototype.bindList.apply(this,arguments);B.enableExtendedChangeDetection(true);return B;};g.prototype.destroy=function(){J.prototype.destroy.apply(this,arguments);};g.prototype.clone=function(s){var o=new g();o._sName=this._sName+"_clone";var a={};if(typeof s==="string"){var j=this.getConditions(s);for(var i=0;i<j.length;i++){var k=j[i];var M=h.call(this,s);if(!a[M]){a[M]=[];}a[M].push(m({},k));}}else{a=m({},this.getAllConditions());}o.setConditions(a);return o;};g.prototype.merge=function(s,S,a){this.removeAllConditions(s);var o=m({},S.getAllConditions());for(var M in o){if(!(typeof a==="string")||M===a){var j=e._removeEmptyConditions(o[M]);for(var i=0;i<j.length;i++){var k=j[i];this.addCondition(M,k);}}}this.checkUpdate(true,true);};g.prototype.getConditions=function(s){return _.call(this,s);};function _(s,a){var o=this.getProperty("/conditions");var i;if(typeof s=="string"){s=h.call(this,s);if(!o[s]&&a){o[s]=[];}i=o[s]||[];}else{throw new Error("ConditionModel","getConditions without FieldPath is not supported!");}return i;}g.prototype.getAllConditions=function(v){var o=this.getProperty("/conditions");var r={};for(var M in o){var a=this.getProperty("/fieldPath");var i=a[M];var s=i?i.fieldPath:M;if(v&&[].concat(v).indexOf(s)===-1){continue;}r[s]=m([],o[M]);}return r;};g.prototype.indexOf=function(s,o){if(typeof s!=="string"){throw new Error("sFieldPath must be a string "+this);}var a=this.getConditions(s);var i=c.indexOfCondition(o,a);return i;};g.prototype.exist=function(o,s){if(typeof s==="string"){return this.indexOf(s,o)>=0;}else{throw new Error("sFieldPath must be provided "+this);}};g.prototype.setConditions=function(o){var i=0;var a;this.setProperty("/conditions",{},undefined,true);if(Array.isArray(o)){throw new Error("setConditions with an Array of condition is not supported! "+this);}else{this._bNoSingleEvent=true;for(var M in o){this._getFieldPathProperty(M);for(i=0;i<o[M].length;i++){a=o[M][i];this.insertCondition(M,-1,a,true);}this.firePropertyChange({reason:b.Add,path:"/conditions/"+M,context:undefined,value:o[M]});}this.checkUpdate(true,true);this._bNoSingleEvent=false;}return this;};g.prototype.addCondition=function(s,o,a){if(typeof s!=="string"){throw new Error("sFieldPath must be a string "+this);}return this.insertCondition(s,-1,o,a);};g.prototype.insertCondition=function(s,I,o,a){if(typeof s!=="string"){throw new Error("sFieldPath must be a string "+this);}if(!o){return this;}var j;c.checkConditionsEmpty(o);c.updateConditionsValues(o);this._getFieldPathProperty(s);if(!a){var i=this.indexOf(s,o);if(i>=0){return this;}}j=_.call(this,s,true);if(I==-1){j.push(o);}else{j.splice(I,0,o);}if(!this._bNoSingleEvent){this.checkUpdate(true,true);this.firePropertyChange({reason:b.Add,path:"/conditions/"+s,context:undefined,value:j});}return this;};g.prototype.createItemCondition=function(s,k,D){L.error("ConditionModel","createItemCondition is deprecated");return e.createItemCondition(k,D);};g.prototype.createCondition=function(s,o,v){L.error("ConditionModel","createCondition is deprecated");return e.createCondition(o,v);};g.prototype.removeCondition=function(s,v){if(typeof s!=="string"){throw new Error("sFieldPath must be a string "+this);}var i=-1;if(typeof v==="object"){i=this.indexOf(s,v);}else if(typeof v==="number"){i=v;}if(i>=0){var a=this.getConditions(s);if(a.length>i){a.splice(i,1);this.checkUpdate(true,true);this.firePropertyChange({reason:b.Remove,path:"/conditions/"+s,context:undefined,value:a});return true;}}return false;};g.prototype.removeAllConditions=function(s){var o=this.getProperty("/conditions");if(typeof s==="string"){var E=h.call(this,s);if(o[E]&&o[E].length>0){o[E]=[];this.firePropertyChange({reason:b.Remove,path:"/conditions/"+s,context:undefined,value:o[s]});}}else{for(var M in o){if(o[M]&&o[M].length>0){o[M]=[];var a=this.getProperty("/fieldPath");var O=a[M].fieldPath;this.firePropertyChange({reason:b.Remove,path:"/conditions/"+O,context:undefined,value:o[M]});}}}this.checkUpdate(true,true);return this;};g.prototype._getFieldPathProperty=function(s){var E=h.call(this,s);var o=this.getProperty("/fieldPath");if(!o[E]){o[E]={fieldPath:s};}var a=this.getProperty("/conditions");if(!a[E]){a[E]=[];}return o[E];};g.prototype.getFilters=function(s){L.error("ConditionModel","usage or deprecated getFilters() function! Please use the FilterConverter.createFilters() function instead.");return f.createFilters(this.getAllConditions(),{});};g.prototype.serialize=function(){var o=m({},this.getAllConditions());for(var M in o){var a=o[M];a.forEach(function(i){delete i.isEmpty;},this);if(a.length===0){delete o[M];}}return'{"conditions":'+JSON.stringify(o)+"}";};g.prototype.parse=function(o){var i=function(k,v){var a;if(!isNaN(parseInt(k))&&(typeof v==='string')){a=/^(\d{4})-(\d{2})-(\d{2})T(\d{2}):(\d{2}):(\d{2}).(\d{3})Z$/.exec(v);if(a){return new Date(v);}}return v;};this.setConditions(JSON.parse(o,i).conditions);};function h(s){if(s){var p=s.split("/");if(p.length>1){s="";for(var i=0;i<p.length;i++){var P=p[i];if(i>0){if(!isNaN(P)||!isNaN(p[i-1])){s=s+"/";}else{s=s+"\\";}}s=s+P;}}}return s;}return g;});
