//@ui5-bundle sap/ui/integration/designtime/library-preload.designtime.js
/*!
 * OpenUI5
 * (c) Copyright 2009-2020 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine('sap/ui/integration/designtime/baseEditor/BaseEditor',["sap/ui/integration/designtime/baseEditor/util/createPromise","sap/ui/integration/designtime/baseEditor/propertyEditor/PropertyEditorFactory","sap/ui/integration/designtime/baseEditor/validator/ValidatorRegistry","sap/ui/integration/designtime/baseEditor/PropertyEditors","sap/ui/integration/designtime/baseEditor/util/binding/resolveBinding","sap/ui/integration/designtime/baseEditor/util/binding/ObjectBinding","sap/ui/integration/designtime/baseEditor/util/hasTag","sap/ui/integration/designtime/baseEditor/util/cleanupDesigntimeMetadata","sap/ui/core/Control","sap/ui/model/resource/ResourceModel","sap/base/util/ObjectPath","sap/base/util/each","sap/base/util/deepClone","sap/base/util/deepEqual","sap/base/util/values","sap/base/util/includes","sap/base/util/isPlainObject","sap/base/util/isEmptyObject","sap/base/util/restricted/_intersection","sap/base/util/restricted/_mergeWith","sap/base/util/restricted/_merge","sap/base/util/restricted/_omit","sap/base/util/restricted/_union","sap/base/util/restricted/_isNil","sap/ui/model/json/JSONModel","sap/base/i18n/ResourceBundle","sap/base/Log","sap/ui/integration/designtime/baseEditor/util/unset"],function(c,P,V,a,r,O,h,b,C,R,d,f,g,i,v,j,k,l,_,m,n,o,p,q,J,s,L,u){"use strict";var t="customProperty--";var S=Promise.resolve();
var B=C.extend("sap.ui.integration.designtime.baseEditor.BaseEditor",{
metadata:{properties:{"json":{type:"object"},"config":{type:"object",defaultValue:{"i18n":["sap/ui/integration/designtime/baseEditor/i18n/i18n.properties"]}},"designtimeMetadata":{type:"object"},"layout":{type:"string",defaultValue:"list"}},defaultAggregation:"content",aggregations:{content:{type:"sap.ui.core.Control",multiple:true}},events:{jsonChange:{parameters:{json:{type:"object"}}},designtimeMetadataChange:{parameters:{designtimeMetadata:{type:"object"}}},propertyEditorsReady:{parameters:{propertyEditors:{type:"array"}}}}},
constructor:function(){this._mObservableConfig={};this._mPropertyEditors={};this._aCancelHandlers=[];this._oDataModel=this._createModel();this._oDesigntimeMetadataModel=this._createModel();this._bInitFinished=false;this._bValidatorsReady=false;this._setReady(false);C.prototype.constructor.apply(this,arguments);this._oDataModel.setData(this._prepareData(this.getJson()));this.attachJsonChange(function(e){var z=e.getParameter("json");this._oDataModel.setData(this._prepareData(z));this._checkReady();},this);},
renderer:function(e,z){var A=z.getContent();e.openStart("div",z);e.openEnd();if(A.length){A.forEach(function(D){e.renderControl(D);});}else{z.getPropertyEditorsSync().forEach(function(D){e.renderControl(D);});}e.close("div");}
});
B.prototype.init=function(){};
B.prototype.exit=function(){this._reset();this._oDataModel.destroy();this._oDesigntimeMetadataModel.destroy();};
B.prototype._prepareData=function(e){var z=g(e);f(this._mObservableConfig,function(A,D){var E=D.path;if(E[0]==="/"){E=E.substr(1);}if(typeof d.get(E.split("/"),z)==="undefined"&&typeof D.defaultValue!=="undefined"){d.set(E.split("/"),g(D.defaultValue),z);}});return z;};
B.prototype.setJson=function(z){var A;if(typeof z==="string"){try{A=JSON.parse(z);}catch(e){L.error("sap.ui.integration.designtime.baseEditor.BaseEditor: invalid JSON string is specified");}}else if(k(z)){A=n({},z);}else{L.error("sap.ui.integration.designtime.baseEditor.BaseEditor: unsupported data type specified in setJson()");}if(A&&JSON.stringify(this.getProperty("json"))!==JSON.stringify(A)){this.setProperty("json",A);this.fireJsonChange({json:A});}};
B.prototype.setConfig=function(e,I){this._bIsDefaultConfig=I;e=e||{};S=S.then(function(){P.deregisterAllTypes();return P.registerTypes(e.propertyEditors||{});}).then(function(z){this._initValidators(e.validators||{});var T={propertyEditors:{},properties:{}};if(!e.i18n){T.i18n=this.getMetadata().getProperty("config").getDefaultValue().i18n;}var N=w(T,e);if(this._oSpecificConfig){N=I?this._oSpecificConfig:y(N,this._oSpecificConfig,z);}this.setProperty("config",N,false);this._initialize();}.bind(this));return S;};
B.prototype.addConfig=function(e,I){return this.setConfig(w(this.getConfig(),e),I);};
function w(T,e){var z=n({},T,e);z.i18n=[].concat(T.i18n||[],e.i18n||[]);return z;}
B.prototype._addSpecificConfig=function(e){return S.then(function(){this._oSpecificConfig=e;x(this.getConfig(),e);return this.setConfig(this.getConfig(),this._bIsDefaultConfig);}.bind(this));};
function x(e,z){f(z.propertyEditors,function(E,A){if(!e.propertyEditors[E]){e.propertyEditors[E]=A;}});}
function y(e,z,A){e.i18n=p(e.i18n,z.i18n);var N=Object.assign({},e,o(z,["properties","i18n","propertyEditors"]),o(e,["properties","i18n","propertyEditors"]));N.properties={};f(e.properties,function(D,E){var F=e.propertyEditors[E.type]&&e.propertyEditors[E.type].split("/").join(".");var G=F&&A[F].configMetadata;if(G&&z.properties[D]){f(E,function(K,T){var H;var M=G[K]&&G[K].mergeStrategy;if(M){if(M==="mostRestrictiveWins"){var I=G[K].mostRestrictiveValue||false;if(T===I){H=I;}else{H=z.properties[D][K];}}else if(M==="intersection"){H=_(T,z.properties[D][K]);}}else{H=T;}N.properties[D]=N.properties[D]||{};N.properties[D][K]=H;});}});return N;}
B.prototype.setDesigntimeMetadata=function(D,I){var N=g(D);if(!i(N,this.getDesigntimeMetadata())){this.setProperty("designtimeMetadata",N);this._oDesigntimeMetadataModel.setData(N);if(!I){this.fireDesigntimeMetadataChange({designtimeMetadata:this._formatExportedDesigntimeMetadata(N)});}}};
B.prototype._formatExportedDesigntimeMetadata=function(M){var F={};var e=function(z,A){Object.keys(z).forEach(function(K){var D=z[K];if(K==="__value"){F[A.join("/")]=D;}else if(k(D)){e(D,[].concat(A,K));}});};e(M||{},[]);return F;};
B.prototype._initValidators=function(e){V.deregisterAllValidators();V.registerValidators(e);V.ready().then(function(){this._bValidatorsReady=true;this._checkReady();}.bind(this));};
B.prototype._reset=function(){this._bInitFinished=false;this._setReady(false);this._aCancelHandlers.forEach(function(e){e();});if(this._oI18nModel){this._oI18nModel.destroy();delete this._oI18nModel;}if(this._oConfigObserver){this._oConfigObserver.destroy();}f(this._mPropertyEditors,function(e,z){z.forEach(function(A){this.deregisterPropertyEditor(A,e);},this);}.bind(this));if(this._oRootWrapper){this._oRootWrapper.destroy();}};
B.prototype._initialize=function(){this._reset();var e=this.getConfig();if(typeof this.getProperty("json")==="undefined"){this.attachEventOnce("jsonChange",this._initialize);return;}if(e){this._oConfigObserver=new O();this._loadI18nBundles(e.i18n).then(function(z){this._oI18nModel=this._createI18nModel(z);this.setModel(this._oI18nModel,"i18n");this._oConfigObserver.addToIgnore(["template","itemLabel"]);this._oConfigObserver.setModel(this._oDataModel);this._oConfigObserver.setModel(this._oDesigntimeMetadataModel,"designtimeMetadata");this._oConfigObserver.setModel(this._oI18nModel,"i18n");var A=this._getContextPath();if(A){this._oConfigObserver.setModel(this._oDataModel,"context");this._oConfigObserver.setBindingContext(this._oDataModel.getContext(A),"context");}var D=r(e.properties,{"i18n":this._oI18nModel});this._mObservableConfig=Object.assign(this._mObservableConfig,this._prepareConfig(D));this._oConfigObserver.setObject(this._mObservableConfig);this._oConfigObserver.attachChange(this._onConfigChange,this);var E=this.getContent();if(E.length===0||E.length===1&&E[0]===this._oRootWrapper){this.removeAllContent();this._createEditors(this._oConfigObserver.getObject());}this._bInitFinished=true;this._checkReady();}.bind(this));}};
B.prototype._onConfigChange=function(e){var z=e.getParameter("changes").reduce(function(D,E){var F=g(E);F.path=F.path.split("/");F.propertyKey=F.path.shift();if(!D[F.propertyKey]){D[F.propertyKey]=[];}D[F.propertyKey].push(F);return D;},{});var A=Object.keys(z).reduce(function(D,E){var F=(this.getPropertyEditorsByNameSync(E)||[]).map(function(G){return{editor:G,propertyName:E};});D=D.concat(F);return D;}.bind(this),[]);var I=A.filter(function(D){return!this._oRootWrapper||!j(this._oRootWrapper._aEditorWrappers,D.editor);}.bind(this));I.forEach(function(D){var E=D.propertyName;var F=e.getSource().getObject();var G=o(g(F[E]),"value");var H=false;var K=z[E]||[];K.forEach(function(N){if(N.path[0]==="value"){D.editor.setValue(N.value);}else{d.set(N.path,N.value,G);H=true;}});if(H){D.editor.setConfig(G);}});if(I.length<A.length){var M=g(this._oRootWrapper.getConfig()).map(function(D){var E=z[D.__propertyName]||[];E.forEach(function(F){d.set(F.path,F.value,D);});return D;});this._oRootWrapper.setConfig(M);}};
B.prototype._createModel=function(){var M=new J();M.setDefaultBindingMode("OneWay");return M;};
B.prototype._loadI18nBundles=function(e){return this._createPromise(function(z,A){Promise.all(e.map(function(I){return new Promise(function(z,D){s.create({url:sap.ui.require.toUrl(I),async:true}).then(z,D);});})).then(z,A);});};
B.prototype._createI18nModel=function(e){var z=e.slice();var I=new R({bundle:z.shift()});I.setDefaultBindingMode("OneWay");z.forEach(function(A){I.enhance(A);});return I;};
B.prototype._prepareConfig=function(e){var z={};f(e,function(K,A){z[K]=Object.assign({},this._preparePropertyConfig(A),{__propertyName:K});}.bind(this));return z;};
B.prototype._preparePropertyConfig=function(e){var z=this._getContextPath();if(z&&!z.endsWith("/")){z=z+"/";}var A=e.path;if(!A.startsWith("/")&&z){A=z+A;}return Object.assign({},e,{path:A,value:"{"+A+"}",designtime:"{designtimeMetadata>"+A+"}"});};
B.prototype._createEditors=function(e){var z=d.get(["layout",this.getLayout()],this.getConfig());if(k(z)||Array.isArray(z)){z=r(z,{"i18n":this._oI18nModel});}this._oRootWrapper=new a({config:v(e),layout:this.getLayout(),layoutConfig:z});this.addContent(this._oRootWrapper);return(Promise.all(v(this._mPropertyEditors).reduce(function(A,D){return A.concat(D);},[]).map(function(A){return A.ready();})).then(this._checkReady.bind(this)));};
B.prototype._getRegistrationKey=function(e,K){if(typeof K!=="string"){if(e.isA("sap.ui.integration.designtime.baseEditor.PropertyEditor")&&!e.getConfig()&&!e.getBindingInfo("config")&&e.getPropertyName()){K=e.getPropertyName();}else{K=t+e.getId();}}return K;};
B.prototype._addCustomProperty=function(K,e){var z=Object.assign({},this._mObservableConfig);z[K]=this._preparePropertyConfig(e);this._mObservableConfig=z;this._oConfigObserver.setObject(z);};
B.prototype._removeCustomProperty=function(K){var e=o(this._mObservableConfig,K);this._mObservableConfig=e;this._oConfigObserver.setObject(e);};
B.prototype.registerPropertyEditor=function(e,K){K=this._getRegistrationKey(e,K);var z=Array.isArray(this._mPropertyEditors[K])?this._mPropertyEditors[K]:[];this._mPropertyEditors[K]=z.concat(e);if(K.startsWith(t)){this._addCustomProperty(K,e.getConfig());}var A=d.get(K,this._oConfigObserver.getObject()).value;e.setValue(A);e.attachValueChange(this._onValueChange,this);e.attachDesigntimeMetadataChange(this._onDesigntimeMetadataChange,this);e.attachReady(this._checkReady,this);};
B.prototype.deregisterPropertyEditor=function(e,K){K=this._getRegistrationKey(e,K);var z=this._mPropertyEditors[K];if(K.startsWith(t)){this._removeCustomProperty(K);}e.detachValueChange(this._onValueChange,this);e.detachDesigntimeMetadataChange(this._onDesigntimeMetadataChange,this);if(Array.isArray(z)){this._mPropertyEditors[K]=z.filter(function(I){return e!==I;});if(this._mPropertyEditors[K].length===0){delete this._mPropertyEditors[K];}}};
B.prototype._setReady=function(e){var z=this._bIsReady;this._bIsReady=e;if(z!==true&&e===true){this.firePropertyEditorsReady({propertyEditors:this.getPropertyEditorsSync()});}};
B.prototype._checkReady=function(){var e=this.getContent().filter(function(E){return(E.isA("sap.ui.integration.designtime.baseEditor.PropertyEditors")||E.isA("sap.ui.integration.designtime.baseEditor.propertyEditor.BasePropertyEditor"));});e.forEach(function(E){if(!sap.ui.base.EventProvider.hasListener(E,"ready",this._checkReady,this)){E.attachReady(this._checkReady,this);}},this);var A=[].concat(e,this.getPropertyEditorsSync());var I=(this._bInitFinished&&this._bValidatorsReady&&A.every(function(E){return E.isReady();}));this._setReady(I);};
B.prototype.isReady=function(){return this._bIsReady;};
B.prototype.ready=function(){return new Promise(function(e){if(this.isReady()){e();}else{this.attachEventOnce("propertyEditorsReady",e);}}.bind(this));};
B.prototype._createPromise=function(e){var z=c(e);this._aCancelHandlers.push(z.cancel);var A=function(D,E){this._aCancelHandlers=this._aCancelHandlers.filter(function(e){return e!==D;});return E;}.bind(this,z.cancel);return z.promise.then(A,A);};
B.prototype.getPropertyConfigByName=function(e){return o(d.get(e,this._oConfigObserver.getObject()),"value");};
B.prototype.getPropertyEditorsByName=function(e){return new Promise(function(z){if(!this._mPropertyEditors||Object.keys(this._mPropertyEditors).length===0){this.attachEventOnce("propertyEditorsReady",z);}else{z();}}.bind(this)).then(function(){return this.getPropertyEditorsByNameSync(e);}.bind(this));};
B.prototype.getPropertyEditorsByNameSync=function(e){var z=this._mPropertyEditors[e];return Array.isArray(z)&&z.slice()||null;};
B.prototype.getPropertyEditorsByTag=function(T){return new Promise(function(e){if(!this._mPropertyEditors||Object.keys(this._mPropertyEditors).length===0){this.attachEventOnce("propertyEditorsReady",e);}else{e();}}.bind(this)).then(function(){return this.getPropertyEditorsByTagSync(T);}.bind(this));};
B.prototype.getConfigsByTag=function(T){var e=this.getConfig().properties;return Object.keys(e).filter(function(z){return h(e[z],T);}).map(function(z){return e[z];});};
B.prototype.getPropertyEditorsByTagSync=function(T){return this.getPropertyEditorsSync().filter(function(e){return h(e.getConfig(),T);});};
B.prototype.getPropertyEditorsSync=function(){return v(this._mPropertyEditors).reduce(function(e,z){return e.concat(z);},[]).sort(function(e,z){return parseInt(e.getId().match(/\d+$/))-parseInt(z.getId().match(/\d+$/));});};
B.prototype.getJson=function(){return n({},this.getProperty("json"));};
B.prototype.getDesigntimeMetadata=function(){return n({},this.getProperty("designtimeMetadata"));};
B.prototype._getContextPath=function(){var e=this.getConfig();var z=e&&e.context||null;if(z&&z[0]!=="/"){z="/"+z;}return z;};
B.prototype._onValueChange=function(e){var z=e.getSource();var A=e.getParameter("path");var D=this.getJson()||{};var E=e.getParameter("value");if(A[0]==="/"){A=A.substr(1);}else{throw new Error("BaseEditor._onValueChange: unknown relative path - '"+A+"'");}var F=A.split("/");d.set(F,E,D);if(typeof E==="undefined"||i(E,z.getRuntimeConfig().defaultValue)||Array.isArray(E)&&E.length===0||k(E)&&l(E)){u(D,F);}this.setJson(D);};
B.prototype._onDesigntimeMetadataChange=function(e){var z=e.getParameter("path");var D=this.getDesigntimeMetadata()||{};var A=e.getParameter("value");if(z[0]==="/"){z=z.substr(1);}else{throw new Error("BaseEditor._onDesigntimeMetadataChange: unknown relative path - '"+z+"'");}var E=z.split("/");d.set(E,A,D);b(D);this.setDesigntimeMetadata(D);};
return B;});
sap.ui.predefine('sap/ui/integration/designtime/baseEditor/PropertyEditor',["sap/ui/core/Control","sap/ui/integration/designtime/baseEditor/util/findClosestInstance","sap/ui/integration/designtime/baseEditor/util/createPromise","sap/ui/integration/designtime/baseEditor/util/escapeParameter","sap/ui/integration/designtime/baseEditor/propertyEditor/PropertyEditorFactory","sap/base/util/restricted/_merge","sap/base/util/restricted/_omit","sap/base/util/deepEqual","sap/base/util/deepClone"],function(C,f,c,e,P,_,a,d,b){"use strict";var g="config";var h="propertyName";
var i=C.extend("sap.ui.integration.designtime.baseEditor.PropertyEditor",{
metadata:{interfaces:["sap.ui.core.IFormContent"],properties:{propertyName:{type:"string"},renderLabel:{type:"boolean"},value:{type:"any"},config:{type:"object"}},aggregations:{propertyEditor:{type:"sap.ui.integration.designtime.baseEditor.propertyEditor.BasePropertyEditor",multiple:false,visibility:"hidden"}},associations:{editor:{type:"sap.ui.integration.designtime.baseEditor.BaseEditor",multiple:false}},events:{editorChange:{parameters:{previousEditor:{type:"sap.ui.integration.designtime.baseEditor.BaseEditor"},editor:{type:"sap.ui.integration.designtime.baseEditor.BaseEditor"}}},propertyEditorChange:{parameters:{previousPropertyEditor:{type:"sap.ui.integration.designtime.baseEditor.propertyEditor.BasePropertyEditor"},propertyEditor:{type:"sap.ui.integration.designtime.baseEditor.propertyEditor.BasePropertyEditor"}}},configChange:{parameters:{previousConfig:{type:"object"},config:{type:"object"}}},propertyNameChange:{parameters:{previousPropertyName:{type:"string"},propertyName:{type:"string"}}},ready:{},beforeValueChange:{parameters:{path:{type:"string"},value:{type:"any"},nextValue:{type:"any"}}},valueChange:{parameters:{path:{type:"string"},value:{type:"any"},previousValue:{type:"any"}}},designtimeMetadataChange:{parameters:{path:{type:"string"},value:{type:"any"},previousValue:{type:"any"}}},init:{}}},
_bEditorAutoDetect:false,
_sCreatedBy:null,
constructor:function(){C.prototype.constructor.apply(this,e(arguments,function(v,p){return(p==="config"&&P.hasType(v.type));}));if(!this.getEditor()){this._bEditorAutoDetect=true;}this._propagationListener=this._propagationListener.bind(this);this.attachEditorChange(function(E){if(this._sCreatedBy){this._removePropertyEditor(E.getParameter("previousEditor"));}this._initPropertyEditor();});this.attachConfigChange(function(E){var p=E.getParameter("previousConfig");var o=E.getParameter("config");var n=this.getAggregation("propertyEditor");if(this._fnCancelInit||!n||!p||!o||p.type!==o.type||p.path!==o.path){this._removePropertyEditor(this.getEditor());this._initPropertyEditor();}else{n.setConfig(o);}});this.attachPropertyNameChange(function(){if(this._sCreatedBy===h){this._removePropertyEditor(this.getEditor());}if(this._sCreatedBy!==g){this._initPropertyEditor();}});this._initPropertyEditor();},
renderer:function(r,o){r.openStart("div",o);r.addStyle("display","inline-block");r.addStyle("width","100%");r.openEnd();r.renderControl(o.getAggregation("propertyEditor"));r.close("div");}
});
i.prototype.init=function(){Promise.resolve().then(function(){this.fireInit();}.bind(this));};
i.prototype.getEditor=function(){return sap.ui.getCore().byId(this.getAssociation("editor"));};
i.prototype.setConfig=function(m){var p=this.getConfig();var n=m&&_({},{designtime:undefined},m);if(!d(p,n)){this.setProperty("config",n);this.fireConfigChange({previousConfig:p,config:n});}};
i.prototype.setPropertyName=function(p){var s=this.getPropertyName();if(s!==p){this.setProperty("propertyName",p);this.firePropertyNameChange({previousPropertyName:s,propertyName:p});}};
i.prototype.setEditor=function(E){var p=this.getEditor();var o=typeof E==="string"?sap.ui.getCore().byId(E):E;if(p!==o){this.setAssociation("editor",E);var o=this.getEditor();this.fireEditorChange({previousEditor:p,editor:o});}};
i.prototype.destroy=function(){this._removePropertyEditor(this.getEditor());C.prototype.destroy.apply(this,arguments);};
i.prototype._cleanupCancelledInit=function(p){p.destroy();};
i.prototype._removePropertyEditor=function(E){var p=this.getAggregation("propertyEditor");if(this._fnCancelInit){this._fnCancelInit().then(this._cleanupCancelledInit);delete this._fnCancelInit;}if(p){this.setAggregation("propertyEditor",null);p.detachReady(this._onPropertyEditorReady,this);p.destroy();this._sCreatedBy=null;this.firePropertyEditorChange({propertyEditor:null});}if(E&&this._mConfig&&this._isAbsolutePath(this._mConfig.path)){E.deregisterPropertyEditor(this,this._mConfig.__propertyName);}};
i.prototype.isReady=function(){var n=this.getAggregation("propertyEditor");return n&&n.isReady()||false;};
i.prototype.ready=function(){return new Promise(function(r){var j=function(n){n.ready().then(r);};var n=this.getAggregation("propertyEditor");if(n){j(n);}else{var w=function(E){var n=E.getParameter("propertyEditor");if(n){this.detachPropertyEditorChange(w,this);j(n);}};this.attachPropertyEditorChange(w,this);}}.bind(this));};
i.prototype._onPropertyEditorReady=function(){this.fireReady();};
i.prototype._initPropertyEditor=function(){if(!this.getEditor()){return;}if(this.getConfig()||(!this.getBindingInfo("config")&&this.getPropertyName()&&this.getEditor())){if(this._fnCancelInit){this._fnCancelInit().then(this._cleanupCancelledInit);delete this._fnCancelInit;}this._mConfig=this.getConfig()||this.getEditor().getPropertyConfigByName(this.getPropertyName());var s=this.getConfig()?g:h;var p=c(function(r,R){P.create(this._mConfig.type).then(r).catch(R);}.bind(this));this._fnCancelInit=p.cancel;if(this._isAbsolutePath(this._mConfig.path)){this.getEditor().registerPropertyEditor(this,this._mConfig.__propertyName);}p.promise.then(function(o){o.setModel(this.getEditor().getModel("i18n"),"i18n");o.setConfig(a(_({},this._mConfig),"__propertyName"));o.attachBeforeValueChange(function(E){this.fireBeforeValueChange(a(E.getParameters(),"id"));},this);o.attachValueChange(function(E){this.setValue(E.getParameter("value"));this.fireValueChange(a(E.getParameters(),"id"));},this);o.attachDesigntimeMetadataChange(function(E){this.fireDesigntimeMetadataChange(a(E.getParameters(),"id"));},this);o.setValue(this.getValue(),true);this._sCreatedBy=s;this.setAggregation("propertyEditor",o);var r=this.getRenderLabel();if(r!==undefined){o.setRenderLabel(r);}o.attachReady(this._onPropertyEditorReady,this);if(o.isReady()){this.fireReady();}this.firePropertyEditorChange({propertyEditor:o});delete this._fnCancelInit;}.bind(this));}};
i.prototype._isAbsolutePath=function(p){return p&&p.startsWith("/");};
i.prototype._propagationListener=function(){var E=f(this.getParent(),"sap.ui.integration.designtime.baseEditor.BaseEditor");if(E){this.setEditor(E);this.removePropagationListener(this._propagationListener);}};
i.prototype.setParent=function(p){C.prototype.setParent.apply(this,arguments);if(this._bEditorAutoDetect){var E=f(p,"sap.ui.integration.designtime.baseEditor.BaseEditor");if(E){this.setEditor(E);}else{this.addPropagationListener(this._propagationListener);}}};
i.prototype.setRenderLabel=function(r){this.setProperty("renderLabel",r);var n=this.getAggregation("propertyEditor");if(n){n.setRenderLabel(r);}};
i.prototype.getContent=function(){var n=this.getAggregation("propertyEditor");return n&&n.getContent();};
i.prototype.setValue=function(v){this.setProperty("value",v);var n=this.getAggregation("propertyEditor");if(n){n.setValue(v,true);}};
i.prototype.getRuntimeConfig=function(){return this._mConfig;};
i.prototype.enhanceAccessibilityState=function(E,A){var p=this.getParent();if(p&&p.enhanceAccessibilityState){p.enhanceAccessibilityState(this,A);}return A;};
i.prototype.getFocusDomRef=function(){var n=this.getAggregation("propertyEditor");if(n){return n.getFocusDomRef();}};
i.prototype.getIdForLabel=function(){var n=this.getAggregation("propertyEditor");if(n){return n.getIdForLabel();}};
return i;});
sap.ui.predefine('sap/ui/integration/designtime/baseEditor/PropertyEditors',["sap/ui/core/Control","sap/ui/integration/designtime/baseEditor/util/findClosestInstance","sap/ui/integration/designtime/baseEditor/util/createPromise","sap/ui/integration/designtime/baseEditor/util/isTemplate","sap/ui/integration/designtime/baseEditor/util/StylesheetManager","sap/base/util/restricted/_intersection","sap/base/util/restricted/_omit","sap/base/util/deepEqual","sap/base/util/deepClone","sap/ui/core/Fragment","sap/ui/model/json/JSONModel","sap/ui/base/ManagedObjectObserver"],function(C,f,c,i,S,_,a,d,b,F,J,M){"use strict";var e="config";var g="tags";var l={"list":{module:"sap/ui/integration/designtime/baseEditor/layout/Form",defaultConfig:{responsiveGridLayout:{labelSpanXL:12,labelSpanL:12,labelSpanM:12,labelSpanS:12,adjustLabelSpan:false,columnsXL:1,columnsL:1,columnsM:1,singleContainerFullSize:false}}},"form":{module:"sap/ui/integration/designtime/baseEditor/layout/Form",defaultConfig:{}}};
var P=C.extend("sap.ui.integration.designtime.baseEditor.PropertyEditors",{
metadata:{properties:{tags:{type:"string"},renderLabels:{type:"boolean"},config:{type:"array"},layout:{type:"string",defaultValue:"list"},layoutConfig:{type:"object"}},aggregations:{content:{type:"sap.ui.core.Control",multiple:false}},associations:{editor:{type:"sap.ui.integration.designtime.baseEditor.BaseEditor",multiple:false},propertyEditors:{type:"sap.ui.integration.designtime.baseEditor.PropertyEditor",visibility:"hidden"}},events:{editorChange:{parameters:{previousEditor:{type:"sap.ui.integration.designtime.baseEditor.BaseEditor"},editor:{type:"sap.ui.integration.designtime.baseEditor.BaseEditor"}}},propertyEditorsChange:{parameters:{previousPropertyEditors:{type:"sap.ui.integration.designtime.baseEditor.PropertyEditor"},propertyEditors:{type:"sap.ui.integration.designtime.baseEditor.PropertyEditor"}}},init:{},configChange:{parameters:{previousConfig:{type:"array"},config:{type:"array"}}},tagsChange:{parameters:{previousTags:{type:"string"},tags:{type:"string"}}},ready:{},layoutChange:{parameters:{previousLayout:{type:"string"},layout:{type:"string"}}},layoutConfigChange:{parameters:{previousLayoutConfig:{type:"object"},layoutConfig:{type:"object"}}}}},
_bEditorAutoDetect:false,
_sCreatedBy:null,
_bLayoutReady:false,
constructor:function(){this._iExpectedWrapperCount=0;this._setReady(false);this._aEditorWrappers=[];this._bInitFinished=false;C.prototype.constructor.apply(this,arguments);var m=new J();this.setModel(m);if(!this.getEditor()){this._bEditorAutoDetect=true;}this._propagationListener=this._propagationListener.bind(this);this.attachEditorChange(function(){if(this._sCreatedBy){this._removePropertyEditors();}this._initPropertyEditors();});this.attachConfigChange(function(E){var p=E.getParameter("previousConfig");var h=E.getParameter("config");if(this._fnCancelInit||this._sCreatedBy===g||!Array.isArray(p)||!Array.isArray(h)||p.length!==h.length){this._removePropertyEditors();this._initPropertyEditors();}else if(this._sCreatedBy){this._evaluateViewRecreation(p,h);}});this.attachTagsChange(function(){if(this._sCreatedBy===g){this._removePropertyEditors();}if(this._sCreatedBy!==e){this._initPropertyEditors();}});if(this.getMetadata().getProperty("layout").getDefaultValue()===this.getLayout()){this._initLayout(this.getLayout());}},
renderer:function(r,o){r.openStart("div",o);r.openEnd();r.renderControl(o.getContent());r.close("div");}
});
P.prototype.init=function(){this.attachLayoutChange(function(E){var p=E.getParameter("previousLayout");this._removeStylesheet(this._getLayoutPath(p));var L=E.getParameter("layout");this._initLayout(L);},this);this.attachLayoutConfigChange(function(){if(this._sCreatedBy){this._removePropertyEditors();}this._initPropertyEditors();},this);Promise.resolve().then(function(){this._bInitFinished=true;this.fireInit();}.bind(this));};
P.prototype.destroy=function(){this._bInitFinished=false;this._setReady(false);if(this._fnCancelLayoutLoading){this._fnCancelLayoutLoading();}this._removeStylesheet(this._getLayoutPath(this.getLayout()));C.prototype.destroy.apply(this,arguments);};
P.prototype._loadFragment=function(s){return F.load({name:s,controller:this});};
P.prototype._loadModule=function(s){return new Promise(function(r,R){sap.ui.require([s],r,R);});};
P.prototype._loadStylesheet=function(s){this._bCssRequested=true;return S.add(s);};
P.prototype._removeStylesheet=function(s){if(this._bCssRequested){S.remove(s);delete this._bCssRequested;}};
P.prototype.getEditor=function(){return sap.ui.getCore().byId(this.getAssociation("editor"));};
P.prototype.setConfig=function(m){var p=this.getConfig();if(!Array.isArray(p)||!Array.isArray(m)||JSON.stringify(p)!==JSON.stringify(m)){var n=b(m);this.setProperty("config",n);this.fireConfigChange({previousConfig:p,config:n});}};
P.prototype.setTags=function(t){var p=this.getTags();var r=t;if(typeof t==="string"){r=t.split(",").sort().join(",");}if(p!==r){this.setProperty("tags",r);this.fireTagsChange({previousTags:p,tags:r});}};
P.prototype.setEditor=function(E){var p=this.getEditor();var o=typeof E==="string"?sap.ui.getCore().byId(E):E;if(p!==o){this.setAssociation("editor",E);var o=this.getEditor();this.fireEditorChange({previousEditor:p,editor:o});}};
P.prototype._removePropertyEditors=function(){var p=this.removeAllAssociation("propertyEditors").map(function(s){return sap.ui.getCore().byId(s);});this._iExpectedWrapperCount=0;this.getModel().setData({});this._sCreatedBy=null;if(p.length){this.firePropertyEditorsChange({previousPropertyEditors:p,propertyEditors:[]});}};
P.prototype._initPropertyEditors=function(){if(this.getEditor()&&(this.getConfig()||(!this.getBindingInfo("config")&&this.getTags()))&&this._bLayoutReady){var E=this.getEditor();var h;if(this.getConfig()){h=this.getConfig();this._sCreatedBy=e;}else{var t=this.getTags().split(",");h=E.getConfigsByTag(t);this._sCreatedBy=g;}var p=(this._getPropertyEditors()||[]).slice();this._updateViewModel(h);this.ready().then(function(){this.firePropertyEditorsChange({previousPropertyEditors:p,propertyEditors:(this._getPropertyEditors()||[]).slice()});}.bind(this));}this._checkReadyState();};
P.prototype._propagationListener=function(){var E=f(this.getParent(),"sap.ui.integration.designtime.baseEditor.BaseEditor");if(E){this.setEditor(E);this.removePropagationListener(this._propagationListener);}};
P.prototype.setParent=function(p){C.prototype.setParent.apply(this,arguments);if(this._bEditorAutoDetect){var E=f(p,"sap.ui.integration.designtime.baseEditor.BaseEditor");if(E){this.setEditor(E);}else{this.addPropagationListener(this._propagationListener);}}};
P.prototype.setLayout=function(L){var p=this.getLayout();if(p!==L){this.setProperty("layout",L);this.fireLayoutChange({previousLayout:p,layout:L});}};
P.prototype.setLayoutConfig=function(L){var p=this.getLayoutConfig();if(!d(p,L)){this.setProperty("layoutConfig",L);this.fireLayoutConfigChange({previousLayoutConfig:p,layoutConfig:L});}};
P.prototype._getLayoutConfig=function(){var L=this.getLayoutConfig();var r=this.getRenderLabels();var R;if(typeof r==="boolean"){R={renderLabels:r};}var D=l[this.getLayout()].defaultConfig;return Object.assign({},D,L,R);};
P.prototype._getLayoutPath=function(L){return l.hasOwnProperty(L)?l[L].module:L;};
P.prototype._initLayout=function(L){this.destroyContent();var p=this._getLayoutPath(L);this._bLayoutReady=false;if(this._sCreatedBy){this._removePropertyEditors();}if(this._fnCancelLayoutLoading){this._fnCancelLayoutLoading();}var m=c(function(r,R){this._loadStylesheet(p);Promise.all([this._loadFragment(p),this._loadModule(p)]).then(r,R);}.bind(this));m.promise.then(function(r){delete this._fnCancelLayoutLoading;var o=r[0];var h=r[1];this._prepareData=h.prepareData;this._aUpdateDependencies=h.updateDependencies||[];this.setContent(o);this._bLayoutReady=true;this._initPropertyEditors();}.bind(this));this._fnCancelLayoutLoading=m.cancel;};
P.prototype._evaluateViewRecreation=function(p,h){var r=this._getPropertyEditors()||[];if(p.length!==h.length||h.length!==r.length||h.some(function(o,I){return this._aUpdateDependencies.some(function(D){return p[I][D]!==o[D];});}.bind(this))){this._updateViewModel(h);}else{r.map(function(o,I){var j=h[I];o.setConfig(a(b(j),"value"));if(j.hasOwnProperty("value")){o.setValue(j.value);}});}};
P.prototype._updateViewModel=function(h){var D=this._prepareData(h,this._getLayoutConfig());this._iExpectedWrapperCount=D.count;if(this._iExpectedWrapperCount>0){this._checkReadyState();}this.getModel().setData(D);};
P.prototype.ready=function(){return new Promise(function(r){if(this.isReady()){r();}else{this.attachEventOnce("ready",r);}}.bind(this));};
P.prototype.isReady=function(){return!!this._bIsReady;};
P.prototype._setReady=function(r){var p=this._bIsReady;this._bIsReady=r;if(p!==true&&r===true){this.fireReady();}};
P.prototype._checkReadyState=function(){if(this._mWrapperReadyCheck){this._mWrapperReadyCheck.cancel();}if(!this._bInitFinished){this._setReady(false);return;}if(this._iExpectedWrapperCount===0){this._setReady(true);return;}if(this._iExpectedWrapperCount===this._aEditorWrappers.length){if(this._aEditorWrappers.every(function(w){return w.isReady();})){this._setReady(true);}else{this._setReady(false);this._mWrapperReadyCheck=c(function(r){Promise.all(this._aEditorWrappers.map(function(w){return w.ready();})).then(r);}.bind(this));this._mWrapperReadyCheck.promise.then(function(){this._setReady(true);delete this._mWrapperReadyCheck;}.bind(this));}}else{this._setReady(false);}};
P.prototype.wrapperInit=function(E){var w=E.getSource();if(i(w,this)){return;}if(!w.getEditor()){w.setEditor(this.getEditor());}this._aEditorWrappers.push(w);this.addAssociation("propertyEditors",w);w.attachReady(function(){this._setReady(false);this._checkReadyState();}.bind(this));if(!this._oWrapperObserver){this._oWrapperObserver=new M(function(m){this._aEditorWrappers=this._aEditorWrappers.filter(function(o){return o!==m.object;});this.removeAssociation("propertyEditors",m.object);}.bind(this));}this._oWrapperObserver.observe(w,{destroy:true});this._checkReadyState();};
P.prototype._getPropertyEditors=function(){var p=(this.getAssociation("propertyEditors")||[]).map(function(I){return sap.ui.getCore().byId(I);});return p.length&&p||null;};
return P;});
sap.ui.predefine('sap/ui/integration/designtime/baseEditor/layout/Form',["sap/ui/integration/designtime/baseEditor/util/hasTag","sap/base/util/restricted/_omit"],function(h,_){"use strict";var d={labelSpanXL:4,labelSpanL:4,labelSpanM:4,labelSpanS:12,adjustLabelSpan:false,columnsXL:1,columnsL:1,columnsM:1,singleContainerFullSize:false};
function c(P){return{label:P.label,value:P.value,config:_(P,["label","value"])};}
function g(C,t){var r=[];var i=0;while(i<C.length){var m=C[i];if(h(m,t)){r.push(m);C.splice(i,1);}else{i++;}}return r;}
function a(C,P){var i=C.findIndex(function(m){return m.__propertyName===P;});if(i>-1){return C.splice(i,1)[0];}}
function b(C){return C.some(function(G){return typeof G.config.visible==="boolean"?G.config.visible:true;});}
function p(P,l){l=l||{};var C=P.slice();var G=l.groups||[];var r=l.responsiveGridLayout||d;var R=l.renderLabels!==false;var v={responsiveGridLayout:r};if(!R){C=C.map(function(m){return _(m,"label");});}if(G.length>0){v.groups=G.map(function(m){var i=[];m.items.forEach(function(I){switch(I.type){case"tag":i=i.concat(g(C,I.value).map(function(f){return c(f);}));break;case"propertyName":var e=a(C,I.value);if(e){i=i.concat(c(e));}break;}});return{label:m.label,items:i,visible:b(i)};});}else{var i=C.splice(0,C.length).map(c);v.groups=[{items:i,visible:b(i)}];}v.groups=v.groups.filter(function(m){return m.items.length>0;});v.count=P.length-C.length;return v;}
return{prepareData:p,updateDependencies:["visible","tags"]};});
sap.ui.predefine('sap/ui/integration/designtime/baseEditor/propertyEditor/BasePropertyEditor',["sap/ui/core/Control","./../util/isTemplate","sap/ui/model/json/JSONModel","sap/m/Label","sap/ui/core/Fragment","sap/base/util/restricted/_omit","sap/ui/base/ManagedObjectObserver","sap/ui/integration/designtime/baseEditor/propertyEditor/PropertyEditorFactory","sap/ui/integration/designtime/baseEditor/util/createPromise","sap/base/util/deepClone","sap/base/util/deepEqual","sap/base/util/isPlainObject","sap/base/util/values","sap/base/util/each","sap/ui/integration/designtime/baseEditor/validator/ValidatorRegistry","sap/ui/integration/designtime/baseEditor/util/BaseDefaultValidatorModules","sap/ui/integration/designtime/baseEditor/util/cleanupDesigntimeMetadata"],function(C,i,J,L,F,_,M,P,c,d,a,b,v,e,V,B,f){"use strict";
var g=C.extend("sap.ui.integration.designtime.baseEditor.propertyEditor.BasePropertyEditor",{
metadata:{interfaces:["sap.ui.core.IFormContent"],properties:{"renderLabel":{type:"boolean",defaultValue:true},"value":{type:"any"},"config":{type:"object"}},aggregations:{"_label":{type:"sap.m.Label",visibility:"hidden",multiple:false},"content":{type:"sap.ui.core.Control",multiple:false}},events:{beforeValueChange:{parameters:{path:{type:"string"},value:{type:"any"},nextValue:{type:"any"}}},valueChange:{parameters:{path:{type:"string"},value:{type:"any"},previousValue:{type:"any"}}},designtimeMetadataChange:{parameters:{path:{type:"string"},value:{type:"any"},previousValue:{type:"any"}}},configChange:{parameters:{previousConfig:{type:"object"},config:{type:"object"}}},fragmentChange:{parameters:{previousFragment:{type:"string"},fragment:{type:"string"}}},ready:{},init:{}}},
xmlFragment:null,
_currentXmlFragment:null,
_bFragmentReady:false,
constructor:function(){this._iExpectedWrapperCount=0;this._currentXmlFragment=this.xmlFragment;C.prototype.constructor.apply(this,arguments);this._oDefaultModel=new J({value:this.getValue(),config:this.getConfig(),displayValue:this._formatValue(this.getValue())});this._oDefaultModel.setDefaultBindingMode("OneWay");this.setBindingContext(this._oDefaultModel.getContext("/"));this.setModel(this._oDefaultModel);this.bindProperty("visible","config/visible");this._setReady(false);this._aEditorWrappers=[];this._bInitFinished=false;this.attachBeforeValueChange(function(E){this._iExpectedWrapperCount=this.getExpectedWrapperCount(E.getParameter("nextValue"));},this);this.attachValueChange(function(E){var l=E.getParameter("value");this._oDefaultModel.setData(Object.assign({},this._oDefaultModel.getData(),{value:l,displayValue:this._formatValue(l)}));this._checkReadyState();},this);this.attachConfigChange(function(E){var p=E.getParameter("previousConfig");var o=E.getParameter("config");if(p&&o&&!a(p.validators,o.validators)){this._validate(this.getValue());}this._oDefaultModel.setData(Object.assign({},this._oDefaultModel.getData(),{config:o}));},this);this.asyncInit().then(function(){this._bInitFinished=true;this.fireInit();this._checkReadyState();}.bind(this));if(this.getFragment()){this._initFragment(this.getFragment());}},
renderer:function(r,p){r.openStart("div",p);r.addStyle("display","inline-block");r.addStyle("width","100%");r.openEnd();if(p.getRenderLabel()&&p.getLabel()){r.openStart("div");r.openEnd();r.renderControl(p.getLabel());r.close("div");}r.renderControl(p.getContent());r.close("div");}
});
g.prototype.init=function(){this.attachFragmentChange(function(E){if(this.getContent()){this.getContent().destroy();}var s=E.getParameter("fragment");this._initFragment(s);},this);};
g.prototype.asyncInit=function(){return Promise.resolve();};
g.prototype.onFragmentReady=function(){};
g.prototype.setValue=function(l,s){var m=this.getValue();var o=this.getConfig()||{};var n=l;if(typeof n==="undefined"&&typeof o.defaultValue!=="undefined"){n=d(o.defaultValue);}this._validate(n,function(r){if((r||s)&&!a(n,m)){this.fireBeforeValueChange({path:o.path,value:m,nextValue:n});this.setProperty("value",n);this.fireValueChange({path:o.path,previousValue:m,value:n});}}.bind(this));};
g.prototype.setDesigntimeMetadata=function(o){var l=this.getDesigntimeMetadata();var n=o;f(n);var m=this.getConfig();if(!a(l,n)){this.fireDesigntimeMetadataChange({path:m.path,previousValue:l,value:n});}};
g.prototype.getDesigntimeMetadata=function(){return(this.getConfig()||{}).designtime||{};};
g.prototype.setDesigntimeMetadataValue=function(o){this.setDesigntimeMetadata(Object.assign({},this.getConfig().designtime,{__value:o}));};
g.prototype.getNestedDesigntimeMetadata=function(K){var D=(this.getConfig()||{}).designtime||{};return D[K];};
g.prototype.getNestedDesigntimeMetadataValue=function(K){return(this.getNestedDesigntimeMetadata(K)||{}).__value||{};};
g.prototype.getDesigntimeMetadataValue=function(){var D=(this.getConfig()||{}).designtime||{};return D.__value||{};};
g.prototype._getValidators=function(){var p=this.getConfig().validators||{};return v(Object.assign({},p,this.getDefaultValidators())).filter(function(o){return o.isEnabled!==false;});};
g.prototype.getDefaultValidators=function(){return{};};
g.prototype._validate=function(l,o){var E=[];var m=this._getValidators();m=m.map(function(p){var q=V.hasValidator(p.type)?V.getValidator(p.type):this.getDefaultValidatorModules()[p.type];if(!q){throw new Error("Unknown validator: "+p.type);}var r={};var s=p.errorMessage||q.errorMessage;var t=[];var u=s;if(b(s)){t=s.placeholders(p.config);u=s.message;}Object.keys(p.config||{}).forEach(function(w){var x=p.config[w];if(typeof x==="function"){x=x(this);}r[w]=x;}.bind(this));return{validator:q,config:r,errorMessage:this.getI18nProperty(u,t),type:p.type};}.bind(this));var n=function(){var r=E.length===0;this.setInputState(!r,E[0]);if(typeof o==="function"){o(r);}}.bind(this);m.forEach(function(p){if(!p.validator.validate(l,p.config)){E.push(p.errorMessage);}});n();};
g.prototype.setInputState=function(H,E){var I=this.getContent();if(!I||!I.setValueState){return;}if(H){I.setValueState("Error");I.setValueStateText(E);}else{I.setValueState("None");}};
g.prototype.getDefaultValidatorModules=function(){return B;};
g.prototype._formatValue=function(l){return this.formatValue(d(l));};
g.prototype.formatValue=function(l){return l;};
g.prototype.getExpectedWrapperCount=function(){return 0;};
g.prototype._checkReadyState=function(){if(this._mWrapperReadyCheck){this._mWrapperReadyCheck.cancel();}if(!this._bInitFinished){this._setReady(false);return;}if(!this._bFragmentReady){this._setReady(false);return;}if(this._iExpectedWrapperCount===0){this._setReady(true);return;}if(this._iExpectedWrapperCount===this._aEditorWrappers.length){if(this._aEditorWrappers.every(function(w){return w.isReady();})){this._setReady(true);}else{this._setReady(false);this._mWrapperReadyCheck=c(function(r){Promise.all(this._aEditorWrappers.map(function(w){return w.ready();})).then(r);}.bind(this));this._mWrapperReadyCheck.promise.then(function(){this._setReady(true);delete this._mWrapperReadyCheck;}.bind(this));}}else{this._setReady(false);}};
g.prototype.wrapperInit=function(E){if(!this._oWrapperObserver){this._oWrapperObserver=new M(function(m){var o=m.object;switch(m.type){case'destroy':this._aEditorWrappers=this._aEditorWrappers.filter(function(l){return l!==o;});this._checkReadyState();break;case'parent':j(o).forEach(function(w){if(!i(w,this)){this._registerWrapper(w);}}.bind(this));this._oWrapperObserver.unobserve(o);break;default:return;}}.bind(this));}var w=E.getSource();if(i(w,this)){var r=h(w);if(!this._oWrapperObserver.isObserved(r,{parent:true})){this._oWrapperObserver.observe(r,{parent:true});}return;}this._registerWrapper(w);};
function h(E){var p=E.getParent();return p?h(p):E;}
function j(E){return k(E)?[E]:E.findAggregatedObjects(true,function(E){return k(E);});}
function k(E){return E.isA("sap.ui.integration.designtime.baseEditor.PropertyEditors")||E.isA("sap.ui.integration.designtime.baseEditor.PropertyEditor");}
g.prototype._registerWrapper=function(w){this._aEditorWrappers.push(w);w.attachReady(function(E){this._setReady(false);this._checkReadyState();}.bind(this));if(w.isA("sap.ui.integration.designtime.baseEditor.PropertyEditor")){w.attachPropertyEditorChange(function(E){var p=E.getParameter("propertyEditor");if(!p){this._setReady(false);}},this);}this._oWrapperObserver.observe(w,{destroy:true});this._checkReadyState();};
g.prototype._setReady=function(r){var p=this._bIsReady;this._bIsReady=r;if(p!==true&&r===true){this.fireReady();}};
g.prototype.isReady=function(){return!!this._bIsReady;};
g.prototype.ready=function(){return new Promise(function(r){if(this.isReady()){r();}else{this.attachEventOnce("ready",r);}}.bind(this));};
g.prototype.setFragment=function(s,G){if(this._currentXmlFragment!==s){var p=this._currentXmlFragment;this._currentXmlFragment=s;if(typeof G==='function'){this.getExpectedWrapperCount=G;}this.fireFragmentChange({previousFragment:p,fragment:s});}};
g.prototype.getFragment=function(){return this._currentXmlFragment;};
g.prototype._initFragment=function(s){this._setReady(false);this._bFragmentReady=false;if(this._fnCancelFragmentLoading){this._fnCancelFragmentLoading();}var o=c(function(r,R){this._loadFragment(s).then(r,R);}.bind(this));this._fnCancelFragmentLoading=o.cancel;return o.promise.then(function(l){delete this._fnCancelFragmentLoading;this._bFragmentReady=true;this.setContent(l);this.onFragmentReady();this._checkReadyState();}.bind(this));};
g.prototype._loadFragment=function(s){return F.load({name:s,controller:this});};
g.prototype.clone=function(){this.destroyContent();return C.prototype.clone.apply(this,arguments);};
g.prototype.exit=function(){this._oDefaultModel.destroy();if(this._oConfigBinding){this._oConfigBinding.destroy();}if(this._oWrapperObserver){this._oWrapperObserver.destroy();}if(this._fnCancelFragmentLoading){this._fnCancelFragmentLoading();}};
g.configMetadata={visible:{defaultValue:true,mergeStrategy:"mostRestrictiveWins"}};
g.prototype.setConfig=function(o){var p=this.getConfig();var D={};var l=P.getType(this.getMetadata().getName()).configMetadata;e(l,function(s,m){D[s]=m.defaultValue;});var n=Object.assign({},D,o);n=this.onBeforeConfigChange(n);if(!a(p,n)){this.setProperty("config",n);this.fireConfigChange({previousConfig:p,config:n});}};
g.prototype.onBeforeConfigChange=function(o){return o;};
g.prototype.getI18nProperty=function(n,p){if(this.getModel("i18n")){return this.getModel("i18n").getResourceBundle().getText(n,p);}return n;};
g.prototype.getLabel=function(){var l=this.getAggregation("_label");if(!l){l=new L({text:"{config/label}",design:"Bold"});this.setAggregation("_label",l);}return l;};
g.prototype.enhanceAccessibilityState=function(E,A){var p=this.getParent();if(p&&p.enhanceAccessibilityState){p.enhanceAccessibilityState(this,A);}return A;};
g.prototype.getFocusDomRef=function(){var o=this.getContent();if(o&&o.isA("sap.ui.core.IFormContent")){return o.getFocusDomRef();}};
g.prototype.getIdForLabel=function(){var o=this.getContent();if(o&&o.isA("sap.ui.core.IFormContent")){return o.getIdForLabel();}};
return g;});
sap.ui.predefine('sap/ui/integration/designtime/baseEditor/propertyEditor/PropertyEditorFactory',["sap/base/util/includes","sap/base/util/values"],function(i,v){"use strict";var P={};var l={};var p={};
P.registerTypes=function(t){Object.keys(t).forEach(function(s){if(!l[s]){l[s]=new Promise(function(r,a){sap.ui.require([t[s]],r,a);}).then(function(o){p[o.getMetadata().getName()]=o;return o;});}});return Promise.all(v(l)).then(function(){return p;});};
P.deregisterType=function(t){if(l[t]){delete l[t];}};
P.deregisterAllTypes=function(){l={};};
P.create=function(s){return new Promise(function(r,a){if(!s){return a("No editor type was specified in the property configuration.");}if(!l[s]){return a("Editor type was not registered");}l[s].then(function(b){return r(new b());}).catch(function(e){return a(e);});});};
P.getType=function(t){return p[t];};
P.getTypes=function(){return Object.assign({},l);};
P.hasType=function(s){return i(Object.keys(P.getTypes()),s);};
return P;});
sap.ui.predefine('sap/ui/integration/designtime/baseEditor/propertyEditor/arrayEditor/ArrayEditor',["sap/ui/integration/designtime/baseEditor/propertyEditor/BasePropertyEditor","sap/base/util/deepClone","sap/base/util/deepEqual","sap/base/util/ObjectPath","sap/ui/model/json/JSONModel","sap/base/util/restricted/_merge","sap/ui/integration/designtime/baseEditor/util/binding/resolveBinding","sap/ui/integration/designtime/baseEditor/util/unset","sap/base/util/restricted/_isNil","sap/base/strings/formatMessage","sap/base/util/isEmptyObject"],function(B,d,a,O,J,_,r,u,b,f,i){"use strict";
var A=B.extend("sap.ui.integration.designtime.baseEditor.propertyEditor.arrayEditor.ArrayEditor",{
xmlFragment:"sap.ui.integration.designtime.baseEditor.propertyEditor.arrayEditor.ArrayEditor",
metadata:{properties:{value:{type:"any"}}},
renderer:B.getMetadata().getRenderer().render
});
A.configMetadata=Object.assign({},B.configMetadata,{allowAddAndRemove:{defaultValue:true,mergeStrategy:"mostRestrictiveWins"},allowSorting:{defaultValue:true,mergeStrategy:"mostRestrictiveWins"},collapsibleItems:{defaultValue:true,mergeStrategy:"mostRestrictiveWins"},showItemLabel:{defaultValue:true,mergeStrategy:"mostRestrictiveWins"},template:{defaultValue:{}}});
A.prototype.init=function(){B.prototype.init.apply(this,arguments);this._itemsModel=new J();this._itemsModel.setDefaultBindingMode("OneWay");this.setModel(this._itemsModel,"itemsModel");};
A.prototype.setValue=function(v){v=Array.isArray(v)?v:[];B.prototype.setValue.call(this,v);this._handleValueChange(this.getValue());};
A.prototype._handleValueChange=function(v){var c=this.getConfig();var I=[];v.forEach(function(V,e){var o=d(V);var D=this.getNestedDesigntimeMetadata(e);var m={itemLabel:c.itemLabel||this.getI18nProperty("BASE_EDITOR.ARRAY.ITEM_LABEL"),index:e,total:v.length,properties:Object.keys(c.template).map(function(k){var t=c.template[k];var P=e+"/"+t.path;var g=O.get(P.split("/"),v);if(typeof g==="undefined"){O.set(t.path.split('/'),d(t.defaultValue),o);}return _({},t,{path:P,value:g,designtime:(D||{})[k]});},this)};var p=new J(o);m.properties=r(m.properties,{"":p},{"":p.getContext("/")},["template","value","itemLabel"]);m.itemLabel=r({itemLabel:m.itemLabel},{"":p},{"":p.getContext("/")}).itemLabel||f(this.getI18nProperty("BASE_EDITOR.ARRAY.NEW_ITEM_LABEL"),[c.addItemLabel||this.getI18nProperty("BASE_EDITOR.ARRAY.ITEM_LABEL")]);p.destroy();I.push(m);},this);this._itemsModel.setData(I);};
A.prototype.onBeforeConfigChange=function(c){if(!c.collapsibleItems){this.setFragment("sap.ui.integration.designtime.baseEditor.propertyEditor.arrayEditor.ArrayEditorPlain");}return c;};
A.prototype.getExpectedWrapperCount=function(v){return v.length;};
A.prototype._removeItem=function(e){var I=e.getSource().data("index");var v=(this.getValue()||[]).slice();v.splice(I,1);this.setValue(v);};
A.prototype._addItem=function(){var c=this.getConfig();var v=(this.getValue()||[]).slice();var D={};Object.keys(c.template).forEach(function(k){var p=c.template[k];if(p.type==="array"){D[k]=[];}});v.push(D);this.setValue(v);};
A.prototype._moveUp=function(e){var I=e.getSource().data("index");if(I>0){var v=this.getValue().slice();var R=v.splice(I,1)[0];v.splice(I-1,0,R);this.setValue(v);}};
A.prototype._moveDown=function(e){var I=e.getSource().data("index");var v=this.getValue().slice();if(I<v.length-1){var R=v.splice(I,1)[0];v.splice(I+1,0,R);this.setValue(v);}};
A.prototype._propertyEditorsChange=function(e){e.getParameter("previousPropertyEditors").forEach(function(p){p.detachValueChange(this._onPropertyValueChange,this);p.detachDesigntimeMetadataChange(this._onDesigntimeMetadataChange,this);},this);e.getParameter("propertyEditors").forEach(function(p){p.attachValueChange(this._onPropertyValueChange,this);p.attachDesigntimeMetadataChange(this._onDesigntimeMetadataChange,this);},this);};
A.prototype._onPropertyValueChange=function(e){var p=e.getSource();var E=d(this.getValue()||[]);var P=e.getParameter("path");var c=P.split("/");var v=e.getParameter("value");O.set(c,v,E);if(typeof v==="undefined"||a(v,p.getConfig().defaultValue)){u(E,c,c.length-2);}this.setValue(E);};
A.prototype._onDesigntimeMetadataChange=function(e){var n={};O.set(e.getParameter("path").split("/"),e.getParameter("value"),n);this.setDesigntimeMetadata(_({},this.getDesigntimeMetadata(),n));this.setValue(this.getValue());};
A.prototype._isNewItem=function(m){return(m&&m.properties||[]).every(function(o){var v=o.value;return b(v)||Array.isArray(v)&&v.length===0||i(v);});};
A.prototype.formatAddItemText=function(s,I,F){return f(s,[I||F]);};
return A;});
sap.ui.predefine('sap/ui/integration/designtime/baseEditor/propertyEditor/booleanEditor/BooleanEditor',["sap/ui/integration/designtime/baseEditor/propertyEditor/BasePropertyEditor","sap/ui/integration/designtime/baseEditor/util/isValidBindingString"],function(B,i){"use strict";
var a=B.extend("sap.ui.integration.designtime.baseEditor.propertyEditor.booleanEditor.BooleanEditor",{
xmlFragment:"sap.ui.integration.designtime.baseEditor.propertyEditor.booleanEditor.BooleanEditor",
renderer:B.getMetadata().getRenderer().render
});
a.prototype.getDefaultValidators=function(){var c=this.getConfig();return Object.assign({},B.prototype.getDefaultValidators.call(this),{isValidBinding:{type:"isValidBinding",isEnabled:c.allowBindings},notABinding:{type:"notABinding",isEnabled:!c.allowBindings},isBoolean:{type:"isBoolean"}});};
a.prototype._onChange=function(){var c=this.getContent();var v=c.getSelectedKey()||c.getValue();if(v==="false"){v=false;}else if(v==="true"){v=true;}this.setValue(v);};
a.configMetadata=Object.assign({},B.configMetadata,{allowBindings:{defaultValue:true,mergeStrategy:"mostRestrictiveWins"}});return a;});
sap.ui.predefine('sap/ui/integration/designtime/baseEditor/propertyEditor/dateEditor/DateEditor',["sap/ui/integration/designtime/baseEditor/propertyEditor/BasePropertyEditor","sap/ui/core/format/DateFormat"],function(B,D){"use strict";
var a=B.extend("sap.ui.integration.designtime.baseEditor.propertyEditor.dateEditor.DateEditor",{
xmlFragment:"sap.ui.integration.designtime.baseEditor.propertyEditor.dateEditor.DateEditor",
renderer:B.getMetadata().getRenderer().render
});
a.prototype.getDefaultValidators=function(){var c=this.getConfig();return Object.assign({},B.prototype.getDefaultValidators.call(this),{isValidBinding:{type:"isValidBinding",isEnabled:c.allowBindings},notABinding:{type:"notABinding",isEnabled:!c.allowBindings},isDate:{type:"isDate"}});};
a.prototype.formatValue=function(v){var d=new Date(v);if(!this._isValidDate(d)){return v;}return this.getFormatterInstance().format(d);};
a.configMetadata=Object.assign({},B.configMetadata,{allowBindings:{defaultValue:true}});
a.prototype.onFragmentReady=function(){var d=this.getContent();d.onkeypress=function(e){if(!e.charCode||e.metaKey||e.ctrlKey){return;}};};
a.prototype._onChange=function(e){var v=e.getParameter("newValue");var p=this._parse(v);this.setValue(p);};
a.prototype._parse=function(v){if(v===""){return undefined;}var p=new Date(v);return this._isValidDate(p)?p.toISOString():v;};
a.prototype._isValidDate=function(d){return d&&!isNaN(d.getTime());};
a.prototype.getFormatterInstance=function(){return D.getDateInstance();};
return a;});
sap.ui.predefine('sap/ui/integration/designtime/baseEditor/propertyEditor/dateTimeEditor/DateTimeEditor',["sap/ui/integration/designtime/baseEditor/propertyEditor/BasePropertyEditor","sap/ui/integration/designtime/baseEditor/propertyEditor/dateEditor/DateEditor","sap/ui/core/format/DateFormat"],function(B,D,a){"use strict";
var b=D.extend("sap.ui.integration.designtime.baseEditor.propertyEditor.dateTimeEditor.DateTimeEditor",{
xmlFragment:"sap.ui.integration.designtime.baseEditor.propertyEditor.dateTimeEditor.DateTimeEditor",
renderer:B.getMetadata().getRenderer().render
});
b.prototype.getFormatterInstance=function(){return a.getDateTimeInstance();};
b.configMetadata=Object.assign({},D.configMetadata);return b;});
sap.ui.predefine('sap/ui/integration/designtime/baseEditor/propertyEditor/enumStringEditor/EnumStringEditor',["sap/ui/integration/designtime/baseEditor/propertyEditor/BasePropertyEditor","sap/ui/integration/designtime/baseEditor/util/isValidBindingString"],function(B,i){"use strict";
var E=B.extend("sap.ui.integration.designtime.baseEditor.propertyEditor.enumStringEditor.EnumStringEditor",{
xmlFragment:"sap.ui.integration.designtime.baseEditor.propertyEditor.enumStringEditor.EnumStringEditor",
renderer:B.getMetadata().getRenderer().render
});
E.configMetadata=Object.assign({},B.configMetadata,{allowBindings:{defaultValue:true,mergeStrategy:"mostRestrictiveWins"},allowCustomValues:{defaultValue:false,mergeStrategy:"mostRestrictiveWins",mostRestrictiveValue:true}});
E.prototype.getDefaultValidators=function(){var c=this.getConfig();return Object.assign({},B.prototype.getDefaultValidators.call(this),{isValidBinding:{type:"isValidBinding",isEnabled:c.allowBindings},notABinding:{type:"notABinding",isEnabled:!c.allowBindings},isSelectedKey:{type:"isSelectedKey",config:{keys:function(p){return p.getConfig().enum;}},isEnabled:!c.allowCustomValues}});};
E.prototype._onChange=function(){var c=this.getContent();var s=c.getSelectedKey();var v=c.getValue();this.setValue(s||v);};
return E;});
sap.ui.predefine('sap/ui/integration/designtime/baseEditor/propertyEditor/iconEditor/IconEditor',["sap/ui/integration/designtime/baseEditor/propertyEditor/BasePropertyEditor","sap/ui/core/ListItem","sap/ui/core/Fragment","sap/ui/model/json/JSONModel","sap/ui/model/Filter","sap/ui/model/FilterOperator","sap/ui/core/IconPool","sap/ui/base/BindingParser","sap/ui/integration/designtime/baseEditor/util/isValidBindingString","./IsInIconPool.validator"],function(B,L,F,J,a,b,I,c,i,d){"use strict";var o=null;
var e=B.extend("sap.ui.integration.designtime.baseEditor.propertyEditor.iconEditor.IconEditor",{
xmlFragment:"sap.ui.integration.designtime.baseEditor.propertyEditor.iconEditor.IconEditor",
renderer:B.getMetadata().getRenderer().render
});
e.configMetadata=Object.assign({},B.configMetadata);
e.prototype.onFragmentReady=function(){var f=this.getContent();this._oIconModel=this._getIconModel();f.setModel(this._oIconModel,"icons");f.bindAggregation("suggestionItems","icons>/",new L({text:"{icons>path}",additionalText:"{icons>name}"}));};
e.prototype._getIconModel=function(){if(!o){o=new J(I.getIconNames().map(function(n){return{name:n,path:"sap-icon://"+n};}));}return o;};
e.prototype._onChange=function(E){var s=E.getParameter("value");this.setValue(s);};
e.prototype._onSuggestionItemSelected=function(E){this.setValue(E.getParameter("selectedItem").getText());};
e.prototype._getDefaultSearchValue=function(s){try{var p=c.complexParser(s);return p?"":s;}catch(E){return s;}};
e.prototype._handleValueHelp=function(E){var v=E.getSource().getValue();if(!this._oDialog){return F.load({name:"sap.ui.integration.designtime.baseEditor.propertyEditor.iconEditor.IconEditorDialog",controller:this}).then(function(D){this._oDialog=D;this.addDependent(this._oDialog);this._oDialog.setModel(this._oIconModel);this._filter(v);this._oDialog.open(this._getDefaultSearchValue(v));return this._oDialog;}.bind(this));}else{this._filter(v);this._oDialog.open(this._getDefaultSearchValue(v));return Promise.resolve(this._oDialog);}};
e.prototype.handleSearch=function(E){var v=E.getParameter("value");this._filter(v);};
e.prototype._filter=function(v){var f=new a("path",b.Contains,v);var g=this._oDialog.getBinding("items");g.filter([f]);};
e.prototype.handleClose=function(E){var s=E.getParameter("selectedItem");if(s){this.setValue(s.getIcon());}E.getSource().getBinding("items").filter([]);};
e.prototype.getDefaultValidators=function(){return Object.assign({},B.prototype.getDefaultValidators.call(this),{isValidBinding:{type:"isValidBinding"},isInIconPool:{type:"isInIconPool"}});};
e.prototype.getDefaultValidatorModules=function(){return Object.assign({},B.prototype.getDefaultValidatorModules.apply(this,arguments),{isInIconPool:d});};
return e;});
sap.ui.predefine('sap/ui/integration/designtime/baseEditor/propertyEditor/iconEditor/IsInIconPool.validator',["sap/ui/integration/designtime/baseEditor/validator/IsValidBinding","sap/base/util/restricted/_isNil","sap/ui/core/IconPool"],function(I,_,a){"use strict";return{async:false,errorMessage:"BASE_EDITOR.VALIDATOR.NOT_AN_ICON",validate:function(v){return _(v)||(typeof v==="string"&&a.isIconURI(v)&&!!a.getIconInfo(v))||I.validate(v,{allowPlainStrings:false});}};});
sap.ui.predefine('sap/ui/integration/designtime/baseEditor/propertyEditor/integerEditor/IntegerEditor',["sap/ui/integration/designtime/baseEditor/propertyEditor/BasePropertyEditor","sap/ui/integration/designtime/baseEditor/propertyEditor/numberEditor/NumberEditor","sap/ui/core/format/NumberFormat"],function(B,N,a){"use strict";
var I=N.extend("sap.ui.integration.designtime.baseEditor.propertyEditor.integerEditor.IntegerEditor",{
invalidInputError:"BASE_EDITOR.INTEGER.INVALID_BINDING_OR_INTEGER",
renderer:B.getMetadata().getRenderer().render
});
I.prototype.getDefaultValidators=function(){return Object.assign({},B.prototype.getDefaultValidators.call(this),{isInteger:{type:"isInteger"}});};
I.configMetadata=Object.assign({},N.configMetadata);
I.prototype.validateNumber=function(v){return N.prototype.validateNumber.call(this,v)&&Number.isInteger(v);};
I.prototype.getFormatterInstance=function(){return a.getIntegerInstance();};
return I;});
sap.ui.predefine('sap/ui/integration/designtime/baseEditor/propertyEditor/jsonEditor/JsonEditor',["sap/ui/integration/designtime/baseEditor/propertyEditor/BasePropertyEditor","sap/ui/core/Fragment"],function(B,F){"use strict";
var J=B.extend("sap.ui.integration.designtime.baseEditor.propertyEditor.jsonEditor.JsonEditor",{
xmlFragment:"sap.ui.integration.designtime.baseEditor.propertyEditor.jsonEditor.JsonEditor",
_onLiveChange:function(){var i=this.getContent();var j=this._parseJson(i.getValue());if(j instanceof Error){i.setValueState("Error");i.setValueStateText("Error: "+j);}else{i.setValueState("None");this.setValue(j);}},
_parseJson:function(j){try{var p=JSON.parse(j);return p;}catch(e){return e;}},
_openJsonEditor:function(){if(!this._oDialog){return F.load({name:"sap.ui.integration.designtime.baseEditor.propertyEditor.jsonEditor.JsonEditorDialog",controller:this}).then(function(d){this._oDialog=d;this._oErrorMsg=this._oDialog.getContent()[0];this._oEditor=this._oDialog.getContent()[1];this._oEditor._getEditorInstance().getSession().on("changeAnnotation",this.onShowError.bind(this));this._oDialog.attachAfterOpen(function(){this._oEditor._getEditorInstance().focus();this._oEditor._getEditorInstance().navigateFileEnd();},this);this.addDependent(this._oDialog);this._openDialog();return this._oDialog;}.bind(this));}else{this._openDialog();return Promise.resolve(this._oDialog);}},
_openDialog:function(){var i=this.getContent().getValue();try{var c=JSON.stringify(JSON.parse(i),0,"\t");this._oEditor.setValue(c);}catch(e){this._oEditor.setValue(i);}this._oDialog.open();},
onClose:function(){this._oCode=null;this._oDialog.close();},
onBeautify:function(){try{var b=JSON.stringify(JSON.parse(this._oEditor.getValue()),0,"\t");this._oEditor.setValue(b);}finally{return;}},
onLiveChange:function(e){try{this._oCode=JSON.parse(e.getParameter("value"));this._oDialog.getBeginButton().setEnabled(true);}catch(a){this._oDialog.getBeginButton().setEnabled(false);}},
onShowError:function(){var e=(this._oEditor._getEditorInstance().getSession().getAnnotations()||[]).map(function(E){return"Line "+String(E.row)+": "+E.text;}).join("\n");this._oErrorMsg.setText(e);this._oErrorMsg.setVisible(!!e);},
onSave:function(){var i=this.getContent();if(this._oCode){this.setValue(this._oCode);i.setValueState("None");i.setValue(JSON.stringify(this._oCode));}this._oDialog.close();},
renderer:B.getMetadata().getRenderer().render
});
J.configMetadata=Object.assign({},B.configMetadata);return J;});
sap.ui.predefine('sap/ui/integration/designtime/baseEditor/propertyEditor/listEditor/ListEditor',["sap/ui/integration/designtime/baseEditor/propertyEditor/BasePropertyEditor","sap/ui/integration/designtime/baseEditor/validator/IsValidBinding"],function(B,I){"use strict";
var L=B.extend("sap.ui.integration.designtime.baseEditor.propertyEditor.listEditor.ListEditor",{
xmlFragment:"sap.ui.integration.designtime.baseEditor.propertyEditor.listEditor.ListEditor",
renderer:B.getMetadata().getRenderer().render
});
L.prototype.onFragmentReady=function(){this.attachValueChange(function(){this.getContent().setValue("");}.bind(this));};
L.prototype.getDefaultValidators=function(){return Object.assign({},B.prototype.getDefaultValidators.call(this),{isUniqueList:{type:"isUniqueList"},isStringList:{type:"isStringList"}});};
L.configMetadata=Object.assign({},B.configMetadata);
L.prototype._onTokenUpdate=function(e){this._setTokens(e.getParameter("addedTokens").map(function(t){return t.getText();}),e.getParameter("removedTokens").map(function(t){return t.getText();}));};
L.prototype._onTokenSubmission=function(e){this._setTokens([e.getParameter("value")],[]);};
L.prototype._onLiveChange=function(e){var v=e.getParameter("newValue");this._validateInput(v);};
L.prototype._setTokens=function(a,r){var v=(this.getValue()||[]).filter(function(t){return r.indexOf(t)<0;});var n=v.concat(a);this.setValue(n);};
L.prototype._validateInput=function(t){this.setInputState(!I.validate(t),this.getI18nProperty(I.errorMessage));};
return L;});
sap.ui.predefine('sap/ui/integration/designtime/baseEditor/propertyEditor/mapEditor/MapEditor',["sap/ui/integration/designtime/baseEditor/propertyEditor/BasePropertyEditor","sap/base/util/deepClone","sap/base/util/deepEqual","sap/ui/model/json/JSONModel","sap/base/util/restricted/_merge","sap/base/util/restricted/_omit","sap/base/util/isPlainObject","sap/base/util/includes"],function(B,d,c,J,_,e,i,f){"use strict";var S={"string":"BASE_EDITOR.MAP.TYPES.STRING","boolean":"BASE_EDITOR.MAP.TYPES.BOOLEAN","number":"BASE_EDITOR.MAP.TYPES.NUMBER","integer":"BASE_EDITOR.MAP.TYPES.INTEGER","date":"BASE_EDITOR.MAP.TYPES.DATE","datetime":"BASE_EDITOR.MAP.TYPES.DATETIME"};
var M=B.extend("sap.ui.integration.designtime.baseEditor.propertyEditor.mapEditor.MapEditor",{
xmlFragment:"sap.ui.integration.designtime.baseEditor.propertyEditor.mapEditor.MapEditor",
init:function(){B.prototype.init.apply(this,arguments);this._itemsModel=new J();this._itemsModel.setDefaultBindingMode("OneWay");this.setModel(this._itemsModel,"itemsModel");this._supportedTypesModel=new J();this._supportedTypesModel.setDefaultBindingMode("OneWay");this.setModel(this._supportedTypesModel,"supportedTypes");this.attachModelContextChange(function(){if(this.getModel("i18n")){var r=this.getModel("i18n").getResourceBundle();this._aSupportedTypes=Object.keys(S).map(function(k){return{key:k,label:r.getText(S[k])};});this._setSupportedTypesModel();}},this);this.attachConfigChange(this._setSupportedTypesModel,this);this._mTypes={};},
setValue:function(v){v=i(v)?v:{};var p=this._getPositions(v);this.setDesigntimeMetadata(_({},this.getDesigntimeMetadata(),Object.keys(p).reduce(function(n,k){n[k]={__value:{position:p[k]}};return n;},{})));B.prototype.setValue.call(this,v);var I=this._processValue(v);I=I.sort(function(V,o){return p[V.key]-p[o.key];}).map(function(o,a){o.index=a;o.total=I.length;return o;});this._itemsModel.setData(I);},
_processValue:function(v){return Object.keys(v).map(function(k){var F=this._prepareInputValue(v[k],k);this._mTypes[k]=F.type;var I={key:k,value:F,designtime:this.getNestedDesigntimeMetadata(k)};return this.getConfig().includeInvalidEntries||this._isValidItem(I,d(v[k]))?I:undefined;},this).filter(Boolean);},
_getPositions:function(v){var k=Object.keys(v);var E=k.map(function(K){var a=this.getNestedDesigntimeMetadataValue(K).position;return a>=0?a:-1;}.bind(this));var n=E.reduce(function(a,b){return Math.max(a,b);},-1);var p={};E.forEach(function(a,b){p[k[b]]=a>=0?a:++n;});return p;},
_prepareInputValue:function(v,k){var F=this.processInputValue(d(v),k);if(!F.type){F.type=this._mTypes[k]||this._getDefaultType(F.value);}return F;},
_isValidItem:function(I){var t=I.value.type;return t&&f(this._getAllowedTypes(),t);},
_getDefaultType:function(v){var a=this._getAllowedTypes();var t=typeof v;var C=f(a,t)?t:undefined;if(!C&&f(a,"string")){C="string";}return C;},
_getAllowedTypes:function(){return(this.getConfig()||M.configMetadata).allowedTypes;},
_setSupportedTypesModel:function(){var a=this._getAllowedTypes();this._supportedTypesModel.setData(this._aSupportedTypes.filter(function(s){return f(a,s.key);}));},
formatItemConfig:function(C){var k=C.key;var t=C.value.type;var v=C.value.value;var o=this.getConfig();return[{label:this.getI18nProperty("BASE_EDITOR.MAP.KEY"),path:"key",value:k,type:"string",enabled:o.allowKeyChange,itemKey:k,allowBindings:false,validators:[{type:"isUniqueKey",config:{keys:function(){return Object.keys(this.getValue());}.bind(this),currentKey:function(p){return p.getValue();}}}]},{label:this.getI18nProperty("BASE_EDITOR.MAP.TYPE"),path:"type",value:t,type:"select",items:this._getAllowedTypes().map(function(k){return{key:k,title:this.getI18nProperty(S[k])};}.bind(this)),visible:o.allowTypeChange,itemKey:k,allowBindings:false},{label:this.getI18nProperty("BASE_EDITOR.MAP.VALUE"),path:"value",value:v,type:t,itemKey:k}];},
getExpectedWrapperCount:function(v){return this._processValue(v).length;},
processInputValue:function(v){return{value:v};},
processOutputValue:function(v){return v.value;},
_onRemoveElement:function(E){var k=E.getSource().getBindingContext("itemsModel").getObject().key;var v=this.getValue();this.setValue(e(v,k));var n=d(this.getDesigntimeMetadata());delete n[k];this.setDesigntimeMetadata(n);},
_onAddElement:function(){var p=_({},this.getValue());var k=this._getUniqueKey(p);p[k]=this.processOutputValue(this._getItemTemplate());this.setValue(p);},
_moveUp:function(E){var I=E.getSource().data("index");if(I>0){var v=this._itemsModel.getData();this._swapPositions(v[I].key,v[I-1].key);}},
_moveDown:function(E){var I=E.getSource().data("index");var v=this._itemsModel.getData();if(I<v.length-1){this._swapPositions(v[I].key,v[I+1].key);}},
_swapPositions:function(k,K){var n={};n[k]={__value:{position:this.getNestedDesigntimeMetadataValue(K).position}};n[K]={__value:{position:this.getNestedDesigntimeMetadataValue(k).position}};this.setDesigntimeMetadata(_({},this.getDesigntimeMetadata(),n));this.setValue(this.getValue());},
_getItemTemplate:function(){return{value:"",type:"string"};},
_isNewItem:function(I){return c(I.value,this._prepareInputValue(this.processOutputValue(this._getItemTemplate())));},
_getUniqueKey:function(p){var k="key";var I=0;while(p.hasOwnProperty(k)){k="key"+ ++I;}return k;},
_propertyEditorsChange:function(E){var p=E.getParameter("previousPropertyEditors");var P=E.getParameter("propertyEditors");if(Array.isArray(p)){p.forEach(function(o){o.detachValueChange(this._onItemChange,this);},this);}if(Array.isArray(P)){P.forEach(function(o){o.attachValueChange(this._onItemChange,this);},this);}},
_onItemChange:function(E){var k=E.getSource().getConfig().itemKey;var C=E.getParameter("path");var h=this.getItemChangeHandlers()[C];if(typeof h!=='function'){h=this._onFieldChange;}h.call(this,k,E);},
getItemChangeHandlers:function(){return{"key":this._onKeyChange,"type":this._onTypeChange};},
_onKeyChange:function(o,E){if(E.getParameter("previousValue")===undefined){return;}var a=_({},this.getValue());var n=E.getParameter("value");if(n!==o){var N={};Object.keys(a).forEach(function(I){var s=I===o?n:I;N[s]=a[I];});this._mTypes[n]=this._mTypes[o];delete this._mTypes[o];this.setValue(N);var D=_({},this.getConfig().designtime);if(D.hasOwnProperty(o)){D[n]=D[o];delete D[o];this.setDesigntimeMetadata(D);}}},
_onTypeChange:function(k,E){if(E.getParameter("previousValue")===undefined){return;}var o=_({},this.getValue());var n=E.getParameter("value");var I=this.processInputValue(o[k]);I.type=n;o[k]=this.processOutputValue(I);this._mTypes[k]=n;this.setValue(o);},
_onFieldChange:function(k,E){var o=_({},this.getValue());var p=E.getParameter("path");var v=E.getParameter("value");var I=this.processInputValue(o[k]);I[p]=v;o[k]=this.processOutputValue(I);this.setValue(o);},
renderer:B.getMetadata().getRenderer().render
});
M.configMetadata=Object.assign({},B.configMetadata,{allowKeyChange:{defaultValue:true,mergeStrategy:"mostRestrictiveWins"},allowTypeChange:{defaultValue:true,mergeStrategy:"mostRestrictiveWins"},allowAddAndRemove:{defaultValue:true,mergeStrategy:"mostRestrictiveWins"},allowedTypes:{defaultValue:["string"],mergeStrategy:"intersection"},allowSorting:{defaultValue:true,mergeStrategy:"mostRestrictiveWins"},includeInvalidEntries:{defaultValue:true,mergeStrategy:"mostRestrictiveWins"}});return M;});
sap.ui.predefine('sap/ui/integration/designtime/baseEditor/propertyEditor/numberEditor/NumberEditor',["sap/ui/integration/designtime/baseEditor/propertyEditor/BasePropertyEditor","sap/ui/integration/designtime/baseEditor/util/isValidBindingString","sap/base/util/restricted/_isNil","sap/ui/core/format/NumberFormat"],function(B,i,_,N){"use strict";
var a=B.extend("sap.ui.integration.designtime.baseEditor.propertyEditor.numberEditor.NumberEditor",{
xmlFragment:"sap.ui.integration.designtime.baseEditor.propertyEditor.numberEditor.NumberEditor",
invalidInputError:"BASE_EDITOR.NUMBER.INVALID_BINDING_OR_NUMBER",
renderer:B.getMetadata().getRenderer().render
});
a.prototype.getDefaultValidators=function(){return Object.assign({},B.prototype.getDefaultValidators.call(this),{isNumber:{type:"isNumber"}});};
a.configMetadata=Object.assign({},B.configMetadata);
a.prototype.formatValue=function(v){if(_(v)||i(v,false)){return v;}var n=parseFloat(v);if(!this.validateNumber(n)){return v;}return this.getFormatterInstance().format(n);};
a.prototype._onLiveChange=function(e){var n=this._parseLocalized(e.getParameter("newValue"));B.prototype.setValue.call(this,n);};
a.prototype.validateNumber=function(v){return!isNaN(v);};
a.prototype.getFormatterInstance=function(){return N.getFloatInstance();};
a.prototype._parseLocalized=function(v){if(!v||i(v,false)){return v;}var n=this.getFormatterInstance().parse(v);return n;};
return a;});
sap.ui.predefine('sap/ui/integration/designtime/baseEditor/propertyEditor/selectEditor/SelectEditor',["sap/ui/integration/designtime/baseEditor/propertyEditor/BasePropertyEditor","sap/ui/integration/designtime/baseEditor/util/isValidBindingString"],function(B,i){"use strict";
var S=B.extend("sap.ui.integration.designtime.baseEditor.propertyEditor.selectEditor.SelectEditor",{
xmlFragment:"sap.ui.integration.designtime.baseEditor.propertyEditor.selectEditor.SelectEditor",
renderer:B.getMetadata().getRenderer().render
});
S.configMetadata=Object.assign({},B.configMetadata,{allowBindings:{defaultValue:true,mergeStrategy:"mostRestrictiveWins"},allowCustomValues:{defaultValue:false,mergeStrategy:"mostRestrictiveWins",mostRestrictiveValue:true}});
S.prototype.getDefaultValidators=function(){var c=this.getConfig();return Object.assign({},B.prototype.getDefaultValidators.call(this),{isValidBinding:{type:"isValidBinding",isEnabled:c.allowBindings},notABinding:{type:"notABinding",isEnabled:!c.allowBindings},isSelectedKey:{type:"isSelectedKey",config:{keys:function(p){return p.getConfig().items.map(function(I){return I.key;});}},isEnabled:!c.allowCustomValues}});};
S.prototype._onChange=function(){var c=this.getContent();var s=c.getSelectedKey();var v=c.getValue();this.setValue(s||v);};
S.prototype._getItemTitle=function(v){var I=this.getConfig()&&this.getConfig().items||[];var s=I.find(function(o){return o.key===v;});return(s||{}).title||v;};
return S;});
sap.ui.predefine('sap/ui/integration/designtime/baseEditor/propertyEditor/stringEditor/StringEditor',["sap/ui/integration/designtime/baseEditor/propertyEditor/BasePropertyEditor","sap/base/util/restricted/_isNil","sap/base/util/isPlainObject"],function(B,_,i){"use strict";
var S=B.extend("sap.ui.integration.designtime.baseEditor.propertyEditor.stringEditor.StringEditor",{
xmlFragment:"sap.ui.integration.designtime.baseEditor.propertyEditor.stringEditor.StringEditor",
renderer:B.getMetadata().getRenderer().render
});
S.configMetadata=Object.assign({},B.configMetadata,{enabled:{defaultValue:true,mergeStrategy:"mostRestrictiveWins"},allowBindings:{defaultValue:true,mergeStrategy:"mostRestrictiveWins"}});
S.prototype.getDefaultValidators=function(){var c=this.getConfig();return Object.assign({},B.prototype.getDefaultValidators.call(this),{isValidBinding:{type:"isValidBinding",isEnabled:c.allowBindings},notABinding:{type:"notABinding",isEnabled:!c.allowBindings},maxLength:{type:"maxLength",isEnabled:typeof c.maxLength==="number",config:{maxLength:c.maxLength}}});};
S.prototype.setValue=function(v){if(!_(v)&&!i(v)){arguments[0]=v.toString();}B.prototype.setValue.apply(this,arguments);};
S.prototype._onLiveChange=function(){var I=this.getContent();this.setValue(I.getValue());};
return S;});
sap.ui.predefine('sap/ui/integration/designtime/baseEditor/util/BaseDefaultValidatorModules',["sap/ui/integration/designtime/baseEditor/validator/NotABinding","sap/ui/integration/designtime/baseEditor/validator/IsValidBinding","sap/ui/integration/designtime/baseEditor/validator/IsSelectedKey","sap/ui/integration/designtime/baseEditor/validator/IsUniqueKey","sap/ui/integration/designtime/baseEditor/validator/IsNumber","sap/ui/integration/designtime/baseEditor/validator/IsInteger","sap/ui/integration/designtime/baseEditor/validator/IsBoolean","sap/ui/integration/designtime/baseEditor/validator/IsDate","sap/ui/integration/designtime/baseEditor/validator/IsStringList","sap/ui/integration/designtime/baseEditor/validator/IsUniqueList","sap/ui/integration/designtime/baseEditor/validator/MaxLength","sap/ui/integration/designtime/baseEditor/validator/IsPatternMatch"],function(N,I,a,b,c,d,e,f,g,h,M,i){"use strict";return{"notABinding":N,"isValidBinding":I,"isSelectedKey":a,"isUniqueKey":b,"isNumber":c,"isInteger":d,"isBoolean":e,"isDate":f,"isUniqueList":h,"isStringList":g,"maxLength":M,"pattern":i};});
sap.ui.predefine('sap/ui/integration/designtime/baseEditor/util/StylesheetManager',["sap/ui/dom/includeStylesheet","sap/base/util/uid"],function(i,u){"use strict";var S="SUCCESS";var a="FAIL";var b="PENDING";var s={};
function l(F){var C={id:u(),status:b,counter:1};var p=new Promise(function(r,R){i(F,C.id,r,R);}).then(function(){var C=s[F];if(C.counter===0){d(F);}else{f(F,S);}}).catch(function(){f(F,a);return Promise.reject("File not found or some other network issue happened.");});C.promise=p;s=Object.assign({},s);s[F]=C;return C.promise;}
function d(F){var m=Object.assign({},s);var C=m[F];var E=document.getElementById(C.id);if(E&&E.parentNode){E.parentNode.removeChild(E);}delete m[F];s=m;}
function c(F){var D={};D[F]=Object.assign({},s[F]);D[F].counter++;s=Object.assign({},s,D);return s[F];}
function e(F){var D={};D[F]=Object.assign({},s[F]);D[F].counter--;s=Object.assign({},s,D);return s[F];}
function f(F,h){var D={};D[F]=Object.assign({},s[F]);D[F].status=h;s=Object.assign({},s,D);return s[F];}
function g(m){return sap.ui.require.toUrl(m)+".css";}
return{add:function(m){var F=g(m);var h=s[F];if(h){c(F);return h.promise;}return l(F);},remove:function(m){var F=g(m);var C=s[F];if(C){var U=e(F);if(U.counter===0&&U.status===S){d(F);}}}};});
sap.ui.predefine('sap/ui/integration/designtime/baseEditor/util/binding/ObjectBinding',["sap/ui/base/ManagedObject","sap/base/util/deepClone","sap/base/util/ObjectPath","sap/base/util/isPlainObject","sap/ui/base/BindingParser","sap/base/util/includes","sap/base/util/deepEqual"],function(M,d,O,i,B,a,b){"use strict";
var c=M.extend("sap.ui.integration.designtime.baseEditor.util.ObjectBinding",{
metadata:{properties:{object:{type:"object"},_value:{type:"any",hidden:true}},events:{change:{parameters:{path:{type:"string"},value:{type:"any"}}}}},
_originalObject:null
});
c.prototype.init=function(){this._aIgnoreList=[];this._oModelMap={};};
c.prototype.exit=function(){this._cleanup();};
c.prototype.setObject=function(o){this._setOriginalObject(o);this._init();return this;};
c.prototype._setObject=function(o){var C=d(o,50);return this.setProperty("object",C);};
c.prototype._setOriginalObject=function(o){this._originalObject=d(o,50);};
c.prototype._getOriginalObject=function(){return this._originalObject;};
c.prototype.setModel=function(m,n){var e=false;var E=Object.keys(this.oModels||{}).find(function(s){if(this.oModels[s]===m){e=true;return true;}return false;}.bind(this));this._oModelMap[n]=e?this._oModelMap[E]:n;var r=M.prototype.setModel.apply(this,arguments);this._init();return r;};
c.prototype.setBindingContext=function(){var r=M.prototype.setBindingContext.apply(this,arguments);this._init();return r;};
c.prototype._init=function(){this._cleanup();var o=this._getOriginalObject();if(o){this._setObject(o);this._createPropertyBindings(o);}};
c.prototype._cleanup=function(){if(this._mSimpleBindings){Object.keys(this._mSimpleBindings).forEach(function(k){var o=this._mSimpleBindings[k].binding;o.getModel().removeBinding(o);o.destroy();}.bind(this));}this._mSimpleBindings={};};
c.prototype._createPropertyBindings=function(o,p){Object.keys(o).filter(function(k){return!this.isIgnored(k);},this).forEach(function(k){var C=p?p+"/"+k:k;if(typeof o[k]==="string"){var e=B.complexParser(o[k]);if(e){if(e.parts){if(!e.parts.find(function(P){return!this.getModel(P.model);}.bind(this))){e.parts.forEach(function(P){this._createSimpleBinding(P,C,e);}.bind(this));}else{return;}}else if(this.getModel(e.model)){this._createSimpleBinding(e,C,e);}else{return;}this._updateValue([{path:C,bindingInfo:e}]);}}else if(o[k]&&(i(o[k])||Array.isArray(o[k]))){this._createPropertyBindings(o[k],C);}},this);};
c.prototype._updateValue=function(v){var C=[];v.forEach(function(u){var o=this.getObject();var p=u.path.split("/");var k=p.pop();if(p.length){o=O.get(p,o);}this.bindProperty("_value",d(u.bindingInfo));var V=d(this.getProperty("_value"));this.unbindProperty("_value");if(V!==o[k]&&(k!=="value"||!(o.value===undefined&&b(V,o.defaultValue)))){o[k]=V;C.push({path:u.path,value:V});}}.bind(this));if(C.length){this.fireChange({changes:C});}};
c.prototype._createSimpleBinding=function(s,C,o){var e=this.getBindingContext(s.model);var m=this._oModelMap[s.model];var f=this.oModels[s.model];var A=f.resolve(s.path,e);var h=m+">"+A;var g=this._mSimpleBindings[h];if(!g){g=this.getModel(s.model).bindProperty(s.path,e);this._mSimpleBindings[h]={binding:g,properties:[]};g.attachChange(function(){this._updateValue(this._mSimpleBindings[h].properties);}.bind(this));}this._mSimpleBindings[h].properties.push({path:C,bindingInfo:o});return g;};
c.prototype.addToIgnore=function(k){this._aIgnoreList=this._aIgnoreList.concat(k);this._init();};
c.prototype.removeFromIgnore=function(k){this._aIgnoreList=this._aIgnoreList.filter(function(I){return I!==k;});this._init();};
c.prototype.isIgnored=function(k){return a(this._aIgnoreList,k);};
return c;});
sap.ui.predefine('sap/ui/integration/designtime/baseEditor/util/binding/resolveBinding',["sap/ui/integration/designtime/baseEditor/util/binding/ObjectBinding"],function(O){"use strict";return function(j,m,c,i){var o=new O();c=c||{};i=i||[];i.forEach(function(p){o.addToIgnore(p);});Object.keys(m).forEach(function(k){o.setModel(m[k],k===""?undefined:k);});Object.keys(c).forEach(function(k){o.setBindingContext(c[k],k===""?undefined:k);});o.setObject(j);var r=o.getObject();o.destroy();return r;};});
sap.ui.predefine('sap/ui/integration/designtime/baseEditor/util/cleanupDesigntimeMetadata',["sap/base/util/restricted/_isNil","sap/base/util/each","sap/base/util/isPlainObject","sap/base/util/isEmptyObject"],function(_,e,i,a){"use strict";
function c(o){e(o,function(k,v){if(i(v)){c(v);}if(_(v)||Array.isArray(v)&&v.length===0||i(v)&&a(v)){delete o[k];}});}
return c;});
sap.ui.predefine('sap/ui/integration/designtime/baseEditor/util/createPromise',function(){"use strict";return function(f){var c=false;var C;var a;var b;var p=new Promise(function(r,R){f(function(){if(!c){r.apply(this,arguments);}else if(a){a.apply(this,arguments);}},function(){if(!c){R.apply(this,arguments);}else if(b){b.apply(this,arguments);}});});return{promise:p,cancel:function(){c=true;if(!C){C=new Promise(function(r,R){a=r;b=R;});}return C;}};};});
sap.ui.predefine('sap/ui/integration/designtime/baseEditor/util/escapeParameter',["sap/base/util/isPlainObject","sap/base/util/each"],function(i,e){"use strict";return function(a,v){v=v||function(){return true;};var A=Array.from(a);var s=typeof A[0]!=="string"&&A[0]!==undefined?0:1;if(i(A[s])){var S=Object.assign({},A[s]);e(S,function(k,V){if(i(V)&&v(V,k)){S[k]=Object.assign({},V,{ui5object:true});}});A[s]=S;}return A;};});
sap.ui.predefine('sap/ui/integration/designtime/baseEditor/util/findClosestInstance',function(){"use strict";return function(c,C){function f(c){if(c){if(c.isA(C)){return c;}else{return f(c.getParent());}}}return f(c);};});
sap.ui.predefine('sap/ui/integration/designtime/baseEditor/util/hasTag',["sap/base/util/restricted/_intersection"],function(_){"use strict";return function hasTag(c,t){var T=[].concat(t);return(Array.isArray(c.tags)&&_(T,c.tags).length===T.length);};});
sap.ui.predefine('sap/ui/integration/designtime/baseEditor/util/isTemplate',function(){"use strict";
function i(c,a){var p=c.sParentAggregationName;var P=c.getParent();if(a&&P===a){return false;}if(P&&p){var b=P.getBindingInfo(p);if(b&&c instanceof b.template.getMetadata().getClass()){return false;}else{return i(P,a);}}return true;}
return i;});
sap.ui.predefine('sap/ui/integration/designtime/baseEditor/util/isValidBindingString',["sap/ui/base/BindingParser"],function(B){"use strict";
function i(I,a){var p;try{var e=I.replace(/{{([^{]*)}}/g,function(f,s){if(i(s)){return"${}";}throw"Invalid binding string";});p=B.complexParser(e);}catch(E){return false;}return a!==false?true:!!p;}
return i;});
sap.ui.predefine('sap/ui/integration/designtime/baseEditor/util/unset',["sap/base/util/ObjectPath","sap/base/util/isPlainObject","sap/base/util/isEmptyObject"],function(O,i,a){"use strict";
function u(o,p,m){var c=p.slice(0,-1);var C=c.length>0?O.get(c,o):o;var k=p[p.length-1];if(Array.isArray(C)){C.splice(k,1);}else{delete C[k];}return(c.length>0&&!(m<=0)&&((Array.isArray(C)&&C.length===0)||(i(C)&&a(C)))?u(o,c,m?m-1:undefined):o);}
return u;});
sap.ui.predefine('sap/ui/integration/designtime/baseEditor/validator/IsBoolean',["sap/ui/integration/designtime/baseEditor/validator/IsValidBinding","sap/base/util/restricted/_isNil"],function(I,_){"use strict";return{async:false,errorMessage:"BASE_EDITOR.VALIDATOR.NOT_A_BOOLEAN",validate:function(v){return _(v)||typeof v==="boolean"||I.validate(v,{allowPlainStrings:false});}};});
sap.ui.predefine('sap/ui/integration/designtime/baseEditor/validator/IsDate',["sap/ui/integration/designtime/baseEditor/validator/IsValidBinding"],function(I){"use strict";return{async:false,errorMessage:"BASE_EDITOR.VALIDATOR.INVALID_DATE",validate:function(d){var D=new Date(d);return d===undefined||I.validate(d,{allowPlainStrings:false})||(D&&!isNaN(new Date(D).getTime()));}};});
sap.ui.predefine('sap/ui/integration/designtime/baseEditor/validator/IsInteger',["sap/ui/integration/designtime/baseEditor/validator/IsValidBinding"],function(I){"use strict";return{async:false,errorMessage:"BASE_EDITOR.VALIDATOR.NOT_AN_INTEGER",validate:function(v){return v===undefined||I.validate(v,{allowPlainStrings:false})||(!isNaN(v)&&Number.isInteger(v));}};});
sap.ui.predefine('sap/ui/integration/designtime/baseEditor/validator/IsNumber',["sap/ui/integration/designtime/baseEditor/validator/IsValidBinding"],function(I){"use strict";return{async:false,errorMessage:"BASE_EDITOR.VALIDATOR.NOT_A_NUMBER",validate:function(v){return v===undefined||I.validate(v,{allowPlainStrings:false})||!isNaN(v);}};});
sap.ui.predefine('sap/ui/integration/designtime/baseEditor/validator/IsPatternMatch',["sap/ui/integration/designtime/baseEditor/validator/IsValidBinding"],function(I){"use strict";return{async:false,errorMessage:"BASE_EDITOR.VALIDATOR.FAILED_PATTERN_TEST",validate:function(v,c){var m=c.modifiers||"";var r=new RegExp(c.pattern,m);var e=c.exactMatch!==false;if(v===undefined){return true;}var i;if(e){var M=v.match(r);i=M&&v===M[0];}else{i=r.test(v);}return i||I.validate(v,{allowPlainStrings:false});}};});
sap.ui.predefine('sap/ui/integration/designtime/baseEditor/validator/IsSelectedKey',["sap/ui/integration/designtime/baseEditor/validator/IsValidBinding"],function(I){"use strict";return{async:false,errorMessage:"BASE_EDITOR.VALIDATOR.FORBIDDEN_CUSTOM_VALUE",validate:function(v,c){return v===undefined||(c.keys||[]).includes(v)||I.validate(v,{allowPlainStrings:false});}};});
sap.ui.predefine('sap/ui/integration/designtime/baseEditor/validator/IsStringList',["sap/ui/integration/designtime/baseEditor/validator/IsValidBinding"],function(I){"use strict";return{async:false,errorMessage:I.errorMessage,validate:function(v){return v===undefined||v.every(function(i){return I.validate(i);});}};});
sap.ui.predefine('sap/ui/integration/designtime/baseEditor/validator/IsUniqueKey',["sap/base/util/includes"],function(i){"use strict";return{async:false,errorMessage:"BASE_EDITOR.VALIDATOR.DUPLICATE_KEY",validate:function(v,c){return(c.currentKey===undefined||!i(c.keys,v)||v===undefined||v===c.currentKey);}};});
sap.ui.predefine('sap/ui/integration/designtime/baseEditor/validator/IsUniqueList',["sap/base/util/restricted/_uniq"],function(_){"use strict";return{async:false,errorMessage:"BASE_EDITOR.VALIDATOR.DUPLICATE_ENTRY",validate:function(v){return v===undefined||v.length===_(v).length;}};});
sap.ui.predefine('sap/ui/integration/designtime/baseEditor/validator/IsValidBinding',["sap/ui/integration/designtime/baseEditor/util/isValidBindingString"],function(i){"use strict";return{async:false,errorMessage:"BASE_EDITOR.VALIDATOR.INVALID_BINDING",validate:function(v,c){var a=(c||{}).allowPlainStrings!==false;return v===undefined||v===""||i(v.toString(),a);}};});
sap.ui.predefine('sap/ui/integration/designtime/baseEditor/validator/MaxLength',["sap/ui/integration/designtime/baseEditor/validator/IsValidBinding","sap/base/util/restricted/_isNil"],function(I,_){"use strict";return{async:false,errorMessage:{message:"BASE_EDITOR.VALIDATOR.MAX_LENGTH",placeholders:function(c){return[c.maxLength];}},validate:function(v,c){return _(v)||(typeof v==="string"&&v.length<=c.maxLength)||I.validate(v,{allowPlainStrings:false});}};});
sap.ui.predefine('sap/ui/integration/designtime/baseEditor/validator/NotABinding',["sap/ui/integration/designtime/baseEditor/util/isValidBindingString"],function(i){"use strict";return{async:false,errorMessage:"BASE_EDITOR.VALIDATOR.FORBIDDEN_BINDING",validate:function(v){return!i(v,false);}};});
sap.ui.predefine('sap/ui/integration/designtime/baseEditor/validator/ValidatorRegistry',["sap/base/util/includes","sap/base/util/values","sap/base/util/restricted/_CancelablePromise"],function(i,v,_){"use strict";var V={};var o={};var l={};
V.registerValidators=function(n){Object.keys(n).forEach(function(N){if(!this.hasValidator(N)){l[N]=new _(function(r,a,b){b(function(){delete l[N];});b.shouldReject=false;sap.ui.require([n[N]],r,a);});l[N].then(function(a){o[N]=a;delete l[N];});}}.bind(this));};
V.ready=function(){return Promise.all(v(l));};
V.deregisterValidator=function(n){if(o[n]){delete o[n];}if(l[n]){l[n].cancel();}};
V.deregisterAllValidators=function(){Object.keys(l).forEach(function(n){this.deregisterValidator(n);}.bind(this));o={};};
V.getValidator=function(n){var a=o[n];if(!a){throw new Error("Validator "+n+" was not registered.");}return a;};
V.hasValidator=function(n){return i(Object.keys(o),n);};
V.isRegistered=function(n){return i(Object.keys(l),n);};
return V;});
sap.ui.predefine('sap/ui/integration/designtime/cardEditor/CardEditor',["sap/base/util/restricted/_CancelablePromise","sap/base/util/restricted/_isEqual","sap/base/util/restricted/_omit","sap/base/util/restricted/_toArray","sap/base/util/deepEqual","sap/base/util/each","sap/base/util/merge","sap/base/util/deepClone","sap/base/util/ObjectPath","sap/ui/integration/designtime/baseEditor/BaseEditor","sap/ui/integration/util/CardMerger","sap/ui/thirdparty/jquery","./config/index"],function(C,_,a,b,d,e,m,c,O,B,f,q,D){"use strict";
var g=B.extend("sap.ui.integration.designtime.cardEditor.CardEditor",{
metadata:{properties:{layout:{type:"string",defaultValue:"form"},designtimeChanges:{type:"array",defaultValue:[]}}},
constructor:function(p){p=p||{};B.prototype.constructor.apply(this,arguments);if(!p["config"]){this.addConfig(D,true);}},
renderer:B.getMetadata().getRenderer()
});
function h(o,l,n,K,v){if(!o[l]){o[l]={};}if(!o[l][n]){o[l][n]={};}o[l][n][K]=v;}
function i(J,I){var n="sap.card";var o=O.get([n,"configuration"],J);var l=O.get([n,"configuration"],I);if(d(o,l)){return undefined;}var p={};e(o,function(r,u){e(u,function(N,S){if(!l[r][N]){p[r]=p[r]||{};p[r][N]=S;}else{e(S,function(K,v){if(l[r][N][K]!==v){h(p,r,N,K,v);}});}});});return{configuration:p};}
g.prototype.init=function(){B.prototype.init.apply(this,arguments);this.attachJsonChange(function(E){if(!this._oInitialJson){this._oInitialJson=E.getParameter("json");}},this);};
g.prototype.setJson=function(){B.prototype.setJson.apply(this,arguments);var J=this.getJson();var l=O.get(["sap.app","id"],J);if(this._bDesigntimeInit&&this._bCardId!==l){if(this._oDesigntimePromise){this._oDesigntimePromise.cancel();}delete this._bCardId;delete this._bDesigntimeInit;}if(!this._bDesigntimeInit){this._bDesigntimeInit=true;this._bCardId=l;var n=s(O.get(["sap.card","designtime"],J)||"");var o=s(O.get(["baseURL"],J)||"");if(o&&n){var p={};var S=s(o);p[l]=S;sap.ui.loader.config({paths:p});var r=t(n);var u=l+"/"+r;var E=u+"/editor.config";var v=S+"/"+r+"/metadata.json";this._oDesigntimePromise=new C(function(R){Promise.all([new Promise(function(w){sap.ui.require([E],w,function(){return{};});}),new Promise(function(w){q.getJSON(v).done(w).fail(function(){w({});});})]).then(R);});this._oDesigntimePromise.then(function(w){var x=m({},w[0]);x.i18n=b(x.i18n);x.i18n.push(u+"/i18n.properties");this._addSpecificConfig(m({},x));var y=w[1];y=f.mergeCardDesigntimeMetadata(y,this.getDesigntimeChanges());this._oInitialDesigntimeMetadata=y;this.setDesigntimeMetadata(j(y),true);}.bind(this));}}};
g.prototype.setDesigntimeChanges=function(l){if(this._oInitialDesigntimeMetadata){throw Error("Designtime Changes can only be set initially");}this.setProperty("designtimeChanges",l);};
function j(F){var o={};Object.keys(F).forEach(function(p){O.set(p.split("/"),{__value:c(F[p])},o);});return o;}
function s(p){return p.trim().replace(/\/*$/,"");}
function t(p){return p.replace(/^\.\//,"");}
g.prototype.getChanges=function(p){return Promise.all([this.getDeltaChangeDefinition(p).catch(function(){return;}),this.getDesigntimeChangeDefinition(p).catch(function(){return;})]).then(function(l){if(l[0]===undefined&&l[1]===undefined){return Promise.reject("No changes");}return{runtimeChange:l[0],designtimeChange:l[1]};});};
function k(p){return new Promise(function(r){sap.ui.require(["sap/ui/fl/Change"],function(l){var o=l.createInitialFileContent(p);o.creation=new Date().toISOString();r(o);});});}
g.prototype.getDesigntimeChangeDefinition=function(p){var l=[];var o=Object.assign({},this._oInitialDesigntimeMetadata);var n=this._formatExportedDesigntimeMetadata(this.getDesigntimeMetadata());e(n,function(K,v){if(o.hasOwnProperty(K)){if(!_(o[K],v)){l.push({propertyPath:K,operation:"UPDATE",propertyValue:v});}delete o[K];}else{l.push({propertyPath:K,operation:"INSERT",propertyValue:v});}});e(o,function(K){l.push({propertyPath:K,operation:"DELETE"});});if(!l.length){return Promise.reject("No Change");}this._oInitialDesigntimeMetadata=n;var r=this.getJson();var P=m({},a(p,["oldValue","newValue"]));P.content={entityPropertyChange:l};P.changeType="appdescr_card_designtime";P.generator="CardEditor";P.selector={};P.reference=O.get(["sap.app","id"],r);return k(P);};
g.prototype.getDeltaChangeDefinition=function(p){var o=this.getJson();var P=m({},p);P.content=i(o,this._oInitialJson);if(!P.content){return Promise.reject("No Change");}this._oInitialJson=o;P.changeType=o.hasOwnProperty("sap.card")?"appdescr_card":"appdescr_widget";P.generator="CardEditor";P.selector={};P.reference=O.get(["sap.app","id"],o);return k(P);};
return g;});
sap.ui.predefine('sap/ui/integration/designtime/cardEditor/PropertyEditor',["sap/ui/integration/designtime/baseEditor/PropertyEditor"],function(P){"use strict";return P;});
sap.ui.predefine('sap/ui/integration/designtime/cardEditor/PropertyEditors',["sap/ui/integration/designtime/baseEditor/PropertyEditors"],function(P){"use strict";return P;});
sap.ui.predefine('sap/ui/integration/designtime/cardEditor/config/generateActionConfig',["sap/base/util/restricted/_merge"],function(_){"use strict";return function(c){return _({},{"label":"{i18n>CARD_EDITOR.ACTIONS}","type":"array","itemLabel":"{type}","addItemLabel":"{i18n>CARD_EDITOR.ACTION}","template":{"enabled":{"label":"{i18n>CARD_EDITOR.ACTION.ENABLED}","type":"boolean","defaultValue":true,"path":"enabled"},"type":{"label":"{i18n>CARD_EDITOR.LABEL.TYPE}","type":"select","items":[{"key":"Navigation"}],"path":"type","visible":"{= !!${enabled}}"},"service":{"label":"{i18n>CARD_EDITOR.ACTION.SERVICE}","type":"string","path":"service","visible":false},"parameters":{"label":"{i18n>CARD_EDITOR.PARAMETERS}","type":"map","allowedTypes":["string","number","boolean"],"path":"parameters","visible":"{= !!${enabled}}"},"url":{"label":"{i18n>CARD_EDITOR.LABEL.URL}","type":"string","path":"url","visible":"{= !!${enabled} && ${type} === 'Navigation'}"},"target":{"label":"{i18n>CARD_EDITOR.TARGET}","type":"select","items":[{"key":"_blank","description":"{i18n>CARD_EDITOR.TARGET.BLANK}"},{"key":"_self","description":"{i18n>CARD_EDITOR.TARGET.SELF}"}],"defaultValue":"_blank","path":"target","visible":"{= !!${enabled} && ${type} === 'Navigation' && !!${url}}"}}},c);};});
sap.ui.predefine('sap/ui/integration/designtime/cardEditor/propertyEditor/complexMapEditor/ComplexMapEditor',["sap/ui/integration/designtime/baseEditor/propertyEditor/BasePropertyEditor","sap/base/util/restricted/_omit","sap/base/util/restricted/_merge","sap/base/util/deepClone"],function(B,_,a,d){"use strict";
var C=B.extend("sap.ui.integration.designtime.cardEditor.propertyEditor.complexMapEditor.ComplexMapEditor",{
xmlFragment:"sap.ui.integration.designtime.cardEditor.propertyEditor.complexMapEditor.ComplexMapEditor",
renderer:B.getMetadata().getRenderer().render
});
C.configMetadata=Object.assign({},B.configMetadata,{allowKeyChange:{defaultValue:true,mergeStrategy:"mostRestrictiveWins"},allowAddAndRemove:{defaultValue:true,mergeStrategy:"mostRestrictiveWins"},keyLabel:{defaultValue:"{i18n>CARD_EDITOR.COMPLEX_MAP.KEY}"}});
C.prototype.onFragmentReady=function(){this._oNestedArrayEditor=this.getContent();this._oNestedArrayEditor.attachValueChange(function(e){var p=e.getParameter("previousValue")||[];var v=d(e.getParameter("value")||[]);var n={};var D=this.getDesigntimeProperties();v=v.map(function(V,i){if(typeof V.key==="undefined"){var k="key";var b=0;var c=function(E){return E.key===k;};while(v.some(c)){k="key"+ ++b;}V.key=k;}var o={};D.forEach(function(P){o[P]=d(V[P]);});n[V.key]={__value:o};return _(V,D);});var N=this._processOutputValue(v);p.forEach(function(P){var o=P.key;if(o!==undefined&&!N.hasOwnProperty(o)){n[o]=null;}});this.setValue(N);this.setDesigntimeMetadata(a({},this.getConfig().designtime,n));},this);};
C.prototype._processInputValue=function(v){var D=this.getDesigntimeProperties();if(!v){v={};}var f=Object.keys(v).map(function(k){var F=d(v[k]);F.key=k;var o=this.getNestedDesigntimeMetadataValue(k);D.forEach(function(p){F[p]=o[p];});return F;}.bind(this));return f;};
C.prototype.getDesigntimeProperties=function(){return[];};
C.prototype.onBeforeConfigChange=function(c){var t={};if(c["allowKeyChange"]){t={key:{label:c["keyLabel"],type:"string",path:"key",validators:{uniqueKey:{type:"isUniqueKey",config:{keys:function(){return Object.keys(this.getValue());}.bind(this),currentKey:function(p){return p.getValue();}}}}}};}var A=a({},{template:t,allowSorting:false},c,{type:"array",path:""});if(this.isReady()){this._oNestedArrayEditor.setConfig(A);}else{this.ready().then(function(A){this._oNestedArrayEditor.setConfig(A);}.bind(this,A));}return c;};
C.prototype.setValue=function(v){var f=this._processInputValue(v);if(this.isReady()){this._oNestedArrayEditor.setValue(f);}else{this.ready().then(function(f){this._oNestedArrayEditor.setValue(f);}.bind(this,f));}B.prototype.setValue.call(this,v);};
C.prototype._processOutputValue=function(v){var f={};v.forEach(function(V){f[V.key]=_(V,"key");});return f;};
return C;});
sap.ui.predefine('sap/ui/integration/designtime/cardEditor/propertyEditor/destinationsEditor/DestinationsEditor',["sap/ui/integration/designtime/baseEditor/propertyEditor/BasePropertyEditor","sap/ui/integration/designtime/cardEditor/propertyEditor/complexMapEditor/ComplexMapEditor","sap/base/util/restricted/_merge"],function(B,C,_){"use strict";
var D=C.extend("sap.ui.integration.designtime.cardEditor.propertyEditor.destinationsEditor.DestinationsEditor",{renderer:B.getMetadata().getRenderer().render});
D.configMetadata=Object.assign({},C.configMetadata,{allowedValues:{defaultValue:[],mergeStrategy:"intersection"}});
D.prototype.getDesigntimeProperties=function(){return[].concat(C.prototype.getDesigntimeProperties.call(this),["label"]);};
D.prototype.onBeforeConfigChange=function(c){var o={};if(c["allowKeyChange"]){o={template:{label:{label:this.getI18nProperty("CARD_EDITOR.LABEL"),type:"string",path:"label"},name:{label:this.getI18nProperty("CARD_EDITOR.DESTINATION.NAME"),type:"select",path:"name",items:(c["allowedValues"]||[]).map(function(k){return{key:k};}),allowCustomValues:true,allowBindings:false},defaultUrl:{label:this.getI18nProperty("CARD_EDITOR.DESTINATION.DEFAULT_URL"),type:"string",path:"defaultUrl"}}};}else{o={collapsibleItems:false,showItemLabel:false,template:{name:{label:"{= ${label} || ${key}}",type:"select",path:"name",items:(c["allowedValues"]||[]).map(function(k){return{key:k};}),allowCustomValues:false,allowBindings:false}}};}var a=_({},o,c);return C.prototype.onBeforeConfigChange.call(this,a);};
return D;});
sap.ui.predefine('sap/ui/integration/designtime/cardEditor/propertyEditor/iconEditor/IconEditor',["sap/ui/integration/designtime/baseEditor/propertyEditor/BasePropertyEditor","sap/ui/integration/designtime/baseEditor/util/isValidBindingString","sap/ui/core/Fragment",'sap/ui/unified/ColorPickerPopover','sap/ui/unified/library',"sap/ui/model/json/JSONModel","sap/base/util/deepClone","sap/base/util/isPlainObject","sap/base/util/isEmptyObject","sap/base/util/restricted/_omit","sap/ui/core/IconPool"],function(B,i,F,C,U,J,d,a,b,_,I){"use strict";
var c=B.extend("sap.ui.integration.designtime.cardEditor.propertyEditor.iconEditor.IconEditor",{
xmlFragment:"sap.ui.integration.designtime.cardEditor.propertyEditor.iconEditor.IconEditor",
renderer:B.getMetadata().getRenderer().render
});
var o={config:{type:"simpleicon"},key:"src"};var t={config:{type:"string",maxLength:2,validators:{isAlphabetic:{type:"pattern",config:{pattern:"^[A-Za-z]*$"},errorMessage:"CARD_EDITOR.VALIDATOR.NOT_AN_ALPHABETIC"}}},key:"text"};var p={config:{type:"string"},key:"src"};var D={type:"icon",src:"",shape:"Circle",alt:"",text:"",backgroundColor:"",color:""};var e=U.ColorPickerMode;var f=U.ColorPickerDisplayMode;
c.prototype.init=function(){this._oIconModel=new J(d(D));this._oIconModel.setDefaultBindingMode("OneWay");this.setModel(this._oIconModel,"icon");this._oConfigsModel=new J({selectConfig:{type:"select",items:[],allowBindings:false},valueConfig:o});this._oConfigsModel.setDefaultBindingMode("OneWay");this.setModel(this._oConfigsModel,"configs");this._oSettingsModel=new J({shapes:[],altVisible:true,backgroundColorVisible:false,colorVisible:false});this._oSettingsModel.setDefaultBindingMode("OneWay");this.setModel(this._oSettingsModel,"settings");this.attachModelContextChange(function(){if(this.getModel("i18n")){var h=d(this._oConfigsModel.getData());h.selectConfig.items=[{"key":"icon","title":this.getI18nProperty("BASE_EDITOR.ICON.TYPE_ICON")},{"key":"text","title":this.getI18nProperty("BASE_EDITOR.ICON.SETTINGS_DIALOG_TEXT_LABEL")},{"key":"picture","title":this.getI18nProperty("BASE_EDITOR.ICON.TYPE_PICTURE")}];this._oConfigsModel.setData(h);var j=d(this._oSettingsModel.getData());j.shapes=[{key:"Square",text:this.getI18nProperty("BASE_EDITOR.ICON.SETTINGS_DIALOG_SHAPE_SQUARE")},{key:"Circle",text:this.getI18nProperty("BASE_EDITOR.ICON.SETTINGS_DIALOG_SHAPE_CIRCLE")}];this._oSettingsModel.setData(j);}},this);};
c.prototype.getExpectedWrapperCount=function(){return 2;};
c.prototype.setValue=function(v){var n=b(v)?undefined:v;B.prototype.setValue.call(this,n);this._oIconModel.setData(Object.assign({},this._oIconModel.getData(),v,{type:this.getDesigntimeMetadataValue().type||g(v)}));};
function g(v){if(a(v)){if(v.src){if(v.backgroundColor||v.color||(I.isIconURI(v.src)&&!!I.getIconInfo(v.src))||i(v.src,false)){return"icon";}else{return"picture";}}else if(v.text){return"text";}}return D.type;}
c.prototype._prepareValue=function(k,h){return h[k];};
c.prototype._onTypeChange=function(E){var h;var T=E.getSource().getValue();switch(T){case"icon":h=o;this._oSettingsModel.setProperty("/altVisible",true);break;case"text":h=t;this._oSettingsModel.setProperty("/altVisible",false);break;case"picture":h=p;this._oSettingsModel.setProperty("/altVisible",true);break;}this._oConfigsModel.setData(Object.assign({},this._oConfigsModel.getData(),{valueConfig:h}));this.setDesigntimeMetadataValue({type:T});this.setValue(this._processOutputValue(this._oIconModel.getData()));};
c.prototype._updateValue=function(E){var k=this._oConfigsModel.getData().valueConfig.key;var n={};n[k]=E.getSource().getValue();var N=Object.assign({},this._oIconModel.getData(),n);this.setValue(this._processOutputValue(N));};
c.prototype._handleSettings=function(){this._oOldData=d(this.getModel("icon").getData());if(!this._oSettingsDialog){return F.load({name:"sap.ui.integration.designtime.cardEditor.propertyEditor.iconEditor.IconEditorSettingsDialog",controller:this}).then(function(h){this._oDialogModel=new J(this._oOldData);this._oSettingsDialog=h;this._oSettingsDialog.setModel(this._oDialogModel,"data");this.addDependent(this._oSettingsDialog);this._oSettingsDialog.open();return this._oSettingsDialog;}.bind(this));}else{this._oSettingsDialog.open();this._oDialogModel.setData(this._oOldData);return Promise.resolve(this._oSettingsDialog);}};
c.prototype._onSettingsSave=function(){this._oSettingsDialog.close();this.setValue(this._processOutputValue(this._oDialogModel.getData()));};
c.prototype._onSettingsCancel=function(){this._oSettingsDialog.close();};
c.prototype._processOutputValue=function(v){var T=this.getDesigntimeMetadataValue().type;var O=["type"];Object.keys(v).forEach(function(k){if(!v[k]||v[k]===D[k]){O.push(k);}});switch(T){case"icon":O.push("text");if(!v["src"]){O.push("shape","alt","backgroundColor","color");}break;case"picture":O.push("text","backgroundColor","color");if(!v["src"]){O.push("shape","alt");}break;case"text":O.push("src","alt");if(!v["text"]){O.push("shape","backgroundColor","color");}break;}return _(v,O);};
c.prototype._openColorPickerPopup=function(E){this._inputId=E.getSource().getId();if(!this.oColorPickerSimplifiedPopover){this.oColorPickerSimplifiedPopover=new C("oColorPickerSimpplifiedPopover",{colorString:"blue",displayMode:f.Simplified,mode:e.HSL,change:this._handleColorPickerChange.bind(this)});}this.oColorPickerSimplifiedPopover.openBy(E.getSource());};
c.prototype._handleColorPickerChange=function(E){var h=sap.ui.getCore().byId(this._inputId);h.setValue(E.getParameter("hex"));h.setValueState("None");this._inputId="";};
c.prototype.getFocusDomRef=function(){return this.getContent().getItems()[0].getContent()[0].getFocusDomRef();};
c.prototype.getIdForLabel=function(){return this.getContent().getItems()[0].getContent()[0].getIdForLabel();};
return c;});
sap.ui.predefine('sap/ui/integration/designtime/cardEditor/propertyEditor/parametersEditor/ParametersEditor',["sap/ui/integration/designtime/baseEditor/propertyEditor/BasePropertyEditor","sap/ui/integration/designtime/baseEditor/propertyEditor/mapEditor/MapEditor","sap/base/util/includes","sap/base/util/restricted/_merge"],function(B,M,i,_){"use strict";
var P=M.extend("sap.ui.integration.designtime.cardEditor.propertyEditor.parametersEditor.ParametersEditor",{renderer:B.getMetadata().getRenderer().render});
P.configMetadata=Object.assign({},M.configMetadata,{allowLabelChange:{defaultValue:true,mergeStrategy:"mostRestrictiveWins"}});
P.prototype.formatItemConfig=function(c){var m=M.prototype.formatItemConfig.apply(this,arguments);var k=c.key;var I=this.getNestedDesigntimeMetadataValue(k);var l=I.label;m.splice(1,0,{label:this.getI18nProperty("CARD_EDITOR.LABEL"),path:"label",value:l,placeholder:l?undefined:k,type:"string",enabled:this.getConfig().allowLabelChange,itemKey:k});return m;};
P.prototype.processInputValue=function(v){return v;};
P.prototype.processOutputValue=function(v){return v;};
P.prototype._configItemsFormatter=function(I){return Array.isArray(I)?I.map(function(o){var a=this.getNestedDesigntimeMetadataValue(o.key);var c=_({},o.value,a);if(!c.label){c.label=o.key;}c.itemKey=o.key;c.path="value";c.designtime=this.getNestedDesigntimeMetadata(o.key);return c;}.bind(this)):[];};
P.prototype.getItemChangeHandlers=function(){return Object.assign({},M.prototype.getItemChangeHandlers.apply(this,arguments),{label:this._onDesigntimeChange});};
P.prototype._onDesigntimeChange=function(k,e){var d=_({},this.getConfig().designtime);var n={__value:{}};n.__value[e.getParameter("path")]=e.getParameter("value");d[k]=_({},d[k],n);this.setDesigntimeMetadata(d);this.setValue(this.getValue());};
P.prototype.onBeforeConfigChange=function(c){if(!c.allowTypeChange&&!c.allowKeyChange){this.setFragment("sap.ui.integration.designtime.cardEditor.propertyEditor.parametersEditor.ParametersConfigurationEditor",function(){return 1;});}return c;};
P.prototype._isValidItem=function(I,o){var t=o.type;var v=o.value;var a=this._getAllowedTypes();return(t&&i(a,t)||typeof v==="string"&&i(a,"string"));};
return P;});
sap.ui.predefine('sap/ui/integration/designtime/cardEditor/util/CommonPatterns',function(){"use strict";return{email:new RegExp(/^(?:(?:(?:[^()<>@,;:\\".\[\]!~*'&=$?\/ \000-\031-][^()<>@,;:\\".\[\]!~*'&=$?\/ \000-\031]*(?:$|(?=[\["()<>@,;:\\".\[\]]))|"(?:[^\"\r\\]|\\.)*")(?:\.(?:[^()<>@,;:\\".\[\]!~*'&=$?\/ \000-\031-][^()<>@,;:\\".\[\]!~*'&=$?\/ \000-\031]*(?:$|(?=[\["()<>@,;:\\".\[\]]))|"(?:[^\"\r\\]|\\.)*"))*@(?:[^()<>@,;:\\".\[\]!~*'&=$?\/ \000-\031-][^()<>@,;:\\".\[\]!~*'&=$?\/ \000-\031]*(?:$|(?=[\["()<>@,;:\\".\[\]]))|\[(?:[^\[\]\r\\]|\\.)*\])(?:\.(?:[^()<>@,;:\\".\[\]!~*'&=$?\/ \000-\031-][^()<>@,;:\\".\[\]!~*'&=$?\/ \000-\031]*(?:$|(?=[\["()<>@,;:\\".\[\]]))|\[(?:[^\[\]\r\\]|\\.)*\]))+|(?:[^()<>@,;:\\".\[\]!~*'&=$?\/ \000-\031-][^()<>@,;:\\".\[\]!~*'&=$?\/ \000-\031]*(?:$|(?=[\["()<>@,;:\\".\[\]]))|"(?:[^\"\r\\]|\\.)*")*\<(?:@(?:[^()<>@,;:\\".\[\]!~*'&=$?\/ \000-\031-][^()<>@,;:\\".\[\]!~*'&=$?\/ \000-\031]*(?:$|(?=[\["()<>@,;:\\".\[\]]))|\[(?:[^\[\]\r\\]|\\.)*\])(?:\.(?:[^()<>@,;:\\".\[\]!~*'&=$?\/ \000-\031-][^()<>@,;:\\".\[\]!~*'&=$?\/ \000-\031]*(?:$|(?=[\["()<>@,;:\\".\[\]]))|\[(?:[^\[\]\r\\]|\\.)*\]))+(?:,@(?:[^()<>@,;:\\".\[\]!~*'&=$?\/ \000-\031-][^()<>@,;:\\".\[\]!~*'&=$?\/ \000-\031]*(?:$|(?=[\["()<>@,;:\\".\[\]]))|\[(?:[^\[\]\r\\]|\\.)*\])(?:\.(?:[^()<>@,;:\\".\[\]!~*'&=$?\/ \000-\031-][^()<>@,;:\\".\[\]!~*'&=$?\/ \000-\031]*(?:$|(?=[\["()<>@,;:\\".\[\]]))|\[(?:[^\[\]\r\\]|\\.)*\]))+)*:)?(?:[^()<>@,;:\\".\[\]!~*'&=$?\/ \000-\031-][^()<>@,;:\\".\[\]!~*'&=$?\/ \000-\031]*(?:$|(?=[\["()<>@,;:\\".\[\]]))|"(?:[^\"\r\\]|\\.)*")(?:\.(?:[^()<>@,;:\\".\[\]!~*'&=$?\/ \000-\031-][^()<>@,;:\\".\[\]!~*'&=$?\/ \000-\031]*(?:$|(?=[\["()<>@,;:\\".\[\]]))|"(?:[^\"\r\\]|\\.)*"))*@(?:[^()<>@,;:\\".\[\]!~*'&=$?\/ \000-\031-][^()<>@,;:\\".\[\]!~*'&=$?\/ \000-\031]*(?:$|(?=[\["()<>@,;:\\".\[\]]))|\[(?:[^\[\]\r\\]|\\.)*\])(?:\.(?:[^()<>@,;:\\".\[\]!~*'&=$?\/ \000-\031-][^()<>@,;:\\".\[\]!~*'&=$?\/ \000-\031]*(?:$|(?=[\["()<>@,;:\\".\[\]]))|\[(?:[^\[\]\r\\]|\\.)*\]))+\>)|(?:[^()<>@,;:\\".\[\]!~*'&=$?\/ \000-\031-][^()<>@,;:\\".\[\]!~*'&=$?\/ \000-\031]*(?:$|(?=[\["()<>@,;:\\".\[\]]))|"(?:[^\"\r\\]|\\.)*")*:(?:(?:(?:[^()<>@,;:\\".\[\]!~*'&=$?\/ \000-\031-][^()<>@,;:\\".\[\]!~*'&=$?\/ \000-\031]*(?:$|(?=[\["()<>@,;:\\".\[\]]))|"(?:[^\"\r\\]|\\.)*")(?:\.(?:[^()<>@,;:\\".\[\]!~*'&=$?\/ \000-\031-][^()<>@,;:\\".\[\]!~*'&=$?\/ \000-\031]*(?:$|(?=[\["()<>@,;:\\".\[\]]))|"(?:[^\"\r\\]|\\.)*"))*@(?:[^()<>@,;:\\".\[\]!~*'&=$?\/ \000-\031-][^()<>@,;:\\".\[\]!~*'&=$?\/ \000-\031]*(?:$|(?=[\["()<>@,;:\\".\[\]]))|\[(?:[^\[\]\r\\]|\\.)*\])(?:\.(?:[^()<>@,;:\\".\[\]!~*'&=$?\/ \000-\031-][^()<>@,;:\\".\[\]!~*'&=$?\/ \000-\031]*(?:$|(?=[\["()<>@,;:\\".\[\]]))|\[(?:[^\[\]\r\\]|\\.)*\]))+|(?:[^()<>@,;:\\".\[\]!~*'&=$?\/ \000-\031-][^()<>@,;:\\".\[\]!~*'&=$?\/ \000-\031]*(?:$|(?=[\["()<>@,;:\\".\[\]]))|"(?:[^\"\r\\]|\\.)*")*\<(?:@(?:[^()<>@,;:\\".\[\]!~*'&=$?\/ \000-\031-][^()<>@,;:\\".\[\]!~*'&=$?\/ \000-\031]*(?:$|(?=[\["()<>@,;:\\".\[\]]))|\[(?:[^\[\]\r\\]|\\.)*\])(?:\.(?:[^()<>@,;:\\".\[\]!~*'&=$?\/ \000-\031-][^()<>@,;:\\".\[\]!~*'&=$?\/ \000-\031]*(?:$|(?=[\["()<>@,;:\\".\[\]]))|\[(?:[^\[\]\r\\]|\\.)*\]))+(?:,@(?:[^()<>@,;:\\".\[\]!~*'&=$?\/ \000-\031-][^()<>@,;:\\".\[\]!~*'&=$?\/ \000-\031]*(?:$|(?=[\["()<>@,;:\\".\[\]]))|\[(?:[^\[\]\r\\]|\\.)*\])(?:\.(?:[^()<>@,;:\\".\[\]!~*'&=$?\/ \000-\031-][^()<>@,;:\\".\[\]!~*'&=$?\/ \000-\031]*(?:$|(?=[\["()<>@,;:\\".\[\]]))|\[(?:[^\[\]\r\\]|\\.)*\]))+)*:)?(?:[^()<>@,;:\\".\[\]!~*'&=$?\/ \000-\031-][^()<>@,;:\\".\[\]!~*'&=$?\/ \000-\031]*(?:$|(?=[\["()<>@,;:\\".\[\]]))|"(?:[^\"\r\\]|\\.)*")(?:\.(?:[^()<>@,;:\\".\[\]!~*'&=$?\/ \000-\031-][^()<>@,;:\\".\[\]!~*'&=$?\/ \000-\031]*(?:$|(?=[\["()<>@,;:\\".\[\]]))|"(?:[^\"\r\\]|\\.)*"))*@(?:[^()<>@,;:\\".\[\]!~*'&=$?\/ \000-\031-][^()<>@,;:\\".\[\]!~*'&=$?\/ \000-\031]*(?:$|(?=[\["()<>@,;:\\".\[\]]))|\[(?:[^\[\]\r\\]|\\.)*\])(?:\.(?:[^()<>@,;:\\".\[\]!~*'&=$?\/ \000-\031-][^()<>@,;:\\".\[\]!~*'&=$?\/ \000-\031]*(?:$|(?=[\["()<>@,;:\\".\[\]]))|\[(?:[^\[\]\r\\]|\\.)*\]))+\>)(?:,\s*(?:(?:[^()<>@,;:\\".\[\]!~*'&=$?\/ \000-\031-][^()<>@,;:\\".\[\]!~*'&=$?\/ \000-\031]*(?:$|(?=[\["()<>@,;:\\".\[\]]))|"(?:[^\"\r\\]|\\.)*")(?:\.(?:[^()<>@,;:\\".\[\]!~*'&=$?\/ \000-\031-][^()<>@,;:\\".\[\]!~*'&=$?\/ \000-\031]*(?:$|(?=[\["()<>@,;:\\".\[\]]))|"(?:[^\"\r\\]|\\.)*"))*@(?:[^()<>@,;:\\".\[\]!~*'&=$?\/ \000-\031-][^()<>@,;:\\".\[\]!~*'&=$?\/ \000-\031]*(?:$|(?=[\["()<>@,;:\\".\[\]]))|\[(?:[^\[\]\r\\]|\\.)*\])(?:\.(?:[^()<>@,;:\\".\[\]!~*'&=$?\/ \000-\031-][^()<>@,;:\\".\[\]!~*'&=$?\/ \000-\031]*(?:$|(?=[\["()<>@,;:\\".\[\]]))|\[(?:[^\[\]\r\\]|\\.)*\]))+|(?:[^()<>@,;:\\".\[\]!~*'&=$?\/ \000-\031-][^()<>@,;:\\".\[\]!~*'&=$?\/ \000-\031]*(?:$|(?=[\["()<>@,;:\\".\[\]]))|"(?:[^\"\r\\]|\\.)*")*\<(?:@(?:[^()<>@,;:\\".\[\]!~*'&=$?\/ \000-\031-][^()<>@,;:\\".\[\]!~*'&=$?\/ \000-\031]*(?:$|(?=[\["()<>@,;:\\".\[\]]))|\[(?:[^\[\]\r\\]|\\.)*\])(?:\.(?:[^()<>@,;:\\".\[\]!~*'&=$?\/ \000-\031-][^()<>@,;:\\".\[\]!~*'&=$?\/ \000-\031]*(?:$|(?=[\["()<>@,;:\\".\[\]]))|\[(?:[^\[\]\r\\]|\\.)*\]))+(?:,@(?:[^()<>@,;:\\".\[\]!~*'&=$?\/ \000-\031-][^()<>@,;:\\".\[\]!~*'&=$?\/ \000-\031]*(?:$|(?=[\["()<>@,;:\\".\[\]]))|\[(?:[^\[\]\r\\]|\\.)*\])(?:\.(?:[^()<>@,;:\\".\[\]!~*'&=$?\/ \000-\031-][^()<>@,;:\\".\[\]!~*'&=$?\/ \000-\031]*(?:$|(?=[\["()<>@,;:\\".\[\]]))|\[(?:[^\[\]\r\\]|\\.)*\]))+)*:)?(?:[^()<>@,;:\\".\[\]!~*'&=$?\/ \000-\031-][^()<>@,;:\\".\[\]!~*'&=$?\/ \000-\031]*(?:$|(?=[\["()<>@,;:\\".\[\]]))|"(?:[^\"\r\\]|\\.)*")(?:\.(?:[^()<>@,;:\\".\[\]!~*'&=$?\/ \000-\031-][^()<>@,;:\\".\[\]!~*'&=$?\/ \000-\031]*(?:$|(?=[\["()<>@,;:\\".\[\]]))|"(?:[^\"\r\\]|\\.)*"))*@(?:[^()<>@,;:\\".\[\]!~*'&=$?\/ \000-\031-][^()<>@,;:\\".\[\]!~*'&=$?\/ \000-\031]*(?:$|(?=[\["()<>@,;:\\".\[\]]))|\[(?:[^\[\]\r\\]|\\.)*\])(?:\.(?:[^()<>@,;:\\".\[\]!~*'&=$?\/ \000-\031-][^()<>@,;:\\".\[\]!~*'&=$?\/ \000-\031]*(?:$|(?=[\["()<>@,;:\\".\[\]]))|\[(?:[^\[\]\r\\]|\\.)*\]))+\>))*)?;\s*)$/).source};});
sap.ui.predefine('sap/ui/integration/designtime/cardEditor/validator/IsPatternMatchList',["sap/ui/integration/designtime/baseEditor/validator/IsPatternMatch"],function(I){"use strict";return{async:false,errorMessage:"BASE_EDITOR.VALIDATOR.FAILED_PATTERN_TEST",validate:function(v,c){return(v||[]).every(function(V){return I.validate(V,c);});}};});
/*!
 * OpenUI5
 * (c) Copyright 2009-2020 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 *
 * @function
 * @private
 * @experimental
 */
sap.ui.predefine('sap/ui/integration/designtime/cardEditor/config/generateDataConfig',function(){"use strict";return function(t,r,a){var d={"DataRequestUrl":{"tags":t.concat(["data"]),"label":"{i18n>CARD_EDITOR.DATA.REQUEST.URL}","type":"string","defaultValue":"","path":r+"data/request/url"},"DataRequestMode":{"tags":t.concat(["data"]),"label":"{i18n>CARD_EDITOR.DATA.REQUEST.MODE}","type":"select","items":[{"key":"no-cors"},{"key":"same-origin"},{"key":"cors"}],"defaultValue":"cors","path":r+"data/request/mode","visible":"{= !!${context>"+r+"data/request/url} }"},"DataRequestMethod":{"tags":t.concat(["data"]),"label":"{i18n>CARD_EDITOR.DATA.REQUEST.METHOD}","type":"select","items":[{"key":"GET"},{"key":"POST"}],"defaultValue":"GET","path":r+"data/request/method","visible":"{= !!${context>"+r+"data/request/url} }"},"DataRequestParameters":{"tags":t.concat(["data"]),"label":"{i18n>CARD_EDITOR.DATA.REQUEST.PARAMETERS}","type":"map","path":r+"data/request/parameters","visible":"{= !!${context>"+r+"data/request/url} }"},"DataRequestHeaders":{"tags":t.concat(["data"]),"label":"{i18n>CARD_EDITOR.DATA.REQUEST.HEADERS}","type":"map","path":r+"data/request/headers","visible":"{= !!${context>"+r+"data/request/url} }"},"DataRequestWithCredentials":{"tags":t.concat(["data"]),"label":"{i18n>CARD_EDITOR.DATA.REQUEST.WITHCREDENTIALS}","type":"boolean","defaultValue":false,"path":r+"data/request/withCredentials","visible":"{= !!${context>"+r+"data/request/url} }"},"DataJson":{"tags":t.concat(["data"]),"label":"{i18n>CARD_EDITOR.DATA.JSON}","type":"json","path":r+"data/json","visible":"{= !${context>"+r+"data/request/url} }"},"DataPath":{"tags":t.concat(["data"]),"label":"{i18n>CARD_EDITOR.DATA.PATH}","type":"string","path":r+"data/path","validators":{"dataPathPattern":{"type":"pattern","config":{"pattern":"^[a-zA-Z0-9_\\.\\-/|\\@\\#]*$"}}}},"DataServiceName":{"tags":t.concat(["data"]),"label":"{i18n>CARD_EDITOR.DATA.SERVICE.NAME}","type":"string","path":r+"data/service/name","visible":false},"DataServiceParameters":{"tags":t.concat(["data"]),"label":"{i18n>CARD_EDITOR.DATA.SERVICE.PARAMETERS}","type":"map","path":r+"data/service/parameters","visible":false},"DataUpdateInterval":{"tags":t.concat(["data"]),"label":"{i18n>CARD_EDITOR.DATA.UPDATEINTERVAL}","type":"number","path":r+"data/updateInterval"}};var g={};Object.keys(d).forEach(function(k){g[a+k]=d[k];});return g;};});
/*!
 * OpenUI5
 * (c) Copyright 2009-2020 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 *
 * @private
 * @experimental
 */
sap.ui.predefine('sap/ui/integration/designtime/cardEditor/config/AppConfig',function(){"use strict";return{"appId":{"tags":["app"],"label":"{i18n>CARD_EDITOR.APP.ID}","type":"string","maxLength":70,"path":"/sap.app/id"},"appVersion":{"tags":["app"],"label":"{i18n>CARD_EDITOR.APP.VERSION}","type":"string","path":"/sap.app/applicationVersion/version"},"appTitle":{"tags":["app"],"label":"{i18n>CARD_EDITOR.TITLE}","type":"string","path":"/sap.app/title"},"appSubTitle":{"tags":["app"],"label":"{i18n>CARD_EDITOR.SUBTITLE}","type":"string","path":"/sap.app/subTitle"},"appShortTitle":{"tags":["app"],"label":"{i18n>CARD_EDITOR.APP.SHORTTITLE}","type":"string","path":"/sap.app/shortTitle"},"appInfo":{"tags":["app"],"label":"{i18n>CARD_EDITOR.APP.INFO}","type":"string","path":"/sap.app/info"},"appIcon":{"tags":["app"],"label":"{i18n>CARD_EDITOR.ICON}","type":"simpleicon","path":"/sap.ui/icons/icon"},"appDescription":{"tags":["app"],"label":"{i18n>CARD_EDITOR.APP.DESCRIPTION}","type":"string","path":"/sap.app/description"},"appI18n":{"tags":["app"],"label":"{i18n>CARD_EDITOR.APP.I18N}","type":"string","path":"/sap.app/i18n","defaultValue":"i18n/i18n.properties"},"appTagKeywords":{"tags":["app"],"label":"{i18n>CARD_EDITOR.APP.TAGS.KEYWORDS}","type":"list","path":"/sap.app/tags/keywords"},"appTagTechnicalAttributes":{"tags":["app"],"label":"{i18n>CARD_EDITOR.APP.TAGS.TECHNICALATTRIBUTES}","type":"list","path":"/sap.app/tags/technicalAttributes","validators":{"technicalAttributesPattern":{"type":"patternList","config":{"pattern":"^[A-Z0-9_\\-\\/]+$"}}}},"appDataSources":{"label":"{i18n>CARD_EDITOR.APP.DATASOURCES}","type":"complexMap","itemLabel":"{key}","addItemLabel":"{i18n>CARD_EDITOR.APP.DATASOURCE}","path":"/sap.app/dataSources","template":{"key":{"label":"{i18n>CARD_EDITOR.APP.DATASOURCES.KEY}","type":"string","path":"key","validators":{"keyPattern":{"type":"pattern","config":{"pattern":"^[a-zA-Z0-9_\\.\\-]*$"}}}},"uri":{"label":"{i18n>CARD_EDITOR.APP.DATASOURCES.URI}","type":"string","path":"uri"},"type":{"label":"{i18n>CARD_EDITOR.LABEL.TYPE}","type":"select","items":[{"key":"OData"},{"key":"ODataAnnotation"},{"key":"INA"},{"key":"XML"},{"key":"JSON"},{"key":"FHIR"}],"defaultValue":"OData","path":"type"},"odataVersion":{"label":"{i18n>CARD_EDITOR.APP.DATASOURCES.SETTINGS.ODATAVERSION}","type":"select","items":[{"key":"2.0"},{"key":"4.0"}],"defaultValue":"2.0","path":"settings/odataVersion","visible":"{= ${type} === 'OData' || ${type} === 'ODataAnnotation'}"},"localUri":{"label":"{i18n>CARD_EDITOR.APP.DATASOURCES.SETTINGS.LOCALURI}","type":"string","path":"settings/localUri","visible":"{= ${type} === 'OData' || ${type} === 'ODataAnnotation'}"},"annotations":{"label":"{i18n>CARD_EDITOR.APP.DATASOURCES.SETTINGS.ANNOTATIONS}","type":"list","path":"settings/annotations","visible":"{= ${type} === 'OData' || ${type} === 'ODataAnnotation'}"},"maxAge":{"label":"{i18n>CARD_EDITOR.APP.DATASOURCES.SETTINGS.MAXAGE}","type":"number","path":"settings/maxAge"}}},"mobile":{"tags":["app"],"label":"{i18n>CARD_EDITOR.APP.MOBILE}","type":"boolean","defaultValue":"","path":"/sap.platform.mobilecards/compatible"}};});
sap.ui.predefine('sap/ui/integration/designtime/cardEditor/config/HeaderConfig',["sap/ui/integration/designtime/cardEditor/config/generateActionConfig"],function(g){"use strict";return{"headerType":{"tags":["header"],"label":"{i18n>CARD_EDITOR.HEADERTYPE}","path":"header/type","type":"select","items":[{"key":"Default","title":"{i18n>CARD_EDITOR.HEADERTYPE.DEFAULT}"},{"key":"Numeric","title":"{i18n>CARD_EDITOR.HEADERTYPE.NUMERIC}"}],"defaultValue":"Default"},"headerPosition":{"tags":["header"],"label":"{i18n>CARD_EDITOR.HEADERPOSITION}","path":"headerPosition","type":"select","items":[{"key":"Top","title":"{i18n>CARD_EDITOR.HEADERPOSITION.TOP}"},{"key":"Bottom","title":"{i18n>CARD_EDITOR.HEADERPOSITION.BOTTOM}"}],"defaultValue":"Top"},"title":{"tags":["header"],"label":"{i18n>CARD_EDITOR.TITLE}","type":"string","path":"header/title"},"subTitle":{"tags":["header"],"label":"{i18n>CARD_EDITOR.SUBTITLE}","type":"string","path":"header/subTitle"},"actions":g({"tags":["header"],"path":"header/actions","maxItems":1}),"statusText":{"tags":["header","defaultHeader"],"label":"{i18n>CARD_EDITOR.STATUS}","type":"string","path":"header/status/text"},"icon":{"tags":["header","defaultHeader"],"label":"{i18n>CARD_EDITOR.ICON}","type":"icon","path":"header/icon","visible":"{= ${context>header/type} !== 'Numeric' }"},"unitOfMeasurement":{"tags":["header","numericHeader"],"label":"{i18n>CARD_EDITOR.UOM}","type":"string","path":"header/unitOfMeasurement","visible":"{= ${context>header/type} === 'Numeric' }"},"mainIndicatorNumber":{"tags":["header","numericHeader","mainIndicator"],"label":"{i18n>CARD_EDITOR.NUMBER}","type":"number","path":"header/mainIndicator/number","visible":"{= ${context>header/type} === 'Numeric' }"},"mainIndicatorUnit":{"tags":["header","numericHeader","mainIndicator"],"label":"{i18n>CARD_EDITOR.MAIN_INDICATOR.UNIT}","type":"string","path":"header/mainIndicator/unit","visible":"{= ${context>header/type} === 'Numeric' }"},"mainIndicatorTrend":{"tags":["header","numericHeader","mainIndicator"],"label":"{i18n>CARD_EDITOR.MAIN_INDICATOR.TREND}","type":"select","items":[{"key":"Down","title":"{i18n>CARD_EDITOR.MAIN_INDICATOR.TREND.DOWN}"},{"key":"None","title":"{i18n>CARD_EDITOR.MAIN_INDICATOR.TREND.NONE}"},{"key":"Up","title":"{i18n>CARD_EDITOR.MAIN_INDICATOR.TREND.UP}"}],"allowBinding":true,"path":"header/mainIndicator/trend","visible":"{= ${context>header/type} === 'Numeric' }"},"mainIndicatorState":{"tags":["header","numericHeader","mainIndicator"],"label":"{i18n>CARD_EDITOR.MAIN_INDICATOR.STATE}","type":"select","items":[{"key":"Critical","title":"{i18n>CARD_EDITOR.MAIN_INDICATOR.STATE.CRITICAL}"},{"key":"Error","title":"{i18n>CARD_EDITOR.MAIN_INDICATOR.STATE.ERROR}"},{"key":"Good","title":"{i18n>CARD_EDITOR.MAIN_INDICATOR.STATE.GOOD}"},{"key":"Neutral","title":"{i18n>CARD_EDITOR.MAIN_INDICATOR.STATE.NEUTRAL}"}],"allowBinding":true,"path":"header/mainIndicator/state","visible":"{= ${context>header/type} === 'Numeric' }"},"details":{"tags":["header","numericHeader"],"label":"{i18n>CARD_EDITOR.DETAILS}","type":"string","path":"header/details","visible":"{= ${context>header/type} === 'Numeric' }"},"sideIndicators":{"tags":["header","numericHeader"],"label":"{i18n>CARD_EDITOR.SIDE_INDICATORS}","path":"header/sideIndicators","type":"array","itemLabel":"{title}","addItemLabel":"{i18n>CARD_EDITOR.SIDE_INDICATOR}","template":{"title":{"label":"{i18n>CARD_EDITOR.TITLE}","type":"string","path":"title"},"number":{"label":"{i18n>CARD_EDITOR.NUMBER}","type":"number","path":"number"},"unit":{"label":"{i18n>CARD_EDITOR.SIDE_INDICATOR.UNIT}","type":"string","path":"unit"}},"maxItems":2,"visible":"{= ${context>header/type} === 'Numeric' }"}};});
sap.ui.predefine('sap/ui/integration/designtime/cardEditor/config/ListCardConfig',["sap/ui/integration/designtime/cardEditor/config/generateActionConfig"],function(g){"use strict";return{"listMaxItems":{"tags":["content"],"label":"{i18n>CARD_EDITOR.MAXITEMS}","type":"integer","path":"content/maxItems","visible":"{= ${context>type} === 'List' }"},"listItemTitle":{"tags":["content","listItem"],"label":"{i18n>CARD_EDITOR.TITLE}","type":"string","path":"content/item/title","visible":"{= ${context>type} === 'List' }"},"listItemDescription":{"tags":["content","listItem"],"label":"{i18n>CARD_EDITOR.LIST_ITEM.DESCRIPTION}","type":"string","path":"content/item/description","visible":"{= ${context>type} === 'List' }"},"listItemInfoValue":{"tags":["content","listItem"],"label":"{i18n>CARD_EDITOR.LIST_ITEM.INFO.VALUE}","type":"string","path":"content/item/info/value","visible":"{= ${context>type} === 'List' }"},"listItemInfoState":{"tags":["content","listItem"],"label":"{i18n>CARD_EDITOR.LIST_ITEM.INFO.STATE}","type":"select","items":[{"key":"Success","title":"{i18n>CARD_EDITOR.STATE.SUCCESS}"},{"key":"Error","title":"{i18n>CARD_EDITOR.STATE.ERROR}"},{"key":"Warning","title":"{i18n>CARD_EDITOR.STATE.WARNING}"},{"key":"None","title":"{i18n>CARD_EDITOR.STATE.NONE}"},{"key":"Information","title":"{i18n>CARD_EDITOR.STATE.INFORMATION}"}],"defaultValue":"None","path":"content/item/info/state","visible":"{= ${context>type} === 'List' }"},"listItemHighlight":{"tags":["content","listItem"],"label":"{i18n>CARD_EDITOR.LIST_ITEM.HIGHLIGHT}","type":"select","items":[{"key":"Success","title":"{i18n>CARD_EDITOR.STATE.SUCCESS}"},{"key":"Error","title":"{i18n>CARD_EDITOR.STATE.ERROR}"},{"key":"Warning","title":"{i18n>CARD_EDITOR.STATE.WARNING}"},{"key":"None","title":"{i18n>CARD_EDITOR.STATE.NONE}"},{"key":"Information","title":"{i18n>CARD_EDITOR.STATE.INFORMATION}"}],"defaultValue":"None","path":"content/item/highlight","visible":"{= ${context>type} === 'List' }"},"listItemIcon":{"tags":["content","listItem"],"label":"{i18n>CARD_EDITOR.LIST_ITEM.ICON}","type":"simpleicon","path":"content/item/icon/src","visible":"{= ${context>type} === 'List' }"},"listItemActions":g({"tags":["content","listItem"],"path":"content/item/actions","maxItems":1,"visible":"{= ${context>type} === 'List' }"})};});
sap.ui.predefine('sap/ui/integration/designtime/cardEditor/config/ObjectCardConfig',["sap/ui/integration/designtime/cardEditor/config/generateActionConfig","sap/ui/integration/designtime/cardEditor/util/CommonPatterns"],function(g,C){"use strict";return{"objectGroups":{"tags":["content"],"label":"{i18n>CARD_EDITOR.OBJECT.GROUPS}","type":"array","path":"content/groups","itemLabel":"{title}","addItemLabel":"{i18n>CARD_EDITOR.OBJECT.GROUP}","template":{"title":{"label":"{i18n>CARD_EDITOR.TITLE}","type":"string","path":"title"},"items":{"tags":["content","objectGroup"],"label":"{i18n>CARD_EDITOR.OBJECT.GROUP.ITEMS}","type":"array","path":"items","itemLabel":"{label}","addItemLabel":"{i18n>CARD_EDITOR.OBJECT.GROUP.ITEM}","template":{"icon":{"tags":["content","objectGroupItem"],"label":"{i18n>CARD_EDITOR.ICON}","type":"icon","path":"icon"},"label":{"tags":["content","objectGroupItem"],"label":"{i18n>CARD_EDITOR.LABEL}","type":"string","path":"label"},"value":{"tags":["content","objectGroupItem"],"label":"{i18n>CARD_EDITOR.OBJECT.GROUP.ITEM.VALUE}","type":"string","path":"value","validators":{"emailPattern":{"type":"pattern","config":{"pattern":C.email,"modifiers":"i"},"errorMessage":"CARD_EDITOR.VALIDATOR.INVALID_EMAIL","isEnabled":"{= ${type} === 'email'}"}}},"type":{"tags":["content","objectGroupItem"],"label":"{i18n>CARD_EDITOR.LABEL.TYPE}","type":"select","items":[{"key":"phone","title":"{i18n>CARD_EDITOR.OBJECT.GROUP.TYPE.PHONE}"},{"key":"email","title":"{i18n>CARD_EDITOR.OBJECT.GROUP.TYPE.EMAIL}"},{"key":"link","title":"{i18n>CARD_EDITOR.OBJECT.GROUP.TYPE.LINK}"},{"key":"text","title":"{i18n>CARD_EDITOR.OBJECT.GROUP.TYPE.TEXT}"}],"defaultValue":"text","path":"type"},"url":{"tags":["content","objectGroupItem"],"label":"{i18n>CARD_EDITOR.LABEL.URL}","type":"string","path":"url","visible":"{= ${type} === 'link'}"},"target":{"tags":["content","objectGroupItem"],"label":"{i18n>CARD_EDITOR.TARGET}","type":"select","items":[{"key":"_blank","description":"{i18n>CARD_EDITOR.TARGET.BLANK}"},{"key":"_self","description":"{i18n>CARD_EDITOR.TARGET.SELF}"}],"defaultValue":"_blank","path":"target","visible":"{= ${type} === 'link' && !!${url}}"},"emailSubject":{"tags":["content","objectGroupItem"],"label":"{i18n>CARD_EDITOR.OBJECT.GROUP.ITEM.EMAILSUBJECT}","type":"string","path":"emailSubject","visible":"{= ${type} === 'email'}"}}}},"visible":"{= ${context>type} === 'Object' }"},"objectActions":g({"tags":["content"],"path":"content/actions","maxItems":1,"visible":"{= ${context>type} === 'Object' }"})};});
sap.ui.predefine('sap/ui/integration/designtime/cardEditor/config/TableCardConfig',["sap/ui/integration/designtime/cardEditor/config/generateActionConfig"],function(g){"use strict";return{"tableMaxItems":{"tags":["content"],"label":"{i18n>CARD_EDITOR.MAXITEMS}","type":"integer","path":"content/maxItems","visible":"{= ${context>type} === 'Table' }"},"tableRowColumns":{"tags":["content","tableRow"],"label":"{i18n>CARD_EDITOR.TABLE.ROW.COLUMNS}","type":"array","path":"content/row/columns","itemLabel":"{title}","addItemLabel":"{i18n>CARD_EDITOR.TABLE.ROW.COLUMN}","template":{"title":{"tags":["content","tableRowColumn"],"label":"{i18n>CARD_EDITOR.TITLE}","type":"string","path":"title"},"width":{"tags":["content","tableRowColumn"],"label":"{i18n>CARD_EDITOR.TABLE.ROW.COLUMN.WIDTH}","type":"string","path":"width"},"value":{"tags":["content","tableRowColumn"],"label":"{i18n>CARD_EDITOR.TABLE.ROW.COLUMN.VALUE}","type":"string","path":"value"},"icon":{"tags":["content","tableRowColumn"],"label":"{i18n>CARD_EDITOR.ICON}","type":"icon","path":"icon","visible":false},"state":{"tags":["content","tableRowColumn"],"label":"{i18n>CARD_EDITOR.TABLE.ROW.COLUMN.STATE}","type":"select","items":[{"key":"Success","title":"{i18n>CARD_EDITOR.STATE.SUCCESS}"},{"key":"Error","title":"{i18n>CARD_EDITOR.STATE.ERROR}"},{"key":"Warning","title":"{i18n>CARD_EDITOR.STATE.WARNING}"},{"key":"None","title":"{i18n>CARD_EDITOR.STATE.NONE}"},{"key":"Information","title":"{i18n>CARD_EDITOR.STATE.INFORMATION}"}],"defaultValue":"None","path":"state"},"url":{"tags":["content","tableRowColumn"],"label":"{i18n>CARD_EDITOR.LABEL.URL}","type":"string","path":"url"},"target":{"tags":["content","tableRowColumn"],"label":"{i18n>CARD_EDITOR.TARGET}","type":"select","items":[{"key":"_blank","description":"{i18n>CARD_EDITOR.TARGET.BLANK}"},{"key":"_self","description":"{i18n>CARD_EDITOR.TARGET.SELF}"}],"defaultValue":"_blank","path":"target","visible":"{= !!${url}}"},"identifier":{"tags":["content","tableRowColumn"],"label":"{i18n>CARD_EDITOR.TABLE.ROW.COLUMN.IDENTIFIER}","type":"boolean","defaultValue":false,"path":"identifier"},"progressIndicatorState":{"tags":["content","tableRowColumn"],"label":"{i18n>CARD_EDITOR.TABLE.ROW.COLUMN.PROGRESSINDICATOR.STATE}","type":"select","items":[{"key":"Success","title":"{i18n>CARD_EDITOR.STATE.SUCCESS}"},{"key":"Error","title":"{i18n>CARD_EDITOR.STATE.ERROR}"},{"key":"Warning","title":"{i18n>CARD_EDITOR.STATE.WARNING}"},{"key":"None","title":"{i18n>CARD_EDITOR.STATE.NONE}"},{"key":"Information","title":"{i18n>CARD_EDITOR.STATE.INFORMATION}"}],"defaultValue":"None","path":"progressIndicator/state"},"progressIndicatorPercent":{"tags":["content","tableRowColumn"],"label":"{i18n>CARD_EDITOR.TABLE.ROW.COLUMN.PROGRESSINDICATOR.PERCENT}","type":"number","path":"progressIndicator/percent"},"progressIndicatorText":{"tags":["content","tableRowColumn"],"label":"{i18n>CARD_EDITOR.TABLE.ROW.COLUMN.PROGRESSINDICATOR.TEXT}","type":"string","path":"progressIndicator/text"}},"visible":"{= ${context>type} === 'Table' }"},"tableRowActions":g({"tags":["content","tableRow"],"path":"content/row/actions","maxItems":1,"visible":"{= ${context>type} === 'Table' }"})};});
sap.ui.predefine('sap/ui/integration/designtime/cardEditor/config/index',["sap/ui/integration/designtime/cardEditor/config/AppConfig","sap/ui/integration/designtime/cardEditor/config/HeaderConfig","sap/ui/integration/designtime/cardEditor/config/ListCardConfig","sap/ui/integration/designtime/cardEditor/config/ObjectCardConfig","sap/ui/integration/designtime/cardEditor/config/TableCardConfig","sap/ui/integration/designtime/cardEditor/config/generateDataConfig"],function(A,H,L,O,T,g){"use strict";return{"context":"sap.card","layout":{"form":{"groups":[{"label":"{i18n>CARD_EDITOR.GROUP.METADATA}","items":[{type:"tag",value:"app"}]},{"label":"{i18n>CARD_EDITOR.GROUP.GENERALCONFIGURATION}","items":[{type:"tag",value:"general"}]},{"label":"{i18n>CARD_EDITOR.GROUP.DATA}","items":[{type:"propertyName",value:"appDataSources"},{type:"tag",value:["data","general-data"]}]},{"label":"{i18n>CARD_EDITOR.GROUP.DATAHEADER}","items":[{type:"tag",value:["data","header"]}]},{"label":"{i18n>CARD_EDITOR.GROUP.DATACONTENT}","items":[{type:"tag",value:["data","content"]}]},{"label":"{i18n>CARD_EDITOR.GROUP.HEADER}","items":[{type:"tag",value:"header"}]},{"label":"{i18n>CARD_EDITOR.GROUP.CONTENT}","items":[{type:"tag",value:"content"}]}]}},"properties":Object.assign({},A,{"type":{"tags":["general"],"label":"{i18n>CARD_EDITOR.TYPE}","type":"select","items":sap.ui.version.includes('SNAPSHOT')&&!window.location.host.includes("openui5nightly")?[{"key":"List"},{"key":"Analytical"},{"key":"Table"},{"key":"Object"},{"key":"Timeline"},{"key":"Component"},{"key":"Calendar"},{"key":"AdaptiveCard"}]:[{"key":"List"},{"key":"Table"},{"key":"Object"}],"path":"type"},"parameters":{"tags":["general"],"label":"{i18n>CARD_EDITOR.PARAMETERS}","path":"configuration/parameters","type":"parameters","allowedTypes":["string","number","boolean","integer","date","datetime"]},"destinations":{"tags":["general"],"label":"{i18n>CARD_EDITOR.DESTINATIONS}","itemLabel":"{key}","addItemLabel":"{i18n>CARD_EDITOR.DESTINATION}","path":"configuration/destinations","type":"destinations","allowedValues":["Northwind","JAM"]}},H,L,O,T,g(["general-data"],"","card"),g(["header"],"header/","header"),g(["content"],"content/","content")),"propertyEditors":{"enum":"sap/ui/integration/designtime/baseEditor/propertyEditor/enumStringEditor/EnumStringEditor","select":"sap/ui/integration/designtime/baseEditor/propertyEditor/selectEditor/SelectEditor","string":"sap/ui/integration/designtime/baseEditor/propertyEditor/stringEditor/StringEditor","simpleicon":"sap/ui/integration/designtime/baseEditor/propertyEditor/iconEditor/IconEditor","array":"sap/ui/integration/designtime/baseEditor/propertyEditor/arrayEditor/ArrayEditor","parameters":"sap/ui/integration/designtime/cardEditor/propertyEditor/parametersEditor/ParametersEditor","boolean":"sap/ui/integration/designtime/baseEditor/propertyEditor/booleanEditor/BooleanEditor","number":"sap/ui/integration/designtime/baseEditor/propertyEditor/numberEditor/NumberEditor","integer":"sap/ui/integration/designtime/baseEditor/propertyEditor/integerEditor/IntegerEditor","json":"sap/ui/integration/designtime/baseEditor/propertyEditor/jsonEditor/JsonEditor","map":"sap/ui/integration/designtime/baseEditor/propertyEditor/mapEditor/MapEditor","list":"sap/ui/integration/designtime/baseEditor/propertyEditor/listEditor/ListEditor","datetime":"sap/ui/integration/designtime/baseEditor/propertyEditor/dateTimeEditor/DateTimeEditor","date":"sap/ui/integration/designtime/baseEditor/propertyEditor/dateEditor/DateEditor","icon":"sap/ui/integration/designtime/cardEditor/propertyEditor/iconEditor/IconEditor","complexMap":"sap/ui/integration/designtime/cardEditor/propertyEditor/complexMapEditor/ComplexMapEditor","destinations":"sap/ui/integration/designtime/cardEditor/propertyEditor/destinationsEditor/DestinationsEditor"},"validators":{"patternList":"sap/ui/integration/designtime/cardEditor/validator/IsPatternMatchList"},"i18n":"sap/ui/integration/designtime/cardEditor/i18n/i18n.properties"};});
//# sourceMappingURL=library-preload.designtime.js.map