/*
 * ! OpenUI5
 * (c) Copyright 2009-2020 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["sap/ui/fl/apply/_internal/flexState/FlexState","sap/ui/fl/Layer","sap/ui/fl/Utils","sap/ui/fl/LayerUtils","sap/ui/fl/registry/ChangeRegistry","sap/ui/fl/FlexControllerFactory","sap/ui/core/util/reflection/JsControlTreeModifier","sap/ui/core/Element","sap/ui/base/ManagedObject","sap/base/util/includes","sap/ui/fl/variants/VariantManagement","sap/ui/fl/apply/_internal/controlVariants/URLHandler","sap/ui/core/Component","sap/base/Log","sap/ui/thirdparty/jquery"],function(F,L,U,a,C,b,J,E,M,i,V,c,d,e,q){"use strict";var f={_determineParameters:function(o,I,u){var A=U.getAppComponentForControl(o);var g=b.createForControl(A);var r=A.getRootControl();var p={rootControl:r,flexController:g};if(!I){var v;var h;var j;p.variantModel=A.getModel(U.VARIANT_MODEL_NAME);p.variantManagement={};if(!u){v=q.makeArray(p.rootControl.$().find(".sapUiFlVarMngmt"));}if(u||v.length===0){v=q.makeArray(q(sap.ui.getCore().getStaticAreaRef()).find(".sapUiFlVarMngmt"));}v.map(function(k){h=sap.ui.getCore().byId(k.id);if(h.getMetadata().getName()==="sap.ui.fl.variants.VariantManagement"){j=h.getFor();j.forEach(function(s){p.variantManagement[s]=p.variantModel.getLocalId(k.id,A);});}});}return p;},_getVariantManagement:function(o,p){p=p||this._determineParameters(o);var g=function(o){if(!p.variantManagement[o.getId()]&&o.getParent()&&o.getId()!==p.rootControl.getId()){return g(o.getParent());}else if(!o.getParent()||o.getId()===p.rootControl.getId()){return p.variantManagement[o.getId()]||"";}return p.variantManagement[o.getId()];};return g(o);},clearVariantParameterInURL:function(o){var u;var A=U.getAppComponentForControl(o);var v=A instanceof d?A.getModel(U.VARIANT_MODEL_NAME):undefined;if(!v){e.warning("Variant model could not be found on the provided control");}if(o instanceof V){var s=v.getLocalId(o.getId(),A);var m=c.removeURLParameterForVariantManagement({model:v,vmReference:s});u=m.parameters;}c.update({parameters:u||[],updateURL:true,updateHashEntry:!!v,model:v||{},silent:!v});},activateVariant:function(v,s){return Promise.resolve().then(function(){var o;if(typeof v==='string'||v instanceof String){o=d.get(v);if(!(o instanceof d)){o=sap.ui.getCore().byId(v);if(!(o instanceof E)){throw new Error("No valid component or control found for the provided ID");}}}else if(v instanceof d||v instanceof E){o=v;}var A=U.getAppComponentForControl(o);if(!A){throw new Error("A valid variant management control or component (instance or ID) should be passed as parameter");}var g=A.getModel(U.VARIANT_MODEL_NAME);if(!g){throw new Error("No variant management model found for the passed control or application component");}var h=g.getVariantManagementReference(s).variantManagementReference;if(!h){throw new Error("A valid control or component, and a valid variant/ID combination are required");}return g.waitForVMControlInit(h).then(function(){return g.updateCurrentVariant(h,s,A);});})["catch"](function(o){e.error(o);return Promise.reject(o);});},_checkChangeSpecificData:function(o,l){if(!o.changeSpecificData){return Promise.reject(new Error("No changeSpecificData available"));}if(!o.changeSpecificData.changeType){return Promise.reject(new Error("No valid changeType"));}if(!(o.selectorControl instanceof E)){return Promise.reject(new Error("No valid selectorControl"));}var s=o.selectorControl.getMetadata().getName();var g=C.getInstance();return g.getChangeHandler(o.changeSpecificData.changeType,s,o.selectorControl,J,l);},addPersonalizationChanges:function(p){var s=[];var l=a.getCurrentLayer(true);var P=[];p.controlChanges.forEach(function(o){var m={};Object.assign(m,{developerMode:false,layer:l});function g(){return this._checkChangeSpecificData(o,l).then(function(){var h=this._determineParameters(o.selectorControl,p.ignoreVariantManagement,p.useStaticArea);if(!p.ignoreVariantManagement){if(!o.changeSpecificData.variantReference){var v=this._getVariantManagement(o.selectorControl,h);if(v){var j=h.variantModel.oData[v].currentVariant;o.changeSpecificData.variantReference=j;}}}else{delete o.changeSpecificData.variantReference;}return h.flexController.createAndApplyChange(Object.assign(m,o.changeSpecificData),o.selectorControl);}.bind(this)).then(function(A){s.push(A);}).catch(function(h){return Promise.reject({change:o,message:h.message});});}P.push(g.bind(this));}.bind(this));return U.execPromiseQueueSequentially(P).then(function(){return s;});},isPersonalized:function(g,h){if(!g||g.length===0){return this._reject("At least one control ID has to be provided as a parameter");}var A=g[0].appComponent||U.getAppComponentForControl(g[0]);if(!A){return this._reject("App Component could not be determined");}var I=g.map(function(j){return j.id||j.getId();});var o=b.createForControl(A);return o.getComponentChanges({currentLayer:L.USER,includeCtrlVariants:true}).then(function(j){return j.filter(this._filterBySelectors.bind(this,A,I)).filter(this._filterByChangeType.bind(this,h)).some(this._ifValidFileType);}.bind(this));},_reject:function(m){e.error(m);return Promise.reject(m);},_filterBySelectors:function(A,I,o){var s=o.getSelector();var g=J.getControlIdBySelector(s,A);return i(I,g);},_filterByChangeType:function(g,o){return(Array.isArray(g)&&g.length>0)?i(g,o.getChangeType()):true;},_ifValidFileType:function(o){return o.getFileType()==="change";},resetChanges:function(g,h){if(!g||g.length===0){return this._reject("At least one control ID has to be provided as a parameter");}var A=g[0].appComponent||U.getAppComponentForControl(g[0]);if(!A){return this._reject("App Component could not be determined");}var s=g.map(function(v){var j=v.id||v.getId();var l=A.getLocalId(j);return l||j;});var o=b.createForControl(A);return o.resetChanges(L.USER,undefined,A,s,h);},saveChanges:function(g,m){if(!(m instanceof M)){var s="A valid sap.ui.base.ManagedObject instance is required as a parameter";e.error(s);return Promise.reject(s);}var p=f._determineParameters(m);var A=U.getAppComponentForControl(m);var v=Object.keys(p.variantManagement).reduce(function(r,h){return r.concat([p.variantManagement[h]]);},[]);return p.flexController.saveSequenceOfDirtyChanges(g,A).then(function(r){p.variantModel.checkDirtyStateForControlModels(v);return r;});},hasVariantManagement:function(o){try{return!!this._getVariantManagement(o);}catch(g){e.error(g.message);return false;}}};return f;},true);
