/*!
 * OpenUI5
 * (c) Copyright 2009-2020 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(['sap/ui/base/Object','sap/ui/core/Locale','sap/ui/core/LocaleData','sap/base/Log','sap/base/assert','sap/base/util/extend'],function(B,L,a,b,c,e){"use strict";var N=B.extend("sap.ui.core.format.NumberFormat",{constructor:function(F){throw new Error();}});var r=/0+(\.0+)?/;var d=/^0+$/;var n={INTEGER:"integer",FLOAT:"float",CURRENCY:"currency",UNIT:"unit",PERCENT:"percent"};var R={FLOOR:"floor",CEILING:"ceiling",TOWARDS_ZERO:"towards_zero",AWAY_FROM_ZERO:"away_from_zero",HALF_FLOOR:"half_floor",HALF_CEILING:"half_ceiling",HALF_TOWARDS_ZERO:"half_towards_zero",HALF_AWAY_FROM_ZERO:"half_away_from_zero"};var m={};m[R.FLOOR]=Math.floor;m[R.CEILING]=Math.ceil;m[R.TOWARDS_ZERO]=function(i){return i>0?Math.floor(i):Math.ceil(i);};m[R.AWAY_FROM_ZERO]=function(i){return i>0?Math.ceil(i):Math.floor(i);};m[R.HALF_TOWARDS_ZERO]=function(i){return i>0?Math.ceil(i-0.5):Math.floor(i+0.5);};m[R.HALF_AWAY_FROM_ZERO]=function(i){return i>0?Math.floor(i+0.5):Math.ceil(i-0.5);};m[R.HALF_FLOOR]=function(i){return Math.ceil(i-0.5);};m[R.HALF_CEILING]=Math.round;N.RoundingMode=R;N.oDefaultIntegerFormat={minIntegerDigits:1,maxIntegerDigits:99,minFractionDigits:0,maxFractionDigits:0,groupingEnabled:false,groupingSize:3,groupingSeparator:",",decimalSeparator:".",plusSign:"+",minusSign:"-",isInteger:true,type:n.INTEGER,showMeasure:false,style:"standard",parseAsString:false,roundingMode:N.RoundingMode.TOWARDS_ZERO,emptyString:NaN,showScale:true};N.oDefaultFloatFormat={minIntegerDigits:1,maxIntegerDigits:99,minFractionDigits:0,maxFractionDigits:99,groupingEnabled:true,groupingSize:3,groupingSeparator:",",decimalSeparator:".",plusSign:"+",minusSign:"-",isInteger:false,type:n.FLOAT,showMeasure:false,style:"standard",parseAsString:false,roundingMode:N.RoundingMode.HALF_AWAY_FROM_ZERO,emptyString:NaN,showScale:true};N.oDefaultPercentFormat={minIntegerDigits:1,maxIntegerDigits:99,minFractionDigits:0,maxFractionDigits:99,groupingEnabled:true,groupingSize:3,groupingSeparator:",",decimalSeparator:".",plusSign:"+",minusSign:"-",percentSign:"%",isInteger:false,type:n.PERCENT,showMeasure:false,style:"standard",parseAsString:false,roundingMode:N.RoundingMode.HALF_AWAY_FROM_ZERO,emptyString:NaN,showScale:true};N.oDefaultCurrencyFormat={minIntegerDigits:1,maxIntegerDigits:99,groupingEnabled:true,groupingSize:3,groupingSeparator:",",decimalSeparator:".",plusSign:"+",minusSign:"-",isInteger:false,type:n.CURRENCY,showMeasure:true,currencyCode:true,currencyContext:'standard',style:"standard",customCurrencies:undefined,parseAsString:false,roundingMode:N.RoundingMode.HALF_AWAY_FROM_ZERO,emptyString:NaN,showScale:true,ignorePrecision:true};N.oDefaultUnitFormat={minIntegerDigits:1,maxIntegerDigits:99,groupingEnabled:true,groupingSize:3,groupingSeparator:",",decimalSeparator:".",plusSign:"+",minusSign:"-",isInteger:false,type:n.UNIT,showMeasure:true,style:"standard",customUnits:undefined,allowedUnits:undefined,parseAsString:false,roundingMode:N.RoundingMode.HALF_AWAY_FROM_ZERO,emptyString:NaN,showScale:true};N.getInstance=function(F,i){return this.getFloatInstance(F,i);};N.getFloatInstance=function(F,i){var t=this.createInstance(F,i),u=this.getLocaleFormatOptions(t.oLocaleData,n.FLOAT);t.oFormatOptions=e({},this.oDefaultFloatFormat,u,F);return t;};N.getIntegerInstance=function(F,i){var t=this.createInstance(F,i),u=this.getLocaleFormatOptions(t.oLocaleData,n.INTEGER);t.oFormatOptions=e({},this.oDefaultIntegerFormat,u,F);return t;};N.getCurrencyInstance=function(F,i){var t=this.createInstance(F,i);var C=F&&F.currencyContext;var S=s(F);if(S){C=C||this.oDefaultCurrencyFormat.style;C="sap-"+C;}var u=this.getLocaleFormatOptions(t.oLocaleData,n.CURRENCY,C);t.oFormatOptions=e({},this.oDefaultCurrencyFormat,u,F);t.oFormatOptions.trailingCurrencyCode=S;t._defineCustomCurrencySymbols();return t;};N.getUnitInstance=function(F,i){var t=this.createInstance(F,i),u=this.getLocaleFormatOptions(t.oLocaleData,n.UNIT);t.oFormatOptions=e({},this.oDefaultUnitFormat,u,F);return t;};N.getPercentInstance=function(F,i){var t=this.createInstance(F,i),u=this.getLocaleFormatOptions(t.oLocaleData,n.PERCENT);t.oFormatOptions=e({},this.oDefaultPercentFormat,u,F);return t;};N.createInstance=function(F,i){var t=Object.create(this.prototype),P;if(F instanceof L){i=F;F=undefined;}if(!i){i=sap.ui.getCore().getConfiguration().getFormatSettings().getFormatLocale();}t.oLocale=i;t.oLocaleData=a.getInstance(i);t.oOriginalFormatOptions=F;if(F){if(F.pattern){P=this.parseNumberPattern(F.pattern);Object.keys(P).forEach(function(u){F[u]=P[u];});}if(F.emptyString!==undefined){c(F.emptyString===""||F.emptyString===0||F.emptyString===null||F.emptyString!==F.emptyString,"The format option 'emptyString' must be either 0, null or NaN");}}return t;};N.getDefaultUnitPattern=function(S){return"{0} "+S;};N.getLocaleFormatOptions=function(i,t,C){var u,v;switch(t){case n.PERCENT:v=i.getPercentPattern();break;case n.CURRENCY:v=i.getCurrencyPattern(C);break;case n.UNIT:v=i.getDecimalPattern();break;default:v=i.getDecimalPattern();}u=this.parseNumberPattern(v);u.plusSign=i.getNumberSymbol("plusSign");u.minusSign=i.getNumberSymbol("minusSign");u.decimalSeparator=i.getNumberSymbol("decimal");u.groupingSeparator=i.getNumberSymbol("group");u.percentSign=i.getNumberSymbol("percentSign");u.pattern=v;switch(t){case n.UNIT:case n.FLOAT:case n.PERCENT:u.minFractionDigits=0;u.maxFractionDigits=99;break;case n.INTEGER:u.minFractionDigits=0;u.maxFractionDigits=0;u.groupingEnabled=false;break;case n.CURRENCY:u.minFractionDigits=undefined;u.maxFractionDigits=undefined;break;}return u;};N.parseNumberPattern=function(F){var M=0,t=0,u=0,G=false,v=0,w=0,S=F.indexOf(";"),x={Integer:0,Fraction:1},y=x.Integer;if(S!==-1){F=F.substring(0,S);}for(var i=0;i<F.length;i++){var C=F[i];switch(C){case",":if(G){v=w;w=0;}G=true;break;case".":y=x.Fraction;break;case"0":if(y===x.Integer){M++;if(G){w++;}}else{t++;u++;}break;case"#":if(y===x.Integer){if(G){w++;}}else{u++;}break;}}if(!v){v=w;w=0;}return{minIntegerDigits:M,minFractionDigits:t,maxFractionDigits:u,groupingEnabled:G,groupingSize:v,groupingBaseSize:w};};N.prototype._defineCustomCurrencySymbols=function(){var O=this.oFormatOptions;var C=this.oLocaleData.getCurrencySymbols();var F=function(S,i){var u=[];var t;for(var K in S){t=S[K];if(u.indexOf(t)===-1){u.push(t);}else if(t!==undefined){i[t]=true;b.error("Symbol '"+t+"' is defined multiple times in custom currencies.",undefined,"NumberFormat");}}};if(O.customCurrencies&&typeof O.customCurrencies==="object"){this.mKnownCurrencySymbols={};this.mKnownCurrencyCodes={};Object.keys(O.customCurrencies).forEach(function(K){if(O.customCurrencies[K].symbol){this.mKnownCurrencySymbols[K]=O.customCurrencies[K].symbol;}else{var i=O.customCurrencies[K].isoCode;if(i){this.mKnownCurrencySymbols[K]=C[i];}}this.mKnownCurrencyCodes[K]=K;}.bind(this));}else{this.mKnownCurrencySymbols=C;this.mKnownCurrencyCodes=this.oLocaleData.getCustomCurrencyCodes();}this.mDuplicatedSymbols={};F(this.mKnownCurrencySymbols,this.mDuplicatedSymbols);};N.prototype.format=function(v,M){if(Array.isArray(v)){M=v[1];v=v[0];}var i="",F="",G="",t="",u="",P="",w=0,x=0,y=0,z=0,A=v<0,D=-1,O=Object.assign({},this.oFormatOptions),C=this.oOriginalFormatOptions,I=O.type===n.CURRENCY&&M==="INR"&&this.oLocale.getLanguage()==="en"&&this.oLocale.getRegion()==="IN",E,S,H,J,U,K;if(v===O.emptyString||(isNaN(v)&&isNaN(O.emptyString))){return"";}if(M&&O.customCurrencies&&!O.customCurrencies[M]){b.error("Currency '"+M+"' is unknown.");return"";}if(O.type===n.UNIT){if(O.customUnits&&typeof O.customUnits==="object"){U=O.customUnits[M];}else{K=this.oLocaleData.getUnitFromMapping(M)||M;U=this.oLocaleData.getUnitFormat(K);}O.decimals=(U&&(typeof U.decimals==="number"&&U.decimals>=0))?U.decimals:O.decimals;O.precision=(U&&(typeof U.precision==="number"&&U.precision>=0))?U.precision:O.precision;}if(O.type==n.CURRENCY){if(O.customCurrencies&&O.customCurrencies[M]){O.decimals=O.customCurrencies[M].decimals!==undefined?O.customCurrencies[M].decimals:O.decimals;}}if(O.decimals!==undefined){O.minFractionDigits=O.decimals;O.maxFractionDigits=O.decimals;}if(O.shortLimit===undefined||Math.abs(v)>=O.shortLimit){H=O.shortRefNumber===undefined?v:O.shortRefNumber;S=g(H,O,this.oLocaleData,I);if(S&&S.formatString!="0"){v=v/S.magnitude;if(O.shortDecimals!==undefined){O.minFractionDigits=O.shortDecimals;O.maxFractionDigits=O.shortDecimals;}else{if(C.minFractionDigits===undefined&&C.maxFractionDigits===undefined&&C.decimals===undefined&&C.precision===undefined&&C.pattern===undefined){O.precision=2;O.minFractionDigits=0;O.maxFractionDigits=99;}if(C.maxFractionDigits===undefined&&C.decimals===undefined){O.maxFractionDigits=99;}}O.roundingMode=N.RoundingMode.HALF_AWAY_FROM_ZERO;}}if((S||!O.ignorePrecision)&&O.precision!==undefined){O.maxFractionDigits=Math.min(O.maxFractionDigits,k(v,O.precision));O.minFractionDigits=Math.min(O.minFractionDigits,O.maxFractionDigits);}if(O.type==n.PERCENT){v=N._shiftDecimalPoint(v,2);}if(O.type==n.CURRENCY){var Q=this.oLocaleData.getCurrencyDigits(M);if(O.customCurrencies&&O.customCurrencies[M]&&O.customCurrencies[M].decimals!==undefined){Q=O.customCurrencies[M].decimals;}if(O.maxFractionDigits===undefined){O.maxFractionDigits=Q;}if(O.minFractionDigits===undefined){O.minFractionDigits=Q;}}if(typeof v==="number"){v=j(v,O.maxFractionDigits,O.roundingMode);}if(v==0){A=false;}u=this.convertToDecimal(v);if(u=="NaN"){return u;}if(A){u=u.substr(1);}D=u.indexOf(".");if(D>-1){i=u.substr(0,D);F=u.substr(D+1);}else{i=u;}if(i.length<O.minIntegerDigits){i=i.padStart(O.minIntegerDigits,"0");}else if(i.length>O.maxIntegerDigits){i="".padStart(O.maxIntegerDigits,"?");}if(F.length<O.minFractionDigits){F=F.padEnd(O.minFractionDigits,"0");}else if(F.length>O.maxFractionDigits){F=F.substr(0,O.maxFractionDigits);}x=i.length;if(O.groupingEnabled){if(I){var T=[3,2,2],V,W=0;w=i.length;while(w>0){V=T[W%3];w-=V;if(W>0){G=O.groupingSeparator+G;}if(w<0){V+=w;w=0;}G=i.substr(w,V)+G;W++;}}else{y=O.groupingSize;z=O.groupingBaseSize||y;w=Math.max(x-z,0)%y||y;G=i.substr(0,w);while(x-w>=z){G+=O.groupingSeparator;G+=i.substr(w,y);w+=y;}G+=i.substr(w);}}else{G=i;}if(A){t=O.minusSign;}t+=G;if(F){t+=O.decimalSeparator+F;}if(S&&S.formatString&&O.showScale&&O.type!==n.CURRENCY){J=this.oLocaleData.getPluralCategory(i+"."+F);S.formatString=this.oLocaleData.getDecimalFormat(O.style,S.key,J);t=S.formatString.replace(S.valueSubString,t);t=t.replace(/'.'/g,".");}if(O.type===n.CURRENCY){P=O.pattern;if(S&&S.formatString&&O.showScale){var X;if(O.trailingCurrencyCode){X="sap-short";}else{X="short";}J=this.oLocaleData.getPluralCategory(i+"."+F);if(I){P=h(X,S.key,J);}else{P=this.oLocaleData.getCurrencyFormat(X,S.key,J);}P=P.replace(/'.'/g,".");}E=P.split(";");if(E.length===2){P=A?E[1]:E[0];if(A){t=t.substring(1);}}if(!O.currencyCode){var Y;if(O.customCurrencies&&typeof O.customCurrencies==="object"){Y=this.mKnownCurrencySymbols[M];}else{Y=this.oLocaleData.getCurrencySymbol(M);}if(Y&&Y!==M){M=Y;}}t=this._composeCurrencyResult(P,t,M,{showMeasure:O.showMeasure,negative:A,minusSign:O.minusSign});}if(O.type===n.PERCENT){P=O.pattern;t=P.replace(/[0#.,]+/,t);t=t.replace(/%/,O.percentSign);}if(O.showMeasure&&O.type===n.UNIT){J=this.oLocaleData.getPluralCategory(i+"."+F);c(J,"Cannot find plural category for "+(i+"."+F));var Z=!O.allowedUnits||O.allowedUnits.indexOf(M)>=0;if(!Z){c(Z,"The given unit '"+M+"' is not part of the allowed unit types: ["+O.allowedUnits.join(",")+"].");return"";}if(U){P=U["unitPattern-count-"+J];if(!P){P=U["unitPattern-count-other"];}c(P,"Cannot find pattern 'unitPattern-count-"+J+"' in '"+M+"'");if(!P){return"";}t=P.replace("{0}",t);}else if(!O.unitOptional){c(U,"Unit '"+M+"' is unknown");return"";}}if(sap.ui.getCore().getConfiguration().getOriginInfo()){t=new String(t);t.originInfo={source:"Common Locale Data Repository",locale:this.oLocale.toString()};}return t;};N.prototype._composeCurrencyResult=function(P,F,M,O){var i=O.minusSign;P=P.replace(/[0#.,]+/,F);if(O.showMeasure&&M){var t="\u00a4",u={"[:digit:]":/\d/,"[:^S:]":/[^\$\xA2-\xA5\u058F\u060B\u09F2\u09F3\u09FB\u0AF1\u0BF9\u0E3F\u17DB\u20A0-\u20BD\uA838\uFDFC\uFE69\uFF04\uFFE0\uFFE1\uFFE5\uFFE6]/},v=P.indexOf(t),w=v<P.length/2?"after":"before",S=this.oLocaleData.getCurrencySpacing(w),C=(w==="after"?M.charAt(M.length-1):M.charAt(0)),x,y=u[S.currencyMatch],z=u[S.surroundingMatch],I;P=P.replace(t,M);x=(w==="after"?P.charAt(v+M.length):P.charAt(v-1));if(y&&y.test(C)&&z&&z.test(x)){if(w==="after"){I=v+M.length;}else{I=v;}P=P.slice(0,I)+S.insertBetween+P.slice(I);}else if(O.negative&&w==="after"){i="\ufeff"+O.minusSign;}}else{P=P.replace(/\s*\u00a4\s*/,"");}if(O.negative){P=P.replace(/-/,i);}return P;};N.prototype.parse=function(v){var O=this.oFormatOptions,P=O.plusSign+this.oLocaleData.getLenientNumberSymbols("plusSign"),M=O.minusSign+this.oLocaleData.getLenientNumberSymbols("minusSign"),t=q(P+M),G=q(O.groupingSeparator),D=q(O.decimalSeparator),u="^\\s*(["+t+"]?(?:[0-9"+G+"]+|[0-9"+G+"]*"+D+"[0-9]*)(?:[eE][+-][0-9]+)?)\\s*$",w="^\\s*(["+t+"]?[0-9"+G+"]+)\\s*$",x=new RegExp(G,"g"),y=new RegExp(D,"g"),z=this.oLocaleData.getNumberSymbol("percentSign"),I=O.type===n.CURRENCY&&this.oLocale.getLanguage()==="en"&&this.oLocale.getRegion()==="IN",A,C,E,F,H=0,S,J;if(v===""){J=O.emptyString;if(O.parseAsString&&(O.emptyString===0||isNaN(O.emptyString))){J=O.emptyString+"";}if(O.type===n.CURRENCY||O.type===n.UNIT){return[J,undefined];}else{return J;}}F=O.type===n.PERCENT?O.pattern:this.oLocaleData.getPercentPattern();if(F.charAt(0)==="%"){u=u.slice(0,1)+"%?"+u.slice(1);}else if(F.charAt(F.length-1)==="%"){u=u.slice(0,u.length-1)+"%?"+u.slice(u.length-1);}var U;if(O.type===n.UNIT){var K;if(O.customUnits&&typeof O.customUnits==="object"){K=O.customUnits;}else{K=this.oLocaleData.getUnitFormats();}c(K,"Unit patterns cannot be loaded");if(O.allowedUnits){var Q={};for(var i=0;i<O.allowedUnits.length;i++){var T=O.allowedUnits[i];Q[T]=K[T];}K=Q;}var V=p(K,v);var W=false;U=V.cldrCode;if(U.length===1){E=U[0];}else if(U.length===0){if((O.unitOptional||!O.showMeasure)&&typeof v==="string"){V.numberValue=v;}else{c(U.length===1,"Cannot find unit for input: '"+(v)+"'");return null;}}else{c(U.length===1,"Ambiguous unit ["+U.join(", ")+"] for input: '"+(v)+"'");E=undefined;W=true;}if(O.strictParsing){if((E&&!O.showMeasure)||W){return null;}}v=V.numberValue||v;}var X;if(O.type===n.CURRENCY){X=o({value:v,currencySymbols:this.mKnownCurrencySymbols,customCurrencyCodes:this.mKnownCurrencyCodes,duplicatedSymbols:this.mDuplicatedSymbols,customCurrenciesAvailable:!!O.customCurrencies});if(!X){return null;}if(O.strictParsing){if((O.showMeasure&&!X.currencyCode)||X.duplicatedSymbolFound){return null;}}v=X.numberValue;E=X.currencyCode;if((O.customCurrencies&&E===null)||(!O.showMeasure&&E)){return null;}}if(typeof v==="string"||v instanceof String){v=v.replace(/[\u202a\u200e\u202c\u202b\u200f]/g,"");v=v.replace(/\s/g,"");}S=f(v,this.oLocaleData,I);if(S){v=S.number;}if(O.isInteger&&!S){A=new RegExp(w);}else{A=new RegExp(u);}if(!A.test(v)){return O.type===n.CURRENCY||O.type===n.UNIT?null:NaN;}v=v.replace(x,"");var Y=v.length;for(var Z=0;Z<Y;Z++){var $=v[Z];if(P.includes($)){v=v.replace($,"+");break;}else if(M.includes($)){v=v.replace($,"-");break;}}v=v.replace(/^\+/,"");if(S){v=v.replace(y,".");v=N._shiftDecimalPoint(v,Math.round(Math.log(S.factor)/Math.LN10));}if(O.isInteger){H=O.parseAsString?v:parseInt(v);}else{v=v.replace(y,".");if(v.indexOf(z)!==-1){C=true;v=v.replace(z,"");}H=O.parseAsString?v:parseFloat(v);if(C){H=N._shiftDecimalPoint(H,-2);}}if(O.parseAsString){H=N._shiftDecimalPoint(v,0);}if(O.type===n.CURRENCY||O.type===n.UNIT){return[H,E];}return H;};N.prototype.convertToDecimal=function(v){var V=""+v,t,u,D,F,E,P;if(V.indexOf("e")==-1&&V.indexOf("E")==-1){return V;}var w=V.match(/^([+-]?)((\d+)(?:\.(\d+))?)[eE]([+-]?\d+)$/);t=w[1]=="-";u=w[2].replace(/\./g,"");D=w[3]?w[3].length:0;F=w[4]?w[4].length:0;E=parseInt(w[5]);if(E>0){if(E<F){P=D+E;V=u.substr(0,P)+"."+u.substr(P);}else{V=u;E-=F;for(var i=0;i<E;i++){V+="0";}}}else{if(-E<D){P=D+E;V=u.substr(0,P)+"."+u.substr(P);}else{V=u;E+=D;for(var i=0;i>E;i--){V="0"+V;}V="0."+V;}}if(t){V="-"+V;}return V;};N.prototype.getScale=function(){if((this.oFormatOptions.style!=="short"&&this.oFormatOptions.style!=="long")||this.oFormatOptions.shortRefNumber===undefined){return;}var S=g(this.oFormatOptions.shortRefNumber,this.oFormatOptions,this.oLocaleData),i;if(S&&S.formatString){i=S.formatString.replace(r,"").replace(/'.'/g,".").trim();if(i){return i;}}};N._shiftDecimalPoint=function(v,S){if(typeof S!=="number"){return NaN;}var M="";var E=v.toString().toLowerCase().split("e");if(typeof v==="number"){S=E[1]?(+E[1]+S):S;return+(E[0]+"e"+S);}else if(typeof v==="string"){if(parseFloat(v)===0&&S>=0){return d.test(v)?"0":v;}var F=E[0].charAt(0);M=F==="-"?F:"";if(M){E[0]=E[0].slice(1);}v=E[0];var D=v.indexOf("."),A,i,t;if(D===-1){v=v+".";D=v.length-1;}if(E[1]){D+=(+E[1]);}A=D+S;if(A<=0){v=v.padStart(v.length-A+1,'0');A=1;}else if(A>=v.length-1){v=v.padEnd(A+1,'0');A=v.length-1;}v=v.replace(".","");i=v.substring(0,A);t=v.substring(A);i=i.replace(/^(-?)0+(\d)/,"$1$2");return M+i+(t?("."+t):"");}else{return null;}};function g(v,O,t,I){var S,K,u,C,w=O.style,P=O.precision!==undefined?O.precision:2;if(w!="short"&&w!="long"){return undefined;}for(var i=0;i<15;i++){K=Math.pow(10,i);if(j(Math.abs(v)/K,P-1)<10){break;}}u=K.toString();if(O.type===n.CURRENCY){if(O.trailingCurrencyCode){w="sap-short";}if(I){C=h(w,u,"other",true);}else{C=t.getCurrencyFormat(w,u,"other");}}else{C=t.getDecimalFormat(w,u,"other");}if(!C||C=="0"){return undefined;}else{S={};S.key=u;S.formatString=C;var x=C.match(r);if(x){S.valueSubString=x[0];var y=S.valueSubString.indexOf(".");if(y==-1){S.decimals=0;S.magnitude=K*Math.pow(10,1-S.valueSubString.length);}else{S.decimals=S.valueSubString.length-y-1;S.magnitude=K*Math.pow(10,1-y);}}else{return undefined;}}return S;}function f(v,t,I){var u,F=1,K=10,P=t.getPluralCategories(),C,w={number:undefined,factor:F},G=function(y,K,S,z){if(z){C=h(S,K.toString(),y,true);}else{C=t.getDecimalFormat(S,K.toString(),y);}if(C){C=C.replace(/[\s\u00a0\u200F]/g,"");C=C.replace(/'.'/g,".");var A=C.match(r);if(A){var V=A[0];var U=C.replace(V,"");if(!U){return;}var D=v.indexOf(U);if(D>=0){u=v.replace(U,"");u=u.replace(/\u200F/g,"");F=K;F*=Math.pow(10,1-V.length);if(w.number===undefined||u.length<w.number.length){w.number=u;w.factor=F;}}}}};["long","short"].forEach(function(S){K=10;while(K<1e15){for(var i=0;i<P.length;i++){var x=P[i];G(x,K,S);}K=K*10;}});if(I&&!u){K=10;while(K<1e15){for(var i=0;i<P.length;i++){var x=P[i];G(x,K,"short",true);}K=K*10;}}if(!u){return;}return w;}function s(F){var S=sap.ui.getCore().getConfiguration().getFormatSettings().getTrailingCurrencyCode();if(F){if(F.trailingCurrencyCode!==undefined){S=F.trailingCurrencyCode;}if(F.pattern){S=false;}if(F.currencyCode===false){S=false;}}return S;}function h(S,K,P,D){var F,C={"short":{"1000-one":"¤0000","1000-other":"¤0000","10000-one":"¤00000","10000-other":"¤00000","100000-one":"¤0 Lk","100000-other":"¤0 Lk","1000000-one":"¤00 Lk","1000000-other":"¤00 Lk","10000000-one":"¤0 Cr","10000000-other":"¤0 Cr","100000000-one":"¤00 Cr","100000000-other":"¤00 Cr","1000000000-one":"¤000 Cr","1000000000-other":"¤000 Cr","10000000000-one":"¤0000 Cr","10000000000-other":"¤0000 Cr","100000000000-one":"¤00000 Cr","100000000000-other":"¤00000 Cr","1000000000000-one":"¤0 Lk Cr","1000000000000-other":"¤0 Lk Cr","10000000000000-one":"¤00 Lk Cr","10000000000000-other":"¤00 Lk Cr","100000000000000-one":"¤0 Cr Cr","100000000000000-other":"¤0 Cr Cr"},"sap-short":{"1000-one":"0000 ¤","1000-other":"0000 ¤","10000-one":"00000 ¤","10000-other":"00000 ¤","100000-one":"0 Lk ¤","100000-other":"0 Lk ¤","1000000-one":"00 Lk ¤","1000000-other":"00 Lk ¤","10000000-one":"0 Cr ¤","10000000-other":"0 Cr ¤","100000000-one":"00 Cr ¤","100000000-other":"00 Cr ¤","1000000000-one":"000 Cr ¤","1000000000-other":"000 Cr ¤","10000000000-one":"0000 Cr ¤","10000000000-other":"0000 Cr ¤","100000000000-one":"00000 Cr ¤","100000000000-other":"00000 Cr ¤","1000000000000-one":"0 Lk Cr ¤","1000000000000-other":"0 Lk Cr ¤","10000000000000-one":"00 Lk Cr ¤","10000000000000-other":"00 Lk Cr ¤","100000000000000-one":"0 Cr Cr ¤","100000000000000-other":"0 Cr Cr ¤"}},i={"short":{"1000-one":"0000","1000-other":"0000","10000-one":"00000","10000-other":"00000","100000-one":"0 Lk","100000-other":"0 Lk","1000000-one":"00 Lk","1000000-other":"00 Lk","10000000-one":"0 Cr","10000000-other":"0 Cr","100000000-one":"00 Cr","100000000-other":"00 Cr","1000000000-one":"000 Cr","1000000000-other":"000 Cr","10000000000-one":"0000 Cr","10000000000-other":"0000 Cr","100000000000-one":"00000 Cr","100000000000-other":"00000 Cr","1000000000000-one":"0 Lk Cr","1000000000000-other":"0 Lk Cr","10000000000000-one":"00 Lk Cr","10000000000000-other":"00 Lk Cr","100000000000000-one":"0 Cr Cr","100000000000000-other":"0 Cr Cr"}};i["sap-short"]=i["short"];var t=D?i:C;var u=t[S];if(!u){u=t["short"];}if(P!=="one"){P="other";}F=u[K+"-"+P];return F;}function j(v,M,i){if(typeof v!=="number"){return NaN;}i=i||N.RoundingMode.HALF_AWAY_FROM_ZERO;M=parseInt(M);if(typeof i==="function"){v=i(v,M);}else{if(!M){return m[i](v);}v=N._shiftDecimalPoint(m[i](N._shiftDecimalPoint(v,M)),-M);}return v;}function q(i){return i.replace(/([.?*+^$[\]\\(){}|-])/g,"\\$1");}function k(v,P){var i=Math.floor(Math.log(Math.abs(v))/Math.LN10);return Math.max(0,P-i-1);}function p(u,v){var i={numberValue:undefined,cldrCode:[]};if(typeof v!=="string"){return i;}var t=Number.POSITIVE_INFINITY;var U,K;for(U in u){for(K in u[U]){if(K.indexOf("unitPattern")===0){var w=u[U][K];var x=w.indexOf("{0}");var C=x>-1;if(C){var P=w.substring(0,x);var y=w.substring(x+"{0}".length);var M=v.startsWith(P)&&v.endsWith(y);var z=M&&v.substring(P.length,v.length-y.length);if(z){if(z.length<t){t=z.length;i.numberValue=z;i.cldrCode=[U];}else if(z.length===t&&i.cldrCode.indexOf(U)===-1){i.cldrCode.push(U);}}}else if(w===v){i.cldrCode=[U];var A;if(K.endsWith("-zero")){A="0";}else if(K.endsWith("-one")){A="1";}else if(K.endsWith("-two")){A="2";}i.numberValue=A;return i;}}}}return i;}function l(v,C){var S="",i,t;for(var u in C){t=C[u];if(v.indexOf(t)>=0&&S.length<t.length){S=t;i=u;}}return{symbol:S,code:i};}function o(C){var v=C.value;var M=l(v,C.currencySymbols);if(!M.code){M=l(v,C.customCurrencyCodes);if(!M.code&&!C.customCurrenciesAvailable){var i=v.match(/(^[A-Z]{3}|[A-Z]{3}$)/);M.code=i&&i[0];}}if(M.code){var t=M.code.length-1;var u=M.code.charAt(t);var D;var w=/[\-\s]+/;if(/\d$/.test(u)){if(v.startsWith(M.code)){D=t+1;if(!w.test(v.charAt(D))){return undefined;}}}else if(/^\d/.test(M.code)){if(v.endsWith(M.code)){D=v.indexOf(M.code)-1;if(!w.test(v.charAt(D))){return undefined;}}}v=v.replace(M.symbol||M.code,"");}var x=false;if(C.duplicatedSymbols&&C.duplicatedSymbols[M.symbol]){M.code=undefined;x=true;b.error("The parsed currency symbol '"+M.symbol+"' is defined multiple "+"times in custom currencies.Therefore the result is not distinct.");}return{numberValue:v,currencyCode:M.code||undefined,duplicatedSymbolFound:x};}return N;});
