/*!
 * OpenUI5
 * (c) Copyright 2009-2020 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(['sap/m/semantic/SegmentedContainer','sap/m/semantic/SemanticConfiguration','sap/m/Button','sap/m/Title','sap/m/Page','sap/m/OverflowToolbar','sap/m/ToolbarSpacer','sap/m/Bar','sap/ui/core/CustomData','sap/ui/base/ManagedObject','sap/m/PageAccessibleLandmarkInfo','sap/ui/base/ManagedObjectObserver','sap/ui/core/Control','sap/ui/core/library','sap/m/library',"./SemanticPageRenderer","sap/base/Log","sap/ui/thirdparty/jquery"],function(S,a,B,T,P,O,b,c,C,M,d,e,f,g,l,h,L,q){"use strict";var i=l.ButtonType;var j=l.PageBackgroundDesign;var k=l.semantic.SemanticRuleSetType;var m=g.TitleLevel;var n=f.extend("sap.m.semantic.SemanticPage",{metadata:{library:"sap.m",properties:{title:{type:"string",group:"Misc",defaultValue:null},titleLevel:{type:"sap.ui.core.TitleLevel",group:"Appearance",defaultValue:m.Auto},showNavButton:{type:"boolean",group:"Appearance",defaultValue:false},showSubHeader:{type:"boolean",group:"Appearance",defaultValue:true},enableScrolling:{type:"boolean",group:"Behavior",defaultValue:true},showFooter:{type:"boolean",group:"Appearance",defaultValue:true},floatingFooter:{type:"boolean",group:"Appearance",defaultValue:false},semanticRuleSet:{type:"sap.m.semantic.SemanticRuleSetType",group:"Misc",defaultValue:k.Classic},backgroundDesign:{type:"sap.m.PageBackgroundDesign",group:"Appearance",defaultValue:j.Standard}},defaultAggregation:"content",aggregations:{subHeader:{type:"sap.m.IBar",multiple:false},content:{type:"sap.ui.core.Control",multiple:true,singularName:"content",forwarding:{getter:"_getPage",aggregation:"content"}},customHeaderContent:{type:"sap.m.Button",multiple:true,singularName:"customHeaderContent"},customFooterContent:{type:"sap.m.Button",multiple:true,singularName:"customFooterContent"},landmarkInfo:{type:"sap.m.PageAccessibleLandmarkInfo",multiple:false,forwarding:{getter:"_getPage",aggregation:"landmarkInfo"}},_page:{type:"sap.m.Page",multiple:false,visibility:"hidden"}},events:{navButtonPress:{}},dnd:{draggable:false,droppable:true},designtime:"sap/m/designtime/semantic/SemanticPage.designtime"}});n.prototype.init=function(){this._oHeaderObserver=new e(n.prototype._updateHeaderVisibility.bind(this));this._currentMode=a._PageMode.display;this._getPage().setCustomHeader(this._getInternalHeader());this._getPage().setFooter(new O(this.getId()+"-footer"));this.setLandmarkInfo(new d());this._getPage().setShowHeader(false);};n.prototype.exit=function(){if(this._oInternalHeader){this._oInternalHeader.destroy();this._oInternalHeader=null;}if(this._oWrappedFooter){this._oWrappedFooter.destroy();this._oWrappedFooter=null;}if(this._oTitle){this._oTitle.destroy();this._oTitle=null;}if(this._oNavButton){this._oNavButton.destroy();this._oNavButton=null;}if(this._oHeaderObserver){this._oHeaderObserver.disconnect();this._oHeaderObserver=null;}this._oPositionsMap=null;};n.prototype.setSubHeader=function(p,r){this._getPage().setSubHeader(p,r);return this;};n.prototype.getSubHeader=function(){return this._getPage().getSubHeader();};n.prototype.destroySubHeader=function(p){this._getPage().destroySubHeader(p);return this;};n.prototype.getShowSubHeader=function(){return this._getPage().getShowSubHeader();};n.prototype.setShowSubHeader=function(p,r){this._getPage().setShowSubHeader(p,r);this.setProperty("showSubHeader",p,true);return this;};n.prototype.getShowFooter=function(){return this._getPage().getShowFooter();};n.prototype.setShowFooter=function(p,r){this._getPage().setShowFooter(p,r);this.setProperty("showFooter",p,true);return this;};n.prototype.setFloatingFooter=function(F,p){this._getPage().setFloatingFooter(F,p);this.setProperty("floatingFooter",F,true);return this;};n.prototype.setTitle=function(t){var p=this._getTitle();if(p){p.setText(t);if(!p.getParent()){this._getInternalHeader().addContentMiddle(p);}}this.setProperty("title",t,true);return this;};n.prototype.setTitleLevel=function(t){this.setProperty("titleLevel",t,true);this._getTitle().setLevel(t);return this;};n.prototype.setShowNavButton=function(p){var r=this._getNavButton();if(r){r.setVisible(p);if(!r.getParent()){this._getInternalHeader().addContentLeft(r);}}this.setProperty("showNavButton",p,true);return this;};n.prototype.setEnableScrolling=function(E){this._getPage().setEnableScrolling(E);this.setProperty("enableScrolling",E,true);return this;};n.prototype.setBackgroundDesign=function(p){this.setProperty("backgroundDesign",p,true);this._getPage().setBackgroundDesign(p);return this;};n.prototype.getCustomFooterContent=function(){return this._getSegmentedFooter().getSection("customRight").getContent();};n.prototype.addCustomFooterContent=function(p,r){this._getSegmentedFooter().getSection("customRight").addContent(p,r);return this;};n.prototype.indexOfCustomFooterContent=function(p){return this._getSegmentedFooter().getSection("customRight").indexOfContent(p);};n.prototype.insertCustomFooterContent=function(p,I,r){this._getSegmentedFooter().getSection("customRight").insertContent(p,I,r);return this;};n.prototype.removeCustomFooterContent=function(p,r){return this._getSegmentedFooter().getSection("customRight").removeContent(p,r);};n.prototype.removeAllCustomFooterContent=function(p){return this._getSegmentedFooter().getSection("customRight").removeAllContent(p);};n.prototype.destroyCustomFooterContent=function(p){var r=this.getCustomFooterContent();if(!r){return this;}if(p){this.iSuppressInvalidate++;}this._getSegmentedFooter().getSection("customRight").destroy(p);if(!this.isInvalidateSuppressed()){this.invalidate();}if(p){this.iSuppressInvalidate--;}return this;};n.prototype.getCustomHeaderContent=function(){return this._getSegmentedHeader().getSection("customRight").getContent();};n.prototype.addCustomHeaderContent=function(p,r){this._getSegmentedHeader().getSection("customRight").addContent(p,r);return this;};n.prototype.indexOfCustomHeaderContent=function(p){return this._getSegmentedHeader().getSection("customRight").indexOfContent(p);};n.prototype.insertCustomHeaderContent=function(p,I,r){this._getSegmentedHeader().getSection("customRight").insertContent(p,I,r);return this;};n.prototype.removeCustomHeaderContent=function(p,r){return this._getSegmentedHeader().getSection("customRight").removeContent(p,r);};n.prototype.removeAllCustomHeaderContent=function(p){return this._getSegmentedHeader().getSection("customRight").removeAllContent(p);};n.prototype.destroyCustomHeaderContent=function(p){var r=this.getCustomHeaderContent();if(!r){return this;}if(p){this.iSuppressInvalidate++;}this._getSegmentedHeader().getSection("customRight").destroy(p);if(!this.isInvalidateSuppressed()){this.invalidate();}if(p){this.iSuppressInvalidate--;}return this;};n.prototype.setAggregation=function(A,p,r){var t=this.mAggregations[A];if(t===p){return this;}p=this.validateAggregation(A,p,false);var u=this.getMetadata().getManagedAggregation(A).type;if(a.isKnownSemanticType(u)){if(t){this._stopMonitor(t);this._removeFromInnerAggregation(t._getControl(),a.getPositionInPage(u),r);}if(p){this._initMonitor(p);this._addToInnerAggregation(p._getControl(),a.getPositionInPage(u),a.getSequenceOrderIndex(u),r);}return M.prototype.setAggregation.call(this,A,p,true);}return M.prototype.setAggregation.call(this,A,p,r);};n.prototype.destroyAggregation=function(A,p){var r=this.getMetadata().getAggregations()[A];if(r&&a.isKnownSemanticType(r.type)){var t=M.prototype.getAggregation.call(this,A);if(t){this._stopMonitor(t);if(!t._getControl().bIsDestroyed){this._removeFromInnerAggregation(t._getControl(),a.getPositionInPage(r.type),p);}}}return M.prototype.destroyAggregation.call(this,A,t,p);};n.prototype._updateHeaderVisibility=function(){var H=this._getInternalHeader();var E=(H.getContentLeft().length===0)&&(H.getContentMiddle().length===0)&&(H.getContentRight().length===0);this._getPage().setShowHeader(!E);};n.prototype._getTitle=function(){if(!this._oTitle){this._oTitle=new T(this.getId()+"-title",{text:this.getTitle()});}return this._oTitle;};n.prototype._getNavButton=function(){if(!this._oNavButton){this._oNavButton=new B(this.getId()+"-navButton",{type:i.Up,tooltip:sap.ui.getCore().getLibraryResourceBundle("sap.m").getText("PAGE_NAVBUTTON_TEXT"),press:q.proxy(this.fireNavButtonPress,this)});}return this._oNavButton;};n.prototype._initMonitor=function(p){var r=p._getConfiguration();if(r.triggers){p.attachEvent("press",this._updateCurrentMode,this);}var t=r.states,u=this;if(t){q.each(a._PageMode,function(v,w){if(t[v]){u.attachEvent(v,p._onPageStateChanged,p);}});}};n.prototype._stopMonitor=function(p){p.detachEvent("press",this._updateCurrentMode,this);var r=p._getConfiguration();var t=r.states,u=this;if(t){q.each(a._PageMode,function(v,w){if(t[v]){u.detachEvent(v,p._onPageStateChanged,p);}});}};n.prototype._updateCurrentMode=function(E){var p=E.oSource._getConfiguration();if(typeof p.triggers==='string'){this._currentMode=p.triggers;}else{var r=p.triggers.length;if(r&&r>0){for(var I=0;I<r;I++){var t=p.triggers[I];if(t&&(t.inState===this._currentMode)){this._currentMode=t.triggers;break;}}}}this.fireEvent(this._currentMode);};n.prototype._removeFromInnerAggregation=function(p,r,t){var u=this._getSemanticPositionsMap()[r];if(u&&u.oContainer&&u.sAggregation){u.oContainer["remove"+o(u.sAggregation)](p,t);}};n.prototype._addToInnerAggregation=function(p,r,t,u){if(!p||!r){return;}var v=this._getSemanticPositionsMap()[r];if(!v||!v.oContainer||!v.sAggregation){return;}if(typeof t!=='undefined'){p.addCustomData(new C({key:"sortIndex",value:t}));}return v.oContainer["add"+o(v.sAggregation)](p,u);};n.prototype._getSemanticPositionsMap=function(p,r){if(!this._oPositionsMap){this._oPositionsMap={};this._oPositionsMap[a.prototype._PositionInPage.headerLeft]={oContainer:this._getInternalHeader(),sAggregation:"contentLeft"};this._oPositionsMap[a.prototype._PositionInPage.headerRight]={oContainer:this._getSegmentedHeader().getSection("semanticRight"),sAggregation:"content"};this._oPositionsMap[a.prototype._PositionInPage.headerMiddle]={oContainer:this._getInternalHeader(),sAggregation:"contentMiddle"};this._oPositionsMap[a.prototype._PositionInPage.footerLeft]={oContainer:this._getSegmentedFooter().getSection("semanticLeft"),sAggregation:"content"};this._oPositionsMap[a.prototype._PositionInPage.footerRight_IconOnly]={oContainer:this._getSegmentedFooter().getSection("semanticRight_IconOnly"),sAggregation:"content"};this._oPositionsMap[a.prototype._PositionInPage.footerRight_TextOnly]={oContainer:this._getSegmentedFooter().getSection("semanticRight_TextOnly"),sAggregation:"content"};}return this._oPositionsMap;};n.prototype._getPage=function(){var p=this.getAggregation("_page");if(!p){this.setAggregation("_page",new P(this.getId()+"-page"));p=this.getAggregation("_page");}return p;};n.prototype._getInternalHeader=function(){if(!this._oInternalHeader){this._oInternalHeader=new c(this.getId()+"-intHeader");if(this._oHeaderObserver){this._oHeaderObserver.observe(this._oInternalHeader,{aggregations:["contentLeft","contentMiddle","contentRight"]});}}return this._oInternalHeader;};n.prototype._getAnyHeader=function(){return this._getInternalHeader();};n.prototype._getSegmentedHeader=function(){if(!this._oWrappedHeader){var H=this._getInternalHeader();if(!H){L.error("missing page header",this);return null;}this._oWrappedHeader=new S(H,"contentRight");this._oWrappedHeader.addSection({sTag:"customRight"});this._oWrappedHeader.addSection({sTag:"semanticRight"});}return this._oWrappedHeader;};n.prototype._getSegmentedFooter=function(){if(!this._oWrappedFooter){var F=this._getPage().getFooter();if(!F){L.error("missing page footer",this);return null;}this._oWrappedFooter=new S(F);this._oWrappedFooter.addSection({sTag:"semanticLeft"});this._oWrappedFooter.addSection({sTag:"spacer",aContent:[new b()]});this._oWrappedFooter.addSection({sTag:"semanticRight_TextOnly",fnSortFunction:s});this._oWrappedFooter.addSection({sTag:"customRight"});this._oWrappedFooter.addSection({sTag:"semanticRight_IconOnly",fnSortFunction:s});}return this._oWrappedFooter;};function o(N){return N.substring(0,1).toUpperCase()+N.substring(1);}function s(p,r){var t=p.data("sortIndex");var u=r.data("sortIndex");if((typeof t==='undefined')||(typeof u==='undefined')){L.warning("sortIndex missing",this);return null;}return(t-u);}return n;});
