/*!
 * OpenUI5
 * (c) Copyright 2009-2020 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(['sap/m/delegate/DateNavigation','sap/ui/core/Control','sap/ui/core/format/DateFormat','sap/ui/core/ResizeHandler','sap/ui/unified/calendar/CalendarUtils','sap/ui/unified/calendar/CalendarDate','sap/ui/unified/calendar/YearRangePicker','sap/ui/unified/calendar/YearPicker','sap/ui/unified/calendar/MonthPicker','sap/m/Column','sap/m/library','sap/m/PlanningCalendar','sap/f/PlanningCalendarInCardLegend','./PlanningCalendarInCardRenderer'],function(D,C,a,R,b,c,Y,d,M,e,l,P,f,g){"use strict";var h=P.extend("sap.f.PlanningCalendarInCard",{});var S=l.ScreenSize;var A=S.Desktop;h.prototype.init=function(){P.prototype.init.call(this,arguments);this._oInfoToolbar.addContent(this._getLegend());this.getAggregation("table").addColumn(new e({minScreenWidth:A,demandPopin:true}));this.getAggregation("table").setMode(l.ListMode.None);};h.prototype.onAfterRendering=function(){P.prototype.onAfterRendering.call(this,arguments);if(!this._sTwoColumnsResizeListener){this._sTwoColumnsResizeListener=R.register(this,this.resizeHandler);}};h.prototype.exit=function(){if(this._sTwoColumnsResizeListener){R.deregister(this._sTwoColumnsResizeListener);this._sTwoColumnsResizeListener=undefined;}P.prototype.exit.call(this,arguments);if(this._oMonthPicker){this._oMonthPicker.destroy();this._oMonthPicker=null;}if(this._oYearPicker){this._oYearPicker.destroy();this._oYearPicker=null;}if(this._oYearRangePicker){this._oYearRangePicker.destroy();this._oYearRangePicker=null;}};h.prototype.resizeHandler=function(E){E.control.toggleStyleClass("sapMPCInCardTwoColumns",E.target.getBoundingClientRect().width>576);};h.prototype._handlePickerButtonPress=function(E){var o;E.preventDefault();if(this._bYearPickerView){this._bYearRangePickerView=true;this._oYearPicker.setVisible(false);if(!this._oYearRangePicker){this._createYearRangePicker();this._oInfoToolbar.insertAggregation("content",this._oYearRangePicker,4);}else{this._oYearRangePicker.setVisible(true);}o=c.fromLocalJSDate(this.getStartDate());o.setMonth(0,1);this._oYearRangePicker.setDate(o.toLocalJSDate());this._getHeader()._oPickerBtn.setVisible(false);}else if(this._bMonthPickerView){this._bYearPickerView=true;this._oMonthPicker.setVisible(false);if(!this._oYearPicker){this._createYearPicker();this._oInfoToolbar.insertContent(this._oYearPicker,3);}else{this._oYearPicker.setVisible(true);}this._getHeader().setPickerText(this._formatYearPickerText());}else{this._bMonthPickerView=true;this._oInfoToolbar.getContent()[1].setVisible(false);if(!this._oMonthPicker){this._createMonthPicker();this._oInfoToolbar.insertContent(this._oMonthPicker,2);}else{this._oMonthPicker.setVisible(true);}this._getHeader().setPickerText(this._formatMonthPickerText());}};h.prototype._createYearRangePicker=function(){this._oYearRangePicker=new Y({date:this.getStartDate(),select:function(){var o=c.fromLocalJSDate(this.getStartDate()),s;o.setYear(this._oYearRangePicker.getYear()+Math.floor(this._oYearRangePicker.getRangeSize()/2));s=o.toLocalJSDate();this.setStartDate(s);this._oYearRangePicker.setYear(s.getFullYear());this._oYearPicker.setDate(s);this._getHeader()._oPickerBtn.setVisible(true);this._getHeader().setPickerText(this._formatYearPickerText());this._bYearRangePickerView=false;this._oYearPicker.setVisible(true);this._oYearRangePicker.setVisible(false);}.bind(this)});};h.prototype._createYearPicker=function(){this._oYearPicker=new d({date:this.getStartDate(),select:function(){var o=c.fromLocalJSDate(this.getStartDate()),s;o.setYear(this._oYearPicker.getYear());s=o.toLocalJSDate();this.setStartDate(s);this._oYearPicker.setYear(s.getFullYear());this._getHeader().setPickerText(this._formatMonthPickerText());this._bYearPickerView=false;this._oMonthPicker.setVisible(true);this._oYearPicker.setVisible(false);}.bind(this)});};h.prototype._createMonthPicker=function(){this._oMonthPicker=new M({month:this.getStartDate().getMonth(),select:function(){var o=c.fromLocalJSDate(this.getStartDate());o.setMonth(this._oMonthPicker.getMonth());this.setStartDate(o.toLocalJSDate());this._getHeader().setPickerText(this._formatPickerText());this._bMonthPickerView=false;this._oInfoToolbar.getContent()[1].setVisible(true);this._oMonthPicker.setVisible(false);}.bind(this)});};h.prototype._formatMonthPickerText=function(){return a.getDateInstance({format:"y"}).format(this.getStartDate());};h.prototype._formatYearPickerText=function(){var i=this._oYearPicker.getYear(),y=this._oYearPicker.getYears(),s=i-Math.floor(y/2),E=i+y/2-1;return""+s+" - "+E;};h.prototype._applyArrowsLogic=function(B){var j=B?-1:1,o,k=this._oInfoToolbar.getContent(),m;if(!this._bMonthPickerView){P.prototype._applyArrowsLogic.apply(this,arguments);}else{for(var i=2;i<k.length;i++){m=k[i];if(m.getVisible()){o=c.fromLocalJSDate(this.getStartDate());if(m.isA("sap.ui.unified.calendar.MonthPicker")){o.setYear(o.getYear()+j);this.setStartDate(o.toLocalJSDate());this._getHeader().setPickerText(this._formatMonthPickerText());return;}else if(m.isA("sap.ui.unified.calendar.YearRangePicker")){B?m.previousPage():m.nextPage();return;}else if(m.isA("sap.ui.unified.calendar.YearPicker")){B?m.previousPage():m.nextPage();this._getHeader().setPickerText(this._formatYearPickerText());return;}}}}};h.prototype._handleTodayPress=function(){var o=new Date(),i=c.fromLocalJSDate(o),s;if(this._bYearRangePickerView){this._oYearRangePicker.setYear(i.toLocalJSDate().getFullYear());this.setStartDate(i.toLocalJSDate());return;}if(this._bYearPickerView){this._oYearPicker.setYear(i.toLocalJSDate().getFullYear());this.setStartDate(i.toLocalJSDate());return;}if(this._bMonthPickerView){this._oMonthPicker.setMonth(i.toLocalJSDate().getMonth());this.setStartDate(i.toLocalJSDate());return;}s=b.getFirstDateOfMonth(b._createUniversalUTCDate(o,undefined,true));this._adjustSelectedDate(c.fromLocalJSDate(o));o=b._createLocalDate(s,true);this.setStartDate(o);this._dateNav.setCurrent(o);this._getHeader().setPickerText(this._formatPickerText());this._updateTodayButtonState();this.fireStartDateChange();this.fireEvent("_todayPressed");};h.prototype._attachHeaderEvents=function(){P.prototype._attachHeaderEvents.call(this,arguments);this._getHeader().attachEvent("_pickerButtonPress",this._handlePickerButtonPress,this);return this;};h.prototype._getLegend=function(){if(!this._oLegend){this._oLegend=new f({columnWidth:"120px",standardItems:[]});}return this._oLegend;};h.prototype.addRow=function(r){var p=this._createPlanningCalendarListItem(r);p.addCell(r._getMoreButton());this.addAggregation("rows",r,true);this.getAggregation("table").addItem(p);return this;};h.prototype.insertRow=function(r,i){var p=this._createPlanningCalendarListItem(r);p.addCell(r._getMoreButton());this.insertAggregation("rows",r,i);this.getAggregation("table").insertItem(p,i,true);return this;};h.prototype._insertInterval=function(i){P.prototype._insertInterval.call(this,i);this._oInfoToolbar.addContent(this._oInfoToolbar.removeContent(this._getLegend()));};h.prototype._shiftStartDate=function(s){return s;};h.prototype._setSelectionMode=function(){return;};return h;});
