/*!
 * OpenUI5
 * (c) Copyright 2009-2020 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(['sap/ui/Device','sap/ui/core/Control','sap/ui/core/Element','sap/ui/core/IconPool','sap/ui/core/util/PasteHelper','sap/ui/model/ChangeReason','sap/ui/model/Filter','sap/ui/model/Sorter','sap/ui/model/BindingMode','./Column','./Row','./library','./utils/TableUtils','./extensions/ExtensionBase','./extensions/Accessibility','./extensions/Keyboard','./extensions/Pointer','./extensions/Scrolling','./extensions/DragAndDrop',"./TableRenderer","./rowmodes/FixedRowMode","./rowmodes/InteractiveRowMode","./rowmodes/AutoRowMode","./plugins/SelectionModelSelection","sap/ui/thirdparty/jquery","sap/base/Log"],function(D,C,E,I,P,a,F,S,B,b,R,c,T,d,A,K,e,f,g,h,j,k,m,n,q,L){"use strict";var G=c.GroupEventType,N=c.NavigationMode,o=c.SelectionMode,p=c.SelectionBehavior,r=c.SortOrder,V=c.VisibleRowCountMode,H=T.Hook.Keys.Table;var s=C.extend("sap.ui.table.Table",{metadata:{library:"sap.ui.table",dnd:true,properties:{width:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:'auto'},rowHeight:{type:"int",group:"Appearance",defaultValue:null},columnHeaderHeight:{type:"int",group:"Appearance",defaultValue:null},columnHeaderVisible:{type:"boolean",group:"Appearance",defaultValue:true},visibleRowCount:{type:"int",group:"Appearance",defaultValue:10},firstVisibleRow:{type:"int",group:"Appearance",defaultValue:0},selectionMode:{type:"sap.ui.table.SelectionMode",group:"Behavior",defaultValue:o.MultiToggle},selectionBehavior:{type:"sap.ui.table.SelectionBehavior",group:"Behavior",defaultValue:p.RowSelector},selectedIndex:{type:"int",group:"Appearance",defaultValue:-1},editable:{type:"boolean",group:"Behavior",defaultValue:true},navigationMode:{type:"sap.ui.table.NavigationMode",group:"Behavior",defaultValue:N.Scrollbar,deprecated:true},threshold:{type:"int",group:"Appearance",defaultValue:100},enableColumnReordering:{type:"boolean",group:"Behavior",defaultValue:true},enableGrouping:{type:"boolean",group:"Behavior",defaultValue:false},showColumnVisibilityMenu:{type:"boolean",group:"Appearance",defaultValue:false},showNoData:{type:"boolean",group:"Appearance",defaultValue:true},visibleRowCountMode:{type:"sap.ui.table.VisibleRowCountMode",group:"Appearance",defaultValue:V.Fixed},minAutoRowCount:{type:"int",group:"Appearance",defaultValue:5},fixedColumnCount:{type:"int",group:"Appearance",defaultValue:0},fixedRowCount:{type:"int",group:"Appearance",defaultValue:0},fixedBottomRowCount:{type:"int",group:"Appearance",defaultValue:0},enableColumnFreeze:{type:"boolean",group:"Behavior",defaultValue:false},enableCellFilter:{type:"boolean",group:"Behavior",defaultValue:false},showOverlay:{type:"boolean",group:"Appearance",defaultValue:false},enableSelectAll:{type:"boolean",group:"Behavior",defaultValue:true},enableCustomFilter:{type:"boolean",group:"Behavior",defaultValue:false},enableBusyIndicator:{type:"boolean",group:"Behavior",defaultValue:false},rowActionCount:{type:"int",group:"Appearance",defaultValue:0},alternateRowColors:{type:"boolean",group:"Appearance",defaultValue:false}},defaultAggregation:"columns",aggregations:{title:{type:"sap.ui.core.Control",altTypes:["string"],multiple:false},footer:{type:"sap.ui.core.Control",altTypes:["string"],multiple:false},toolbar:{type:"sap.ui.core.Toolbar",multiple:false,deprecated:true},extension:{type:"sap.ui.core.Control",multiple:true,singularName:"extension"},columns:{type:"sap.ui.table.Column",multiple:true,singularName:"column",bindable:"bindable",dnd:{layout:"Horizontal"}},rows:{type:"sap.ui.table.Row",multiple:true,singularName:"row",bindable:"bindable",selector:"#{id}-tableCCnt",dnd:true},rowMode:{type:"sap.ui.core.Element",multiple:false,visibility:"hidden"},creationRow:{type:"sap.ui.core.Control",multiple:false,visibility:"hidden"},noData:{type:"sap.ui.core.Control",altTypes:["string"],multiple:false},rowActionTemplate:{type:"sap.ui.table.RowAction",multiple:false},rowSettingsTemplate:{type:"sap.ui.table.RowSettings",multiple:false},contextMenu:{type:"sap.ui.core.IContextMenu",multiple:false},plugins:{type:"sap.ui.table.plugins.SelectionPlugin",multiple:true,singularName:"plugin"},_messageStrip:{type:"sap.ui.core.Control",multiple:false,visibility:"hidden"},_hiddenDependents:{type:"sap.ui.core.Element",multiple:true,visibility:"hidden"}},associations:{groupBy:{type:"sap.ui.table.Column",multiple:false},ariaLabelledBy:{type:"sap.ui.core.Control",multiple:true,singularName:"ariaLabelledBy"}},events:{rowSelectionChange:{parameters:{rowIndex:{type:"int"},rowContext:{type:"object"},rowIndices:{type:"int[]"},selectAll:{type:"boolean"},userInteraction:{type:"boolean"}}},columnSelect:{allowPreventDefault:true,parameters:{column:{type:"sap.ui.table.Column"}}},columnResize:{allowPreventDefault:true,parameters:{column:{type:"sap.ui.table.Column"},width:{type:"sap.ui.core.CSSSize"}}},columnMove:{allowPreventDefault:true,parameters:{column:{type:"sap.ui.table.Column"},newPos:{type:"int"}}},sort:{allowPreventDefault:true,parameters:{column:{type:"sap.ui.table.Column"},sortOrder:{type:"sap.ui.table.SortOrder"},columnAdded:{type:"boolean"}}},filter:{allowPreventDefault:true,parameters:{column:{type:"sap.ui.table.Column"},value:{type:"string"}}},group:{allowPreventDefault:true,parameters:{column:{type:"sap.ui.table.Column"}}},columnVisibility:{allowPreventDefault:true,parameters:{column:{type:"sap.ui.table.Column"},newVisible:{type:"boolean"}}},cellClick:{allowPreventDefault:true,parameters:{cellControl:{type:"sap.ui.core.Control"},cellDomRef:{type:"Object"},rowIndex:{type:"int"},columnIndex:{type:"int"},columnId:{type:"string"},rowBindingContext:{type:"sap.ui.model.Context"}}},cellContextmenu:{allowPreventDefault:true,parameters:{cellControl:{type:"sap.ui.core.Control"},cellDomRef:{type:"Object"},rowIndex:{type:"int"},columnIndex:{type:"int"},columnId:{type:"string"},rowBindingContext:{type:"sap.ui.model.Context"}},deprecated:true},beforeOpenContextMenu:{allowPreventDefault:true,parameters:{rowIndex:{type:"int"},columnIndex:{type:"int"},contextMenu:{type:"sap.ui.core.IContextMenu"}}},columnFreeze:{allowPreventDefault:true,parameters:{column:{type:"sap.ui.table.Column"}}},customFilter:{column:{type:"sap.ui.table.Column"},value:{type:"string"}},firstVisibleRowChanged:{firstVisibleRow:{type:"int"}},busyStateChanged:{busy:{type:"boolean"}},paste:{allowPreventDefault:true,parameters:{data:{type:"string[][]"}}}},designtime:"sap/ui/table/designtime/Table.designtime"}});I.insertFontFaceStyle();s.prototype.init=function(){this.mSkipPropagation={rowActionTemplate:true,rowSettingsTemplate:true};this._attachExtensions();this._bRtlMode=sap.ui.getCore().getConfiguration().getRTL();this._bRowsBeingBound=false;this._bContextsAvailable=false;this._aRowClones=[];this._bRowAggregationInvalid=true;this._mTimeouts={};this._mAnimationFrames={};this._bHideStandardTooltips=false;this._aRowHeights=[];this._iRenderedFirstVisibleRow=0;this._aSortedColumns=[];this._aTableHeaders=[];this._bAllowColumnHeaderTextSelection=false;this._iPendingRequests=0;this._bPendingRequest=false;this._iBindingLength=null;this._bFirstRendering=true;this._nDevicePixelRatio=window.devicePixelRatio;if(sap.ui.getCore().isThemeApplied()){T.readThemeParameters();}this._bInvalid=true;};s.prototype.applySettings=function(l,M){if(l){var O=["rowMode","plugins"];var Q={};for(var i=0;i<O.length;i++){var U=O[i];if(U in l){Q[U]=l[U];delete l[U];}}if(Object.keys(Q).length>0){C.prototype.applySettings.call(this,Q,M);}}this._initLegacyRowMode();this._initLegacySelectionPlugin();C.prototype.applySettings.call(this,l,M);};s.prototype._attachExtensions=function(){if(this._bExtensionsInitialized){return;}d.enrich(this,e);d.enrich(this,f);d.enrich(this,K);d.enrich(this,A);d.enrich(this,g);this._bExtensionsInitialized=true;};s.prototype.exit=function(){this.invalidateRowsAggregation();this._detachExtensions();if(this._dataReceivedHandlerId){clearTimeout(this._dataReceivedHandlerId);delete this._dataReceivedHandlerId;}this._cleanUpTimers();this._detachEvents();T.Menu.cleanupDefaultContentCellContextMenu(this);delete this._aTableHeaders;};s.prototype._detachExtensions=function(){d.cleanup(this);};s.prototype.onpaste=function(i){if(i.isMarked()||/^(input|textarea)$/i.test(i.target.tagName)||!this.getDomRef("sapUiTableCnt").contains(i.target)){return;}var l=P.getPastedDataAs2DArray(i.originalEvent);if(l.length===0||l[0].length===0){return;}this.firePaste({data:l});};s.prototype.onThemeChanged=function(){T.readThemeParameters();if(this.getDomRef()){this.invalidate();}};s.prototype.onlocalizationChanged=function(i){var l=i.changes||{};var M=l.hasOwnProperty("rtl");var O=l.hasOwnProperty("language");this._adaptLocalization(M,O).then(function(){this.invalidate();}.bind(this));};s.prototype._adaptLocalization=function(i,l){if(!i&&!l){return Promise.reject();}var M=Promise.resolve();if(i){this._bRtlMode=sap.ui.getCore().getConfiguration().getRTL();}if(l){M=T.getResourceBundle({async:true,reload:true});}return M.then(function(){if(l){T.Menu.cleanupDefaultContentCellContextMenu(this);this._invalidateColumnMenus();}}.bind(this));};s.prototype._collectRowHeights=function(l){var M=this.getDomRef();if(!M){return[];}var O=this._getBaseRowHeight();var Q=l?".sapUiTableColHdrTr":".sapUiTableTr";var U=M.querySelectorAll(".sapUiTableCtrlFixed > tbody > tr"+Q);var W=M.querySelectorAll(".sapUiTableCtrlScroll > tbody > tr"+Q);var X=l?T.getHeaderRowCount(this):this.getRows().length;var Y=[];var Z=D.browser.chrome&&window.devicePixelRatio!=1;if(l){if(this.getColumnHeaderHeight()>0){O=this.getColumnHeaderHeight();}else if(this.getRowMode()){O=this._getDefaultRowHeight();}}for(var i=0;i<X;i++){var $=U[i]?U[i].getBoundingClientRect().height:0;var _=W[i]?W[i].getBoundingClientRect().height:0;var a1=Math.max($,_);if(Z){var b1=O-a1;if(b1>0&&b1<1){Y.push(Math.max(a1,O-1));continue;}}Y.push(Math.max(a1,O));}if(Y.length>0&&!l){T.dynamicCall(this._getSyncExtension,function(c1){var d1=c1.syncRowHeights(Y.slice());if(d1&&d1.length===Y.length){Y=d1.slice();}});}return Y;};s.prototype._resetRowHeights=function(){var l=this._getBaseRowHeight();var M="";if(l){M=l+"px";}var O=this.getDomRef("tableCCnt");if(O){var Q=O.querySelectorAll(".sapUiTableTr");for(var i=0;i<Q.length;i++){Q[i].style.height=M;}}};s.prototype._resetColumnHeaderHeights=function(){var l=this.getDomRef();if(l){var M=l.querySelectorAll(".sapUiTableColHdrTr");for(var i=0;i<M.length;i++){M[i].style.height=null;}}};s.prototype._collectTableSizes=function(){var l={tableCtrlScrollWidth:0,tableRowHdrScrWidth:0,tableCtrlScrWidth:0,tableHSbScrollLeft:0,tableCtrlFixedWidth:0,tableCntHeight:0,tableCntWidth:0};var M=this.getDomRef();if(!M){return l;}var O=M.querySelector(".sapUiTableCnt");if(O){l.tableCntHeight=O.clientHeight;l.tableCntWidth=O.clientWidth;}var Q=M.querySelector(".sapUiTableCtrlScroll:not(.sapUiTableCHT)");if(Q){l.tableCtrlScrollWidth=Q.clientWidth;}var U=M.querySelector(".sapUiTableRowHdrScr");if(U){l.tableRowHdrScrWidth=U.clientWidth;}var W=M.querySelector(".sapUiTableCtrlScr:not(.sapUiTableCHA)");if(W){l.tableCtrlScrWidth=W.clientWidth;}var X=this._getScrollExtension().getHorizontalScrollbar();if(X){l.tableHSbScrollLeft=X.scrollLeft;}var Y=M.querySelector(".sapUiTableCtrlScrFixed:not(.sapUiTableCHA) > .sapUiTableCtrlFixed");if(Y){l.tableCtrlFixedWidth=Y.clientWidth;}var Z=this.getFixedColumnCount();var $=0;if(Z){var _=this.getColumns();var a1=M.querySelectorAll(".sapUiTableCtrlFirstCol:not(.sapUiTableCHTHR) > th");for(var i=0;i<a1.length;i++){var b1=parseInt(a1[i].getAttribute("data-sap-ui-headcolindex"));if(!isNaN(b1)&&(b1<Z)){var c1=_[b1];var d1;if(c1._iFixWidth!=null){d1=c1._iFixWidth;}else{d1=a1[i].getBoundingClientRect().width;}$+=d1;}}}if($>0){var e1=this._getScrollExtension();var f1=l.tableRowHdrScrWidth;var g1=e1.getVerticalScrollbar();if(g1&&!e1.isVerticalScrollbarExternal()){f1+=g1.offsetWidth;}if(T.hasRowActions(this)){var h1=this.getDomRef("sapUiTableRowActionScr");if(h1){f1+=h1.offsetWidth;}}f1+=T.Column.getMinColumnWidth();var i1=l.tableCntWidth-f1;var j1=i1>$;var k1=!j1;if(this._bIgnoreFixedColumnCount!==k1){this._bIgnoreFixedColumnCount=k1;if(this.getEnableColumnFreeze()){this._invalidateColumnMenus();}this.invalidate();}}return l;};s.prototype._updateRowHeights=function(i,l){var M=this.getDomRef();if(!M){return;}function O(Z,$){var _=i[$];if(_){Z.style.height=_+"px";}}var Q=l?".sapUiTableColHdrTr":".sapUiTableTr";var U=l?[]:M.querySelectorAll(".sapUiTableRowSelectionCell");var W=l?[]:M.querySelectorAll(".sapUiTableRowActionCell");var X=M.querySelectorAll(".sapUiTableCtrlFixed > tbody > tr"+Q);var Y=M.querySelectorAll(".sapUiTableCtrlScroll > tbody > tr"+Q);Array.prototype.forEach.call(U,O);Array.prototype.forEach.call(W,O);Array.prototype.forEach.call(X,O);Array.prototype.forEach.call(Y,O);};s.prototype.onBeforeRendering=function(i){this._bInvalid=true;this._detachEvents();if(i&&i.isMarked("renderRows")){return;}this._cleanUpTimers();this.getBinding("rows");this._aTableHeaders=[];};s.prototype.onAfterRendering=function(i){var l=i&&i.isMarked("renderRows");this._bInvalid=false;this._attachEvents();this._initRowDomRefs();if(!this._bAllowColumnHeaderTextSelection&&!l){this._disableTextSelection(this.$().find(".sapUiTableColHdrCnt"));}this.getDomRef().classList.remove("sapUiTableRActFlexible");if(!l){this._aTableHeaders=this.$().find(".sapUiTableColHdrCnt th");}this._updateTableSizes(T.RowsUpdateReason.Render,true);T.registerResizeHandler(this,"Table",this._onTableResize.bind(this));this._bFirstRendering=false;};s.prototype.invalidate=function(){this._bInvalid=true;T.Column.invalidateColumnUtils(this);return C.prototype.invalidate.call(this);};s.prototype._initRowDomRefs=function(){var l=this.getRows();for(var i=0;i<l.length;i++){l[i].initDomRefs();}};s.prototype._updateTableSizes=function(l,M){M=M===true;var O=this.getDomRef();if(this._bInvalid||!O||!sap.ui.getCore().isThemeApplied()||O.offsetWidth===0){return;}if(!M){this._resetRowHeights();this._resetColumnHeaderHeights();}this._aRowHeights=this._collectRowHeights(false);var Q=this._collectRowHeights(true);function U(f1){var g1=f1.getDomRef();var h1=T.Column.getMinColumnWidth();var i1=[];var j1=f1.getColumnHeaderVisible();function k1(n1,o1){if(n1<=o1){return Math.max(n1,o1-5,h1)+"px";}return-1;}function l1(o1){var p1=Math.max(o1._minWidth||0,h1,o1.getMinWidth());var q1=o1.getWidth();var r1;var s1;var t1;if(T.isVariableWidth(q1)&&!T.isFixedColumn(f1,o1.getIndex())){r1=g1.querySelectorAll('th[data-sap-ui-colid="'+o1.getId()+'"]');s1=r1[j1?0:1];t1=s1?s1.offsetWidth:null;if(t1!==null){if(t1<=p1){return{headers:r1,newWidth:k1(t1,p1)};}else if(s1&&s1.style.width!=q1){i1.push({col:o1,header:s1,minWidth:p1,headers:r1});return{headers:r1,newWidth:q1};}i1.push({col:o1,header:s1,minWidth:p1,headers:r1});}}return null;}function m1(o1){if(o1){Array.prototype.forEach.call(o1.headers,function(p1){p1.style.width=o1.newWidth;});}}f1._getVisibleColumns().map(l1).forEach(m1);if(i1.length){var n1;for(var i=0;i<i1.length;i++){n1=i1[i].header&&i1[i].header.offsetWidth;i1[i].newWidth=k1(n1,i1[i].minWidth);if(parseInt(i1[i].newWidth)>=0){m1(i1[i]);}}}}U(this);var W=this._collectTableSizes();this._updateRowHeights(this._aRowHeights,false);this._updateRowHeights(Q,true);T.dynamicCall(this._getSyncExtension,function(i){i.syncLayout({top:this.getDomRef("sapUiTableCnt").offsetTop,headerHeight:this.getDomRef().querySelector(".sapUiTableColHdrCnt").getBoundingClientRect().height,contentHeight:this.getDomRef("tableCCnt").getBoundingClientRect().height});},this);var X=this._getScrollExtension();X.updateHorizontalScrollbar(W);X.updateVerticalScrollbarPosition();X.updateVerticalScrollbarVisibility();var $=this.$();if(T.hasRowActions(this)||T.hasRowNavigationIndicators(this)){var Y=$.hasClass("sapUiTableRActFlexible");var Z=this.getDomRef("dummycolhdr");if(Z){var _=this.getDomRef("header");var a1=_.clientWidth;var b1=this.getColumns().reduce(function(b1,i){if(i.getDomRef()&&i.getIndex()>=this.getComputedFixedColumnCount()){return b1+T.convertCSSSizeToPixel(i.getWidth());}return b1;}.bind(this),0);var c1=a1>b1;if(!Y&&c1){var d1=b1+W.tableRowHdrScrWidth+W.tableCtrlFixedWidth;var e1={};if(!T.hasRowActions(this)){d1=d1-T.ThemeParameters.navIndicatorWidth+T.BaseBorderWidth;}e1[this._bRtlMode?"right":"left"]=d1;this.$("sapUiTableRowActionScr").css(e1);this.$("rowacthdr").css(e1);$.toggleClass("sapUiTableRActFlexible",true);}else if(Y&&!c1){this.$("sapUiTableRowActionScr").removeAttr("style");this.$("rowacthdr").removeAttr("style");$.toggleClass("sapUiTableRActFlexible",false);}}}$.find(".sapUiTableNoOpacity").addBack().removeClass("sapUiTableNoOpacity");T.Hook.call(this,H.UpdateSizes,l);};s.prototype.setShowOverlay=function(i){i=!!i;this.setProperty("showOverlay",i,true);if(this.getDomRef()){var l=document.activeElement;this.$().toggleClass("sapUiTableOverlay",i);this._getAccExtension().updateAriaStateForOverlayAndNoData();this._getKeyboardExtension().updateNoDataAndOverlayFocus(l);}return this;};s.prototype._updateFixedBottomRows=function(){var i=this.getDomRef();if(!i||this._getRowCounts().fixedBottom===0){return;}var l=T.getFirstFixedBottomRowIndex(this);var M=this.getRows();var $;q(i).find(".sapUiTableRowLastScrollable").removeClass("sapUiTableRowLastScrollable");q(i).find(".sapUiTableRowFirstFixedBottom").removeClass("sapUiTableRowFirstFixedBottom");if(l>=0&&l<M.length){$=M[l].getDomRefs(true);$.row.addClass("sapUiTableRowFirstFixedBottom",true);}if(l>=1&&l<M.length){$=M[l-1].getDomRefs(true);$.row.addClass("sapUiTableRowLastScrollable",true);}};s.prototype.getFocusInfo=function(){var i=this.$().find(":focus").attr("id");if(i){return{customId:i};}else{return E.prototype.getFocusInfo.apply(this,arguments);}};s.prototype.applyFocusInfo=function(i){if(i&&i.customId){q(document.getElementById(i.customId)).trigger("focus");}else{E.prototype.applyFocusInfo.apply(this,arguments);}return this;};s.prototype.setTitle=function(i){var l=i;if(typeof(i)==="string"||i instanceof String){l=c.TableHelper.createTextView({text:i});l.addStyleClass("sapUiTableHdrTitle");}this.setAggregation("title",l);return this;};s.prototype.setFooter=function(i){var l=i;if(typeof(i)==="string"||i instanceof String){l=c.TableHelper.createTextView({text:i});}this.setAggregation("footer",l);return this;};s.prototype.setSelectionMode=function(i){if(i===o.Multi){i=o.MultiToggle;L.warning("The selection mode 'Multi' is deprecated and must not be used anymore."+" Your setting was defaulted to selection mode 'MultiToggle'",this);}if(this._hasSelectionPlugin()){L.error("If a selection plugin is applied to the table, the selection mode is controlled by the plugin.",this);}else{this.setProperty("selectionMode",i);this._oLegacySelectionPlugin.setSelectionMode(i);}return this;};s.prototype.setFirstVisibleRow=function(i){this._setFirstVisibleRowIndex(i);return this;};s.prototype._setFirstVisibleRowIndex=function(i,l){l=Object.assign({onScroll:false,suppressEvent:false,forceEvent:false,suppressRendering:false},l);if(parseInt(i)<0){L.error("The index of the first visible row must be greater than or equal to 0. The value has been set to 0.",this);i=0;}if(this._getTotalRowCount()>0){var M=this._getMaxFirstVisibleRowIndex();if(M<i){if(!l.onScroll){L.warning("The index of the first visible row must be lesser or equal than the scrollable row count minus the visible row count."+" The value has been set to "+M+".",this);}i=M;}}var O=this.getFirstVisibleRow()!=i;var Q=this._getScrollExtension();var U=false;if(O){var W=this._getFirstRenderedRowIndex();this.setProperty("firstVisibleRow",i,true);if(this.getBinding("rows")){var X=this._getFirstRenderedRowIndex()!==W;if(X&&!l.suppressRendering){y(this,l.onScroll?T.RowsUpdateReason.VerticalScroll:T.RowsUpdateReason.FirstVisibleRowChange);U=true;}if(!l.onScroll){Q.updateVerticalScrollPosition(X);}}if(!l.suppressEvent){this.fireFirstVisibleRowChanged({firstVisibleRow:i});}}else{if(l.forceEvent&&!l.suppressEvent){this.fireFirstVisibleRowChanged({firstVisibleRow:i});}if(!l.onScroll){Q.updateVerticalScrollPosition();}}return U;};s.getMetadata().getAggregation("rows")._doesNotRequireFactory=true;s.prototype.bindAggregation=function(i,l){if(i==="rows"){this._bindRows(u(Array.prototype.slice.call(arguments,1)));return this;}return C.prototype.bindAggregation.apply(this,arguments);};s.prototype.bindRows=function(i){this._bindRows(u(arguments));return this;};s.prototype._bindRows=function(i){t(this);x(this);s._addBindingListener(i,"change",function(){this._onBindingChange.apply(this,arguments);}.bind(this));s._addBindingListener(i,"dataRequested",function(){this._onBindingDataRequested.apply(this,arguments);}.bind(this));s._addBindingListener(i,"dataReceived",function(){this._onBindingDataReceived.apply(this,arguments);}.bind(this));if(this.getEnableBusyIndicator()){this.setBusy(false);}T.Hook.call(this,H.BindRows,i);C.prototype.bindAggregation.call(this,"rows",i);this._bRowsBeingBound=false;};s.prototype._bindAggregation=function(i,l){if(i==="rows"){t(this);}C.prototype._bindAggregation.call(this,i,l);if(i==="rows"){var M=this.getBinding("rows");var O=M?M.getModel():null;this._bRowsBeingBound=false;T.Hook.call(this,H.RowsBound,M);if(O&&O.getDefaultBindingMode()===B.OneTime){L.error("The binding mode of the model is set to \"OneTime\"."+" This binding mode is not supported for the \"rows\" aggregation!"+" Scrolling can not be performed.",this);}}};s.prototype.unbindAggregation=function(i,l){if(i==="rows"){this._unbindRows();return this;}return C.prototype.unbindAggregation.apply(this,arguments);};s.prototype.unbindRows=function(){this._unbindRows();return this;};s.prototype._unbindRows=function(){var i=this.getBindingInfo("rows");if(i){T.Hook.call(this,H.UnbindRows,i);}C.prototype.unbindAggregation.call(this,"rows",true);if(this._bRowsBeingBound||this.bIsDestroyed||this._bIsBeingDestroyed){return;}this._adjustToTotalRowCount();if(i){T.Hook.call(this,H.RowsUnbound);}};function t(i){i._bRowsBeingBound=true;i._bContextsAvailable=false;i._iPendingRequests=0;i._bPendingRequest=false;i._iBindingLength=null;}function u(i){var l;if(i==null||i[0]==null){l={};}else if(typeof i[0]==="string"){var M=i[0];var O=i[1];var Q=i[2];var U=i[3];if(O instanceof S||Array.isArray(Q)&&Q[0]instanceof F){U=Q;Q=O;O=undefined;}l={path:M,sorter:Q,filters:U,template:O};}else{l=i[0];}return l;}s._addBindingListener=function(i,l,M,O){if(!i.events){i.events={};}var Q=i.events[l];i.events[l]=function(){M.apply(O,arguments);if(Q){Q.apply(this,arguments);}};};s.prototype._onBindingChange=function(i){var l=i.getParameter("reason");if(l===a.Sort||l===a.Filter){this.setFirstVisibleRow(0);}};s.prototype.setRowMode=function(i){this._destroyLegacyRowMode();this.setAggregation("rowMode",i);this._initLegacyRowMode();};s.prototype.getRowMode=function(){return this.getAggregation("rowMode");};s.prototype._getRowMode=function(){var i=this.getRowMode()||this._oLegacyRowMode;if(!i){this._initLegacyRowMode();i=this._oLegacyRowMode;}return i;};s.prototype._initLegacyRowMode=function(){if(this._oLegacyRowMode||this.getRowMode()){return;}this._oLegacyRowMode=v(this);this.addAggregation("_hiddenDependents",this._oLegacyRowMode);};s.prototype._destroyLegacyRowMode=function(){if(this._oLegacyRowMode){this._oLegacyRowMode.destroy();delete this._oLegacyRowMode;}};function v(i){var l;switch(i.getVisibleRowCountMode()){case V.Fixed:l=new j(true);break;case V.Interactive:l=new k(true);break;case V.Auto:l=new m(true);break;default:}return l;}s.prototype._getRowCounts=function(){return this._getRowMode().getComputedRowCounts();};s.prototype.setVisibleRowCountMode=function(i){if(this.getRowMode()){L.warning("If the \"rowMode\" aggregation is set, setting the \"visibleRowCountMode\" has no effect");return this.setProperty("visibleRowCountMode",i,true);}var O=this.getVisibleRowCountMode();this.setProperty("visibleRowCountMode",i);var l=this.getVisibleRowCountMode();if(l!==O){this._destroyLegacyRowMode();this._initLegacyRowMode();}return this;};s.prototype.setVisibleRowCount=function(i){var l=this.getVisibleRowCountMode();if(l==V.Auto){L.error("VisibleRowCount will be ignored since VisibleRowCountMode is set to Auto",this);return this;}if(i!=null&&!isFinite(i)){return this;}var M=this.getFixedRowCount()+this.getFixedBottomRowCount();if(i<=M&&M>0){L.error("Table: "+this.getId()+" visibleRowCount('"+i+"') must be bigger than number of"+" fixed rows('"+(this.getFixedRowCount()+this.getFixedBottomRowCount())+"')",this);return this;}if(this.getRowMode()){L.warning("If the \"rowMode\" aggregation is set, setting the \"visibleRowCount\" has no effect");return this.setProperty("visibleRowCount",i,true);}i=this.validateProperty("visibleRowCount",i);if(this.getBinding("rows")&&this._getTotalRowCount()<=i){this.setProperty("firstVisibleRow",0);}this.setProperty("visibleRowCount",i);T.dynamicCall(this._getSyncExtension,function(O){O.syncRowCount(i);});return this;};s.prototype.setMinAutoRowCount=function(M){if(parseInt(M)<1){L.error("The minAutoRowCount property must be greater than 0. The value has been set to 1.",this);M=1;}if(this.getRowMode()){L.warning("If the \"rowMode\" aggregation is set, setting the \"minAutoRowCount\" has no effect");return this.setProperty("minAutoRowCount",M,true);}return this.setProperty("minAutoRowCount",M);};s.prototype.setTooltip=function(i){L.warning("The aggregation tooltip is not supported for sap.ui.table.Table",this);return this.setAggregation("tooltip",i,true);};s.prototype.setNavigationMode=function(){this.setProperty("navigationMode",N.Scrollbar,true);L.error("The navigationMode property is deprecated and must not be used anymore. Your setting was defaulted to 'Scrollbar'",this);return this;};s.prototype._getFixedBottomRowContexts=function(){var i=this._getRowCounts();var l=this._getTotalRowCount();if(i.fixedBottom>0&&i.count-i.fixedBottom<l){return this._getContexts(l-i.fixedBottom,i.fixedBottom);}else{return[];}};s.prototype._getFixedRowContexts=function(){var i=this._getRowCounts();if(i.fixedTop>0){return this._getContexts(0,i.fixedTop);}else{return[];}};s.prototype._getContexts=function(i,l,M){var O=this.getBinding("rows");if(O){return O.getContexts(i,l,M);}else{return[];}};s.prototype._getRowContexts=function(l,M,O){var Q=this.getBinding("rows");var U=this.getRows().length;l=l==null?U:l;l=Math.max(l,this._getRowMode().getMinRequestLength());if(!Q||l<=0){return[];}M=M===true;O=O===true;var W=this._getFirstRenderedRowIndex();var X=this._getRowCounts();var Y=[];var Z;var $=l-X.fixedBottom;var _=0;var a1=$;var b1=this.getThreshold();b1=b1?Math.max(U,b1):0;var c1=W;var d1=function(g1,h1,c1){for(var i=0;i<h1.length;i++){g1[c1+i]=h1[i];}};if(X.fixedTop>0&&W>0){c1=W+X.fixedTop;$-=X.fixedTop;_=X.fixedTop;Z=this._getFixedRowContexts();Y=Y.concat(Z);}Z=this._getContexts(c1,$,b1);if(!M){this._adjustToTotalRowCount();}var e1=this._getTotalRowCount();d1(Y,Z,_);a1=Math.min(a1,Math.max(e1-X.fixedBottom,0));if(X.fixedBottom>0){Z=this._getFixedBottomRowContexts();d1(Y,Z,a1);}var f1=this._getMaxFirstRenderedRowIndex();if(f1<W&&this._bContextsAvailable&&!O){this.setProperty("firstVisibleRow",f1,true);Y=this._getRowContexts(l,M,true);}return Y;};s.prototype._adjustToTotalRowCount=function(){var i=this.getBinding("rows");var l=this._getTotalRowCount();var M=this._getScrollExtension();if(this._iBindingLength!==l){this._iBindingLength=l;this._updateFixedBottomRows();M.adjustToTotalRowCount();if(!i||!T.hasPendingRequests(this)){this._updateNoData();}}};s.prototype.refreshRows=function(i){this._bContextsAvailable=false;if(i===a.Sort||i===a.Filter){this.setFirstVisibleRow(0);}T.Hook.call(this,H.RefreshRows,i||T.RowsUpdateReason.Unknown);};s.prototype.updateRows=function(i,l){if(this.bIsDestroyed||this._bIsBeingDestroyed){return;}if(l.detailedReason==="AddVirtualContext"){w(this);return;}else if(l.detailedReason==="RemoveVirtualContext"){x(this);return;}this._bContextsAvailable=true;y(this,i);};function w(i){var l=i._getRowContexts(null,true)[0];x(i);i._oVirtualRow=i._getRowClone("virtual");i._oVirtualRow.setBindingContext(l,i.getBindingInfo("rows").model);i.addAggregation("_hiddenDependents",i._oVirtualRow);}function x(i){if(i._oVirtualRow){i._oVirtualRow.destroy();delete i._oVirtualRow;}}function y(i,l){if(i._bContextsAvailable){T.Hook.call(i,H.UpdateRows,l||T.RowsUpdateReason.Unknown);}}s.prototype.insertRow=function(){L.error("The control manages the rows aggregation. The method \"insertRow\" cannot be used programmatically!",this);return this;};s.prototype.addRow=function(){L.error("The control manages the rows aggregation. The method \"addRow\" cannot be used programmatically!",this);return this;};s.prototype.removeRow=function(){L.error("The control manages the rows aggregation. The method \"removeRow\" cannot be used programmatically!",this);return null;};s.prototype.removeAllRows=function(){L.error("The control manages the rows aggregation. The method \"removeAllRows\" cannot be used programmatically!",this);return[];};s.prototype.destroyRows=function(){L.error("The control manages the rows aggregation. The method \"destroyRows\" cannot be used programmatically!",this);return this;};s.prototype.setCreationRow=function(i){if(!T.isA(i,"sap.ui.table.CreationRow")){i=null;}return this.setAggregation("creationRow",i);};s.prototype.getCreationRow=function(){return this.getAggregation("creationRow");};s.prototype.destroyCreationRow=function(){return this.destroyAggregation("creationRow");};s.prototype.autoResizeColumn=function(i){this._getPointerExtension().doAutoResizeColumn(i);};s.prototype._attachEvents=function(){var $=this.$();if(sap.ui.getCore().getConfiguration().getAnimation()){q(document.body).on("webkitTransitionEnd transitionend",function(i){if(q(i.target).has($).length>0){this._updateTableSizes(T.RowsUpdateReason.Animation);}}.bind(this));}D.resize.attachHandler(this._onWindowResize,this);d.attachEvents(this);};s.prototype._detachEvents=function(){q(document.body).off('webkitTransitionEnd transitionend');T.deregisterResizeHandler(this,"Table");D.resize.detachHandler(this._onWindowResize,this);d.detachEvents(this);};s.prototype._cleanUpTimers=function(){var i;for(i in this._mTimeouts){if(this._mTimeouts[i]){window.clearTimeout(this._mTimeouts[i]);delete this._mTimeouts[i];}}for(i in this._mAnimationFrames){if(this._mAnimationFrames[i]){window.cancelAnimationFrame(this._mAnimationFrames[i]);delete this._mAnimationFrames[i];}}};s.prototype._updateNoData=function(){if(!this.getDomRef()){return;}var i=document.activeElement;this.$().toggleClass("sapUiTableEmpty",T.isNoDataVisible(this));this._getAccExtension().updateAriaStateForOverlayAndNoData();this._getKeyboardExtension().updateNoDataAndOverlayFocus(i);};s.prototype.removeColumn=function(i,l){var M=this.removeAggregation('columns',i,l);if(typeof i==="number"&&i>-1){i=this.getColumns()[i];}var O=this._aSortedColumns.indexOf(i);if(!this._bReorderInProcess&&O>=0){this._aSortedColumns.splice(O,1);}this.invalidateRowsAggregation();var Q=this.getCreationRow();if(Q){Q._update();}return M;};s.prototype.removeAllColumns=function(){var i=this.removeAllAggregation('columns');this._aSortedColumns=[];this.invalidateRowsAggregation();var l=this.getCreationRow();if(l){l._update();}return i;};s.prototype.destroyColumns=function(){var i=this.destroyAggregation('columns');this._aSortedColumns=[];this.invalidateRowsAggregation();var l=this.getCreationRow();if(l){l._update();}return i;};s.prototype.addColumn=function(i,l){this.addAggregation('columns',i,l);this.invalidateRowsAggregation();var M=this.getCreationRow();if(M){M._update();}return this;};s.prototype.insertColumn=function(i,l,M){this.insertAggregation('columns',i,l,M);this.invalidateRowsAggregation();var O=this.getCreationRow();if(O){O._update();}return this;};s.prototype._getTotalRowCount=function(){var i=this.getBinding("rows");var l=this.getBindingInfo("rows");if(!i){return 0;}if(l.length!=null){return l.length;}return i.getLength();};s.prototype._getMaxFirstVisibleRowIndex=function(){var M;if(T.isVariableRowHeightEnabled(this)){M=this._getTotalRowCount()-1;}else{M=this._getTotalRowCount()-this._getRowCounts().count;}return Math.max(0,M);};s.prototype._getMaxFirstRenderedRowIndex=function(){var M;if(T.isVariableRowHeightEnabled(this)){M=this._getTotalRowCount()-this._getRowCounts().count-1;}else{M=this._getTotalRowCount()-this._getRowCounts().count;}return Math.max(0,M);};s.prototype._getFirstRenderedRowIndex=function(){var i=this.getFirstVisibleRow();if(T.isVariableRowHeightEnabled(this)&&i>this._getMaxFirstRenderedRowIndex()){return this._getMaxFirstRenderedRowIndex();}else{return i;}};s.prototype._getVisibleColumns=function(){var M=[];var O=this.getColumns();for(var i=0,l=O.length;i<l;i++){if(O[i].shouldRender()){M.push(O[i]);}}return M;};s.prototype._getColumnsWidth=function(M,O){var Q=this.getColumns();var U=0;if(M!==0&&!M){M=0;}if(O!==0&&!O){O=Q.length;}for(var i=M,l=O;i<l;i++){if(Q[i]&&Q[i].shouldRender()){var W=T.convertCSSSizeToPixel(Q[i].getWidth());if(W==null){W=T.Column.getMinColumnWidth();}U+=W;}}return U;};s.prototype._onTableResize=function(i){var O=i.oldSize.width;var l=i.size.width;if(this._bInvalid||!this.getDomRef()||O===l){return;}this._updateTableSizes(T.RowsUpdateReason.Resize);};s.prototype._onWindowResize=function(){if(this._bInvalid||!this.getDomRef()){return;}if(D.browser.chrome&&window.devicePixelRatio!==this._nDevicePixelRatio){this._nDevicePixelRatio=window.devicePixelRatio;this._updateTableSizes(T.RowsUpdateReason.Zoom);this._adjustOutlineOffset();}};s.prototype._adjustOutlineOffset=function(){if(window.devicePixelRatio<1){this.addStyleClass("sapUiTableZoomout");}else{this.removeStyleClass("sapUiTableZoomout");}};s.prototype._disableTextSelection=function(i){q(i||document.body).attr("unselectable","on").css({"-moz-user-select":"none","-webkit-user-select":"none","user-select":"none"}).on("selectstart",function(l){l.preventDefault();return false;});};s.prototype._enableTextSelection=function(i){q(i||document.body).attr("unselectable","off").css({"-moz-user-select":"","-webkit-user-select":"","user-select":""}).off("selectstart");};s.prototype._clearTextSelection=function(){if(window.getSelection){if(window.getSelection().empty){window.getSelection().empty();}else if(window.getSelection().removeAllRanges){window.getSelection().removeAllRanges();}}else if(document.selection&&document.selection.empty){try{document.selection.empty();}catch(i){}}};s.prototype._findAndfireCellEvent=function(i,l,M){var $=q(l.target);var O=$.closest(".sapUiTableDataCell");var Q=O.attr("id");var U=/.*-row(\d*)-col(\d*)/i.exec(Q);var W=false;if(U){var X=U[1];var Y=U[2];var Z=this.getRows()[X];var _=Z&&Z.getCells()[Y];var a1=Z&&Z.getIndex();var b1=b.ofCell(_).getId();var c1=Z.getRowBindingContext();var d1={rowIndex:a1,columnIndex:Y,columnId:b1,cellControl:_,rowBindingContext:c1,cellDomRef:O.get(0)};W=!i.call(this,d1);if(!W&&typeof M==="function"){d1.cellDomRef=O[0];W=M.call(this,d1);}}return W;};s.prototype.getFocusDomRef=function(){this._getKeyboardExtension().initItemNavigation();var i=T.getFocusedItemInfo(this);if(i){return i.domRef||C.prototype.getFocusDomRef.apply(this,arguments);}return null;};s.prototype.pushSortedColumn=function(i,l){if(!l){this._aSortedColumns=[];}if(this._aSortedColumns.indexOf(i)===-1){this._aSortedColumns.push(i);}};s.prototype.getSortedColumns=function(){return this._aSortedColumns.slice();};s.prototype.sort=function(l,M,O){if(!l){for(var i=0;i<this._aSortedColumns.length;i++){this._aSortedColumns[i].setSorted(false);}var Q=this.getBinding("rows");if(Q){Q.sort();}this._aSortedColumns=[];}if(this.getColumns().indexOf(l)>=0){l.sort(M===r.Descending,O);}};s.prototype.filter=function(i,l){if(this.getColumns().indexOf(i)>=0){if(l==null){l="";}else if(typeof l!=="string"){throw new Error("The filter value is not a string");}i.filter(l);}};s.prototype._updateSelection=function(){var l=this.getSelectionMode();if(l===o.None){return;}var M=this._getSelectionPlugin().getRenderConfig();var O;var Q;var $=this.$("selall");var U=this.getRows();for(var i=0;i<U.length;i++){var W=U[i];W._updateSelection();}if(!M.headerSelector.visible){return;}if(M.headerSelector.type==="toggle"){var X=T.areAllRowsSelected(this);$.toggleClass("sapUiTableSelAll",!X);this._getAccExtension().setSelectAllState(X);O=X?"TBL_DESELECT_ALL":"TBL_SELECT_ALL";}else if(M.headerSelector.type==="clear"){$.toggleClass("sapUiTableSelAllDisabled",!M.headerSelector.enabled);O="TBL_DESELECT_ALL";if(M.headerSelector.enabled){$.removeAttr("aria-disabled");}else{$.attr("aria-disabled","true");}}if(O){Q=T.getResourceText(O);if(this._getShowStandardTooltips()){$.attr('title',Q);}else if(M.headerSelector.type==="toggle"){this.getDomRef("ariaselectall").innerText=Q;}}};s.prototype._getShowStandardTooltips=function(){return!this._bHideStandardTooltips;};s.prototype._onSelectionChanged=function(i){var l=this._getSelectionPlugin();var M=i.getParameter("rowIndices");var O=i.getParameter("selectAll");var Q=this._iSourceRowIndex!==undefined?this._iSourceRowIndex:l.getSelectedIndex();this._updateSelection();if(!this._hasSelectionPlugin()){this.setProperty("selectedIndex",l.getSelectedIndex(),true);this.fireRowSelectionChange({rowIndex:Q,rowContext:this.getContextByIndex(Q),rowIndices:M,selectAll:O,userInteraction:this._iSourceRowIndex!==undefined});}};s.prototype.getContextByIndex=function(i){var l=this.getBinding("rows");return i>=0&&l?l.getContexts(i,1)[0]:null;};s.prototype.getSelectedIndex=function(){if(this._hasSelectionPlugin()){throw new Error("Unsupported operation: sap.ui.table.Table#getSelectedIndex must not be called if a selection plugin is applied.");}return this._getSelectionPlugin().getSelectedIndex();};s.prototype.setSelectedIndex=function(i){if(this._hasSelectionPlugin()){throw new Error("Unsupported operation: sap.ui.table.Table#setSelectedIndex must not be called if a selection plugin is applied.");}this._getSelectionPlugin().setSelectedIndex(i);return this;};s.prototype.clearSelection=function(){if(this._hasSelectionPlugin()){throw new Error("Unsupported operation: sap.ui.table.Table#clearSelection must not be called if a selection plugin is applied.");}this._getSelectionPlugin().clearSelection();return this;};s.prototype.selectAll=function(){if(this._hasSelectionPlugin()){throw new Error("Unsupported operation: sap.ui.table.Table#selectAll must not be called if a selection plugin is applied.");}if(T.hasSelectAll(this)){this._getSelectionPlugin().selectAll();}return this;};s.prototype.getSelectedIndices=function(){if(this._hasSelectionPlugin()){throw new Error("Unsupported operation: sap.ui.table.Table#getSelectedIndices must not be called if a selection plugin is applied.");}return this._getSelectionPlugin().getSelectedIndices();};s.prototype.addSelectionInterval=function(i,l){if(this._hasSelectionPlugin()){throw new Error("Unsupported operation: sap.ui.table.Table#addSelectionInterval must not be called if a selection plugin is applied.");}this._getSelectionPlugin().addSelectionInterval(i,l);return this;};s.prototype.setSelectionInterval=function(i,l){if(this._hasSelectionPlugin()){throw new Error("Unsupported operation: sap.ui.table.Table#setSelectionInterval must not be called if a selection plugin is applied.");}this._getSelectionPlugin().setSelectionInterval(i,l);return this;};s.prototype.removeSelectionInterval=function(i,l){if(this._hasSelectionPlugin()){throw new Error("Unsupported operation: sap.ui.table.Table#removeSelectionInterval must not be called if a selection plugin is applied.");}this._getSelectionPlugin().removeSelectionInterval(i,l);return this;};s.prototype.isIndexSelected=function(i){if(this._hasSelectionPlugin()){throw new Error("Unsupported operation: sap.ui.table.Table#isIndexSelected must not be called if a selection plugin is applied.");}return this._getSelectionPlugin().isIndexSelected(i);};s.prototype.setGroupBy=function(i){var l=i;var O=sap.ui.getCore().byId(this.getGroupBy());if(typeof l==="string"){l=sap.ui.getCore().byId(l);}var M=false;if(l instanceof b&&l!==O){if(this.getColumns().indexOf(l)===-1){throw new Error("Column has to be part of the columns aggregation!");}var Q=this.fireGroup({column:l,groupedColumns:[l.getId()],type:G.group});if(O){O.setGrouped(false);M=true;}if(Q&&this.getEnableGrouping()){l.setGrouped(true);}}if(!l||M){if(O){O.setGrouped(false);}T.Grouping.resetExperimentalGrouping(this);}return this.setAssociation("groupBy",l);};s.prototype.getBinding=function(i){T.Grouping.setupExperimentalGrouping(this);return E.prototype.getBinding.call(this,[i||"rows"]);};s.prototype.setEnableGrouping=function(i){var l=sap.ui.getCore().byId(this.getGroupBy());this.setProperty("enableGrouping",i);if(l){l.setGrouped(i);}T.Grouping.resetExperimentalGrouping(this);this._invalidateColumnMenus();return this;};s.prototype.setEnableCustomFilter=function(i){this.setProperty("enableCustomFilter",i);this._invalidateColumnMenus();return this;};s.prototype.setEnableColumnFreeze=function(i){this.setProperty("enableColumnFreeze",i);this._invalidateColumnMenus();return this;};s.prototype.setShowColumnVisibilityMenu=function(i){this.setProperty("showColumnVisibilityMenu",i);this._invalidateColumnMenus();return this;};s.prototype.getComputedFixedColumnCount=function(){if(this._bIgnoreFixedColumnCount){return 0;}return this.getFixedColumnCount();};s.prototype.setFixedColumnCount=function(l,M){var O=this.getColumns();var Q,i;for(i=l-1;i>=0;i--){Q=O[i];if(Q&&Q.getVisible()){l=Math.max(l,Q.getIndex()+T.Column.getHeaderSpan(Q));break;}}var $=this.$().find(".sapUiTableCtrlFirstCol > th");for(i=l-1;i>=0;i--){Q=O[i];if(Q&&T.isVariableWidth(Q.getWidth())){Q._iFixWidth=$.filter("[data-sap-ui-headcolindex='"+Q.getIndex()+"']").width();}}this.setProperty("fixedColumnCount",l,M);this._collectTableSizes();if(this.getEnableColumnFreeze()){this._invalidateColumnMenus();}return this;};s.prototype.setFixedRowCount=function(i){if(!(parseInt(i)>=0)){L.error("Number of fixed rows must be greater or equal 0",this);return this;}if((i+this.getFixedBottomRowCount())>=this.getVisibleRowCount()){L.error("Table '"+this.getId()+"' fixed rows('"+(i+this.getFixedBottomRowCount())+"') must be smaller than"+" numberOfVisibleRows('"+this.getVisibleRowCount()+"')",this);return this;}if(this.getRowMode()){L.warning("If the \"rowMode\" aggregation is set, setting the \"fixedRowCount\" has no effect");return this.setProperty("fixedRowCount",i,true);}return this.setProperty("fixedRowCount",i);};s.prototype.setFixedBottomRowCount=function(i){if(!(parseInt(i)>=0)){L.error("Number of fixed bottom rows must be greater or equal 0",this);return this;}if((i+this.getFixedRowCount())>=this.getVisibleRowCount()){L.error("Table '"+this.getId()+"' fixed rows('"+(i+this.getFixedRowCount())+"') must be smaller than"+" numberOfVisibleRows('"+this.getVisibleRowCount()+"')",this);return this;}if(this.getRowMode()){L.warning("If the \"rowMode\" aggregation is set, setting the \"iFixedBottomRowCount\" has no effect");return this.setProperty("fixedBottomRowCount",i,true);}return this.setProperty("fixedBottomRowCount",i);};s.prototype.setThreshold=function(i){this.setProperty("threshold",i,true);return this;};s.prototype._invalidateColumnMenus=function(){var M=this.getColumns();for(var i=0,l=M.length;i<l;i++){M[i].invalidateMenu();}};s.prototype._isTouchEvent=function(i){return!!(i&&i.originalEvent&&i.originalEvent.touches);};s.prototype._getRowClone=function(M){var O=typeof M==="number";var Q=O;var U=Q?this._aRowClones[M]:null;if(U&&!U.bIsDestroyed){return U;}U=new R(this.getId()+"-rows"+"-row"+(O?M:"-"+M));if(Q){this._aRowClones[M]=U;}var W=this.getColumns();for(var i=0,l=W.length;i<l;i++){if(W[i].getVisible()){var X=W[i].getTemplateClone(i);if(X){U.addCell(X);}}}if(T.hasRowActions(this)){var Y=this.getRowActionTemplate().clone();U.setAggregation("_rowAction",Y,true);}var Z=this.getRowSettingsTemplate();if(Z){var $=Z.clone();U.setAggregation("_settings",$,true);}return U;};s.prototype.invalidateRowsAggregation=function(){this._bRowAggregationInvalid=true;};s.prototype._getBaseRowHeight=function(){var i=this._getRowMode().getBaseRowContentHeight();if(i>0){return i+T.RowHorizontalFrameSize;}else{return this._getDefaultRowHeight();}};s.prototype._getDefaultRowHeight=function(){var i=T.getContentDensity(this);return T.DefaultRowHeight[i];};s.prototype._getDefaultRowContentHeight=function(){var i=T.getContentDensity(this);return T.BaseSize[i];};s.prototype.setShowNoData=function(i){this.setProperty('showNoData',i,true);this._updateNoData();return this;};s.prototype.setNoData=function(i){var O=T.getNoDataText(this);this.setAggregation("noData",i,true);var l=T.getNoDataText(this);if(O!=null&&l!=null){if(O!==l){this.$("noDataMsg").text(l);}}else{this.invalidate();}return this;};s.prototype.exportData=function(M){var O=sap.ui.requireSync("sap/ui/core/util/Export");M=M||{};if(!M.rows){var Q=this.getBinding("rows"),U=this.getBindingInfo("rows");var W=Q.aFilters.concat(Q.aApplicationFilters);M.rows={path:U.path,model:U.model,sorter:Q.aSorters,filters:W,parameters:U.parameters};}if(!M.exportType){var X=sap.ui.requireSync("sap/ui/core/util/ExportTypeCSV");M.exportType=new X();}var Y=M.rows.model;if(!Y){var Z=M.rows.path;var $=Z.indexOf(">");if($>0){Y=Z.substr(0,$);}}if(!M.columns){M.columns=[];var _=this.getColumns();for(var i=0,l=_.length;i<l;i++){var a1=_[i];if(a1.getSortProperty()){M.columns.push({name:a1.getLabel().getText(),template:{content:{path:a1.getSortProperty(),model:Y}}});}}}var b1=new O(M);this.addDependent(b1);return b1;};s.prototype._onPersoApplied=function(){var M=this.getColumns();var O=[];for(var i=0,l=M.length;i<l;i++){var Q=M[i];if(Q.getSorted()){O.push(new S(Q.getSortProperty(),Q.getSortOrder()===r.Descending));}}var U=this.getBinding("rows");if(U){if(O.length>0){U.sort(O);}}};s.prototype._toggleSelectAll=function(){if(!T.hasData(this)||this.getSelectionMode()!==o.MultiToggle){return;}var i=this._getSelectionPlugin();if(T.areAllRowsSelected(this)){this._iSourceRowIndex=-1;i.clearSelection();}else{this._iSourceRowIndex=0;i.selectAll();}this._iSourceRowIndex=undefined;};s.prototype.setBusy=function(i,l){var M=this.getBusy()!=i;l="sapUiTableGridCnt";var O=C.prototype.setBusy.call(this,i,l);if(M){this.fireBusyStateChanged({busy:i});}return O;};s.prototype.setEnableBusyIndicator=function(i){this.setProperty("enableBusyIndicator",i,true);if(!i){this.setBusy(false);}return this;};s.prototype._onBindingDataRequested=function(i){if(i.getSource()!=this.getBinding("rows")||i.getParameter("__simulateAsyncAnalyticalBinding")){return;}this._iPendingRequests++;this._bPendingRequest=true;var l=T.canUsePendingRequestsCounter(this);if(this.getEnableBusyIndicator()&&(l&&this._iPendingRequests===1||!l)){this.setBusy(true);}if(this._dataReceivedHandlerId!=null){clearTimeout(this._dataReceivedHandlerId);delete this._dataReceivedHandlerId;}};s.prototype._onBindingDataReceived=function(i){if(i.getSource()!=this.getBinding("rows")||i.getParameter("__simulateAsyncAnalyticalBinding")){return;}this._iPendingRequests--;this._bPendingRequest=false;this._adjustToTotalRowCount();if(!T.hasPendingRequests(this)){this._dataReceivedHandlerId=setTimeout(function(){if(this.getEnableBusyIndicator()){this.setBusy(false);}this._updateNoData();delete this._dataReceivedHandlerId;}.bind(this),0);}};s.prototype._setLargeDataScrolling=function(l){this._bLargeDataScrolling=!!l;};s.prototype.setRowActionTemplate=function(i){this.setAggregation("rowActionTemplate",i);this.invalidateRowsAggregation();return this;};s.prototype.setRowActionCount=function(i){if(typeof i==="number"){i=Math.max(0,Math.min(i,2));}return this.setProperty("rowActionCount",i);};s.prototype.setRowSettingsTemplate=function(i){this.setAggregation("rowSettingsTemplate",i);this.invalidateRowsAggregation();return this;};s.prototype.addPlugin=function(i){this.addAggregation("plugins",i);if(T.isA(i,"sap.ui.table.plugins.SelectionPlugin")){this._initSelectionPlugin();}return this;};s.prototype.insertPlugin=function(i,l){this.insertAggregation("plugins",i,l);if(T.isA(i,"sap.ui.table.plugins.SelectionPlugin")){this._initSelectionPlugin();}return this;};s.prototype.removePlugin=function(i){var l=this.removeAggregation("plugins",i);if(T.isA(l,"sap.ui.table.plugins.SelectionPlugin")){this._initSelectionPlugin();}return l;};s.prototype.removeAllPlugins=function(){var i=this.removeAllAggregation("plugins");this._initSelectionPlugin();return i;};s.prototype.destroyPlugins=function(){this.destroyAggregation('plugins');this._initSelectionPlugin();return this;};s.prototype.getPlugin=function(l){if(typeof l!=="string"){return null;}var M=this.getPlugins();for(var i=0;i<M.length;i++){if(M[i].isA(l)){return M[i];}}return null;};s.prototype._getSelectionPlugin=function(){var i=this._oSelectionPlugin||this._oLegacySelectionPlugin;if(!i){this._initLegacySelectionPlugin();i=this._oLegacySelectionPlugin;}if(typeof this._getSelectedIndicesCount==="function"&&i.getSelectedCount!==this._getSelectedIndicesCount){i.getSelectedCount=this._getSelectedIndicesCount;["isIndexSelected","setSelectedIndex","getSelectedIndex","getSelectedIndices","setSelectionInterval","addSelectionInterval","removeSelectionInterval","selectAll","clearSelection"].forEach(function(M){i[M]=this[M];}.bind(this));}return i;};s.prototype._hasSelectionPlugin=function(){return this._oSelectionPlugin!=null;};s.prototype._initSelectionPlugin=function(){var i=this.getPlugin("sap.ui.table.plugins.SelectionPlugin");if(i){this._destroyLegacySelectionPlugin();if(i!==this._oSelectionPlugin){J(this,this._oSelectionPlugin);z(this,i);this._oSelectionPlugin=i;}}else{this._initLegacySelectionPlugin();J(this,this._oSelectionPlugin);delete this._oSelectionPlugin;}};s.prototype._initLegacySelectionPlugin=function(){if(this._oLegacySelectionPlugin||this.getPlugin("sap.ui.table.plugins.SelectionPlugin")){return;}this._oLegacySelectionPlugin=this._createLegacySelectionPlugin();this.addAggregation("_hiddenDependents",this._oLegacySelectionPlugin);z(this,this._oLegacySelectionPlugin);};s.prototype._destroyLegacySelectionPlugin=function(){if(this._oLegacySelectionPlugin){this._oLegacySelectionPlugin.destroy();delete this._oLegacySelectionPlugin;}};s.prototype._createLegacySelectionPlugin=function(){return new n();};function z(i,l){if(l&&l.getMetadata().hasEvent("selectionChange")){l.attachSelectionChange(i._onSelectionChanged,i);}}function J(i,l){if(l&&l.getMetadata().hasEvent("selectionChange")){l.detachSelectionChange(i._onSelectionChanged,i);}}s.prototype.insertAggregation=function(i,O,l,M){if(i==="_hiddenDependents"){return C.prototype.insertAggregation.call(this,i,O,l,true);}return C.prototype.insertAggregation.apply(this,arguments);};s.prototype.addAggregation=function(i,O,l){if(i==="_hiddenDependents"){return C.prototype.addAggregation.call(this,i,O,true);}return C.prototype.addAggregation.apply(this,arguments);};s.prototype.removeAggregation=function(i,O,l){if(i==="_hiddenDependents"){return C.prototype.removeAggregation.call(this,i,O,true);}return C.prototype.removeAggregation.apply(this,arguments);};s.prototype.removeAllAggregation=function(i,l){if(i==="_hiddenDependents"){return C.prototype.removeAllAggregation.call(this,i,true);}return C.prototype.removeAllAggregation.apply(this,arguments);};s.prototype.destroyAggregation=function(i,l){if(i==="_hiddenDependents"){return C.prototype.destroyAggregation.call(this,i,true);}C.prototype.destroyAggregation.apply(this,arguments);if(i==="rows"){this._aRowClones.forEach(function(M){M.destroy();});this._aRowClones=[];}return this;};s.prototype.getCellControl=function(i,l,M){var O=T.getRowColCell(this,i,l,!M);return O.cell;};s.prototype._fireRowsUpdated=function(i){var l={reason:i||T.RowsUpdateReason.Unknown};this.onRowsUpdated(l);clearTimeout(this._mTimeouts.fireRowsUpdated);this._mTimeouts.fireRowsUpdated=setTimeout(function(){this.onRowsContentUpdated(l);this.fireEvent("_rowsUpdated",l);}.bind(this),0);};s.prototype.onRowsUpdated=function(i){this._iRenderedFirstVisibleRow=this._getFirstRenderedRowIndex();T.Grouping.updateGroups(this);this._updateSelection();};s.prototype.onRowsContentUpdated=function(i){if(this.getRows().length>0){this._resetRowHeights();this._aRowHeights=this._collectRowHeights(false);this._updateRowHeights(this._aRowHeights,false);this._getAccExtension().updateAccForCurrentCell(i.reason);}};s.prototype._enableSynchronization=function(){var i=this;return new Promise(function(l,M){sap.ui.require(["sap/ui/table/extensions/Synchronization"],function(O){l(d.enrich(i,O).getInterface());},function(O){M(O);});});};s.prototype._enableLegacyMultiSelection=function(){if(this._hasSelectionPlugin()){throw new Error("Unsupported operation: sap.ui.table.Table#_enableLegacyMultiSelection must not be called"+" if a selection plugin is applied.");}this._legacyMultiSelection=function(i,l){if(this._hasSelectionPlugin()){throw new Error("Unsupported operation: The legacy multi selection is not supported if a selection plugin is applied");}var M=!!(l.metaKey||l.ctrlKey);if(!this.isIndexSelected(i)){if(M){this.addSelectionInterval(i,i);}else{this.setSelectedIndex(i);}}else if(M||this._getSelectionPlugin().getSelectedCount()===1){this.removeSelectionInterval(i,i);}else{this.setSelectedIndex(i);}}.bind(this);};return s;});
