/*!
 * OpenUI5
 * (c) Copyright 2009-2020 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(['sap/ui/thirdparty/jquery','sap/base/Log','./library','sap/ui/core/Control','./TreeRenderer','./Button'],function(q,L,l,C,T,B){"use strict";var a=l.TreeSelectionMode;var b=C.extend("sap.ui.commons.Tree",{metadata:{library:"sap.ui.commons",properties:{title:{type:"string",group:"Misc",defaultValue:null},width:{type:"sap.ui.core.CSSSize",group:"Misc",defaultValue:'auto'},height:{type:"sap.ui.core.CSSSize",group:"Misc",defaultValue:'auto'},showHeader:{type:"boolean",group:"Misc",defaultValue:true},showHeaderIcons:{type:"boolean",group:"Misc",defaultValue:true},showHorizontalScrollbar:{type:"boolean",group:"Misc",defaultValue:false},minWidth:{type:"sap.ui.core.CSSSize",group:"Misc",defaultValue:null},selectionMode:{type:"sap.ui.commons.TreeSelectionMode",group:"Behavior",defaultValue:a.Legacy}},defaultAggregation:"nodes",aggregations:{nodes:{type:"sap.ui.commons.TreeNode",multiple:true,singularName:"node",bindable:"bindable"}},events:{select:{allowPreventDefault:true,parameters:{node:{type:"sap.ui.commons.TreeNode"},nodeContext:{type:"object"}}},selectionChange:{parameters:{nodes:{type:"sap.ui.commons.TreeNode[]"},nodeContexts:{type:"object[]"}}}}}});b.prototype.resizeListenerId;b.prototype.init=function(){this.bAllCollapsed=false;this.allowTextSelection(false);this.iOldScrollTop=null;this.mSelectedNodes={};this.mSelectedContexts={};this.aLeadSelection=null;var R=sap.ui.getCore().getLibraryResourceBundle("sap.ui.commons");this.oCollapseAllButton=new B(this.getId()+"-CollapseAll",{icon:this.getIconPrefix()+"CollapseAll.png",tooltip:R.getText("TREE_COLLAPSE_ALL"),lite:true});this.oExpandAllButton=new B(this.getId()+"-ExpandAll",{icon:this.getIconPrefix()+"ExpandAll.png",tooltip:R.getText("TREE_EXPAND_ALL"),lite:true});this.oCollapseAllButton.attachPress(this.onCollapseAll,this);this.oExpandAllButton.attachPress(this.onExpandAll,this);this.oCollapseAllButton.addStyleClass("sapUiTreeCol");this.oExpandAllButton.addStyleClass("sapUiTreeExp");};b.prototype.exit=function(){if(this.oCollapseAllButton){this.oCollapseAllButton.destroy();this.oCollapseAllButton=null;}if(this.oExpandAllButton){this.oExpandAllButton.destroy();this.oExpandAllButton=null;}};b.SelectionType={Select:"Select",Toggle:"Toggle",Range:"Range"};b.prototype.onThemeChanged=function(){if(this.oCollapseAllButton&&this.oExpandAllButton){this.oCollapseAllButton.setIcon(this.getIconPrefix()+"CollapseAll.png");this.oExpandAllButton.setIcon(this.getIconPrefix()+"ExpandAll.png");}};b.prototype.onExpandAll=function(){this.expandAll();};b.prototype.onCollapseAll=function(){this.collapseAll();};b.prototype.expandAll=function(){var n=this._getNodes();for(var i=0;i<n.length;i++){n[i].expand(true,true);this._adjustSelectionOnExpanding(n[i]);}};b.prototype.collapseAll=function(){var n=this._getNodes();for(var i=0;i<n.length;i++){n[i].collapse(true,true);this._adjustSelectionOnCollapsing(n[i]);}this._adjustFocus();};b.prototype.onsapdown=function(e){this.moveFocus(false);e.preventDefault();};b.prototype.onsapup=function(e){this.moveFocus(true);e.preventDefault();};b.prototype.onsaphome=function(e){this.placeFocus(this.getFirstSibling(e.target));e.preventDefault();};b.prototype.onsaphomemodifiers=function(e){this.placeFocus(this.getFirst());e.preventDefault();};b.prototype.onsapend=function(e){this.placeFocus(this.getLastSibling(e.target));e.preventDefault();};b.prototype.onsapendmodifiers=function(e){this.placeFocus(this.getLast());e.preventDefault();};b.prototype.onsapcollapseall=function(e){if(this.bAllCollapsed){this.expandAll();}else{this.collapseAll();}this.bAllCollapsed=!this.bAllCollapsed;};b.prototype.getIconPrefix=function(){var i="themes/"+sap.ui.getCore().getConfiguration().getTheme()+"/";if(!sap.ui.getCore().getConfiguration().getRTL()){i+="img/tree/";}else{i+="img-RTL/tree/";}return sap.ui.resource("sap.ui.commons",i);};b.prototype.getFirstSibling=function(d){var D=q(d).siblings(".sapUiTreeNode:visible").first();if(D.length){return D[0];}return null;};b.prototype.getLastSibling=function(d){var D=q(d).siblings(".sapUiTreeNode:visible").last();if(D.length){return D[0];}return null;};b.prototype.getFirst=function(){var d=this.$().find(".sapUiTreeNode:visible").first();if(d.length){return d[0];}return null;};b.prototype.getLast=function(){var d=this.$().find(".sapUiTreeNode:visible").last();if(d.length){return d[0];}return null;};b.prototype.moveFocus=function(m){var d=q(".sapUiTreeNode:focus");if(d.length){var o=sap.ui.getCore().byId(d[0].id);var D=this.$().find(".sapUiTreeNode:visible");var e=D.index(d[0]);var n=e;if(m){n--;}else{n++;}if(n>=0&&n<D.length){var f=D.eq(n);var N=sap.ui.getCore().byId(f[0].id);o.blur();N.focus();}}};b.prototype._adjustFocus=function(){var f=this.$().find('.sapUiTreeNode[tabIndex="0"]');if(!f.is(':visible')){var d=this.$().find(".sapUiTreeNode");var e=d.index(f[0]);var D=d.filter(":lt("+e+")");var g=D.filter(":visible");var n=g[g.length-1];if(n){n.setAttribute("tabindex","0");if(q(".sapUiTreeNode:focus").is(":not(:visible)")){n.focus();}}}};b.prototype.placeFocus=function(d){if(!d){return;}var D=this.$().find(".sapUiTreeNode[tabIndex='0']");if(D.length){D[0].setAttribute("tabindex","-1");}d.setAttribute("tabindex","0");var t=sap.ui.getCore().byId(d.id);t.focus();};b.prototype._adjustSelectionOnExpanding=function(e){if(!e){return;}var E=[];if(e.getSelectedForNodes().length){E.push(e);}r(e,E,null);var $=e.$();if($&&$.hasClass('sapUiTreeNodeSelectedParent')){$.removeClass('sapUiTreeNodeSelectedParent');}var s=e.$('children').find('.sapUiTreeNodeExpanded.sapUiTreeNodeSelectedParent');s.removeClass('sapUiTreeNodeSelectedParent');};function r(n,e,f){var I=n.getExpanded(),N=false,d=I&&!!n.getSelectedForNodes().length,F=(f||I)?f:n,i;for(i=0;i<e.length;i++){if(e[i].getSelectedForNodes().indexOf(n.getId())!==-1){N=true;e[i].removeAssociation("selectedForNodes",n,true);}}if(F&&N&&F!==n){if(F.getSelectedForNodes().indexOf(n.getId())===-1){F.addAssociation("selectedForNodes",n,true);}F.$().addClass('sapUiTreeNodeSelectedParent');}if(d){e.push(n);}var g=n._getNodes();for(i=0;i<g.length;i++){r(g[i],e,F);}if(d){e.pop(n);}}function c(n,R){var N=n._getNodes(),o;for(var i=0;i<N.length;i++){o=N[i];if(o.getIsSelected()){R.addAssociation("selectedForNodes",o,true);}c(o,R);}}b.prototype._adjustSelectionOnCollapsing=function(o){if(!o){return;}c(o,o);if(o.getSelectedForNodes().length){var $=o.$();if($&&!$.hasClass('sapUiTreeNodeSelectedParent')){$.addClass('sapUiTreeNodeSelectedParent');}}};b.prototype.isTreeBinding=function(n){return(n=="nodes");};b.prototype.updateNodes=function(R){var n,N,k,d,i;if(R==="filter"){n=this.getAggregation("nodes");d=n.length;for(i=0;i<d;i++){n[i].destroy();}this.mSelectedNodes={};}this.updateAggregation("nodes");for(k in this.mSelectedContexts){N=this.getNodeByContext(this.mSelectedContexts[k]);if(N){N.setIsSelected(true);}else{this.mSelectedContexts=this._removeItemFromObject(this.mSelectedContexts,k);}}};b.prototype._removeItemFromObject=function(o,k){var K,R={};for(K in o){if(K!==k){R[K]=o[K];}}return R;};b.prototype.getNodeContext=function(n){var o=this.getBindingInfo("nodes"),m=o&&o.model;return n.getBindingContext(m);};b.prototype.getNodeByContext=function(o){var d=this.getBindingInfo("nodes"),m=d&&d.model;return this.findNode(this,function(n){var e=n.getBindingContext(m);return(o&&e&&o.getPath()===e.getPath());});};b.prototype.findNode=function(n,m){var f,t=this;if(m(n)){return n;}q.each(n._getNodes(),function(i,n){f=t.findNode(n,m);if(f){return false;}});return f;};b.prototype.setSelectionMode=function(m){m=this.validateProperty("selectionMode",m);if(this.getSelectionMode()!=m){this.setProperty("selectionMode",m);this._delSelection();}return this;};b.prototype.getSelection=function(){for(var i in this.mSelectedNodes){return this.mSelectedNodes[i];}return null;};b.prototype.setSelection=function(n,s,t){var d=true;if(!s){d=this.fireSelect({node:n,nodeContext:this.getNodeContext(n)});}if(d){switch(this.getSelectionMode()){case a.Legacy:case a.Single:this._setSelectedNode(n,s);break;case a.Multi:if(t==b.SelectionType.Range){this._setSelectedNodeMapRange(n,s);}else if(t==b.SelectionType.Toggle){this._setSelectedNodeMapToggle(n,s);}else{this._setSelectedNode(n,s);}break;case a.None:break;}}};b.prototype.onAfterRendering=function(){if(this.iOldScrollTop){this.$("TreeCont").scrollTop(this.iOldScrollTop);}};b.prototype.invalidate=function(){var t=this;C.prototype.invalidate.apply(this,arguments);if(this.iSelectionUpdateTimer){return;}this.iSelectionUpdateTimer=setTimeout(function(){t.mSelectedNodes={};t.mSelectedContexts=[];t.updateSelection(t,true);t.iSelectionUpdateTimer=null;},0);};b.prototype._addSelectedNodeContext=function(o){var p;if(o&&o.sPath){p=o.sPath;if(this.getSelectionMode()===a.Multi){if(!(p in this.mSelectedContexts)){this.mSelectedContexts[p]=o;}}else{this.mSelectedContexts={};this.mSelectedContexts[p]=o;}}};b.prototype.updateSelection=function(n,e){var t=this;q.each(n._getNodes(),function(i,n){if(n.getIsSelected()){switch(t.getSelectionMode()){case a.None:L.warning("Added selected nodes in a tree with disabled selection");n.setIsSelected(false);break;case a.Legacy:if(q.isEmptyObject(t.mSelectedNodes)){t.mSelectedNodes[n.getId()]=n;t._addSelectedNodeContext(t.getNodeContext(n));}break;case a.Single:if(q.isEmptyObject(t.mSelectedNodes)==false){L.warning("Added multiple selected nodes in single select tree");n.setIsSelected(false);}else{t.mSelectedNodes[n.getId()]=n;t._addSelectedNodeContext(t.getNodeContext(n));}break;case a.Multi:if(!e){L.warning("Added selected node inside collapsed node in multi select tree");n.setIsSelected(false);}else{t.mSelectedNodes[n.getId()]=n;t._addSelectedNodeContext(t.getNodeContext(n));}break;}}t.updateSelection(n,e&&n.getExpanded());});};b.prototype.onBeforeRendering=function(){this.iOldScrollTop=this.$("TreeCont").scrollTop();};b.prototype._setSelectedNode=function(n,s){var t=this,o=this.getNodeContext(n);q.each(this.mSelectedNodes,function(i,n){t._delMultiSelection(n,s);});n._select(s,true);this.mSelectedNodes[n.getId()]=n;this._addSelectedNodeContext(o);this.oLeadSelection=n;if(!s){this.fireSelectionChange({nodes:[n],nodeContexts:[o]});}};b.prototype._setSelectedNodeMapToggle=function(n,s){this._setNodeSelection(n,!n.getIsSelected(),s);};b.prototype._setSelectedNodeMapRange=function(n,s){var S,d=[],e=[],f,E,F,t;if(this.mSelectedNodes[n.getId()]==n){return;}else{if(this._getNodes().length>0){S=this._getSelectableNodes();f=S.indexOf(this.oLeadSelection);E=S.indexOf(n);F=f<E?f:E;t=f<E?E:f;for(var i=F;i<=t;i++){this._setMultiSelection(S[i],s);}}}if(!s){q.map(this.mSelectedNodes,function(n){d.push(n);});q.map(this.mSelectedContexts,function(o){e.push(o);});this.fireSelectionChange({nodes:d,nodeContexts:e});}};b.prototype._getSelectableNodes=function(n){var s=[];function d(n){q.each(n,function(i,N){if(N.getSelectable()){s.push(N);}if(N.getExpanded()){d(N._getNodes());}});}d(this._getNodes());return s;};b.prototype._setNodeSelection=function(n,i,s){var S=[],d=[],v;if(this.getSelectionMode()==a.Single){if(i){var o=this.getSelection();this._setSelectedNode(n,s);if(!n.isVisible()){v=this._getVisibleNode(n);this._adjustSelectionOnCollapsing(v);}if(o&&!o.isVisible()){v=this._getVisibleNode(o);this._adjustSelectionOnExpanding(v);}return;}else{this._delMultiSelection(n,s);if(!n.isVisible()){v=this._getVisibleNode(n);this._adjustSelectionOnExpanding(v);}}}if(i){this._setMultiSelection(n,s);this.oLeadSelection=n;}else{this._delMultiSelection(n,s);this.oLeadSelection=n;}if(!s){q.map(this.mSelectedNodes,function(n){S.push(n);});q.map(this.mSelectedContexts,function(e){d.push(e);});this.fireSelectionChange({nodes:S,nodeContexts:d});}};b.prototype._setMultiSelection=function(s,S){if(!s){return;}s._select(S);this.mSelectedNodes[s.getId()]=s;this._addSelectedNodeContext(this.getNodeContext(s));};b.prototype._delMultiSelection=function(s){var o;if(!s){return;}s._deselect();this.mSelectedNodes=this._removeItemFromObject(this.mSelectedNodes,s.getId());o=s.getBindingContext();if(o&&o.sPath){if(o.sPath in this.mSelectedContexts){this.mSelectedContexts=this._removeItemFromObject(this.mSelectedContexts,o.sPath);}}};b.prototype._delSelection=function(){var t=this;if(this.oSelectedNode){this.oSelectedNode._deselect();}if(q.isEmptyObject(this.mSelectedNodes)==false){q.each(this.mSelectedNodes,function(i,n){t._delMultiSelection(n);});}};b.prototype._getNodes=function(){return this.mAggregations.nodes||[];};b.prototype._getVisibleNode=function(n){var p=n.getParent();if(p.isVisible()){var v=p;}else{v=this._getVisibleNode(p);}return v;};return b;});
