/*!
 * OpenUI5
 * (c) Copyright 2009-2020 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(['sap/ui/Device','./Control','./library',"./ScrollBarRenderer","sap/ui/performance/trace/Interaction","sap/base/Log","sap/ui/dom/containsOrEquals","sap/ui/events/jquery/EventSimulation","sap/ui/thirdparty/jquery"],function(D,C,l,S,I,L,c,E,q){"use strict";var a=l.ScrollBarAction;var b=C.extend("sap.ui.core.ScrollBar",{metadata:{library:"sap.ui.core",properties:{vertical:{type:"boolean",group:"Behavior",defaultValue:true},scrollPosition:{type:"int",group:"Behavior",defaultValue:null},size:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:null},contentSize:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:null},steps:{type:"int",group:"Dimension",defaultValue:null}},events:{scroll:{parameters:{action:{type:"sap.ui.core.ScrollBarAction"},forward:{type:"boolean"},newScrollPos:{type:"int"},oldScrollPos:{type:"int"}}}}}});b.prototype.init=function(){this._$ScrollDomRef=null;this._iOldScrollPos=0;this._iOldStep=0;this._bScrollPosIsChecked=false;this._bRTL=sap.ui.getCore().getConfiguration().getRTL();this._bSuppressScroll=false;this._iMaxContentDivSize=1000000;if(E.touchEventMode==="ON"){sap.ui.requireSync("sap/ui/thirdparty/zyngascroll");this._iLastTouchScrollerPosition=null;this._iTouchStepTreshold=24;this._bSkipTouchHandling=false;this._oTouchScroller=new window.Scroller(q.proxy(this._handleTouchScroll,this),{bouncing:false});}};b.prototype.onBeforeRendering=function(){this.$("sb").off("scroll",this.onscroll);};b.prototype.onAfterRendering=function(){this._iSteps=this.getSteps();var s=this.getContentSize();this._bStepMode=!s;var i=this.getSize();if(i.endsWith("px")){i=i.substr(0,i.length-2);}else{i=this.getVertical()?this.$().height():this.$().width();}var d=null;var $=this.$("ffsize");if(D.browser.firefox){d=$.outerHeight();if(d===0){d=window.getComputedStyle(q("body").get(0))["font-size"];if(d.endsWith("px")){d=d.substr(0,d.length-2);}d=parseInt(d);}}$.remove();if(D.browser.webkit){if(!document.width){d=Math.round(40/(window.outerWidth/q(document).width()));}else{d=Math.round(40/(document.width/q(document).width()));}}if(this.getVertical()){if(D.browser.firefox){this._iFactor=d;}else if(D.browser.webkit){this._iFactor=d;}else{this._iFactor=Math.floor(i*0.125);}this._iFactorPage=D.browser.firefox?i-d:Math.floor(i*0.875);}else{if(D.browser.firefox){this._iFactor=10;this._iFactorPage=Math.floor(i*0.8);}else if(D.browser.webkit){this._iFactor=d;this._iFactorPage=Math.floor(i*0.875);}else{this._iFactor=7;this._iFactorPage=i-14;}}this._$ScrollDomRef=this.$("sb");if(this._bStepMode){if(this.getVertical()){var e=this._iSteps*this._iFactor;if(e>this._iMaxContentDivSize){this._iFactor=this._iFactor/(e/this._iMaxContentDivSize);}var f=this._$ScrollDomRef.height()+Math.ceil(this._iSteps*this._iFactor);this._$ScrollDomRef.find("div").height(f);}else{var f=this._$ScrollDomRef.width()+this._iSteps*this._iFactor;this._$ScrollDomRef.find("div").width(f);}}this.setCheckedScrollPosition(this.getScrollPosition()?this.getScrollPosition():0,true);this._$ScrollDomRef.on("scroll",q.proxy(this.onscroll,this));if(E.touchEventMode==="ON"){this._bSkipTouchHandling=true;var o={width:0,height:0};o[this.getVertical()?"height":"width"]=this._bStepMode?(this.getSteps()*this._iTouchStepTreshold):parseInt(this.getContentSize());this._oTouchScroller.setDimensions(0,0,o.width,o.height);var g=this._$ScrollDomRef.get(0);if(g){var r=g.getBoundingClientRect();this._oTouchScroller.setPosition(r.left+g.clientLeft,r.top+g.clientTop);this._bSkipTouchHandling=false;}}};b.prototype.onmousewheel=function(e){if(this.$().is(":visible")){var o=e.originalEvent;var w=o.detail?o.detail:o.wheelDelta*(-1)/40;var f=w>0?true:false;if(c(this._$ScrollDomRef[0],e.target)){this._doScroll(a.MouseWheel,f);}else{this._bMouseWheel=true;var p=null;if(this._bStepMode){p=w+this._iOldStep;}else{p=w*this._iFactor+this._iOldScrollPos;}this.setCheckedScrollPosition(p,true);}e.preventDefault();e.stopPropagation();return false;}};b.prototype.ontouchstart=function(e){var t=e.touches;var f=t[0];if(f&&f.target&&f.target.tagName.match(/input|textarea|select/i)){return;}if(this._oTouchScroller){this._oTouchScroller.doTouchStart(t,e.timeStamp);}if(t.length==1){e.preventDefault();}};b.prototype.ontouchmove=function(e){if(this._oTouchScroller){this._oTouchScroller.doTouchMove(e.touches,e.timeStamp,e.scale);}};b.prototype.ontouchend=function(e){if(this._oTouchScroller){this._oTouchScroller.doTouchEnd(e.timeStamp);}};b.prototype.ontouchcancel=function(e){if(this._oTouchScroller){this._oTouchScroller.doTouchEnd(e.timeStamp);}};b.prototype.onscroll=function(e){if(this._bSuppressScroll){this._bSuppressScroll=false;e.preventDefault();e.stopPropagation();return false;}var s=null;if(this._$ScrollDomRef){if(this.getVertical()){s=Math.round(this._$ScrollDomRef.scrollTop());}else{s=Math.round(this._$ScrollDomRef.scrollLeft());if(D.browser.firefox&&this._bRTL){s=Math.abs(s);}else if(D.browser.webkit&&this._bRTL){var o=this._$ScrollDomRef.get(0);s=o.scrollWidth-o.clientWidth-o.scrollLeft;}}}var d=s-this._iOldScrollPos;var f=d>0?true:false;if(d<0){d=d*(-1);}var g=a.Drag;if(d==this._iFactor){g=a.Step;}else if(d==this._iFactorPage){g=a.Page;}else if(this._bMouseWheel){g=a.MouseWheel;}if(this._bLargeDataScrolling&&g===a.Drag){this._eAction=g;this._bForward=f;if(D.browser.msie){if(this._scrollTimeout){window.clearTimeout(this._scrollTimeout);}this._scrollTimeout=window.setTimeout(this._onScrollTimeout.bind(this),300);}}else{this._doScroll(g,f);}e.preventDefault();e.stopPropagation();return false;};b.prototype._onScrollTimeout=function(){this._scrollTimeout=undefined;this._doScroll(this._eAction,this._bForward);this._eAction=undefined;this._bForward=undefined;this._bTouchScroll=undefined;};b.prototype.onmouseup=function(){if(this._bLargeDataScrolling&&(this._eAction||this._bForward||this._bTouchScroll)&&!D.browser.msie){this._doScroll(this._eAction,this._bForward);this._eAction=undefined;this._bForward=undefined;this._bTouchScroll=undefined;}};b.prototype.ontouchend=b.prototype.onmouseup;b.prototype._handleTouchScroll=function(i,t,z){if(this._bSkipTouchHandling){return;}var v=this.getVertical()?t:i;var p;if(this._bStepMode){p=Math.max(Math.round(v/this._iTouchStepTreshold),0);}else{p=Math.round(v);}if(this._iLastTouchScrollerPosition!==p){this._iLastTouchScrollerPosition=p;this.setCheckedScrollPosition(p,true);if(this._bLargeDataScrolling){this._bTouchScroll=true;}else{this.fireScroll();}}};b.prototype.unbind=function(o){if(o){this._$OwnerDomRef=q(o);if(this.getVertical()){this._$OwnerDomRef.off(D.browser.firefox?"DOMMouseScroll":"mousewheel",this.onmousewheel);}if(E.touchEventMode==="ON"){this._$OwnerDomRef.off(this._getTouchEventType("touchstart"),q.proxy(this.ontouchstart,this));this._$OwnerDomRef.off(this._getTouchEventType("touchmove"),q.proxy(this.ontouchmove,this));this._$OwnerDomRef.off(this._getTouchEventType("touchend"),q.proxy(this.ontouchend,this));this._$OwnerDomRef.off(this._getTouchEventType("touchcancel"),q.proxy(this.ontouchcancel,this));}}};b.prototype.bind=function(o){if(o){this._$OwnerDomRef=q(o);if(this.getVertical()){this._$OwnerDomRef.on(D.browser.firefox?"DOMMouseScroll":"mousewheel",q.proxy(this.onmousewheel,this));}if(E.touchEventMode==="ON"){this._$OwnerDomRef.on(this._getTouchEventType("touchstart"),q.proxy(this.ontouchstart,this));this._$OwnerDomRef.on(this._getTouchEventType("touchmove"),q.proxy(this.ontouchmove,this));this._$OwnerDomRef.on(this._getTouchEventType("touchend"),q.proxy(this.ontouchend,this));this._$OwnerDomRef.on(this._getTouchEventType("touchcancel"),q.proxy(this.ontouchcancel,this));}}};b.prototype._getTouchEventType=function(t){return E.touchEventMode==="SIM"?("sap"+t):t;};b.prototype.pageUp=function(){this._doScroll(a.Page,false);};b.prototype.pageDown=function(){this._doScroll(a.Page,true);};b.prototype.setScrollPosition=function(s){if(this._$ScrollDomRef){this.setCheckedScrollPosition(s,true);}else{this.setProperty("scrollPosition",s);}return this;};b.prototype.setCheckedScrollPosition=function(s,d){var i=Math.max(s,0);if(this._bStepMode===undefined){this._bStepMode=!this.getContentSize();}var e=i;if(this._bStepMode){i=Math.min(i,this.getSteps());e=i*this._iFactor;}i=Math.round(i);this._bSuppressScroll=!d;this.setProperty("scrollPosition",i,true);if(this.getVertical()){this._$ScrollDomRef.scrollTop(e);}else{if(D.browser.firefox&&this._bRTL){this._$ScrollDomRef.scrollLeft(-e);}else if(D.browser.webkit&&this._bRTL){var o=this._$ScrollDomRef.get(0);this._$ScrollDomRef.scrollLeft(o.scrollWidth-o.clientWidth-e);}else{this._$ScrollDomRef.scrollLeft(e);}}if(E.touchEventMode==="ON"){var v=i;if(this._bStepMode){v=Math.round(i*this._iTouchStepTreshold);}this._oTouchScroller.__scrollTop=this.getVertical()?v:0;this._oTouchScroller.__scrollLeft=this.getVertical()?0:v;}};b.prototype.setContentSize=function(s){this.setProperty("contentSize",s,true);this._bStepMode=false;var $=this.$("sbcnt");if($){if(this.getVertical()){$.height(s);}else{$.width(s);}}return this;};b.prototype._doScroll=function(A,f){var s=null;if(this._$ScrollDomRef){if(this.getVertical()){s=Math.round(this._$ScrollDomRef.scrollTop());}else{s=Math.round(this._$ScrollDomRef.scrollLeft());if(D.browser.firefox&&this._bRTL){s=Math.abs(s);}else if(D.browser.webkit&&this._bRTL){var o=this._$ScrollDomRef.get(0);s=o.scrollWidth-o.clientWidth-o.scrollLeft;}}}if(this._bStepMode){var i=Math.round(s/this._iFactor);var O=this._iOldStep;if(O!==i){this.setCheckedScrollPosition(i,false);L.debug("-----STEPMODE-----: New Step: "+i+" --- Old Step: "+O+" --- Scroll Pos in px: "+s+" --- Action: "+A+" --- Direction is forward: "+f);this.fireScroll({action:A,forward:f,newScrollPos:i,oldScrollPos:O});this._iOldStep=i;}}else{s=Math.round(s);this.setProperty("scrollPosition",s,true);L.debug("-----PIXELMODE-----: New ScrollPos: "+s+" --- Old ScrollPos: "+this._iOldScrollPos+" --- Action: "+A+" --- Direction is forward: "+f);this.fireScroll({action:A,forward:f,newScrollPos:s,oldScrollPos:this._iOldScrollPos});}if(Math.round(this._iFactor)==this._iFactor||!D.browser.msie){this._bSuppressScroll=false;}this._iOldScrollPos=s;this._bMouseWheel=false;I.notifyScrollEvent({type:A});};b.prototype.onThemeChanged=function(){this.rerender();};b.prototype.getNativeScrollPosition=function(){if(this._$ScrollDomRef){if(this.getVertical()){return Math.round(this._$ScrollDomRef.scrollTop());}else{return Math.round(this._$ScrollDomRef.scrollLeft());}}return 0;};b.prototype.setNativeScrollPosition=function(n){var s=Math.round(n);if(this._$ScrollDomRef){if(this.getVertical()){this._$ScrollDomRef.scrollTop(s);}else{this._$ScrollDomRef.scrollLeft(s);}}};return b;});
