/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.util.text;

import com.intellij.openapi.util.text.StringUtilRt;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.longs.LongArrayList;
import java.time.Duration;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public final class Formats {
    private static final String[] TIME_UNITS = new String[]{"ms", "s", "m", "h", "d"};
    private static final long[] TIME_MULTIPLIERS = new long[]{1L, 1000L, 60L, 60L, 24L};

    @Contract(pure=true)
    @NotNull
    public static String formatFileSize(long fileSize) {
        String string2 = StringUtilRt.formatFileSize((long)fileSize);
        if (string2 == null) {
            Formats.$$$reportNull$$$0(0);
        }
        return string2;
    }

    /*
     * WARNING - void declaration
     */
    @Contract(pure=true)
    @NotNull
    public static String formatFileSize(long fileSize, @NotNull String string2) {
        void unitSeparator;
        if (string2 == null) {
            Formats.$$$reportNull$$$0(1);
        }
        String string3 = StringUtilRt.formatFileSize((long)fileSize, (String)unitSeparator);
        if (string3 == null) {
            Formats.$$$reportNull$$$0(2);
        }
        return string3;
    }

    @Contract(pure=true)
    @NotNull
    public static String formatDuration(long duration) {
        return Formats.formatDuration(duration, " ");
    }

    @Contract(pure=true)
    @NotNull
    public static String formatDuration(@NotNull Duration duration) {
        if (duration == null) {
            Formats.$$$reportNull$$$0(3);
        }
        return Formats.formatDuration(duration.toMillis());
    }

    /*
     * WARNING - void declaration
     */
    @Contract(pure=true)
    @NotNull
    public static String formatDuration(long duration, @NotNull String string2) {
        void unitSeparator;
        if (string2 == null) {
            Formats.$$$reportNull$$$0(4);
        }
        return Formats.formatDuration(duration, (String)unitSeparator, Integer.MAX_VALUE);
    }

    /*
     * WARNING - void declaration
     */
    @Contract(pure=true)
    @NotNull
    private static String formatDuration(long duration, @NotNull String unitSeparator, int n) {
        void maxFragments;
        long multiplier;
        int i;
        if (unitSeparator == null) {
            Formats.$$$reportNull$$$0(5);
        }
        LongArrayList unitValues = new LongArrayList();
        IntArrayList unitIndices = new IntArrayList();
        long count = duration;
        for (i = 1; i < TIME_UNITS.length && count > 0L && count >= (multiplier = TIME_MULTIPLIERS[i]); ++i) {
            long remainder = count % multiplier;
            count /= multiplier;
            if (remainder == 0L && unitValues.isEmpty()) continue;
            unitValues.add(0, remainder);
            unitIndices.add(0, i - 1);
        }
        unitValues.add(0, count);
        unitIndices.add(0, i - 1);
        if (unitValues.size() > maxFragments) {
            int lastUnitIndex = unitIndices.getInt((int)(maxFragments - true));
            long lastMultiplier = TIME_MULTIPLIERS[lastUnitIndex];
            if (unitValues.getLong((int)maxFragments) > lastMultiplier / 2L) {
                long increment = lastMultiplier - unitValues.getLong((int)maxFragments);
                for (int unit = lastUnitIndex - 1; unit > 0; --unit) {
                    increment *= TIME_MULTIPLIERS[unit];
                }
                return Formats.formatDuration(duration + increment, unitSeparator, (int)maxFragments);
            }
        }
        StringBuilder result = new StringBuilder();
        for (i = 0; i < unitValues.size() && i < maxFragments; ++i) {
            if (i > 0) {
                result.append(" ");
            }
            result.append(unitValues.getLong(i)).append(unitSeparator).append(TIME_UNITS[unitIndices.getInt(i)]);
        }
        String string2 = result.toString();
        if (string2 == null) {
            Formats.$$$reportNull$$$0(6);
        }
        return string2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/util/text/Formats";
                break;
            }
            case 1: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "unitSeparator";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "duration";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "formatFileSize";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/util/text/Formats";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "formatDuration";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "formatFileSize";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "formatDuration";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

