/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.startup;

import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.util.io.NioFiles;
import com.intellij.util.io.Decompressor;
import java.io.File;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.io.StreamCorruptedException;
import java.nio.file.AccessDeniedException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Predicate;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class StartupActionScriptManager {
    public static final String STARTUP_WIZARD_MODE = "StartupWizardMode";
    public static final String ACTION_SCRIPT_FILE = "action.script";

    private StartupActionScriptManager() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ApiStatus.Internal
    public static synchronized void executeActionScript() throws IOException {
        Path scriptFile = StartupActionScriptManager.getActionScriptFile();
        try {
            List<ActionCommand> commands = StartupActionScriptManager.loadActionScript(scriptFile);
            for (ActionCommand command : commands) {
                command.execute();
            }
        }
        finally {
            Files.deleteIfExists(scriptFile);
        }
    }

    @ApiStatus.Internal
    public static void executeActionScriptCommands(@NotNull List<? extends ActionCommand> commands, @NotNull Path oldTarget, @NotNull Path newTarget) throws IOException {
        if (commands == null) {
            StartupActionScriptManager.$$$reportNull$$$0(0);
        }
        if (oldTarget == null) {
            StartupActionScriptManager.$$$reportNull$$$0(1);
        }
        if (newTarget == null) {
            StartupActionScriptManager.$$$reportNull$$$0(2);
        }
        for (ActionCommand actionCommand : commands) {
            ActionCommand toExecute = StartupActionScriptManager.mapPaths(actionCommand, oldTarget, newTarget);
            if (toExecute == null) continue;
            toExecute.execute();
        }
    }

    public static synchronized void addActionCommand(@NotNull ActionCommand command) throws IOException {
        if (command == null) {
            StartupActionScriptManager.$$$reportNull$$$0(3);
        }
        StartupActionScriptManager.addActionCommands(List.of(command));
    }

    /*
     * WARNING - void declaration
     */
    public static synchronized void addActionCommands(@NotNull List<? extends ActionCommand> commands) throws IOException {
        if (commands == null) {
            StartupActionScriptManager.$$$reportNull$$$0(4);
        }
        if (Boolean.getBoolean(STARTUP_WIZARD_MODE)) {
            for (ActionCommand actionCommand : commands) {
                actionCommand.execute();
            }
        } else {
            ArrayList<ActionCommand> script = new ArrayList<ActionCommand>();
            Object var2_4 = null;
            Path scriptFile = StartupActionScriptManager.getActionScriptFile();
            if (Files.exists(scriptFile, new LinkOption[0])) {
                List<ActionCommand> list = StartupActionScriptManager.loadActionScript(scriptFile);
                script.addAll(list);
            }
            script.addAll(commands);
            try {
                StartupActionScriptManager.saveActionScript(script, scriptFile);
            }
            catch (Throwable t) {
                void var2_6;
                if (var2_6 != null) {
                    try {
                        StartupActionScriptManager.saveActionScript((List<ActionCommand>)var2_6, scriptFile);
                    }
                    catch (Throwable tt) {
                        t.addSuppressed(tt);
                    }
                }
                throw t;
            }
        }
    }

    private static Path getActionScriptFile() {
        return Path.of(PathManager.getPluginTempPath(), ACTION_SCRIPT_FILE);
    }

    /*
     * Loose catch block
     */
    @ApiStatus.Internal
    @NotNull
    public static List<ActionCommand> loadActionScript(@NotNull Path scriptFile) throws IOException {
        Object data;
        ObjectInputStream ois;
        block12: {
            if (scriptFile == null) {
                StartupActionScriptManager.$$$reportNull$$$0(5);
            }
            ois = new ObjectInputStream(Files.newInputStream(scriptFile, new OpenOption[0]));
            data = ois.readObject();
            if (!(data instanceof ActionCommand[])) break block12;
            List<ActionCommand> list = Arrays.asList((ActionCommand[])data);
            ois.close();
            List<ActionCommand> list2 = list;
            if (list2 == null) {
                StartupActionScriptManager.$$$reportNull$$$0(6);
            }
            return list2;
        }
        try {
            throw new IOException("An unexpected object: " + data + "/" + data.getClass() + " in " + scriptFile);
            {
                catch (Throwable throwable) {
                    try {
                        ois.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
        }
        catch (AccessDeniedException | NoSuchFileException e) {
            List<ActionCommand> list = List.of();
            if (list == null) {
                StartupActionScriptManager.$$$reportNull$$$0(7);
            }
            return list;
        }
        catch (ReflectiveOperationException e) {
            throw (StreamCorruptedException)new StreamCorruptedException("Stream error: " + scriptFile).initCause(e);
        }
    }

    @ApiStatus.Internal
    public static void saveActionScript(@NotNull List<ActionCommand> commands, @NotNull Path scriptFile) throws IOException {
        if (commands == null) {
            StartupActionScriptManager.$$$reportNull$$$0(8);
        }
        if (scriptFile == null) {
            StartupActionScriptManager.$$$reportNull$$$0(9);
        }
        Files.createDirectories(scriptFile.getParent(), new FileAttribute[0]);
        try (ObjectOutputStream oos = new ObjectOutputStream(Files.newOutputStream(scriptFile, new OpenOption[0]));){
            oos.writeObject(commands.toArray(new ActionCommand[0]));
        }
        catch (Throwable t) {
            try {
                Files.deleteIfExists(scriptFile);
            }
            catch (IOException e) {
                t.addSuppressed(e);
            }
            throw t;
        }
    }

    @Nullable
    private static ActionCommand mapPaths(ActionCommand command, Path oldTarget, Path newTarget) {
        Path source;
        if (command instanceof CopyCommand) {
            Path destination = StartupActionScriptManager.mapPath(((CopyCommand)command).myDestination, oldTarget, newTarget);
            if (destination != null) {
                return new CopyCommand(Paths.get(((CopyCommand)command).mySource, new String[0]), destination);
            }
        } else if (command instanceof UnzipCommand) {
            UnzipCommand unzipCommand = (UnzipCommand)command;
            Path destination = StartupActionScriptManager.mapPath(unzipCommand.myDestination, oldTarget, newTarget);
            if (destination != null) {
                return new UnzipCommand(Path.of(unzipCommand.mySource, new String[0]), destination, unzipCommand.myFilenameFilter);
            }
        } else if (command instanceof DeleteCommand && (source = StartupActionScriptManager.mapPath(((DeleteCommand)command).mySource, oldTarget, newTarget)) != null) {
            return new DeleteCommand(source);
        }
        return null;
    }

    @Nullable
    private static Path mapPath(String path, Path oldTarget, Path newTarget) {
        String oldTargetPath = oldTarget.toString();
        if (path.startsWith(oldTargetPath)) {
            if (path.length() == oldTargetPath.length()) {
                return newTarget;
            }
            if (path.charAt(oldTargetPath.length()) == File.separatorChar) {
                return newTarget.resolve(path.substring(oldTargetPath.length() + 1));
            }
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: 
            case 7: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commands";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "oldTarget";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newTarget";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "command";
                break;
            }
            case 5: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scriptFile";
                break;
            }
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/startup/StartupActionScriptManager";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/startup/StartupActionScriptManager";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "loadActionScript";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "executeActionScriptCommands";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "addActionCommand";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "addActionCommands";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "loadActionScript";
                break;
            }
            case 6: 
            case 7: {
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "saveActionScript";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 6: 
            case 7: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }

    public static final class DeleteCommand
    implements Serializable,
    ActionCommand {
        private static final long serialVersionUID = 201708031943L;
        private final String mySource;

        public DeleteCommand(@NotNull Path source) {
            if (source == null) {
                DeleteCommand.$$$reportNull$$$0(0);
            }
            this.mySource = source.toAbsolutePath().toString();
        }

        @Deprecated
        public DeleteCommand(@NotNull File source) {
            if (source == null) {
                DeleteCommand.$$$reportNull$$$0(1);
            }
            this.mySource = source.getAbsolutePath();
        }

        @Override
        public void execute() throws IOException {
            NioFiles.deleteRecursively(Path.of(this.mySource, new String[0]));
        }

        public String toString() {
            return "delete[" + this.mySource + "]";
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "source", "com/intellij/ide/startup/StartupActionScriptManager$DeleteCommand", "<init>"));
        }
    }

    public static final class UnzipCommand
    implements Serializable,
    ActionCommand {
        private static final long serialVersionUID = 201708031943L;
        private final String mySource;
        private final String myDestination;
        @Nullable
        private final Predicate<? super String> myFilenameFilter;

        public UnzipCommand(@NotNull Path source, @NotNull Path destination) {
            if (source == null) {
                UnzipCommand.$$$reportNull$$$0(0);
            }
            if (destination == null) {
                UnzipCommand.$$$reportNull$$$0(1);
            }
            this(source, destination, null);
        }

        @Deprecated
        public UnzipCommand(@NotNull File source, @NotNull File destination) {
            if (source == null) {
                UnzipCommand.$$$reportNull$$$0(2);
            }
            if (destination == null) {
                UnzipCommand.$$$reportNull$$$0(3);
            }
            this(source.toPath(), destination.toPath());
        }

        public UnzipCommand(@NotNull Path source, @NotNull Path destination, @Nullable Predicate<? super String> filenameFilter) {
            if (source == null) {
                UnzipCommand.$$$reportNull$$$0(4);
            }
            if (destination == null) {
                UnzipCommand.$$$reportNull$$$0(5);
            }
            this.mySource = source.toAbsolutePath().toString();
            this.myDestination = destination.toAbsolutePath().toString();
            this.myFilenameFilter = filenameFilter;
        }

        @Override
        public void execute() throws IOException {
            Path source = Path.of(this.mySource, new String[0]);
            Path destination = Path.of(this.myDestination, new String[0]);
            if (!Files.isRegularFile(source, new LinkOption[0])) {
                throw new IOException("Source file missing: " + this.mySource);
            }
            Files.createDirectories(destination, new FileAttribute[0]);
            new Decompressor.Zip(source).filter(this.myFilenameFilter).extract(destination);
        }

        public String toString() {
            return "unzip[" + this.mySource + "," + this.myDestination + "," + this.myFilenameFilter + "]";
        }

        public String getSource() {
            return this.mySource;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "source";
                    break;
                }
                case 1: 
                case 3: 
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[0] = "destination";
                    break;
                }
            }
            objectArray[1] = "com/intellij/ide/startup/StartupActionScriptManager$UnzipCommand";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static final class CopyCommand
    implements Serializable,
    ActionCommand {
        private static final long serialVersionUID = 201708031943L;
        private final String mySource;
        private final String myDestination;

        public CopyCommand(@NotNull Path source, @NotNull Path destination) {
            if (source == null) {
                CopyCommand.$$$reportNull$$$0(0);
            }
            if (destination == null) {
                CopyCommand.$$$reportNull$$$0(1);
            }
            this.mySource = source.toAbsolutePath().toString();
            this.myDestination = destination.toAbsolutePath().toString();
        }

        @Deprecated(forRemoval=true)
        public CopyCommand(@NotNull File source, @NotNull File destination) {
            if (source == null) {
                CopyCommand.$$$reportNull$$$0(2);
            }
            if (destination == null) {
                CopyCommand.$$$reportNull$$$0(3);
            }
            this.mySource = source.getAbsolutePath();
            this.myDestination = destination.getAbsolutePath();
        }

        @Override
        public void execute() throws IOException {
            Path source = Path.of(this.mySource, new String[0]);
            Path destination = Path.of(this.myDestination, new String[0]);
            if (!Files.isRegularFile(source, new LinkOption[0])) {
                throw new IOException("Source file missing: " + this.mySource);
            }
            Files.createDirectories(destination.getParent(), new FileAttribute[0]);
            Files.copy(source, destination, new CopyOption[0]);
        }

        public String toString() {
            return "copy[" + this.mySource + "," + this.myDestination + "]";
        }

        public String getSource() {
            return this.mySource;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "source";
                    break;
                }
                case 1: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[0] = "destination";
                    break;
                }
            }
            objectArray[1] = "com/intellij/ide/startup/StartupActionScriptManager$CopyCommand";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static interface ActionCommand {
        public void execute() throws IOException;
    }
}

