/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.util;

import com.intellij.diff.comparison.ComparisonMergeUtil;
import com.intellij.diff.comparison.ComparisonPolicy;
import com.intellij.diff.comparison.ComparisonUtil;
import com.intellij.diff.fragments.MergeLineFragment;
import com.intellij.diff.fragments.MergeWordFragment;
import com.intellij.diff.tools.util.text.LineOffsets;
import com.intellij.diff.util.DiffRangeUtil;
import com.intellij.diff.util.MergeConflictType;
import com.intellij.diff.util.ThreeSide;
import com.intellij.openapi.util.Condition;
import java.util.List;
import java.util.function.BiPredicate;
import java.util.function.BooleanSupplier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MergeRangeUtil {
    @NotNull
    public static MergeConflictType getMergeType(@NotNull Condition<? super ThreeSide> emptiness, @NotNull BiPredicate<? super ThreeSide, ? super ThreeSide> equality, @Nullable BiPredicate<? super ThreeSide, ? super ThreeSide> trueEquality, @NotNull BooleanSupplier conflictResolver) {
        if (emptiness == null) {
            MergeRangeUtil.$$$reportNull$$$0(0);
        }
        if (equality == null) {
            MergeRangeUtil.$$$reportNull$$$0(1);
        }
        if (conflictResolver == null) {
            MergeRangeUtil.$$$reportNull$$$0(2);
        }
        boolean isLeftEmpty = emptiness.value((Object)ThreeSide.LEFT);
        boolean isBaseEmpty = emptiness.value((Object)ThreeSide.BASE);
        boolean isRightEmpty = emptiness.value((Object)ThreeSide.RIGHT);
        assert (!(isLeftEmpty && isBaseEmpty && isRightEmpty));
        if (isBaseEmpty) {
            if (isLeftEmpty) {
                return new MergeConflictType(MergeConflictType.Type.INSERTED, false, true);
            }
            if (isRightEmpty) {
                return new MergeConflictType(MergeConflictType.Type.INSERTED, true, false);
            }
            boolean equalModifications = equality.test(ThreeSide.LEFT, ThreeSide.RIGHT);
            if (equalModifications) {
                return new MergeConflictType(MergeConflictType.Type.INSERTED, true, true);
            }
            return new MergeConflictType(MergeConflictType.Type.CONFLICT, true, true, false);
        }
        if (isLeftEmpty && isRightEmpty) {
            return new MergeConflictType(MergeConflictType.Type.DELETED, true, true);
        }
        boolean unchangedLeft = equality.test(ThreeSide.BASE, ThreeSide.LEFT);
        boolean unchangedRight = equality.test(ThreeSide.BASE, ThreeSide.RIGHT);
        if (unchangedLeft && unchangedRight) {
            assert (trueEquality != null);
            boolean trueUnchangedLeft = trueEquality.test(ThreeSide.BASE, ThreeSide.LEFT);
            boolean trueUnchangedRight = trueEquality.test(ThreeSide.BASE, ThreeSide.RIGHT);
            assert (!trueUnchangedLeft || !trueUnchangedRight);
            return new MergeConflictType(MergeConflictType.Type.MODIFIED, !trueUnchangedLeft, !trueUnchangedRight);
        }
        if (unchangedLeft) {
            return new MergeConflictType(isRightEmpty ? MergeConflictType.Type.DELETED : MergeConflictType.Type.MODIFIED, false, true);
        }
        if (unchangedRight) {
            return new MergeConflictType(isLeftEmpty ? MergeConflictType.Type.DELETED : MergeConflictType.Type.MODIFIED, true, false);
        }
        boolean equalModifications = equality.test(ThreeSide.LEFT, ThreeSide.RIGHT);
        if (equalModifications) {
            return new MergeConflictType(MergeConflictType.Type.MODIFIED, true, true);
        }
        boolean canBeResolved = !isLeftEmpty && !isRightEmpty && conflictResolver.getAsBoolean();
        return new MergeConflictType(MergeConflictType.Type.CONFLICT, true, true, canBeResolved);
    }

    @NotNull
    public static MergeConflictType getLineThreeWayDiffType(@NotNull MergeLineFragment fragment, @NotNull List<? extends CharSequence> sequences, @NotNull List<? extends LineOffsets> lineOffsets, @NotNull ComparisonPolicy policy) {
        if (fragment == null) {
            MergeRangeUtil.$$$reportNull$$$0(3);
        }
        if (sequences == null) {
            MergeRangeUtil.$$$reportNull$$$0(4);
        }
        if (lineOffsets == null) {
            MergeRangeUtil.$$$reportNull$$$0(5);
        }
        if (policy == null) {
            MergeRangeUtil.$$$reportNull$$$0(6);
        }
        return MergeRangeUtil.getMergeType((Condition<? super ThreeSide>)((Condition)side -> MergeRangeUtil.isLineMergeIntervalEmpty(fragment, side)), (side1, side2) -> MergeRangeUtil.compareLineMergeContents(fragment, sequences, lineOffsets, policy, side1, side2), null, () -> MergeRangeUtil.canResolveLineConflict(fragment, sequences, lineOffsets));
    }

    @NotNull
    public static MergeConflictType getLineMergeType(@NotNull MergeLineFragment fragment, @NotNull List<? extends CharSequence> sequences, @NotNull List<? extends LineOffsets> lineOffsets, @NotNull ComparisonPolicy policy) {
        if (fragment == null) {
            MergeRangeUtil.$$$reportNull$$$0(7);
        }
        if (sequences == null) {
            MergeRangeUtil.$$$reportNull$$$0(8);
        }
        if (lineOffsets == null) {
            MergeRangeUtil.$$$reportNull$$$0(9);
        }
        if (policy == null) {
            MergeRangeUtil.$$$reportNull$$$0(10);
        }
        return MergeRangeUtil.getMergeType((Condition<? super ThreeSide>)((Condition)side -> MergeRangeUtil.isLineMergeIntervalEmpty(fragment, side)), (side1, side2) -> MergeRangeUtil.compareLineMergeContents(fragment, sequences, lineOffsets, policy, side1, side2), (side1, side2) -> MergeRangeUtil.compareLineMergeContents(fragment, sequences, lineOffsets, ComparisonPolicy.DEFAULT, side1, side2), () -> MergeRangeUtil.canResolveLineConflict(fragment, sequences, lineOffsets));
    }

    private static boolean canResolveLineConflict(@NotNull MergeLineFragment fragment, @NotNull List<? extends CharSequence> sequences, @NotNull List<? extends LineOffsets> lineOffsets) {
        List contents;
        if (fragment == null) {
            MergeRangeUtil.$$$reportNull$$$0(11);
        }
        if (sequences == null) {
            MergeRangeUtil.$$$reportNull$$$0(12);
        }
        if (lineOffsets == null) {
            MergeRangeUtil.$$$reportNull$$$0(13);
        }
        return ComparisonMergeUtil.tryResolveConflict((CharSequence)(contents = ThreeSide.map(side -> DiffRangeUtil.getLinesContent((CharSequence)side.select(sequences), (LineOffsets)side.select(lineOffsets), fragment.getStartLine((ThreeSide)((Object)side)), fragment.getEndLine((ThreeSide)((Object)side))))).get(0), (CharSequence)contents.get(1), (CharSequence)contents.get(2)) != null;
    }

    private static boolean compareLineMergeContents(@NotNull MergeLineFragment fragment, @NotNull List<? extends CharSequence> sequences, @NotNull List<? extends LineOffsets> lineOffsets, @NotNull ComparisonPolicy policy, @NotNull ThreeSide side1, @NotNull ThreeSide side2) {
        if (fragment == null) {
            MergeRangeUtil.$$$reportNull$$$0(14);
        }
        if (sequences == null) {
            MergeRangeUtil.$$$reportNull$$$0(15);
        }
        if (lineOffsets == null) {
            MergeRangeUtil.$$$reportNull$$$0(16);
        }
        if (policy == null) {
            MergeRangeUtil.$$$reportNull$$$0(17);
        }
        if (side1 == null) {
            MergeRangeUtil.$$$reportNull$$$0(18);
        }
        if (side2 == null) {
            MergeRangeUtil.$$$reportNull$$$0(19);
        }
        int start1 = fragment.getStartLine(side1);
        int end1 = fragment.getEndLine(side1);
        int start2 = fragment.getStartLine(side2);
        int end2 = fragment.getEndLine(side2);
        if (end2 - start2 != end1 - start1) {
            return false;
        }
        CharSequence sequence1 = side1.select(sequences);
        CharSequence sequence2 = side2.select(sequences);
        LineOffsets offsets1 = side1.select(lineOffsets);
        LineOffsets offsets2 = side2.select(lineOffsets);
        for (int i = 0; i < end1 - start1; ++i) {
            CharSequence content2;
            int line1 = start1 + i;
            int line2 = start2 + i;
            CharSequence content1 = DiffRangeUtil.getLinesContent(sequence1, offsets1, line1, line1 + 1);
            if (ComparisonUtil.isEqualTexts(content1, content2 = DiffRangeUtil.getLinesContent(sequence2, offsets2, line2, line2 + 1), policy)) continue;
            return false;
        }
        return true;
    }

    private static boolean isLineMergeIntervalEmpty(@NotNull MergeLineFragment fragment, @NotNull ThreeSide side) {
        if (fragment == null) {
            MergeRangeUtil.$$$reportNull$$$0(20);
        }
        if (side == null) {
            MergeRangeUtil.$$$reportNull$$$0(21);
        }
        return fragment.getStartLine(side) == fragment.getEndLine(side);
    }

    @NotNull
    public static MergeConflictType getWordMergeType(@NotNull MergeWordFragment fragment, @NotNull List<? extends CharSequence> texts, @NotNull ComparisonPolicy policy) {
        if (fragment == null) {
            MergeRangeUtil.$$$reportNull$$$0(22);
        }
        if (texts == null) {
            MergeRangeUtil.$$$reportNull$$$0(23);
        }
        if (policy == null) {
            MergeRangeUtil.$$$reportNull$$$0(24);
        }
        return MergeRangeUtil.getMergeType((Condition<? super ThreeSide>)((Condition)side -> MergeRangeUtil.isWordMergeIntervalEmpty(fragment, side)), (side1, side2) -> MergeRangeUtil.compareWordMergeContents(fragment, texts, policy, side1, side2), null, () -> false);
    }

    public static boolean compareWordMergeContents(@NotNull MergeWordFragment fragment, @NotNull List<? extends CharSequence> texts, @NotNull ComparisonPolicy policy, @NotNull ThreeSide side1, @NotNull ThreeSide side2) {
        if (fragment == null) {
            MergeRangeUtil.$$$reportNull$$$0(25);
        }
        if (texts == null) {
            MergeRangeUtil.$$$reportNull$$$0(26);
        }
        if (policy == null) {
            MergeRangeUtil.$$$reportNull$$$0(27);
        }
        if (side1 == null) {
            MergeRangeUtil.$$$reportNull$$$0(28);
        }
        if (side2 == null) {
            MergeRangeUtil.$$$reportNull$$$0(29);
        }
        int start1 = fragment.getStartOffset(side1);
        int end1 = fragment.getEndOffset(side1);
        int start2 = fragment.getStartOffset(side2);
        int end2 = fragment.getEndOffset(side2);
        CharSequence document1 = side1.select(texts);
        CharSequence document2 = side2.select(texts);
        CharSequence content1 = document1.subSequence(start1, end1);
        CharSequence content2 = document2.subSequence(start2, end2);
        return ComparisonUtil.isEqualTexts(content1, content2, policy);
    }

    private static boolean isWordMergeIntervalEmpty(@NotNull MergeWordFragment fragment, @NotNull ThreeSide side) {
        if (fragment == null) {
            MergeRangeUtil.$$$reportNull$$$0(30);
        }
        if (side == null) {
            MergeRangeUtil.$$$reportNull$$$0(31);
        }
        return fragment.getStartOffset(side) == fragment.getEndOffset(side);
    }

    @NotNull
    public static MergeConflictType getLineLeftToRightThreeSideDiffType(@NotNull MergeLineFragment fragment, @NotNull List<? extends CharSequence> sequences, @NotNull List<? extends LineOffsets> lineOffsets, @NotNull ComparisonPolicy policy) {
        if (fragment == null) {
            MergeRangeUtil.$$$reportNull$$$0(32);
        }
        if (sequences == null) {
            MergeRangeUtil.$$$reportNull$$$0(33);
        }
        if (lineOffsets == null) {
            MergeRangeUtil.$$$reportNull$$$0(34);
        }
        if (policy == null) {
            MergeRangeUtil.$$$reportNull$$$0(35);
        }
        return MergeRangeUtil.getLeftToRightDiffType((Condition<? super ThreeSide>)((Condition)side -> MergeRangeUtil.isLineMergeIntervalEmpty(fragment, side)), (side1, side2) -> MergeRangeUtil.compareLineMergeContents(fragment, sequences, lineOffsets, policy, side1, side2));
    }

    @NotNull
    private static MergeConflictType getLeftToRightDiffType(@NotNull Condition<? super ThreeSide> emptiness, @NotNull BiPredicate<? super ThreeSide, ? super ThreeSide> equality) {
        if (emptiness == null) {
            MergeRangeUtil.$$$reportNull$$$0(36);
        }
        if (equality == null) {
            MergeRangeUtil.$$$reportNull$$$0(37);
        }
        boolean isLeftEmpty = emptiness.value((Object)ThreeSide.LEFT);
        boolean isBaseEmpty = emptiness.value((Object)ThreeSide.BASE);
        boolean isRightEmpty = emptiness.value((Object)ThreeSide.RIGHT);
        assert (!(isLeftEmpty && isBaseEmpty && isRightEmpty));
        if (isBaseEmpty) {
            if (isLeftEmpty) {
                return new MergeConflictType(MergeConflictType.Type.INSERTED, false, true);
            }
            if (isRightEmpty) {
                return new MergeConflictType(MergeConflictType.Type.DELETED, true, false);
            }
            return new MergeConflictType(MergeConflictType.Type.MODIFIED, true, true);
        }
        if (isLeftEmpty && isRightEmpty) {
            return new MergeConflictType(MergeConflictType.Type.MODIFIED, true, true);
        }
        boolean unchangedLeft = equality.test(ThreeSide.BASE, ThreeSide.LEFT);
        boolean unchangedRight = equality.test(ThreeSide.BASE, ThreeSide.RIGHT);
        assert (!unchangedLeft || !unchangedRight);
        if (unchangedLeft) {
            return new MergeConflictType(isRightEmpty ? MergeConflictType.Type.DELETED : MergeConflictType.Type.MODIFIED, false, true);
        }
        if (unchangedRight) {
            return new MergeConflictType(isLeftEmpty ? MergeConflictType.Type.INSERTED : MergeConflictType.Type.MODIFIED, true, false);
        }
        return new MergeConflictType(MergeConflictType.Type.MODIFIED, true, true);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "emptiness";
                break;
            }
            case 1: 
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "equality";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "conflictResolver";
                break;
            }
            case 3: 
            case 7: 
            case 11: 
            case 14: 
            case 20: 
            case 22: 
            case 25: 
            case 30: 
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fragment";
                break;
            }
            case 4: 
            case 8: 
            case 12: 
            case 15: 
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sequences";
                break;
            }
            case 5: 
            case 9: 
            case 13: 
            case 16: 
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lineOffsets";
                break;
            }
            case 6: 
            case 10: 
            case 17: 
            case 24: 
            case 27: 
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "policy";
                break;
            }
            case 18: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "side1";
                break;
            }
            case 19: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "side2";
                break;
            }
            case 21: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "side";
                break;
            }
            case 23: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "texts";
                break;
            }
        }
        objectArray2[1] = "com/intellij/diff/util/MergeRangeUtil";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getMergeType";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "getLineThreeWayDiffType";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[2] = "getLineMergeType";
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[2] = "canResolveLineConflict";
                break;
            }
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray2;
                objectArray2[2] = "compareLineMergeContents";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray2;
                objectArray2[2] = "isLineMergeIntervalEmpty";
                break;
            }
            case 22: 
            case 23: 
            case 24: {
                objectArray = objectArray2;
                objectArray2[2] = "getWordMergeType";
                break;
            }
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: {
                objectArray = objectArray2;
                objectArray2[2] = "compareWordMergeContents";
                break;
            }
            case 30: 
            case 31: {
                objectArray = objectArray2;
                objectArray2[2] = "isWordMergeIntervalEmpty";
                break;
            }
            case 32: 
            case 33: 
            case 34: 
            case 35: {
                objectArray = objectArray2;
                objectArray2[2] = "getLineLeftToRightThreeSideDiffType";
                break;
            }
            case 36: 
            case 37: {
                objectArray = objectArray2;
                objectArray2[2] = "getLeftToRightDiffType";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

