/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.comparison;

import com.intellij.diff.comparison.ByCharRt;
import com.intellij.diff.comparison.CancellationChecker;
import com.intellij.diff.comparison.ChunkOptimizer;
import com.intellij.diff.comparison.ComparisonMergeUtil;
import com.intellij.diff.comparison.ComparisonPolicy;
import com.intellij.diff.comparison.ComparisonUtil;
import com.intellij.diff.comparison.LineFragmentSplitter;
import com.intellij.diff.comparison.TrimUtil;
import com.intellij.diff.comparison.iterables.DiffIterable;
import com.intellij.diff.comparison.iterables.DiffIterableUtil;
import com.intellij.diff.comparison.iterables.FairDiffIterable;
import com.intellij.diff.fragments.DiffFragment;
import com.intellij.diff.fragments.DiffFragmentImpl;
import com.intellij.diff.fragments.MergeWordFragment;
import com.intellij.diff.fragments.MergeWordFragmentImpl;
import com.intellij.diff.util.MergeRange;
import com.intellij.diff.util.Range;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.text.Strings;
import com.intellij.util.text.MergingCharSequence;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;

public final class ByWordRt {
    @NotNull
    public static List<DiffFragment> compare(@NotNull CharSequence text1, @NotNull CharSequence text2, @NotNull ComparisonPolicy policy, @NotNull CancellationChecker indicator) {
        if (text1 == null) {
            ByWordRt.$$$reportNull$$$0(0);
        }
        if (text2 == null) {
            ByWordRt.$$$reportNull$$$0(1);
        }
        if (policy == null) {
            ByWordRt.$$$reportNull$$$0(2);
        }
        if (indicator == null) {
            ByWordRt.$$$reportNull$$$0(3);
        }
        indicator.checkCanceled();
        List<InlineChunk> words1 = ByWordRt.getInlineChunks(text1);
        List<InlineChunk> words2 = ByWordRt.getInlineChunks(text2);
        return ByWordRt.compare(text1, words1, text2, words2, policy, indicator);
    }

    @NotNull
    public static List<DiffFragment> compare(@NotNull CharSequence text1, @NotNull List<? extends InlineChunk> words1, @NotNull CharSequence text2, @NotNull List<? extends InlineChunk> words2, @NotNull ComparisonPolicy policy, @NotNull CancellationChecker indicator) {
        if (text1 == null) {
            ByWordRt.$$$reportNull$$$0(4);
        }
        if (words1 == null) {
            ByWordRt.$$$reportNull$$$0(5);
        }
        if (text2 == null) {
            ByWordRt.$$$reportNull$$$0(6);
        }
        if (words2 == null) {
            ByWordRt.$$$reportNull$$$0(7);
        }
        if (policy == null) {
            ByWordRt.$$$reportNull$$$0(8);
        }
        if (indicator == null) {
            ByWordRt.$$$reportNull$$$0(9);
        }
        FairDiffIterable wordChanges = DiffIterableUtil.diff(words1, words2, indicator);
        wordChanges = ByWordRt.optimizeWordChunks(text1, text2, words1, words2, wordChanges, indicator);
        FairDiffIterable delimitersIterable = ByWordRt.matchAdjustmentDelimiters(text1, text2, words1, words2, wordChanges, indicator);
        DiffIterable iterable = ByWordRt.matchAdjustmentWhitespaces(text1, text2, delimitersIterable, policy, indicator);
        return ByWordRt.convertIntoDiffFragments(iterable);
    }

    @NotNull
    public static List<MergeWordFragment> compare(@NotNull CharSequence text1, @NotNull CharSequence text2, @NotNull CharSequence text3, @NotNull ComparisonPolicy policy, @NotNull CancellationChecker indicator) {
        if (text1 == null) {
            ByWordRt.$$$reportNull$$$0(10);
        }
        if (text2 == null) {
            ByWordRt.$$$reportNull$$$0(11);
        }
        if (text3 == null) {
            ByWordRt.$$$reportNull$$$0(12);
        }
        if (policy == null) {
            ByWordRt.$$$reportNull$$$0(13);
        }
        if (indicator == null) {
            ByWordRt.$$$reportNull$$$0(14);
        }
        indicator.checkCanceled();
        List<InlineChunk> words1 = ByWordRt.getInlineChunks(text1);
        List<InlineChunk> words2 = ByWordRt.getInlineChunks(text2);
        List<InlineChunk> words3 = ByWordRt.getInlineChunks(text3);
        FairDiffIterable wordChanges1 = DiffIterableUtil.diff(words2, words1, indicator);
        wordChanges1 = ByWordRt.optimizeWordChunks(text2, text1, words2, words1, wordChanges1, indicator);
        FairDiffIterable iterable1 = ByWordRt.matchAdjustmentDelimiters(text2, text1, words2, words1, wordChanges1, indicator);
        FairDiffIterable wordChanges2 = DiffIterableUtil.diff(words2, words3, indicator);
        wordChanges2 = ByWordRt.optimizeWordChunks(text2, text3, words2, words3, wordChanges2, indicator);
        FairDiffIterable iterable2 = ByWordRt.matchAdjustmentDelimiters(text2, text3, words2, words3, wordChanges2, indicator);
        List<MergeRange> wordConflicts = ComparisonMergeUtil.buildSimple(iterable1, iterable2, indicator);
        List<MergeRange> result = ByWordRt.matchAdjustmentWhitespaces(text1, text2, text3, wordConflicts, policy, indicator);
        return ByWordRt.convertIntoMergeWordFragments(result);
    }

    @NotNull
    public static List<LineBlock> compareAndSplit(@NotNull CharSequence text1, @NotNull CharSequence text2, @NotNull ComparisonPolicy policy, @NotNull CancellationChecker indicator) {
        if (text1 == null) {
            ByWordRt.$$$reportNull$$$0(15);
        }
        if (text2 == null) {
            ByWordRt.$$$reportNull$$$0(16);
        }
        if (policy == null) {
            ByWordRt.$$$reportNull$$$0(17);
        }
        if (indicator == null) {
            ByWordRt.$$$reportNull$$$0(18);
        }
        indicator.checkCanceled();
        List<InlineChunk> words1 = ByWordRt.getInlineChunks(text1);
        List<InlineChunk> words2 = ByWordRt.getInlineChunks(text2);
        FairDiffIterable wordChanges = DiffIterableUtil.diff(words1, words2, indicator);
        wordChanges = ByWordRt.optimizeWordChunks(text1, text2, words1, words2, wordChanges, indicator);
        List<LineFragmentSplitter.WordBlock> wordBlocks = new LineFragmentSplitter(text1, text2, words1, words2, wordChanges, indicator).run();
        ArrayList<LineBlock> lineBlocks = new ArrayList<LineBlock>(wordBlocks.size());
        for (LineFragmentSplitter.WordBlock block : wordBlocks) {
            Range offsets = block.offsets;
            Range words = block.words;
            CharSequence subtext1 = text1.subSequence(offsets.start1, offsets.end1);
            CharSequence subtext2 = text2.subSequence(offsets.start2, offsets.end2);
            List<InlineChunk> subwords1 = words1.subList(words.start1, words.end1);
            List<InlineChunk> subwords2 = words2.subList(words.start2, words.end2);
            FairDiffIterable subiterable = DiffIterableUtil.fair(DiffIterableUtil.subiterable(wordChanges, words.start1, words.end1, words.start2, words.end2));
            FairDiffIterable delimitersIterable = ByWordRt.matchAdjustmentDelimiters(subtext1, subtext2, subwords1, subwords2, subiterable, offsets.start1, offsets.start2, indicator);
            DiffIterable iterable = ByWordRt.matchAdjustmentWhitespaces(subtext1, subtext2, delimitersIterable, policy, indicator);
            List<DiffFragment> fragments = ByWordRt.convertIntoDiffFragments(iterable);
            int newlines1 = ByWordRt.countNewlines(subwords1);
            int newlines2 = ByWordRt.countNewlines(subwords2);
            lineBlocks.add(new LineBlock(fragments, offsets, newlines1, newlines2));
        }
        ArrayList<LineBlock> arrayList = lineBlocks;
        if (arrayList == null) {
            ByWordRt.$$$reportNull$$$0(19);
        }
        return arrayList;
    }

    @NotNull
    private static FairDiffIterable optimizeWordChunks(@NotNull CharSequence text1, @NotNull CharSequence text2, @NotNull List<? extends InlineChunk> words1, @NotNull List<? extends InlineChunk> words2, @NotNull FairDiffIterable iterable, @NotNull CancellationChecker indicator) {
        if (text1 == null) {
            ByWordRt.$$$reportNull$$$0(20);
        }
        if (text2 == null) {
            ByWordRt.$$$reportNull$$$0(21);
        }
        if (words1 == null) {
            ByWordRt.$$$reportNull$$$0(22);
        }
        if (words2 == null) {
            ByWordRt.$$$reportNull$$$0(23);
        }
        if (iterable == null) {
            ByWordRt.$$$reportNull$$$0(24);
        }
        if (indicator == null) {
            ByWordRt.$$$reportNull$$$0(25);
        }
        FairDiffIterable fairDiffIterable = new ChunkOptimizer.WordChunkOptimizer(words1, words2, text1, text2, iterable, indicator).build();
        if (fairDiffIterable == null) {
            ByWordRt.$$$reportNull$$$0(26);
        }
        return fairDiffIterable;
    }

    @NotNull
    private static FairDiffIterable matchAdjustmentDelimiters(@NotNull CharSequence text1, @NotNull CharSequence text2, @NotNull List<? extends InlineChunk> words1, @NotNull List<? extends InlineChunk> words2, @NotNull FairDiffIterable changes, @NotNull CancellationChecker indicator) {
        if (text1 == null) {
            ByWordRt.$$$reportNull$$$0(27);
        }
        if (text2 == null) {
            ByWordRt.$$$reportNull$$$0(28);
        }
        if (words1 == null) {
            ByWordRt.$$$reportNull$$$0(29);
        }
        if (words2 == null) {
            ByWordRt.$$$reportNull$$$0(30);
        }
        if (changes == null) {
            ByWordRt.$$$reportNull$$$0(31);
        }
        if (indicator == null) {
            ByWordRt.$$$reportNull$$$0(32);
        }
        return ByWordRt.matchAdjustmentDelimiters(text1, text2, words1, words2, changes, 0, 0, indicator);
    }

    @NotNull
    private static FairDiffIterable matchAdjustmentDelimiters(@NotNull CharSequence text1, @NotNull CharSequence text2, @NotNull List<? extends InlineChunk> words1, @NotNull List<? extends InlineChunk> words2, @NotNull FairDiffIterable changes, int startShift1, int startShift2, @NotNull CancellationChecker indicator) {
        if (text1 == null) {
            ByWordRt.$$$reportNull$$$0(33);
        }
        if (text2 == null) {
            ByWordRt.$$$reportNull$$$0(34);
        }
        if (words1 == null) {
            ByWordRt.$$$reportNull$$$0(35);
        }
        if (words2 == null) {
            ByWordRt.$$$reportNull$$$0(36);
        }
        if (changes == null) {
            ByWordRt.$$$reportNull$$$0(37);
        }
        if (indicator == null) {
            ByWordRt.$$$reportNull$$$0(38);
        }
        FairDiffIterable fairDiffIterable = new AdjustmentPunctuationMatcher(text1, text2, words1, words2, startShift1, startShift2, changes, indicator).build();
        if (fairDiffIterable == null) {
            ByWordRt.$$$reportNull$$$0(39);
        }
        return fairDiffIterable;
    }

    @NotNull
    private static DiffIterable matchAdjustmentWhitespaces(@NotNull CharSequence text1, @NotNull CharSequence text2, @NotNull FairDiffIterable iterable, @NotNull ComparisonPolicy policy, @NotNull CancellationChecker indicator) {
        if (text1 == null) {
            ByWordRt.$$$reportNull$$$0(40);
        }
        if (text2 == null) {
            ByWordRt.$$$reportNull$$$0(41);
        }
        if (iterable == null) {
            ByWordRt.$$$reportNull$$$0(42);
        }
        if (policy == null) {
            ByWordRt.$$$reportNull$$$0(43);
        }
        if (indicator == null) {
            ByWordRt.$$$reportNull$$$0(44);
        }
        switch (policy) {
            case DEFAULT: {
                DiffIterable diffIterable = new DefaultCorrector(iterable, text1, text2, indicator).build();
                if (diffIterable == null) {
                    ByWordRt.$$$reportNull$$$0(45);
                }
                return diffIterable;
            }
            case TRIM_WHITESPACES: {
                DiffIterable defaultIterable = new DefaultCorrector(iterable, text1, text2, indicator).build();
                DiffIterable diffIterable = new TrimSpacesCorrector(defaultIterable, text1, text2, indicator).build();
                if (diffIterable == null) {
                    ByWordRt.$$$reportNull$$$0(46);
                }
                return diffIterable;
            }
            case IGNORE_WHITESPACES: {
                DiffIterable diffIterable = new IgnoreSpacesCorrector(iterable, text1, text2, indicator).build();
                if (diffIterable == null) {
                    ByWordRt.$$$reportNull$$$0(47);
                }
                return diffIterable;
            }
        }
        throw new IllegalArgumentException(policy.name());
    }

    @NotNull
    private static List<MergeRange> matchAdjustmentWhitespaces(@NotNull CharSequence text1, @NotNull CharSequence text2, @NotNull CharSequence text3, @NotNull List<? extends MergeRange> conflicts, @NotNull ComparisonPolicy policy, @NotNull CancellationChecker indicator) {
        if (text1 == null) {
            ByWordRt.$$$reportNull$$$0(48);
        }
        if (text2 == null) {
            ByWordRt.$$$reportNull$$$0(49);
        }
        if (text3 == null) {
            ByWordRt.$$$reportNull$$$0(50);
        }
        if (conflicts == null) {
            ByWordRt.$$$reportNull$$$0(51);
        }
        if (policy == null) {
            ByWordRt.$$$reportNull$$$0(52);
        }
        if (indicator == null) {
            ByWordRt.$$$reportNull$$$0(53);
        }
        switch (policy) {
            case DEFAULT: {
                List<MergeRange> list = new MergeDefaultCorrector(conflicts, text1, text2, text3, indicator).build();
                if (list == null) {
                    ByWordRt.$$$reportNull$$$0(54);
                }
                return list;
            }
            case TRIM_WHITESPACES: {
                List<MergeRange> defaultConflicts = new MergeDefaultCorrector(conflicts, text1, text2, text3, indicator).build();
                List<MergeRange> list = new MergeTrimSpacesCorrector(defaultConflicts, text1, text2, text3, indicator).build();
                if (list == null) {
                    ByWordRt.$$$reportNull$$$0(55);
                }
                return list;
            }
            case IGNORE_WHITESPACES: {
                List<MergeRange> list = new MergeIgnoreSpacesCorrector(conflicts, text1, text2, text3, indicator).build();
                if (list == null) {
                    ByWordRt.$$$reportNull$$$0(56);
                }
                return list;
            }
        }
        throw new IllegalArgumentException(policy.name());
    }

    @NotNull
    public static List<MergeWordFragment> convertIntoMergeWordFragments(@NotNull List<? extends MergeRange> conflicts) {
        if (conflicts == null) {
            ByWordRt.$$$reportNull$$$0(57);
        }
        List<MergeWordFragment> list = conflicts.stream().map(ch -> new MergeWordFragmentImpl((MergeRange)ch)).collect(Collectors.toList());
        if (list == null) {
            ByWordRt.$$$reportNull$$$0(58);
        }
        return list;
    }

    @NotNull
    public static List<DiffFragment> convertIntoDiffFragments(@NotNull DiffIterable changes) {
        if (changes == null) {
            ByWordRt.$$$reportNull$$$0(59);
        }
        ArrayList<DiffFragment> fragments = new ArrayList<DiffFragment>();
        for (Range ch : changes.iterateChanges()) {
            fragments.add(new DiffFragmentImpl(ch.start1, ch.end1, ch.start2, ch.end2));
        }
        ArrayList<DiffFragment> arrayList = fragments;
        if (arrayList == null) {
            ByWordRt.$$$reportNull$$$0(60);
        }
        return arrayList;
    }

    @NotNull
    private static Couple<FairDiffIterable> comparePunctuation2Side(@NotNull CharSequence text1, @NotNull CharSequence text21, @NotNull CharSequence text22, @NotNull CancellationChecker indicator) {
        if (text1 == null) {
            ByWordRt.$$$reportNull$$$0(61);
        }
        if (text21 == null) {
            ByWordRt.$$$reportNull$$$0(62);
        }
        if (text22 == null) {
            ByWordRt.$$$reportNull$$$0(63);
        }
        if (indicator == null) {
            ByWordRt.$$$reportNull$$$0(64);
        }
        MergingCharSequence text2 = new MergingCharSequence(text21, text22);
        FairDiffIterable changes = ByCharRt.comparePunctuation(text1, text2, indicator);
        Couple<List<Range>> ranges = ByWordRt.splitIterable2Side(changes, text21.length());
        FairDiffIterable iterable1 = DiffIterableUtil.fair(DiffIterableUtil.createUnchanged((List)ranges.first, text1.length(), text21.length()));
        FairDiffIterable iterable2 = DiffIterableUtil.fair(DiffIterableUtil.createUnchanged((List)ranges.second, text1.length(), text22.length()));
        Couple couple = Couple.of((Object)iterable1, (Object)iterable2);
        if (couple == null) {
            ByWordRt.$$$reportNull$$$0(65);
        }
        return couple;
    }

    @NotNull
    private static Couple<List<Range>> splitIterable2Side(@NotNull FairDiffIterable changes, int offset) {
        if (changes == null) {
            ByWordRt.$$$reportNull$$$0(66);
        }
        ArrayList<Range> ranges1 = new ArrayList<Range>();
        ArrayList<Range> ranges2 = new ArrayList<Range>();
        for (Range ch : changes.iterateUnchanged()) {
            if (ch.end2 <= offset) {
                ranges1.add(new Range(ch.start1, ch.end1, ch.start2, ch.end2));
                continue;
            }
            if (ch.start2 >= offset) {
                ranges2.add(new Range(ch.start1, ch.end1, ch.start2 - offset, ch.end2 - offset));
                continue;
            }
            int len2 = offset - ch.start2;
            ranges1.add(new Range(ch.start1, ch.start1 + len2, ch.start2, offset));
            ranges2.add(new Range(ch.start1 + len2, ch.end1, 0, ch.end2 - offset));
        }
        Couple couple = Couple.of(ranges1, ranges2);
        if (couple == null) {
            ByWordRt.$$$reportNull$$$0(67);
        }
        return couple;
    }

    public static boolean isWordChunk(@NotNull InlineChunk chunk) {
        if (chunk == null) {
            ByWordRt.$$$reportNull$$$0(68);
        }
        return chunk instanceof WordChunk;
    }

    private static boolean isLeadingTrailingSpace(@NotNull CharSequence text, int start) {
        if (text == null) {
            ByWordRt.$$$reportNull$$$0(69);
        }
        return ByWordRt.isLeadingSpace(text, start) || ByWordRt.isTrailingSpace(text, start);
    }

    private static boolean isLeadingSpace(@NotNull CharSequence text, int start) {
        if (text == null) {
            ByWordRt.$$$reportNull$$$0(70);
        }
        if (start < 0) {
            return false;
        }
        if (start == text.length()) {
            return false;
        }
        if (!Strings.isWhiteSpace(text.charAt(start))) {
            return false;
        }
        --start;
        while (start >= 0) {
            char c = text.charAt(start);
            if (c == '\n') {
                return true;
            }
            if (!Strings.isWhiteSpace(c)) {
                return false;
            }
            --start;
        }
        return true;
    }

    private static boolean isTrailingSpace(@NotNull CharSequence text, int end) {
        if (text == null) {
            ByWordRt.$$$reportNull$$$0(71);
        }
        if (end < 0) {
            return false;
        }
        if (end == text.length()) {
            return false;
        }
        if (!Strings.isWhiteSpace(text.charAt(end))) {
            return false;
        }
        while (end < text.length()) {
            char c = text.charAt(end);
            if (c == '\n') {
                return true;
            }
            if (!Strings.isWhiteSpace(c)) {
                return false;
            }
            ++end;
        }
        return true;
    }

    private static int countNewlines(@NotNull List<? extends InlineChunk> words) {
        if (words == null) {
            ByWordRt.$$$reportNull$$$0(72);
        }
        int count = 0;
        for (InlineChunk inlineChunk : words) {
            if (!(inlineChunk instanceof NewlineChunk)) continue;
            ++count;
        }
        return count;
    }

    @NotNull
    public static List<InlineChunk> getInlineChunks(@NotNull CharSequence text) {
        int charCount;
        if (text == null) {
            ByWordRt.$$$reportNull$$$0(73);
        }
        ArrayList<InlineChunk> chunks = new ArrayList<InlineChunk>();
        int len = text.length();
        int wordStart = -1;
        int wordHash = 0;
        for (int offset = 0; offset < len; offset += charCount) {
            boolean isWordPart;
            int ch = Character.codePointAt(text, offset);
            charCount = Character.charCount(ch);
            boolean isAlpha = TrimUtil.isAlpha(ch);
            boolean bl = isWordPart = isAlpha && !TrimUtil.isContinuousScript(ch);
            if (isWordPart) {
                if (wordStart == -1) {
                    wordStart = offset;
                    wordHash = 0;
                }
                wordHash = wordHash * 31 + ch;
                continue;
            }
            if (wordStart != -1) {
                chunks.add(new WordChunk(text, wordStart, offset, wordHash));
                wordStart = -1;
            }
            if (isAlpha) {
                chunks.add(new WordChunk(text, offset, offset + charCount, ch));
                continue;
            }
            if (ch != 10) continue;
            chunks.add(new NewlineChunk(offset));
        }
        if (wordStart != -1) {
            chunks.add(new WordChunk(text, wordStart, len, wordHash));
        }
        ArrayList<InlineChunk> arrayList = chunks;
        if (arrayList == null) {
            ByWordRt.$$$reportNull$$$0(74);
        }
        return arrayList;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 19: 
            case 26: 
            case 39: 
            case 45: 
            case 46: 
            case 47: 
            case 54: 
            case 55: 
            case 56: 
            case 58: 
            case 60: 
            case 65: 
            case 67: 
            case 74: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 19: 
            case 26: 
            case 39: 
            case 45: 
            case 46: 
            case 47: 
            case 54: 
            case 55: 
            case 56: 
            case 58: 
            case 60: 
            case 65: 
            case 67: 
            case 74: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text1";
                break;
            }
            case 1: 
            case 6: 
            case 11: 
            case 16: 
            case 21: 
            case 28: 
            case 34: 
            case 41: 
            case 49: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text2";
                break;
            }
            case 2: 
            case 8: 
            case 13: 
            case 17: 
            case 43: 
            case 52: {
                objectArray2 = objectArray3;
                objectArray3[0] = "policy";
                break;
            }
            case 3: 
            case 9: 
            case 14: 
            case 18: 
            case 25: 
            case 32: 
            case 38: 
            case 44: 
            case 53: 
            case 64: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indicator";
                break;
            }
            case 5: 
            case 22: 
            case 29: 
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "words1";
                break;
            }
            case 7: 
            case 23: 
            case 30: 
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "words2";
                break;
            }
            case 12: 
            case 50: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text3";
                break;
            }
            case 19: 
            case 26: 
            case 39: 
            case 45: 
            case 46: 
            case 47: 
            case 54: 
            case 55: 
            case 56: 
            case 58: 
            case 60: 
            case 65: 
            case 67: 
            case 74: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/diff/comparison/ByWordRt";
                break;
            }
            case 24: 
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "iterable";
                break;
            }
            case 31: 
            case 37: 
            case 59: 
            case 66: {
                objectArray2 = objectArray3;
                objectArray3[0] = "changes";
                break;
            }
            case 51: 
            case 57: {
                objectArray2 = objectArray3;
                objectArray3[0] = "conflicts";
                break;
            }
            case 62: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text21";
                break;
            }
            case 63: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text22";
                break;
            }
            case 68: {
                objectArray2 = objectArray3;
                objectArray3[0] = "chunk";
                break;
            }
            case 69: 
            case 70: 
            case 71: 
            case 73: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 72: {
                objectArray2 = objectArray3;
                objectArray3[0] = "words";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/diff/comparison/ByWordRt";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "compareAndSplit";
                break;
            }
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "optimizeWordChunks";
                break;
            }
            case 39: {
                objectArray = objectArray2;
                objectArray2[1] = "matchAdjustmentDelimiters";
                break;
            }
            case 45: 
            case 46: 
            case 47: 
            case 54: 
            case 55: 
            case 56: {
                objectArray = objectArray2;
                objectArray2[1] = "matchAdjustmentWhitespaces";
                break;
            }
            case 58: {
                objectArray = objectArray2;
                objectArray2[1] = "convertIntoMergeWordFragments";
                break;
            }
            case 60: {
                objectArray = objectArray2;
                objectArray2[1] = "convertIntoDiffFragments";
                break;
            }
            case 65: {
                objectArray = objectArray2;
                objectArray2[1] = "comparePunctuation2Side";
                break;
            }
            case 67: {
                objectArray = objectArray2;
                objectArray2[1] = "splitIterable2Side";
                break;
            }
            case 74: {
                objectArray = objectArray2;
                objectArray2[1] = "getInlineChunks";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "compare";
                break;
            }
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "compareAndSplit";
                break;
            }
            case 19: 
            case 26: 
            case 39: 
            case 45: 
            case 46: 
            case 47: 
            case 54: 
            case 55: 
            case 56: 
            case 58: 
            case 60: 
            case 65: 
            case 67: 
            case 74: {
                break;
            }
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "optimizeWordChunks";
                break;
            }
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "matchAdjustmentDelimiters";
                break;
            }
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: {
                objectArray = objectArray;
                objectArray[2] = "matchAdjustmentWhitespaces";
                break;
            }
            case 57: {
                objectArray = objectArray;
                objectArray[2] = "convertIntoMergeWordFragments";
                break;
            }
            case 59: {
                objectArray = objectArray;
                objectArray[2] = "convertIntoDiffFragments";
                break;
            }
            case 61: 
            case 62: 
            case 63: 
            case 64: {
                objectArray = objectArray;
                objectArray[2] = "comparePunctuation2Side";
                break;
            }
            case 66: {
                objectArray = objectArray;
                objectArray[2] = "splitIterable2Side";
                break;
            }
            case 68: {
                objectArray = objectArray;
                objectArray[2] = "isWordChunk";
                break;
            }
            case 69: {
                objectArray = objectArray;
                objectArray[2] = "isLeadingTrailingSpace";
                break;
            }
            case 70: {
                objectArray = objectArray;
                objectArray[2] = "isLeadingSpace";
                break;
            }
            case 71: {
                objectArray = objectArray;
                objectArray[2] = "isTrailingSpace";
                break;
            }
            case 72: {
                objectArray = objectArray;
                objectArray[2] = "countNewlines";
                break;
            }
            case 73: {
                objectArray = objectArray;
                objectArray[2] = "getInlineChunks";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 19: 
            case 26: 
            case 39: 
            case 45: 
            case 46: 
            case 47: 
            case 54: 
            case 55: 
            case 56: 
            case 58: 
            case 60: 
            case 65: 
            case 67: 
            case 74: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }

    public static class LineBlock {
        @NotNull
        public final List<DiffFragment> fragments;
        @NotNull
        public final Range offsets;
        public final int newlines1;
        public final int newlines2;

        public LineBlock(@NotNull List<DiffFragment> fragments, @NotNull Range offsets, int newlines1, int newlines2) {
            if (fragments == null) {
                LineBlock.$$$reportNull$$$0(0);
            }
            if (offsets == null) {
                LineBlock.$$$reportNull$$$0(1);
            }
            this.fragments = fragments;
            this.offsets = offsets;
            this.newlines1 = newlines1;
            this.newlines2 = newlines2;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "fragments";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "offsets";
                    break;
                }
            }
            objectArray[1] = "com/intellij/diff/comparison/ByWordRt$LineBlock";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    static class NewlineChunk
    implements InlineChunk {
        private final int myOffset;

        NewlineChunk(int offset) {
            this.myOffset = offset;
        }

        @Override
        public int getOffset1() {
            return this.myOffset;
        }

        @Override
        public int getOffset2() {
            return this.myOffset + 1;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            return o != null && this.getClass() == o.getClass();
        }

        public int hashCode() {
            return this.getClass().hashCode();
        }
    }

    static class WordChunk
    implements InlineChunk {
        @NotNull
        private final CharSequence myText;
        private final int myOffset1;
        private final int myOffset2;
        private final int myHash;

        WordChunk(@NotNull CharSequence text, int offset1, int offset2, int hash) {
            if (text == null) {
                WordChunk.$$$reportNull$$$0(0);
            }
            this.myText = text;
            this.myOffset1 = offset1;
            this.myOffset2 = offset2;
            this.myHash = hash;
        }

        @NotNull
        public CharSequence getContent() {
            CharSequence charSequence = this.myText.subSequence(this.myOffset1, this.myOffset2);
            if (charSequence == null) {
                WordChunk.$$$reportNull$$$0(1);
            }
            return charSequence;
        }

        @Override
        public int getOffset1() {
            return this.myOffset1;
        }

        @Override
        public int getOffset2() {
            return this.myOffset2;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            WordChunk word = (WordChunk)o;
            if (this.myHash != word.myHash) {
                return false;
            }
            return ComparisonUtil.isEquals(this.getContent(), word.getContent(), ComparisonPolicy.DEFAULT);
        }

        public int hashCode() {
            return this.myHash;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string2;
            switch (n) {
                default: {
                    string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string2 = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "text";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/diff/comparison/ByWordRt$WordChunk";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/diff/comparison/ByWordRt$WordChunk";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getContent";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string3 = String.format(string2, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string3);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string3);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static interface InlineChunk {
        public int getOffset1();

        public int getOffset2();
    }

    private static class MergeTrimSpacesCorrector {
        @NotNull
        private final List<? extends MergeRange> myIterable;
        @NotNull
        private final CharSequence myText1;
        @NotNull
        private final CharSequence myText2;
        @NotNull
        private final CharSequence myText3;
        @NotNull
        private final CancellationChecker myIndicator;
        @NotNull
        private final List<MergeRange> myChanges;

        MergeTrimSpacesCorrector(@NotNull List<? extends MergeRange> iterable, @NotNull CharSequence text1, @NotNull CharSequence text2, @NotNull CharSequence text3, @NotNull CancellationChecker indicator) {
            if (iterable == null) {
                MergeTrimSpacesCorrector.$$$reportNull$$$0(0);
            }
            if (text1 == null) {
                MergeTrimSpacesCorrector.$$$reportNull$$$0(1);
            }
            if (text2 == null) {
                MergeTrimSpacesCorrector.$$$reportNull$$$0(2);
            }
            if (text3 == null) {
                MergeTrimSpacesCorrector.$$$reportNull$$$0(3);
            }
            if (indicator == null) {
                MergeTrimSpacesCorrector.$$$reportNull$$$0(4);
            }
            this.myIterable = iterable;
            this.myText1 = text1;
            this.myText2 = text2;
            this.myText3 = text3;
            this.myIndicator = indicator;
            this.myChanges = new ArrayList<MergeRange>();
        }

        @NotNull
        public List<MergeRange> build() {
            for (MergeRange mergeRange : this.myIterable) {
                MergeRange trimmed;
                int start1 = mergeRange.start1;
                int start2 = mergeRange.start2;
                int start3 = mergeRange.start3;
                int end1 = mergeRange.end1;
                int end2 = mergeRange.end2;
                int end3 = mergeRange.end3;
                if (ByWordRt.isLeadingTrailingSpace(this.myText1, start1)) {
                    start1 = TrimUtil.trimStart(this.myText1, start1, end1);
                }
                if (ByWordRt.isLeadingTrailingSpace(this.myText1, end1 - 1)) {
                    end1 = TrimUtil.trimEnd(this.myText1, start1, end1);
                }
                if (ByWordRt.isLeadingTrailingSpace(this.myText2, start2)) {
                    start2 = TrimUtil.trimStart(this.myText2, start2, end2);
                }
                if (ByWordRt.isLeadingTrailingSpace(this.myText2, end2 - 1)) {
                    end2 = TrimUtil.trimEnd(this.myText2, start2, end2);
                }
                if (ByWordRt.isLeadingTrailingSpace(this.myText3, start3)) {
                    start3 = TrimUtil.trimStart(this.myText3, start3, end3);
                }
                if (ByWordRt.isLeadingTrailingSpace(this.myText3, end3 - 1)) {
                    end3 = TrimUtil.trimEnd(this.myText3, start3, end3);
                }
                if ((trimmed = new MergeRange(start1, end1, start2, end2, start3, end3)).isEmpty() || TrimUtil.isEquals(this.myText1, this.myText2, this.myText3, trimmed)) continue;
                this.myChanges.add(trimmed);
            }
            List<MergeRange> list = this.myChanges;
            if (list == null) {
                MergeTrimSpacesCorrector.$$$reportNull$$$0(5);
            }
            return list;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string2;
            switch (n) {
                default: {
                    string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 5: {
                    string2 = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 5: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "iterable";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "text1";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "text2";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "text3";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "indicator";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/diff/comparison/ByWordRt$MergeTrimSpacesCorrector";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/diff/comparison/ByWordRt$MergeTrimSpacesCorrector";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "build";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 5: {
                    break;
                }
            }
            String string3 = String.format(string2, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string3);
                    break;
                }
                case 5: {
                    runtimeException = new IllegalStateException(string3);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    static class TrimSpacesCorrector {
        @NotNull
        private final DiffIterable myIterable;
        @NotNull
        private final CharSequence myText1;
        @NotNull
        private final CharSequence myText2;
        @NotNull
        private final CancellationChecker myIndicator;
        @NotNull
        private final List<Range> myChanges;

        TrimSpacesCorrector(@NotNull DiffIterable iterable, @NotNull CharSequence text1, @NotNull CharSequence text2, @NotNull CancellationChecker indicator) {
            if (iterable == null) {
                TrimSpacesCorrector.$$$reportNull$$$0(0);
            }
            if (text1 == null) {
                TrimSpacesCorrector.$$$reportNull$$$0(1);
            }
            if (text2 == null) {
                TrimSpacesCorrector.$$$reportNull$$$0(2);
            }
            if (indicator == null) {
                TrimSpacesCorrector.$$$reportNull$$$0(3);
            }
            this.myIterable = iterable;
            this.myText1 = text1;
            this.myText2 = text2;
            this.myIndicator = indicator;
            this.myChanges = new ArrayList<Range>();
        }

        @NotNull
        public DiffIterable build() {
            for (Range range : this.myIterable.iterateChanges()) {
                Range trimmed;
                int start1 = range.start1;
                int start2 = range.start2;
                int end1 = range.end1;
                int end2 = range.end2;
                if (ByWordRt.isLeadingTrailingSpace(this.myText1, start1)) {
                    start1 = TrimUtil.trimStart(this.myText1, start1, end1);
                }
                if (ByWordRt.isLeadingTrailingSpace(this.myText1, end1 - 1)) {
                    end1 = TrimUtil.trimEnd(this.myText1, start1, end1);
                }
                if (ByWordRt.isLeadingTrailingSpace(this.myText2, start2)) {
                    start2 = TrimUtil.trimStart(this.myText2, start2, end2);
                }
                if (ByWordRt.isLeadingTrailingSpace(this.myText2, end2 - 1)) {
                    end2 = TrimUtil.trimEnd(this.myText2, start2, end2);
                }
                if ((trimmed = new Range(start1, end1, start2, end2)).isEmpty() || TrimUtil.isEquals(this.myText1, this.myText2, trimmed)) continue;
                this.myChanges.add(trimmed);
            }
            DiffIterable diffIterable = DiffIterableUtil.create(this.myChanges, this.myText1.length(), this.myText2.length());
            if (diffIterable == null) {
                TrimSpacesCorrector.$$$reportNull$$$0(4);
            }
            return diffIterable;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string2;
            switch (n) {
                default: {
                    string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 4: {
                    string2 = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 4: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "iterable";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "text1";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "text2";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "indicator";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/diff/comparison/ByWordRt$TrimSpacesCorrector";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/diff/comparison/ByWordRt$TrimSpacesCorrector";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "build";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 4: {
                    break;
                }
            }
            String string3 = String.format(string2, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string3);
                    break;
                }
                case 4: {
                    runtimeException = new IllegalStateException(string3);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class MergeIgnoreSpacesCorrector {
        @NotNull
        private final List<? extends MergeRange> myIterable;
        @NotNull
        private final CharSequence myText1;
        @NotNull
        private final CharSequence myText2;
        @NotNull
        private final CharSequence myText3;
        @NotNull
        private final CancellationChecker myIndicator;
        @NotNull
        private final List<MergeRange> myChanges;

        MergeIgnoreSpacesCorrector(@NotNull List<? extends MergeRange> iterable, @NotNull CharSequence text1, @NotNull CharSequence text2, @NotNull CharSequence text3, @NotNull CancellationChecker indicator) {
            if (iterable == null) {
                MergeIgnoreSpacesCorrector.$$$reportNull$$$0(0);
            }
            if (text1 == null) {
                MergeIgnoreSpacesCorrector.$$$reportNull$$$0(1);
            }
            if (text2 == null) {
                MergeIgnoreSpacesCorrector.$$$reportNull$$$0(2);
            }
            if (text3 == null) {
                MergeIgnoreSpacesCorrector.$$$reportNull$$$0(3);
            }
            if (indicator == null) {
                MergeIgnoreSpacesCorrector.$$$reportNull$$$0(4);
            }
            this.myIterable = iterable;
            this.myText1 = text1;
            this.myText2 = text2;
            this.myText3 = text3;
            this.myIndicator = indicator;
            this.myChanges = new ArrayList<MergeRange>();
        }

        @NotNull
        public List<MergeRange> build() {
            for (MergeRange mergeRange : this.myIterable) {
                MergeRange expanded = TrimUtil.expandWhitespaces(this.myText1, this.myText2, this.myText3, mergeRange);
                MergeRange trimmed = TrimUtil.trim(this.myText1, this.myText2, this.myText3, expanded);
                if (trimmed.isEmpty() || TrimUtil.isEqualsIgnoreWhitespaces(this.myText1, this.myText2, this.myText3, trimmed)) continue;
                this.myChanges.add(trimmed);
            }
            List<MergeRange> list = this.myChanges;
            if (list == null) {
                MergeIgnoreSpacesCorrector.$$$reportNull$$$0(5);
            }
            return list;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string2;
            switch (n) {
                default: {
                    string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 5: {
                    string2 = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 5: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "iterable";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "text1";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "text2";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "text3";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "indicator";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/diff/comparison/ByWordRt$MergeIgnoreSpacesCorrector";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/diff/comparison/ByWordRt$MergeIgnoreSpacesCorrector";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "build";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 5: {
                    break;
                }
            }
            String string3 = String.format(string2, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string3);
                    break;
                }
                case 5: {
                    runtimeException = new IllegalStateException(string3);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class IgnoreSpacesCorrector {
        @NotNull
        private final DiffIterable myIterable;
        @NotNull
        private final CharSequence myText1;
        @NotNull
        private final CharSequence myText2;
        @NotNull
        private final CancellationChecker myIndicator;
        @NotNull
        private final List<Range> myChanges;

        IgnoreSpacesCorrector(@NotNull DiffIterable iterable, @NotNull CharSequence text1, @NotNull CharSequence text2, @NotNull CancellationChecker indicator) {
            if (iterable == null) {
                IgnoreSpacesCorrector.$$$reportNull$$$0(0);
            }
            if (text1 == null) {
                IgnoreSpacesCorrector.$$$reportNull$$$0(1);
            }
            if (text2 == null) {
                IgnoreSpacesCorrector.$$$reportNull$$$0(2);
            }
            if (indicator == null) {
                IgnoreSpacesCorrector.$$$reportNull$$$0(3);
            }
            this.myIterable = iterable;
            this.myText1 = text1;
            this.myText2 = text2;
            this.myIndicator = indicator;
            this.myChanges = new ArrayList<Range>();
        }

        @NotNull
        public DiffIterable build() {
            for (Range range : this.myIterable.iterateChanges()) {
                Range expanded = TrimUtil.expandWhitespaces(this.myText1, this.myText2, range);
                Range trimmed = TrimUtil.trim(this.myText1, this.myText2, expanded);
                if (trimmed.isEmpty() || TrimUtil.isEqualsIgnoreWhitespaces(this.myText1, this.myText2, trimmed)) continue;
                this.myChanges.add(trimmed);
            }
            DiffIterable diffIterable = DiffIterableUtil.create(this.myChanges, this.myText1.length(), this.myText2.length());
            if (diffIterable == null) {
                IgnoreSpacesCorrector.$$$reportNull$$$0(4);
            }
            return diffIterable;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string2;
            switch (n) {
                default: {
                    string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 4: {
                    string2 = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 4: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "iterable";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "text1";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "text2";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "indicator";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/diff/comparison/ByWordRt$IgnoreSpacesCorrector";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/diff/comparison/ByWordRt$IgnoreSpacesCorrector";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "build";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 4: {
                    break;
                }
            }
            String string3 = String.format(string2, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string3);
                    break;
                }
                case 4: {
                    runtimeException = new IllegalStateException(string3);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class MergeDefaultCorrector {
        @NotNull
        private final List<? extends MergeRange> myIterable;
        @NotNull
        private final CharSequence myText1;
        @NotNull
        private final CharSequence myText2;
        @NotNull
        private final CharSequence myText3;
        @NotNull
        private final CancellationChecker myIndicator;
        @NotNull
        private final List<MergeRange> myChanges;

        MergeDefaultCorrector(@NotNull List<? extends MergeRange> iterable, @NotNull CharSequence text1, @NotNull CharSequence text2, @NotNull CharSequence text3, @NotNull CancellationChecker indicator) {
            if (iterable == null) {
                MergeDefaultCorrector.$$$reportNull$$$0(0);
            }
            if (text1 == null) {
                MergeDefaultCorrector.$$$reportNull$$$0(1);
            }
            if (text2 == null) {
                MergeDefaultCorrector.$$$reportNull$$$0(2);
            }
            if (text3 == null) {
                MergeDefaultCorrector.$$$reportNull$$$0(3);
            }
            if (indicator == null) {
                MergeDefaultCorrector.$$$reportNull$$$0(4);
            }
            this.myIterable = iterable;
            this.myText1 = text1;
            this.myText2 = text2;
            this.myText3 = text3;
            this.myIndicator = indicator;
            this.myChanges = new ArrayList<MergeRange>();
        }

        @NotNull
        public List<MergeRange> build() {
            for (MergeRange mergeRange : this.myIterable) {
                int endCut = TrimUtil.expandWhitespacesBackward(this.myText1, this.myText2, this.myText3, mergeRange.start1, mergeRange.start2, mergeRange.start3, mergeRange.end1, mergeRange.end2, mergeRange.end3);
                int startCut = TrimUtil.expandWhitespacesForward(this.myText1, this.myText2, this.myText3, mergeRange.start1, mergeRange.start2, mergeRange.start3, mergeRange.end1 - endCut, mergeRange.end2 - endCut, mergeRange.end3 - endCut);
                MergeRange expand = new MergeRange(mergeRange.start1 + startCut, mergeRange.end1 - endCut, mergeRange.start2 + startCut, mergeRange.end2 - endCut, mergeRange.start3 + startCut, mergeRange.end3 - endCut);
                if (expand.isEmpty()) continue;
                this.myChanges.add(expand);
            }
            List<MergeRange> list = this.myChanges;
            if (list == null) {
                MergeDefaultCorrector.$$$reportNull$$$0(5);
            }
            return list;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string2;
            switch (n) {
                default: {
                    string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 5: {
                    string2 = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 5: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "iterable";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "text1";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "text2";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "text3";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "indicator";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/diff/comparison/ByWordRt$MergeDefaultCorrector";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/diff/comparison/ByWordRt$MergeDefaultCorrector";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "build";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 5: {
                    break;
                }
            }
            String string3 = String.format(string2, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string3);
                    break;
                }
                case 5: {
                    runtimeException = new IllegalStateException(string3);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class DefaultCorrector {
        @NotNull
        private final DiffIterable myIterable;
        @NotNull
        private final CharSequence myText1;
        @NotNull
        private final CharSequence myText2;
        @NotNull
        private final CancellationChecker myIndicator;
        @NotNull
        private final List<Range> myChanges;

        DefaultCorrector(@NotNull DiffIterable iterable, @NotNull CharSequence text1, @NotNull CharSequence text2, @NotNull CancellationChecker indicator) {
            if (iterable == null) {
                DefaultCorrector.$$$reportNull$$$0(0);
            }
            if (text1 == null) {
                DefaultCorrector.$$$reportNull$$$0(1);
            }
            if (text2 == null) {
                DefaultCorrector.$$$reportNull$$$0(2);
            }
            if (indicator == null) {
                DefaultCorrector.$$$reportNull$$$0(3);
            }
            this.myIterable = iterable;
            this.myText1 = text1;
            this.myText2 = text2;
            this.myIndicator = indicator;
            this.myChanges = new ArrayList<Range>();
        }

        @NotNull
        public DiffIterable build() {
            for (Range range : this.myIterable.iterateChanges()) {
                int endCut = TrimUtil.expandWhitespacesBackward(this.myText1, this.myText2, range.start1, range.start2, range.end1, range.end2);
                int startCut = TrimUtil.expandWhitespacesForward(this.myText1, this.myText2, range.start1, range.start2, range.end1 - endCut, range.end2 - endCut);
                Range expand = new Range(range.start1 + startCut, range.end1 - endCut, range.start2 + startCut, range.end2 - endCut);
                if (expand.isEmpty()) continue;
                this.myChanges.add(expand);
            }
            DiffIterable diffIterable = DiffIterableUtil.create(this.myChanges, this.myText1.length(), this.myText2.length());
            if (diffIterable == null) {
                DefaultCorrector.$$$reportNull$$$0(4);
            }
            return diffIterable;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string2;
            switch (n) {
                default: {
                    string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 4: {
                    string2 = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 4: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "iterable";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "text1";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "text2";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "indicator";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/diff/comparison/ByWordRt$DefaultCorrector";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/diff/comparison/ByWordRt$DefaultCorrector";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "build";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 4: {
                    break;
                }
            }
            String string3 = String.format(string2, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string3);
                    break;
                }
                case 4: {
                    runtimeException = new IllegalStateException(string3);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class AdjustmentPunctuationMatcher {
        @NotNull
        private final CharSequence myText1;
        @NotNull
        private final CharSequence myText2;
        @NotNull
        private final List<? extends InlineChunk> myWords1;
        @NotNull
        private final List<? extends InlineChunk> myWords2;
        @NotNull
        private final FairDiffIterable myChanges;
        @NotNull
        private final CancellationChecker myIndicator;
        private final int myStartShift1;
        private final int myStartShift2;
        private final int myLen1;
        private final int myLen2;
        private final DiffIterableUtil.ChangeBuilder myBuilder;
        int lastStart1;
        int lastStart2;
        int lastEnd1;
        int lastEnd2;

        AdjustmentPunctuationMatcher(@NotNull CharSequence text1, @NotNull CharSequence text2, @NotNull List<? extends InlineChunk> words1, @NotNull List<? extends InlineChunk> words2, int startShift1, int startShift2, @NotNull FairDiffIterable changes, @NotNull CancellationChecker indicator) {
            if (text1 == null) {
                AdjustmentPunctuationMatcher.$$$reportNull$$$0(0);
            }
            if (text2 == null) {
                AdjustmentPunctuationMatcher.$$$reportNull$$$0(1);
            }
            if (words1 == null) {
                AdjustmentPunctuationMatcher.$$$reportNull$$$0(2);
            }
            if (words2 == null) {
                AdjustmentPunctuationMatcher.$$$reportNull$$$0(3);
            }
            if (changes == null) {
                AdjustmentPunctuationMatcher.$$$reportNull$$$0(4);
            }
            if (indicator == null) {
                AdjustmentPunctuationMatcher.$$$reportNull$$$0(5);
            }
            this.myText1 = text1;
            this.myText2 = text2;
            this.myWords1 = words1;
            this.myWords2 = words2;
            this.myStartShift1 = startShift1;
            this.myStartShift2 = startShift2;
            this.myChanges = changes;
            this.myIndicator = indicator;
            this.myLen1 = text1.length();
            this.myLen2 = text2.length();
            this.myBuilder = new DiffIterableUtil.ChangeBuilder(this.myLen1, this.myLen2);
        }

        @NotNull
        public FairDiffIterable build() {
            this.execute();
            FairDiffIterable fairDiffIterable = DiffIterableUtil.fair(this.myBuilder.finish());
            if (fairDiffIterable == null) {
                AdjustmentPunctuationMatcher.$$$reportNull$$$0(6);
            }
            return fairDiffIterable;
        }

        private void execute() {
            this.clearLastRange();
            this.matchForward(-1, -1);
            for (Range ch : this.myChanges.iterateUnchanged()) {
                int count = ch.end1 - ch.start1;
                for (int i = 0; i < count; ++i) {
                    int index1 = ch.start1 + i;
                    int index2 = ch.start2 + i;
                    int start1 = this.getStartOffset1(index1);
                    int start2 = this.getStartOffset2(index2);
                    int end1 = this.getEndOffset1(index1);
                    int end2 = this.getEndOffset2(index2);
                    this.matchBackward(index1, index2);
                    this.myBuilder.markEqual(start1, start2, end1, end2);
                    this.matchForward(index1, index2);
                }
            }
            this.matchBackward(this.myWords1.size(), this.myWords2.size());
        }

        private void clearLastRange() {
            this.lastStart1 = -1;
            this.lastStart2 = -1;
            this.lastEnd1 = -1;
            this.lastEnd2 = -1;
        }

        private void matchBackward(int index1, int index2) {
            int start1 = index1 == 0 ? 0 : this.getEndOffset1(index1 - 1);
            int start2 = index2 == 0 ? 0 : this.getEndOffset2(index2 - 1);
            int end1 = index1 == this.myWords1.size() ? this.myLen1 : this.getStartOffset1(index1);
            int end2 = index2 == this.myWords2.size() ? this.myLen2 : this.getStartOffset2(index2);
            this.matchBackward(start1, start2, end1, end2);
            this.clearLastRange();
        }

        private void matchForward(int index1, int index2) {
            int start1 = index1 == -1 ? 0 : this.getEndOffset1(index1);
            int start2 = index2 == -1 ? 0 : this.getEndOffset2(index2);
            int end1 = index1 + 1 == this.myWords1.size() ? this.myLen1 : this.getStartOffset1(index1 + 1);
            int end2 = index2 + 1 == this.myWords2.size() ? this.myLen2 : this.getStartOffset2(index2 + 1);
            this.matchForward(start1, start2, end1, end2);
        }

        private void matchForward(int start1, int start2, int end1, int end2) {
            assert (this.lastStart1 == -1 && this.lastStart2 == -1 && this.lastEnd1 == -1 && this.lastEnd2 == -1);
            this.lastStart1 = start1;
            this.lastStart2 = start2;
            this.lastEnd1 = end1;
            this.lastEnd2 = end2;
        }

        private void matchBackward(int start1, int start2, int end1, int end2) {
            assert (this.lastStart1 != -1 && this.lastStart2 != -1 && this.lastEnd1 != -1 && this.lastEnd2 != -1);
            if (this.lastStart1 == start1 && this.lastStart2 == start2) {
                assert (this.lastEnd1 == end1 && this.lastEnd2 == end2);
                this.matchRange(start1, start2, end1, end2);
                return;
            }
            if (this.lastStart1 < start1 && this.lastStart2 < start2) {
                assert (this.lastEnd1 <= start1 && this.lastEnd2 <= start2);
                this.matchRange(this.lastStart1, this.lastStart2, this.lastEnd1, this.lastEnd2);
                this.matchRange(start1, start2, end1, end2);
                return;
            }
            this.matchComplexRange(this.lastStart1, this.lastStart2, this.lastEnd1, this.lastEnd2, start1, start2, end1, end2);
        }

        private void matchRange(int start1, int start2, int end1, int end2) {
            if (start1 == end1 && start2 == end2) {
                return;
            }
            CharSequence sequence1 = this.myText1.subSequence(start1, end1);
            CharSequence sequence2 = this.myText2.subSequence(start2, end2);
            FairDiffIterable changes = ByCharRt.comparePunctuation(sequence1, sequence2, this.myIndicator);
            for (Range ch : changes.iterateUnchanged()) {
                this.myBuilder.markEqual(start1 + ch.start1, start2 + ch.start2, start1 + ch.end1, start2 + ch.end2);
            }
        }

        private void matchComplexRange(int start11, int start12, int end11, int end12, int start21, int start22, int end21, int end22) {
            if (start11 == start21 && end11 == end21) {
                this.matchComplexRangeLeft(start11, end11, start12, end12, start22, end22);
            } else if (start12 == start22 && end12 == end22) {
                this.matchComplexRangeRight(start12, end12, start11, end11, start21, end21);
            } else {
                throw new IllegalStateException();
            }
        }

        private void matchComplexRangeLeft(int start1, int end1, int start12, int end12, int start22, int end22) {
            CharSequence sequence1 = this.myText1.subSequence(start1, end1);
            CharSequence sequence21 = this.myText2.subSequence(start12, end12);
            CharSequence sequence22 = this.myText2.subSequence(start22, end22);
            Couple changes = ByWordRt.comparePunctuation2Side(sequence1, sequence21, sequence22, this.myIndicator);
            for (Range ch : ((FairDiffIterable)changes.first).iterateUnchanged()) {
                this.myBuilder.markEqual(start1 + ch.start1, start12 + ch.start2, start1 + ch.end1, start12 + ch.end2);
            }
            for (Range ch : ((FairDiffIterable)changes.second).iterateUnchanged()) {
                this.myBuilder.markEqual(start1 + ch.start1, start22 + ch.start2, start1 + ch.end1, start22 + ch.end2);
            }
        }

        private void matchComplexRangeRight(int start2, int end2, int start11, int end11, int start21, int end21) {
            CharSequence sequence11 = this.myText1.subSequence(start11, end11);
            CharSequence sequence12 = this.myText1.subSequence(start21, end21);
            CharSequence sequence2 = this.myText2.subSequence(start2, end2);
            Couple changes = ByWordRt.comparePunctuation2Side(sequence2, sequence11, sequence12, this.myIndicator);
            for (Range ch : ((FairDiffIterable)changes.first).iterateUnchanged()) {
                this.myBuilder.markEqual(start11 + ch.start2, start2 + ch.start1, start11 + ch.end2, start2 + ch.end1);
            }
            for (Range ch : ((FairDiffIterable)changes.second).iterateUnchanged()) {
                this.myBuilder.markEqual(start21 + ch.start2, start2 + ch.start1, start21 + ch.end2, start2 + ch.end1);
            }
        }

        private int getStartOffset1(int index) {
            return this.myWords1.get(index).getOffset1() - this.myStartShift1;
        }

        private int getStartOffset2(int index) {
            return this.myWords2.get(index).getOffset1() - this.myStartShift2;
        }

        private int getEndOffset1(int index) {
            return this.myWords1.get(index).getOffset2() - this.myStartShift1;
        }

        private int getEndOffset2(int index) {
            return this.myWords2.get(index).getOffset2() - this.myStartShift2;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string2;
            switch (n) {
                default: {
                    string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 6: {
                    string2 = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 6: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "text1";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "text2";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "words1";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "words2";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "changes";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "indicator";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/diff/comparison/ByWordRt$AdjustmentPunctuationMatcher";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/diff/comparison/ByWordRt$AdjustmentPunctuationMatcher";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "build";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 6: {
                    break;
                }
            }
            String string3 = String.format(string2, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string3);
                    break;
                }
                case 6: {
                    runtimeException = new IllegalStateException(string3);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

