/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic.local;

import com.intellij.internal.statistic.local.ActionGlobalUsageInfo;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.text.CharFilter;
import com.intellij.openapi.util.text.StringUtil;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service(value={Service.Level.APP})
public final class ActionsGlobalSummaryManager {
    private static final Logger LOG = Logger.getInstance(ActionsGlobalSummaryManager.class);
    @NotNull
    private static final CharFilter QUOTE_FILTER = ch -> ch != '\"';
    private static final int DEFAULT_STATISTICS_VERSION = 1;
    private static final int UPDATED_STATISTICS_VERSION = 2;
    private final Map<String, ActionGlobalUsageInfo> myStatisticsMap = this.loadStatistics("/statistics/actionsUsagesV1.csv");
    private final Map<String, ActionGlobalUsageInfo> myUpdatedStatisticsMap = this.loadStatistics("/statistics/actionsUsagesV2.csv");
    private final ActionsGlobalTotalSummary mySummary = ActionsGlobalSummaryManager.calculateTotalSummary(this.myStatisticsMap);
    private final ActionsGlobalTotalSummary myUpdatedSummary = ActionsGlobalSummaryManager.calculateTotalSummary(this.myUpdatedStatisticsMap);
    private static final String DEFAULT_SEPARATOR = ",";

    public static int getDefaultStatisticsVersion() {
        return 1;
    }

    public static int getUpdatedStatisticsVersion() {
        return 2;
    }

    @Nullable
    public ActionGlobalUsageInfo getActionStatistics(String actionID) {
        return this.myStatisticsMap.get(actionID);
    }

    @Nullable
    public ActionGlobalUsageInfo getUpdatedActionStatistics(String actionID) {
        return this.myUpdatedStatisticsMap.get(actionID);
    }

    @NotNull
    public ActionsGlobalTotalSummary getTotalSummary() {
        ActionsGlobalTotalSummary actionsGlobalTotalSummary = this.mySummary;
        if (actionsGlobalTotalSummary == null) {
            ActionsGlobalSummaryManager.$$$reportNull$$$0(0);
        }
        return actionsGlobalTotalSummary;
    }

    @NotNull
    public ActionsGlobalTotalSummary getUpdatedTotalSummary() {
        ActionsGlobalTotalSummary actionsGlobalTotalSummary = this.myUpdatedSummary;
        if (actionsGlobalTotalSummary == null) {
            ActionsGlobalSummaryManager.$$$reportNull$$$0(1);
        }
        return actionsGlobalTotalSummary;
    }

    private static ActionsGlobalTotalSummary calculateTotalSummary(Map<String, ActionGlobalUsageInfo> statistics) {
        long maxCount = 0L;
        long minCount = Long.MAX_VALUE;
        for (ActionGlobalUsageInfo value : statistics.values()) {
            long count = value.getUsagesCount();
            maxCount = Math.max(count, maxCount);
            minCount = Math.min(count, minCount);
        }
        return new ActionsGlobalTotalSummary(maxCount, minCount);
    }

    private Map<String, ActionGlobalUsageInfo> loadStatistics(String filename) {
        HashMap<String, ActionGlobalUsageInfo> res = new HashMap<String, ActionGlobalUsageInfo>();
        try (InputStream stream = this.getClass().getResourceAsStream(filename);
             BufferedReader reader = new BufferedReader(new InputStreamReader(stream, StandardCharsets.UTF_8));){
            String line = reader.readLine();
            while (line != null) {
                String[] items = line.split(DEFAULT_SEPARATOR);
                String id = StringUtil.trim((String)items[0], (CharFilter)QUOTE_FILTER);
                long users = Long.parseLong(StringUtil.trim((String)items[3], (CharFilter)QUOTE_FILTER));
                long allUsers = Long.parseLong(StringUtil.trim((String)items[5], (CharFilter)QUOTE_FILTER));
                long usages = Long.parseLong(StringUtil.trim((String)items[4], (CharFilter)QUOTE_FILTER));
                res.put(id, new ActionGlobalUsageInfo(users, allUsers, usages));
                line = reader.readLine();
            }
        }
        catch (IOException e) {
            LOG.error("Cannot parse statistics file", (Throwable)e);
        }
        return res;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/intellij/internal/statistic/local/ActionsGlobalSummaryManager";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getTotalSummary";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getUpdatedTotalSummary";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    public static class ActionsGlobalTotalSummary {
        private final long maxUsageCount;
        private final long minUsageCount;

        public ActionsGlobalTotalSummary(long maxUsageCount, long minUsageCount) {
            this.maxUsageCount = maxUsageCount;
            this.minUsageCount = minUsageCount;
        }

        public long getMaxUsageCount() {
            return this.maxUsageCount;
        }

        public long getMinUsageCount() {
            return this.minUsageCount;
        }
    }
}

