/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.sdk.add;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.SystemInfoRt;
import com.intellij.ui.JBCardLayout;
import com.intellij.ui.components.panels.NonOpaquePanel;
import com.intellij.ui.messages.ProcessExecutionErrorDialogKt;
import com.intellij.util.ui.GridBag;
import com.intellij.util.ui.JBInsets;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import com.jetbrains.python.packaging.PyExecutionException;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.border.Border;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=2, d1={"\u00008\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u001a\u0016\u0010\u0000\u001a\u00020\u00012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u0002\u001a$\u0010\u0005\u001a\u00020\u00012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u0000\u001a\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u00012\u0006\u0010\u000b\u001a\u00020\fH\u0000\u001a\u0018\u0010\r\u001a\u00020\t2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0010\u001a\u00020\u0011\u001a \u0010\u0012\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u00012\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0013\u001a\u00020\u0014H\u0000\u00a8\u0006\u0015"}, d2={"createButtonsPanel", "Ljavax/swing/JPanel;", "buttons", "", "Ljavax/swing/JButton;", "doCreateSouthPanel", "leftButtons", "rightButtons", "show", "", "panel", "stepContent", "Ljava/awt/Component;", "showProcessExecutionErrorDialog", "project", "Lcom/intellij/openapi/project/Project;", "e", "Lcom/jetbrains/python/packaging/PyExecutionException;", "swipe", "swipeDirection", "Lcom/intellij/ui/JBCardLayout$SwipeDirection;", "intellij.python.community.impl"})
public final class WizardUIUtilKt {
    @NotNull
    public static final JPanel doCreateSouthPanel(@NotNull List<? extends JButton> leftButtons, @NotNull List<? extends JButton> rightButtons) {
        Insets insets;
        Intrinsics.checkNotNullParameter(leftButtons, (String)"leftButtons");
        Intrinsics.checkNotNullParameter(rightButtons, (String)"rightButtons");
        JPanel panel2 = new JPanel(new BorderLayout());
        if (SystemInfoRt.isMac) {
            JBInsets jBInsets = UIUtil.isUnderIntelliJLaF() ? JBUI.insets((int)0, (int)8) : JBInsets.emptyInsets();
            Intrinsics.checkNotNullExpressionValue((Object)jBInsets, (String)"if (UIUtil.isUnderIntell\u2026se JBInsets.emptyInsets()");
            insets = (Insets)jBInsets;
        } else if (UIUtil.isUnderWin10LookAndFeel()) {
            JBInsets jBInsets = JBInsets.emptyInsets();
            Intrinsics.checkNotNullExpressionValue((Object)jBInsets, (String)"JBInsets.emptyInsets()");
            insets = (Insets)jBInsets;
        } else {
            insets = new Insets(8, 0, 0, 0);
        }
        Insets insets2 = insets;
        GridBag bag = new GridBag().setDefaultInsets(insets2);
        NonOpaquePanel lrButtonsPanel = new NonOpaquePanel((LayoutManager)new GridBagLayout());
        JPanel leftButtonsPanel = WizardUIUtilKt.createButtonsPanel(leftButtons);
        leftButtonsPanel.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 20));
        lrButtonsPanel.add((Component)leftButtonsPanel, (Object)bag.next());
        lrButtonsPanel.add(Box.createHorizontalGlue(), (Object)bag.next().weightx(1.0).fillCellHorizontally());
        JPanel buttonsPanel = WizardUIUtilKt.createButtonsPanel(rightButtons);
        lrButtonsPanel.add((Component)buttonsPanel, (Object)bag.next());
        panel2.add((Component)lrButtonsPanel, "Center");
        panel2.setBorder((Border)JBUI.Borders.emptyTop((int)8));
        return panel2;
    }

    private static final JPanel createButtonsPanel(List<? extends JButton> buttons) {
        int hgap = SystemInfoRt.isMac ? (UIUtil.isUnderIntelliJLaF() ? 8 : 0) : 5;
        NonOpaquePanel buttonsPanel = new NonOpaquePanel((LayoutManager)new GridLayout(1, buttons.size(), hgap, 0));
        Iterable $this$forEach$iv = buttons;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            JButton it = (JButton)element$iv;
            boolean bl = false;
            buttonsPanel.add((Component)it);
        }
        return (JPanel)buttonsPanel;
    }

    public static final void swipe(@NotNull JPanel panel2, @NotNull Component stepContent, @NotNull JBCardLayout.SwipeDirection swipeDirection) {
        Intrinsics.checkNotNullParameter((Object)panel2, (String)"panel");
        Intrinsics.checkNotNullParameter((Object)stepContent, (String)"stepContent");
        Intrinsics.checkNotNullParameter((Object)swipeDirection, (String)"swipeDirection");
        String stepContentName = String.valueOf(stepContent.hashCode());
        panel2.add(stepContentName, stepContent);
        LayoutManager layoutManager = panel2.getLayout();
        if (layoutManager == null) {
            throw new NullPointerException("null cannot be cast to non-null type com.intellij.ui.JBCardLayout");
        }
        ((JBCardLayout)layoutManager).swipe((Container)panel2, stepContentName, swipeDirection);
    }

    public static final void show(@NotNull JPanel panel2, @NotNull Component stepContent) {
        Intrinsics.checkNotNullParameter((Object)panel2, (String)"panel");
        Intrinsics.checkNotNullParameter((Object)stepContent, (String)"stepContent");
        String stepContentName = String.valueOf(stepContent.hashCode());
        panel2.add(stepContentName, stepContent);
        LayoutManager layoutManager = panel2.getLayout();
        if (layoutManager == null) {
            throw new NullPointerException("null cannot be cast to non-null type java.awt.CardLayout");
        }
        ((CardLayout)layoutManager).show(panel2, stepContentName);
    }

    public static final void showProcessExecutionErrorDialog(@Nullable Project project, @NotNull PyExecutionException e) {
        Intrinsics.checkNotNullParameter((Object)((Object)e), (String)"e");
        String string = e.getLocalizedMessage();
        String string2 = string;
        if (string2 == null) {
            string2 = "";
        }
        String string3 = e.getCommand();
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"e.command");
        ProcessExecutionErrorDialogKt.showProcessExecutionErrorDialog((Project)project, (String)string2, (String)string3, (String)e.getStdout(), (String)e.getStderr(), (int)e.getExitCode());
    }
}

