/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.sdk;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.options.UnnamedConfigurable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.SdkAdditionalData;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.vfs.VirtualFile;
import com.jetbrains.python.run.PyVirtualEnvReaderKt;
import com.jetbrains.python.sdk.PySdkUtil;
import com.jetbrains.python.sdk.PyTerminalBundle;
import com.jetbrains.python.sdk.PyVirtualEnvTerminalSettings;
import com.jetbrains.python.sdk.PythonSdkAdditionalData;
import com.jetbrains.python.sdk.PythonSdkUtil;
import com.jetbrains.python.sdk.flavors.CondaEnvSdkFlavor;
import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Map;
import javax.swing.JCheckBox;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.io.path.PathsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.terminal.LocalTerminalCustomizer;
import org.jetbrains.plugins.terminal.TerminalOptionsProvider;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002JK\u0010\u0003\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\u00052\u000e\u0010\t\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00050\u00042\u0012\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\u000bH\u0016\u00a2\u0006\u0002\u0010\fJ\u0012\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J'\u0010\u000f\u001a\f\u0012\u0006\b\u0001\u0012\u00020\u0005\u0018\u00010\u00042\u0006\u0010\u0010\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u0012H\u0002\u00a2\u0006\u0002\u0010\u0013J\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0005H\u0002\u00a8\u0006\u0019"}, d2={"Lcom/jetbrains/python/sdk/PyVirtualEnvTerminalCustomizer;", "Lorg/jetbrains/plugins/terminal/LocalTerminalCustomizer;", "()V", "customizeCommandAndEnvironment", "", "", "project", "Lcom/intellij/openapi/project/Project;", "workingDirectory", "command", "envs", "", "(Lcom/intellij/openapi/project/Project;Ljava/lang/String;[Ljava/lang/String;Ljava/util/Map;)[Ljava/lang/String;", "findSdk", "Lcom/intellij/openapi/projectRoots/Sdk;", "generateCommandForPowerShell", "sdk", "sdkHomePath", "Lcom/intellij/openapi/vfs/VirtualFile;", "(Lcom/intellij/openapi/projectRoots/Sdk;Lcom/intellij/openapi/vfs/VirtualFile;)[Ljava/lang/String;", "getConfigurable", "Lcom/intellij/openapi/options/UnnamedConfigurable;", "isShellIntegrationAvailable", "", "shellPath", "intellij.python.terminal"})
public final class PyVirtualEnvTerminalCustomizer
extends LocalTerminalCustomizer {
    private final String[] generateCommandForPowerShell(Sdk sdk, VirtualFile sdkHomePath) {
        String[] stringArray;
        SdkAdditionalData sdkAdditionalData = sdk.getSdkAdditionalData();
        if (!(sdkAdditionalData instanceof PythonSdkAdditionalData)) {
            sdkAdditionalData = null;
        }
        PythonSdkAdditionalData pythonSdkAdditionalData = (PythonSdkAdditionalData)sdkAdditionalData;
        if ((pythonSdkAdditionalData != null ? pythonSdkAdditionalData.getFlavor() : null) instanceof CondaEnvSdkFlavor) {
            String string = PyTerminalBundle.message("powershell.conda.not.activated", new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"PyTerminalBundle.message\u2026ell.conda.not.activated\")");
            String errorMessage = StringsKt.replace$default((String)string, (char)'\'', (char)'\"', (boolean)false, (int)4, null);
            VirtualFile virtualFile = sdkHomePath.getParent();
            Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"sdkHomePath.parent");
            String condaActivateCommand = "try { conda activate " + virtualFile.getPath() + " } catch { Write-Host('" + errorMessage + "') }";
            return new String[]{"powershell.exe", "-NoExit", "-Command", condaActivateCommand};
        }
        VirtualFile virtualFile = sdkHomePath.getParent().findChild("activate.ps1");
        if (virtualFile == null) {
            return null;
        }
        Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"sdkHomePath.parent.findC\u2026vate.ps1\") ?: return null");
        VirtualFile virtualEnvProfile = virtualFile;
        if (virtualEnvProfile.exists()) {
            String[] stringArray2 = new String[4];
            stringArray2[0] = "powershell.exe";
            stringArray2[1] = "-NoExit";
            stringArray2[2] = "-File";
            stringArray = stringArray2;
            String string = virtualEnvProfile.getPath();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"virtualEnvProfile.path");
            stringArray2[3] = string;
        } else {
            stringArray = null;
        }
        return stringArray;
    }

    @NotNull
    public String[] customizeCommandAndEnvironment(@NotNull Project project, @Nullable String workingDirectory, @NotNull String[] command, @NotNull Map<String, String> envs) {
        String[] stringArray;
        VirtualFile sdkHomePath;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)command, (String)"command");
        Intrinsics.checkNotNullParameter(envs, (String)"envs");
        Sdk sdk = PySdkUtil.findSdkForDirectory(project, workingDirectory);
        if (sdk != null && (PythonSdkUtil.isVirtualEnv(sdk) || PythonSdkUtil.isConda(sdk)) && PyVirtualEnvTerminalSettings.Companion.getInstance(project).getVirtualEnvActivate() && (sdkHomePath = sdk.getHomeDirectory()) != null && !((stringArray = command).length == 0)) {
            String shellPath = command[0];
            Path path2 = Paths.get(shellPath, new String[0]);
            Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"get(path)");
            if (Intrinsics.areEqual((Object)PathsKt.getName((Path)path2), (Object)"powershell.exe")) {
                String[] stringArray2 = this.generateCommandForPowerShell(sdk, sdkHomePath);
                if (stringArray2 == null) {
                    stringArray2 = command;
                }
                return stringArray2;
            }
            if (this.isShellIntegrationAvailable(shellPath)) {
                Pair<String, String> pair = PyVirtualEnvReaderKt.findActivateScript(sdkHomePath.getPath(), shellPath);
                if (pair != null) {
                    Pair<String, String> pair2;
                    Pair<String, String> activate = pair2 = pair;
                    boolean bl = false;
                    envs.put("JEDITERM_SOURCE", (String)activate.getFirst());
                    String string = (String)activate.getSecond();
                    if (string == null) {
                        string = "";
                    }
                    envs.put("JEDITERM_SOURCE_ARGS", string);
                }
            } else {
                Map<String, String> map2 = PySdkUtil.activateVirtualEnv(sdk);
                Intrinsics.checkNotNullExpressionValue(map2, (String)"PySdkUtil.activateVirtualEnv(sdk)");
                envs.putAll(map2);
            }
        }
        return command;
    }

    private final boolean isShellIntegrationAvailable(String shellPath) {
        if (TerminalOptionsProvider.Companion.getInstance().getShellIntegration()) {
            String shellName = new File(shellPath).getName();
            return Intrinsics.areEqual((Object)shellName, (Object)"bash") || SystemInfo.isMac && Intrinsics.areEqual((Object)shellName, (Object)"sh") || Intrinsics.areEqual((Object)shellName, (Object)"zsh") || Intrinsics.areEqual((Object)shellName, (Object)"fish");
        }
        return false;
    }

    private final Sdk findSdk(Project project) {
        ModuleManager moduleManager = ModuleManager.getInstance((Project)project);
        Intrinsics.checkNotNullExpressionValue((Object)moduleManager, (String)"ModuleManager.getInstance(project)");
        for (Module m : moduleManager.getModules()) {
            Sdk sdk = PythonSdkUtil.findPythonSdk(m);
            if (sdk == null || PythonSdkUtil.isRemote(sdk)) continue;
            return sdk;
        }
        return null;
    }

    @NotNull
    public UnnamedConfigurable getConfigurable(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        return new UnnamedConfigurable(project){
            @NotNull
            private final PyVirtualEnvTerminalSettings settings;
            @NotNull
            private JCheckBox myCheckbox;
            final /* synthetic */ Project $project;

            @NotNull
            public final PyVirtualEnvTerminalSettings getSettings() {
                return this.settings;
            }

            @NotNull
            public final JCheckBox getMyCheckbox() {
                return this.myCheckbox;
            }

            public final void setMyCheckbox(@NotNull JCheckBox jCheckBox) {
                Intrinsics.checkNotNullParameter((Object)jCheckBox, (String)"<set-?>");
                this.myCheckbox = jCheckBox;
            }

            @NotNull
            public JCheckBox createComponent() {
                return this.myCheckbox;
            }

            public boolean isModified() {
                return this.myCheckbox.isSelected() != this.settings.getVirtualEnvActivate();
            }

            public void apply() {
                this.settings.setVirtualEnvActivate(this.myCheckbox.isSelected());
            }

            public void reset() {
                this.myCheckbox.setSelected(this.settings.getVirtualEnvActivate());
            }
            {
                this.$project = $captured_local_variable$0;
                this.settings = PyVirtualEnvTerminalSettings.Companion.getInstance($captured_local_variable$0);
                this.myCheckbox = new JCheckBox(PyTerminalBundle.message("activate.virtualenv.checkbox.text", new Object[0]));
            }
        };
    }
}

