/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.packaging;

import com.google.common.collect.Lists;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.RunCanceledByUserException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.CapturingProcessHandler;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.process.ProcessNotCreatedException;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.execution.util.ExecUtil;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.jetbrains.python.PySdkBundle;
import com.jetbrains.python.packaging.IndicatedProcessOutputListener;
import com.jetbrains.python.packaging.PyExecutionException;
import com.jetbrains.python.packaging.PyPackage;
import com.jetbrains.python.packaging.PyPackageManagerImplBase;
import com.jetbrains.python.packaging.PyPackageManagers;
import com.jetbrains.python.packaging.PyRequirement;
import com.jetbrains.python.psi.LanguageLevel;
import com.jetbrains.python.sdk.PyLazySdk;
import com.jetbrains.python.sdk.PySdkExtKt;
import com.jetbrains.python.sdk.PySdkUtil;
import com.jetbrains.python.sdk.PythonEnvUtil;
import com.jetbrains.python.sdk.PythonSdkUtil;
import com.jetbrains.python.sdk.flavors.PythonSdkFlavor;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PyPackageManagerImpl
extends PyPackageManagerImplBase {
    private static final String VIRTUALENV_ZIPAPP_NAME = "virtualenv.pyz";
    private static final Logger LOG = Logger.getInstance(PyPackageManagerImpl.class);

    @Override
    protected final void installUsingPipWheel(String ... pipArgs) throws ExecutionException {
        if (pipArgs == null) {
            PyPackageManagerImpl.$$$reportNull$$$0(0);
        }
        String pipWheel = this.getHelperPath("pip-20.3.4-py2.py3-none-any.whl");
        ArrayList args2 = Lists.newArrayList((Object[])new String[]{"install"});
        args2.addAll(Arrays.asList(pipArgs));
        this.getPythonProcessResult(pipWheel + this.mySeparator + "pip", args2, true, true, null);
    }

    @NotNull
    protected String toSystemDependentName(@NotNull String dirName) {
        if (dirName == null) {
            PyPackageManagerImpl.$$$reportNull$$$0(1);
        }
        String string = FileUtil.toSystemDependentName((String)dirName);
        if (string == null) {
            PyPackageManagerImpl.$$$reportNull$$$0(2);
        }
        return string;
    }

    protected PyPackageManagerImpl(@NotNull Sdk sdk) {
        if (sdk == null) {
            PyPackageManagerImpl.$$$reportNull$$$0(3);
        }
        super(sdk);
        this.subscribeToLocalChanges();
        PyPackageManagers parentDisposable = sdk instanceof Disposable ? (Disposable)sdk : PyPackageManagers.getInstance();
        Disposer.register((Disposable)parentDisposable, (Disposable)this);
    }

    @Override
    public void install(@NotNull String requirementString) throws ExecutionException {
        if (requirementString == null) {
            PyPackageManagerImpl.$$$reportNull$$$0(4);
        }
        this.install(Collections.singletonList(this.parseRequirement(requirementString)), Collections.emptyList());
    }

    @Override
    public void install(@Nullable List<PyRequirement> requirements2, @NotNull List<String> extraArgs) throws ExecutionException {
        if (extraArgs == null) {
            PyPackageManagerImpl.$$$reportNull$$$0(5);
        }
        this.install(requirements2, extraArgs, null);
    }

    public void install(@Nullable List<PyRequirement> requirements2, @NotNull List<String> extraArgs, @Nullable String workingDir) throws ExecutionException {
        if (extraArgs == null) {
            PyPackageManagerImpl.$$$reportNull$$$0(6);
        }
        if (requirements2 == null) {
            return;
        }
        if (!this.hasManagement()) {
            this.installManagement();
        }
        ArrayList<String> args2 = new ArrayList<String>();
        args2.add("install");
        boolean useUserSite = extraArgs.contains("--user");
        String proxyString = PyPackageManagerImpl.getProxyString();
        if (proxyString != null) {
            args2.add("--proxy");
            args2.add(proxyString);
        }
        args2.addAll(extraArgs);
        for (PyRequirement req : requirements2) {
            args2.addAll(req.getInstallOptions());
        }
        try {
            this.getHelperResult(args2, !useUserSite, true, workingDir);
        }
        catch (PyExecutionException e) {
            ArrayList<String> simplifiedArgs = new ArrayList<String>();
            simplifiedArgs.add("install");
            if (proxyString != null) {
                simplifiedArgs.add("--proxy");
                simplifiedArgs.add(proxyString);
            }
            simplifiedArgs.addAll(extraArgs);
            for (PyRequirement req : requirements2) {
                simplifiedArgs.addAll(req.getInstallOptions());
            }
            throw new PyExecutionException(e.getMessage(), "pip", PyPackageManagerImpl.makeSafeToDisplayCommand(simplifiedArgs), e.getStdout(), e.getStderr(), e.getExitCode(), e.getFixes());
        }
        finally {
            LOG.debug("Packages cache is about to be refreshed because these requirements were installed: " + requirements2);
            this.refreshPackagesSynchronously();
        }
    }

    @Override
    public void uninstall(@NotNull List<PyPackage> packages) throws ExecutionException {
        if (packages == null) {
            PyPackageManagerImpl.$$$reportNull$$$0(7);
        }
        ArrayList<String> args2 = new ArrayList<String>();
        try {
            args2.add("uninstall");
            boolean canModify = true;
            for (PyPackage pkg : packages) {
                String location;
                if (canModify && (location = pkg.getLocation()) != null) {
                    canModify = Files.isWritable(Paths.get(location, new String[0]));
                }
                args2.add(pkg.getName());
            }
            this.getHelperResult(args2, !canModify, true);
        }
        catch (PyExecutionException e) {
            throw new PyExecutionException(e.getMessage(), "pip", args2, e.getStdout(), e.getStderr(), e.getExitCode(), e.getFixes());
        }
        finally {
            LOG.debug("Packages cache is about to be refreshed because these packages were uninstalled: " + packages);
            this.refreshPackagesSynchronously();
        }
    }

    @Override
    @Nullable
    public List<PyPackage> getPackages() {
        List packages = this.myPackagesCache;
        return packages != null ? Collections.unmodifiableList(packages) : null;
    }

    @Override
    @NotNull
    protected List<PyPackage> collectPackages() throws ExecutionException {
        List<PyPackage> list;
        if (this.mySdk instanceof PyLazySdk) {
            List<PyPackage> list2 = List.of();
            if (list2 == null) {
                PyPackageManagerImpl.$$$reportNull$$$0(8);
            }
            return list2;
        }
        try {
            LOG.debug("Collecting installed packages for the SDK " + this.mySdk.getName(), new Throwable());
            String output = this.getHelperResult(List.of("list"), false, false);
            list = this.parsePackagingToolOutput(output);
        }
        catch (ProcessNotCreatedException ex) {
            if (ApplicationManager.getApplication().isUnitTestMode()) {
                LOG.info("Not-env unit test mode, will return mock packages");
                List<PyPackage> list3 = List.of(new PyPackage("pip", "20.3.4"), new PyPackage("setuptools", "44.1.1"));
                if (list3 == null) {
                    PyPackageManagerImpl.$$$reportNull$$$0(10);
                }
                return list3;
            }
            throw ex;
        }
        if (list == null) {
            PyPackageManagerImpl.$$$reportNull$$$0(9);
        }
        return list;
    }

    @Override
    @NotNull
    public String createVirtualEnv(@NotNull String destinationDir, boolean useGlobalSite) throws ExecutionException {
        if (destinationDir == null) {
            PyPackageManagerImpl.$$$reportNull$$$0(11);
        }
        ArrayList<String> args2 = new ArrayList<String>();
        Sdk sdk = this.getSdk();
        LanguageLevel languageLevel = PyPackageManagerImpl.getOrRequestLanguageLevelForSdk(sdk);
        if (languageLevel.isOlderThan(LanguageLevel.PYTHON27)) {
            throw new ExecutionException(PySdkBundle.message("python.sdk.packaging.creating.virtual.environment.for.python.not.supported", new Object[]{languageLevel, LanguageLevel.PYTHON27}));
        }
        if (useGlobalSite) {
            args2.add("--system-site-packages");
        }
        args2.add(destinationDir);
        try {
            this.getPythonProcessResult(Objects.requireNonNull(this.getHelperPath(VIRTUALENV_ZIPAPP_NAME)), args2, false, true, null, List.of("-S"));
        }
        catch (ExecutionException e) {
            throw new ExecutionException(PySdkBundle.message("python.creating.venv.failed.sentence", new Object[0]), (Throwable)e);
        }
        String binary = PythonSdkUtil.getPythonExecutable(destinationDir);
        String binaryFallback = destinationDir + this.mySeparator + "bin" + this.mySeparator + "python";
        Object object = binary != null ? binary : binaryFallback;
        if (object == null) {
            PyPackageManagerImpl.$$$reportNull$$$0(12);
        }
        return object;
    }

    @NotNull
    private String getHelperResult(@NotNull List<String> args2, boolean askForSudo, boolean showProgress) throws ExecutionException {
        if (args2 == null) {
            PyPackageManagerImpl.$$$reportNull$$$0(13);
        }
        return this.getHelperResult(args2, askForSudo, showProgress, null);
    }

    @NotNull
    private String getHelperResult(@NotNull List<String> args2, boolean askForSudo, boolean showProgress, @Nullable String parentDir) throws ExecutionException {
        String helperPath;
        if (args2 == null) {
            PyPackageManagerImpl.$$$reportNull$$$0(14);
        }
        if ((helperPath = this.getHelperPath("packaging_tool.py")) == null) {
            throw new ExecutionException(PySdkBundle.message("python.sdk.packaging.cannot.find.external.tool", "packaging_tool.py"));
        }
        return this.getPythonProcessResult(helperPath, args2, askForSudo, showProgress, parentDir);
    }

    @NotNull
    private String getPythonProcessResult(@NotNull String path2, @NotNull List<String> args2, boolean askForSudo, boolean showProgress, @Nullable String workingDir) throws ExecutionException {
        if (path2 == null) {
            PyPackageManagerImpl.$$$reportNull$$$0(15);
        }
        if (args2 == null) {
            PyPackageManagerImpl.$$$reportNull$$$0(16);
        }
        return this.getPythonProcessResult(path2, args2, askForSudo, showProgress, workingDir, null);
    }

    @NotNull
    private String getPythonProcessResult(@NotNull String path2, @NotNull List<String> args2, boolean askForSudo, boolean showProgress, @Nullable String workingDir, @Nullable List<String> pyArgs) throws ExecutionException {
        if (path2 == null) {
            PyPackageManagerImpl.$$$reportNull$$$0(17);
        }
        if (args2 == null) {
            PyPackageManagerImpl.$$$reportNull$$$0(18);
        }
        ProcessOutput output = this.getPythonProcessOutput(path2, args2, askForSudo, showProgress, workingDir, pyArgs);
        int exitCode = output.getExitCode();
        if (output.isTimeout()) {
            throw new PyExecutionException(PySdkBundle.message("python.sdk.packaging.timed.out", new Object[0]), path2, args2, output);
        }
        if (exitCode != 0) {
            throw new PyExecutionException(PySdkBundle.message("python.sdk.packaging.non.zero.exit.code", exitCode), path2, args2, output);
        }
        String string = output.getStdout();
        if (string == null) {
            PyPackageManagerImpl.$$$reportNull$$$0(19);
        }
        return string;
    }

    @NotNull
    protected ProcessOutput getPythonProcessOutput(@NotNull String helperPath, @NotNull List<String> args2, boolean askForSudo, boolean showProgress, @Nullable String workingDir, @Nullable List<String> pyArgs) throws ExecutionException {
        ProcessOutput processOutput;
        String homePath2;
        if (helperPath == null) {
            PyPackageManagerImpl.$$$reportNull$$$0(20);
        }
        if (args2 == null) {
            PyPackageManagerImpl.$$$reportNull$$$0(21);
        }
        if ((homePath2 = this.getSdk().getHomePath()) == null) {
            throw new ExecutionException(PySdkBundle.message("python.sdk.packaging.cannot.find.python.interpreter", this.mySdk.getName()));
        }
        if (workingDir == null) {
            workingDir = new File(homePath2).getParent();
        }
        ArrayList<String> cmdline = new ArrayList<String>();
        cmdline.add(homePath2);
        if (pyArgs != null) {
            cmdline.addAll(pyArgs);
        }
        cmdline.add(helperPath);
        cmdline.addAll(args2);
        LOG.info("Running packaging tool: " + StringUtil.join(PyPackageManagerImpl.makeSafeToDisplayCommand(cmdline), (String)" "));
        try {
            ProcessOutput result;
            GeneralCommandLine commandLine = new GeneralCommandLine(cmdline).withWorkDirectory(workingDir).withEnvironment(PySdkUtil.activateVirtualEnv(this.getSdk()));
            Map environment = commandLine.getEnvironment();
            PySdkUtil.configureCharset(commandLine);
            PythonEnvUtil.setPythonUnbuffered(environment);
            PythonEnvUtil.setPythonDontWriteBytecode(environment);
            PythonEnvUtil.resetHomePathChanges(homePath2, environment);
            PythonSdkFlavor flavor = PythonSdkFlavor.getFlavor(this.mySdk);
            if (flavor != null && flavor.commandLinePatcher() != null) {
                flavor.commandLinePatcher().patchCommandLine(commandLine);
            }
            boolean useSudo = askForSudo && PySdkExtKt.adminPermissionsNeeded(this.mySdk);
            Process process2 = useSudo ? ExecUtil.sudo((GeneralCommandLine)commandLine, (String)PySdkBundle.message("python.sdk.packaging.enter.your.password.to.make.changes", new Object[0])) : commandLine.createProcess();
            CapturingProcessHandler handler = new CapturingProcessHandler(process2, commandLine.getCharset(), commandLine.getCommandLineString());
            ProgressIndicator indicator = ProgressManager.getInstance().getProgressIndicator();
            if (showProgress && indicator != null) {
                handler.addProcessListener((ProcessListener)new IndicatedProcessOutputListener(indicator));
                result = handler.runProcessWithProgressIndicator(indicator);
            } else {
                result = handler.runProcess(600000);
            }
            if (result.isCancelled()) {
                throw new RunCanceledByUserException();
            }
            result.checkSuccess(LOG);
            int exitCode = result.getExitCode();
            if (exitCode != 0) {
                String message = StringUtil.isEmptyOrSpaces((String)result.getStdout()) && StringUtil.isEmptyOrSpaces((String)result.getStderr()) ? PySdkBundle.message("python.conda.permission.denied", new Object[0]) : PySdkBundle.message("python.sdk.packaging.non.zero.exit.code", exitCode);
                throw new PyExecutionException(message, helperPath, args2, result);
            }
            processOutput = result;
        }
        catch (IOException e) {
            throw new PyExecutionException(e.getMessage(), helperPath, args2);
        }
        if (processOutput == null) {
            PyPackageManagerImpl.$$$reportNull$$$0(22);
        }
        return processOutput;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 19: 
            case 22: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 19: 
            case 22: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pipArgs";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dirName";
                break;
            }
            case 2: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 19: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/packaging/PyPackageManagerImpl";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdk";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "requirementString";
                break;
            }
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "extraArgs";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "packages";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "destinationDir";
                break;
            }
            case 13: 
            case 14: 
            case 16: 
            case 18: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "args";
                break;
            }
            case 15: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "helperPath";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/packaging/PyPackageManagerImpl";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "toSystemDependentName";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "collectPackages";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "createVirtualEnv";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getPythonProcessResult";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "getPythonProcessOutput";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "installUsingPipWheel";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "toSystemDependentName";
                break;
            }
            case 2: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 19: 
            case 22: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "install";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "uninstall";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "createVirtualEnv";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getHelperResult";
                break;
            }
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "getPythonProcessResult";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "getPythonProcessOutput";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 19: 
            case 22: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

