/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.inspections.quickfix;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.application.ex.ApplicationManagerEx;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.impl.source.resolve.FileContextUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.usageView.UsageInfo;
import com.intellij.util.ObjectUtils;
import com.jetbrains.python.PyPsiBundle;
import com.jetbrains.python.codeInsight.PyPsiIndexUtil;
import com.jetbrains.python.codeInsight.imports.AddImportHelper;
import com.jetbrains.python.inspections.unresolvedReference.SimplePyUnresolvedReferencesInspection;
import com.jetbrains.python.psi.PyArgumentList;
import com.jetbrains.python.psi.PyAssignmentStatement;
import com.jetbrains.python.psi.PyCallExpression;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.PyElement;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyFile;
import com.jetbrains.python.psi.PyFunction;
import com.jetbrains.python.psi.PyParameter;
import com.jetbrains.python.psi.PyRecursiveElementVisitor;
import com.jetbrains.python.psi.PyReferenceExpression;
import com.jetbrains.python.psi.PyTargetExpression;
import com.jetbrains.python.psi.PyUtil;
import com.jetbrains.python.psi.types.TypeEvalContext;
import java.util.List;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PyMakeFunctionFromMethodQuickFix
implements LocalQuickFix {
    @NotNull
    public String getFamilyName() {
        String string = PyPsiBundle.message("QFIX.NAME.make.function", new Object[0]);
        if (string == null) {
            PyMakeFunctionFromMethodQuickFix.$$$reportNull$$$0(0);
        }
        return string;
    }

    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor2) {
        PsiElement element;
        PyFunction problemFunction;
        if (project == null) {
            PyMakeFunctionFromMethodQuickFix.$$$reportNull$$$0(1);
        }
        if (descriptor2 == null) {
            PyMakeFunctionFromMethodQuickFix.$$$reportNull$$$0(2);
        }
        if ((problemFunction = (PyFunction)PsiTreeUtil.getParentOfType((PsiElement)(element = descriptor2.getPsiElement()), PyFunction.class)) == null) {
            return;
        }
        PyClass containingClass = problemFunction.getContainingClass();
        if (containingClass == null) {
            return;
        }
        List usages = StreamEx.of(PyPsiIndexUtil.findUsages(problemFunction, false)).map(UsageInfo::getElement).select(PyReferenceExpression.class).toList();
        ApplicationManagerEx.getApplicationEx().runWriteActionWithCancellableProgressInDispatchThread(PyPsiBundle.message("refactoring.progress.title.updating.existing.usages", new Object[0]), problemFunction.getProject(), null, indicator -> {
            PyFunction function = PyMakeFunctionFromMethodQuickFix.transformDefinition(problemFunction);
            for (int i = 0; i < usages.size(); ++i) {
                indicator.checkCanceled();
                indicator.setFraction(((double)i + 1.0) / (double)usages.size());
                PyReferenceExpression usage = (PyReferenceExpression)usages.get(i);
                PsiFile usageFile = usage.getContainingFile();
                PyMakeFunctionFromMethodQuickFix.updateUsage(function, usage, usageFile, !usageFile.equals(containingClass.getContainingFile()));
            }
        });
    }

    @NotNull
    private static PyFunction transformDefinition(@NotNull PyFunction method) {
        PyParameter[] parameters;
        if (method == null) {
            PyMakeFunctionFromMethodQuickFix.$$$reportNull$$$0(3);
        }
        if ((parameters = method.getParameterList().getParameters()).length > 0) {
            parameters[0].delete();
        }
        PyClass topmostClass = (PyClass)PsiTreeUtil.getTopmostParentOfType((PsiElement)method, PyClass.class);
        assert (topmostClass != null);
        PsiElement copy = method.copy();
        method.delete();
        PyFunction pyFunction = (PyFunction)topmostClass.getParent().addBefore(copy, (PsiElement)topmostClass);
        if (pyFunction == null) {
            PyMakeFunctionFromMethodQuickFix.$$$reportNull$$$0(4);
        }
        return pyFunction;
    }

    private static void updateUsage(@NotNull PsiElement finalElement, @NotNull PyReferenceExpression element, @NotNull PsiFile usageFile, boolean addImport) {
        PyExpression qualifier;
        if (finalElement == null) {
            PyMakeFunctionFromMethodQuickFix.$$$reportNull$$$0(5);
        }
        if (element == null) {
            PyMakeFunctionFromMethodQuickFix.$$$reportNull$$$0(6);
        }
        if (usageFile == null) {
            PyMakeFunctionFromMethodQuickFix.$$$reportNull$$$0(7);
        }
        if ((qualifier = element.getQualifier()) == null) {
            return;
        }
        if (qualifier.getText().equals("self")) {
            PyUtil.removeQualifier(element);
            return;
        }
        if (qualifier instanceof PyCallExpression) {
            if (addImport) {
                AddImportHelper.addImport((PsiNamedElement)finalElement, usageFile, element);
            }
            PyUtil.removeQualifier(element);
            PyMakeFunctionFromMethodQuickFix.removeFormerImport(usageFile, addImport);
        } else {
            PsiReference reference = qualifier.getReference();
            if (reference == null) {
                return;
            }
            PsiElement resolved = reference.resolve();
            if (resolved instanceof PyTargetExpression) {
                PyMakeFunctionFromMethodQuickFix.updateAssignment(element, resolved);
            } else if (resolved instanceof PyClass) {
                PyUtil.removeQualifier(element);
                PyMakeFunctionFromMethodQuickFix.updateArgumentList(element);
            }
        }
    }

    private static void removeFormerImport(@NotNull PsiFile usageFile, boolean addImport) {
        if (usageFile == null) {
            PyMakeFunctionFromMethodQuickFix.$$$reportNull$$$0(8);
        }
        if (usageFile instanceof PyFile && addImport) {
            PsiFile contextFile = FileContextUtil.getContextFile((PsiElement)usageFile);
            PsiFile file = (PsiFile)ObjectUtils.chooseNotNull((Object)contextFile, (Object)usageFile);
            TypeEvalContext context2 = TypeEvalContext.codeAnalysis(file.getProject(), file);
            final SimplePyUnresolvedReferencesInspection.Visitor visitor2 = new SimplePyUnresolvedReferencesInspection.Visitor(null, new SimplePyUnresolvedReferencesInspection(), context2);
            usageFile.accept((PsiElementVisitor)new PyRecursiveElementVisitor(){

                @Override
                public void visitPyElement(@NotNull PyElement node) {
                    if (node == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    super.visitPyElement(node);
                    node.accept(visitor2);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/jetbrains/python/inspections/quickfix/PyMakeFunctionFromMethodQuickFix$1", "visitPyElement"));
                }
            });
            visitor2.optimizeImports();
        }
    }

    private static void updateAssignment(PyReferenceExpression element, @NotNull PsiElement resolved) {
        PyExpression callee;
        PyExpression value;
        PsiElement parent;
        if (resolved == null) {
            PyMakeFunctionFromMethodQuickFix.$$$reportNull$$$0(9);
        }
        if ((parent = resolved.getParent()) instanceof PyAssignmentStatement && (value = ((PyAssignmentStatement)parent).getAssignedValue()) instanceof PyCallExpression && (callee = ((PyCallExpression)value).getCallee()) instanceof PyReferenceExpression) {
            PyExpression calleeQualifier = ((PyReferenceExpression)callee).getQualifier();
            if (calleeQualifier != null) {
                value.replace((PsiElement)calleeQualifier);
            } else {
                PyUtil.removeQualifier(element);
            }
        }
    }

    private static void updateArgumentList(@NotNull PyReferenceExpression element) {
        PyCallExpression callExpression;
        if (element == null) {
            PyMakeFunctionFromMethodQuickFix.$$$reportNull$$$0(10);
        }
        if ((callExpression = (PyCallExpression)PsiTreeUtil.getParentOfType((PsiElement)element, PyCallExpression.class)) == null) {
            return;
        }
        PyArgumentList argumentList = callExpression.getArgumentList();
        if (argumentList == null) {
            return;
        }
        PyExpression[] arguments = argumentList.getArguments();
        if (arguments.length > 0) {
            arguments[0].delete();
        }
    }

    public boolean startInWriteAction() {
        return false;
    }

    @Nullable
    public PsiElement getElementToMakeWritable(@NotNull PsiFile currentFile) {
        if (currentFile == null) {
            PyMakeFunctionFromMethodQuickFix.$$$reportNull$$$0(11);
        }
        return currentFile;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/inspections/quickfix/PyMakeFunctionFromMethodQuickFix";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "finalElement";
                break;
            }
            case 6: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "usageFile";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resolved";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "currentFile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/inspections/quickfix/PyMakeFunctionFromMethodQuickFix";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "transformDefinition";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "applyFix";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "transformDefinition";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "updateUsage";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "removeFormerImport";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "updateAssignment";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "updateArgumentList";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getElementToMakeWritable";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

