/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.inspections.quickfix;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.ObjectUtils;
import com.jetbrains.python.PyPsiBundle;
import com.jetbrains.python.PyTokenTypes;
import com.jetbrains.python.psi.PyBinaryExpression;
import com.jetbrains.python.psi.PyElementGenerator;
import com.jetbrains.python.psi.PyElementType;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyUtil;
import java.util.ArrayList;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ChainedComparisonsQuickFix
implements LocalQuickFix {
    private final boolean myCommonIsInLeftLeft;
    private final boolean myCommonIsInRightLeft;
    private final boolean myUseRightChildOfLeft;

    public ChainedComparisonsQuickFix(boolean commonIsInLeftLeft, boolean commonIsInRightLeft, boolean useRightChildOfLeft) {
        this.myCommonIsInLeftLeft = commonIsInLeftLeft;
        this.myCommonIsInRightLeft = commonIsInRightLeft;
        this.myUseRightChildOfLeft = useRightChildOfLeft;
    }

    @NotNull
    public String getFamilyName() {
        String string = PyPsiBundle.message("QFIX.chained.comparison", new Object[0]);
        if (string == null) {
            ChainedComparisonsQuickFix.$$$reportNull$$$0(0);
        }
        return string;
    }

    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor2) {
        PyBinaryExpression expression;
        if (project == null) {
            ChainedComparisonsQuickFix.$$$reportNull$$$0(1);
        }
        if (descriptor2 == null) {
            ChainedComparisonsQuickFix.$$$reportNull$$$0(2);
        }
        if (ChainedComparisonsQuickFix.isLogicalAndExpression(expression = PyUtil.as(descriptor2.getPsiElement(), PyBinaryExpression.class)) && expression.isWritable()) {
            PyBinaryExpression rightExpression = PyUtil.as(expression.getRightExpression(), PyBinaryExpression.class);
            PyBinaryExpression leftExpression = PyUtil.as(expression.getLeftExpression(), PyBinaryExpression.class);
            if (ChainedComparisonsQuickFix.isLogicalAndExpression(leftExpression)) {
                PyExpression nested = this.myUseRightChildOfLeft ? leftExpression.getRightExpression() : leftExpression.getLeftExpression();
                leftExpression = PyUtil.as(nested, PyBinaryExpression.class);
            }
            if (ChainedComparisonsQuickFix.isComparisonExpression(leftExpression) && ChainedComparisonsQuickFix.isComparisonExpression(rightExpression)) {
                this.applyFix(leftExpression, rightExpression, project);
            }
        }
    }

    private void applyFix(@NotNull PyBinaryExpression leftExpression, @NotNull PyBinaryExpression rightExpression, @NotNull Project project) {
        PyExpression newRightExpression;
        String operator;
        if (leftExpression == null) {
            ChainedComparisonsQuickFix.$$$reportNull$$$0(3);
        }
        if (rightExpression == null) {
            ChainedComparisonsQuickFix.$$$reportNull$$$0(4);
        }
        if (project == null) {
            ChainedComparisonsQuickFix.$$$reportNull$$$0(5);
        }
        PyElementGenerator elementGenerator = PyElementGenerator.getInstance(project);
        PyExpression newLeftExpression = this.myCommonIsInLeftLeft ? ChainedComparisonsQuickFix.invertExpression(leftExpression, elementGenerator) : leftExpression;
        if (this.myCommonIsInRightLeft) {
            operator = ChainedComparisonsQuickFix.getLeftestOperator(rightExpression).getText();
            newRightExpression = ChainedComparisonsQuickFix.getLargeRightExpression(rightExpression, project);
        } else {
            operator = ChainedComparisonsQuickFix.invertOperator(Objects.requireNonNull(rightExpression.getPsiOperator()));
            PyExpression rightLeftExpr = rightExpression.getLeftExpression();
            newRightExpression = rightLeftExpr instanceof PyBinaryExpression ? ChainedComparisonsQuickFix.invertExpression((PyBinaryExpression)rightLeftExpr, elementGenerator) : rightLeftExpr;
        }
        PyBinaryExpression binaryExpression = elementGenerator.createBinaryExpression(operator, newLeftExpression, newRightExpression);
        leftExpression.replace((PsiElement)ChainedComparisonsQuickFix.makePsiConsistentBinaryExpression(project, binaryExpression));
        rightExpression.delete();
    }

    @NotNull
    private static PyExpression makePsiConsistentBinaryExpression(@NotNull Project project, @NotNull PyBinaryExpression binaryExpression) {
        if (project == null) {
            ChainedComparisonsQuickFix.$$$reportNull$$$0(6);
        }
        if (binaryExpression == null) {
            ChainedComparisonsQuickFix.$$$reportNull$$$0(7);
        }
        ArrayList<PyExpression> elements = new ArrayList<PyExpression>();
        ArrayList<String> operators = new ArrayList<String>();
        ChainedComparisonsQuickFix.collectExpressionsDfs(elements, operators, binaryExpression);
        PyExpression resultExpression = ChainedComparisonsQuickFix.buildResultExpression(project, elements, operators);
        PyExpression pyExpression = (PyExpression)ObjectUtils.chooseNotNull((Object)resultExpression, (Object)binaryExpression);
        if (pyExpression == null) {
            ChainedComparisonsQuickFix.$$$reportNull$$$0(8);
        }
        return pyExpression;
    }

    private static void collectExpressionsDfs(@NotNull ArrayList<PyExpression> elements, @NotNull ArrayList<String> operators, @NotNull PyBinaryExpression expression) {
        PyExpression leftExpr;
        PyExpression rightExpr;
        if (elements == null) {
            ChainedComparisonsQuickFix.$$$reportNull$$$0(9);
        }
        if (operators == null) {
            ChainedComparisonsQuickFix.$$$reportNull$$$0(10);
        }
        if (expression == null) {
            ChainedComparisonsQuickFix.$$$reportNull$$$0(11);
        }
        if ((rightExpr = expression.getRightExpression()) instanceof PyBinaryExpression && ChainedComparisonsQuickFix.isComparisonExpression(rightExpr)) {
            ChainedComparisonsQuickFix.collectExpressionsDfs(elements, operators, (PyBinaryExpression)rightExpr);
        } else {
            elements.add(rightExpr);
        }
        if (expression.getPsiOperator() != null) {
            operators.add(expression.getPsiOperator().getText());
        }
        if ((leftExpr = expression.getLeftExpression()) instanceof PyBinaryExpression && ChainedComparisonsQuickFix.isComparisonExpression(leftExpr)) {
            ChainedComparisonsQuickFix.collectExpressionsDfs(elements, operators, (PyBinaryExpression)leftExpr);
        } else {
            elements.add(leftExpr);
        }
    }

    @Nullable
    private static PyExpression buildResultExpression(@NotNull Project project, @NotNull ArrayList<PyExpression> elements, @NotNull ArrayList<String> operators) {
        if (project == null) {
            ChainedComparisonsQuickFix.$$$reportNull$$$0(12);
        }
        if (elements == null) {
            ChainedComparisonsQuickFix.$$$reportNull$$$0(13);
        }
        if (operators == null) {
            ChainedComparisonsQuickFix.$$$reportNull$$$0(14);
        }
        PyElementGenerator elementGenerator = PyElementGenerator.getInstance(project);
        int size = elements.size();
        if (elements.isEmpty()) {
            return null;
        }
        PyExpression currentResult = elements.get(size - 1);
        for (int i = size - 2; i >= 0; --i) {
            PyExpression nextElement = elements.get(i);
            String nextOperator = operators.get(i);
            currentResult = elementGenerator.createBinaryExpression(nextOperator, currentResult, nextElement);
        }
        return currentResult;
    }

    @NotNull
    private static PsiElement getLeftestOperator(@NotNull PyBinaryExpression expression) {
        if (expression == null) {
            ChainedComparisonsQuickFix.$$$reportNull$$$0(15);
        }
        PsiElement op = expression.getPsiOperator();
        while (ChainedComparisonsQuickFix.isComparisonExpression(expression.getLeftExpression())) {
            expression = (PyBinaryExpression)expression.getLeftExpression();
            op = expression.getPsiOperator();
        }
        assert (op != null);
        PsiElement psiElement = op;
        if (psiElement == null) {
            ChainedComparisonsQuickFix.$$$reportNull$$$0(16);
        }
        return psiElement;
    }

    @NotNull
    private static PyExpression invertExpression(@NotNull PyBinaryExpression expression, @NotNull PyElementGenerator elementGenerator) {
        if (expression == null) {
            ChainedComparisonsQuickFix.$$$reportNull$$$0(17);
        }
        if (elementGenerator == null) {
            ChainedComparisonsQuickFix.$$$reportNull$$$0(18);
        }
        if (ChainedComparisonsQuickFix.isComparisonExpression(expression)) {
            PyExpression left = expression.getLeftExpression();
            PyExpression right = expression.getRightExpression();
            String newOperator = ChainedComparisonsQuickFix.invertOperator(Objects.requireNonNull(expression.getPsiOperator()));
            PyExpression newRight = ChainedComparisonsQuickFix.isComparisonExpression(left) ? ChainedComparisonsQuickFix.invertExpression((PyBinaryExpression)left, elementGenerator) : left;
            PyBinaryExpression pyBinaryExpression = elementGenerator.createBinaryExpression(newOperator, right, newRight);
            if (pyBinaryExpression == null) {
                ChainedComparisonsQuickFix.$$$reportNull$$$0(19);
            }
            return pyBinaryExpression;
        }
        PyBinaryExpression pyBinaryExpression = expression;
        if (pyBinaryExpression == null) {
            ChainedComparisonsQuickFix.$$$reportNull$$$0(20);
        }
        return pyBinaryExpression;
    }

    @NotNull
    private static String invertOperator(@NotNull PsiElement op) {
        if (op == null) {
            ChainedComparisonsQuickFix.$$$reportNull$$$0(21);
        }
        if (op.getText().equals(">")) {
            return "<";
        }
        if (op.getText().equals("<")) {
            return ">";
        }
        if (op.getText().equals(">=")) {
            return "<=";
        }
        if (op.getText().equals("<=")) {
            return ">=";
        }
        String string = op.getText();
        if (string == null) {
            ChainedComparisonsQuickFix.$$$reportNull$$$0(22);
        }
        return string;
    }

    @Nullable
    private static PyExpression getLargeRightExpression(@NotNull PyBinaryExpression expression, @NotNull Project project) {
        if (expression == null) {
            ChainedComparisonsQuickFix.$$$reportNull$$$0(23);
        }
        if (project == null) {
            ChainedComparisonsQuickFix.$$$reportNull$$$0(24);
        }
        PyElementGenerator elementGenerator = PyElementGenerator.getInstance(project);
        PyExpression left = expression.getLeftExpression();
        PyExpression right = expression.getRightExpression();
        PsiElement operator = expression.getPsiOperator();
        while (ChainedComparisonsQuickFix.isComparisonExpression(left)) {
            assert (operator != null);
            right = elementGenerator.createBinaryExpression(operator.getText(), ((PyBinaryExpression)left).getRightExpression(), right);
            operator = ((PyBinaryExpression)left).getPsiOperator();
            left = ((PyBinaryExpression)left).getLeftExpression();
        }
        return right;
    }

    private static boolean isComparisonExpression(@Nullable PyExpression expression) {
        if (!(expression instanceof PyBinaryExpression)) {
            return false;
        }
        PyElementType operator = ((PyBinaryExpression)expression).getOperator();
        return PyTokenTypes.RELATIONAL_OPERATIONS.contains((IElementType)operator) || PyTokenTypes.EQUALITY_OPERATIONS.contains((IElementType)operator);
    }

    private static boolean isLogicalAndExpression(@Nullable PyExpression expression) {
        return expression instanceof PyBinaryExpression && ((PyBinaryExpression)expression).getOperator() == PyTokenTypes.AND_KEYWORD;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 17: 
            case 18: 
            case 21: 
            case 23: 
            case 24: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 17: 
            case 18: 
            case 21: 
            case 23: 
            case 24: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/inspections/quickfix/ChainedComparisonsQuickFix";
                break;
            }
            case 1: 
            case 5: 
            case 6: 
            case 12: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "leftExpression";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rightExpression";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "binaryExpression";
                break;
            }
            case 9: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
            case 10: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "operators";
                break;
            }
            case 11: 
            case 15: 
            case 17: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementGenerator";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "op";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 17: 
            case 18: 
            case 21: 
            case 23: 
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/inspections/quickfix/ChainedComparisonsQuickFix";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "makePsiConsistentBinaryExpression";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getLeftestOperator";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "invertExpression";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "invertOperator";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "applyFix";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "makePsiConsistentBinaryExpression";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "collectExpressionsDfs";
                break;
            }
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "buildResultExpression";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getLeftestOperator";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "invertExpression";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "invertOperator";
                break;
            }
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "getLargeRightExpression";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 17: 
            case 18: 
            case 21: 
            case 23: 
            case 24: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

