/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.debugger.containerview;

import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.ui.layout.impl.JBRunnerTabs;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.PlatformCoreDataKeys;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.openapi.wm.ToolWindowType;
import com.intellij.openapi.wm.ex.ToolWindowManagerListener;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentFactory;
import com.intellij.ui.tabs.TabInfo;
import com.intellij.ui.tabs.impl.JBEditorTabs;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.xdebugger.XDebuggerManager;
import com.jetbrains.python.PyBundle;
import com.jetbrains.python.PythonPluginDisposable;
import com.jetbrains.python.console.PydevConsoleCommunication;
import com.jetbrains.python.debugger.PyDebugProcess;
import com.jetbrains.python.debugger.PyDebugValue;
import com.jetbrains.python.debugger.PyFrameAccessor;
import com.jetbrains.python.debugger.containerview.PyDataViewDialog;
import com.jetbrains.python.debugger.containerview.PyDataViewPanelFactory;
import com.jetbrains.python.debugger.containerview.PyDataViewerPanel;
import icons.PythonIcons;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Predicate;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PyDataView
implements DumbAware {
    public static final String DATA_VIEWER_ID = "SciView";
    public static final String COLORED_BY_DEFAULT = "python.debugger.dataview.coloredbydefault";
    public static final String AUTO_RESIZE = "python.debugger.dataview.autoresize";
    private static final Logger LOG = Logger.getInstance(PyDataView.class);
    private static final String HELP_ID = "reference.toolWindows.PyDataView";
    @NotNull
    private final Project myProject;
    private JBEditorTabs myTabs;
    private final Map<ProcessHandler, TabInfo> mySelectedInfos;

    public PyDataView(@NotNull Project project) {
        if (project == null) {
            PyDataView.$$$reportNull$$$0(0);
        }
        this.mySelectedInfos = new ConcurrentHashMap<ProcessHandler, TabInfo>();
        this.myProject = project;
    }

    public void show(@NotNull PyDebugValue value) {
        if (value == null) {
            PyDataView.$$$reportNull$$$0(1);
        }
        if (ToolWindowManager.getInstance((Project)this.myProject).getToolWindow(DATA_VIEWER_ID) != null) {
            this.showInToolwindow(value);
        } else {
            ApplicationManager.getApplication().invokeLater(() -> {
                PyDataViewDialog dialog2 = new PyDataViewDialog(this.myProject, value);
                dialog2.show();
            });
        }
    }

    private void showInToolwindow(@NotNull PyDebugValue value) {
        ToolWindow window;
        if (value == null) {
            PyDataView.$$$reportNull$$$0(2);
        }
        if ((window = ToolWindowManager.getInstance((Project)this.myProject).getToolWindow(DATA_VIEWER_ID)) == null) {
            LOG.error("Tool window 'SciView' is not found");
            return;
        }
        window.getContentManager().getReady((Object)this).doWhenDone(() -> {
            TabInfo selectedInfo = this.addTab(value.getFrameAccessor());
            PyDataViewerPanel dataViewerPanel = (PyDataViewerPanel)selectedInfo.getComponent();
            dataViewerPanel.apply(value, false);
        });
        window.show(null);
        Content dataView = window.getContentManager().getContent(0);
        if (dataView != null) {
            window.getContentManager().setSelectedContent(dataView);
        }
    }

    public void closeTabs(Predicate<PyFrameAccessor> ifClose) {
        ArrayList<TabInfo> tabsToRemove = new ArrayList<TabInfo>();
        for (TabInfo info : this.myTabs.getTabs()) {
            if (!ifClose.test(PyDataView.getPanel(info).getFrameAccessor())) continue;
            tabsToRemove.add(info);
        }
        ApplicationManager.getApplication().invokeLater(() -> {
            for (TabInfo info : tabsToRemove) {
                this.myTabs.removeTab(info);
                PyDataView.getPanel(info).closeEditorTabs();
            }
        });
    }

    public void updateTabs(@NotNull ProcessHandler handler) {
        PyFrameAccessor accessor;
        if (handler == null) {
            PyDataView.$$$reportNull$$$0(3);
        }
        this.saveSelectedInfo();
        for (TabInfo info : this.myTabs.getTabs()) {
            PyDataViewerPanel panel2 = PyDataView.getPanel(info);
            PyFrameAccessor accessor2 = panel2.getFrameAccessor();
            if (!(accessor2 instanceof PyDebugProcess)) continue;
            boolean shouldBeShown = Comparing.equal((Object)handler, (Object)((PyDebugProcess)accessor2).getProcessHandler());
            info.setHidden(!shouldBeShown);
        }
        this.restoreSelectedInfo(handler);
        if (this.myTabs.getSelectedInfo() == null && (accessor = this.getFrameAccessor(handler)) != null) {
            this.addTab(accessor);
        }
    }

    private void restoreSelectedInfo(@NotNull ProcessHandler handler) {
        TabInfo savedSelection;
        if (handler == null) {
            PyDataView.$$$reportNull$$$0(4);
        }
        if ((savedSelection = this.mySelectedInfos.get(handler)) != null) {
            this.myTabs.select(savedSelection, true);
            this.mySelectedInfos.remove(handler);
        }
    }

    private void saveSelectedInfo() {
        PyFrameAccessor accessor;
        TabInfo selectedInfo = this.myTabs.getSelectedInfo();
        if (!this.hasOnlyEmptyTab() && selectedInfo != null && (accessor = PyDataView.getPanel(selectedInfo).getFrameAccessor()) instanceof PyDebugProcess) {
            this.mySelectedInfos.put(((PyDebugProcess)accessor).getProcessHandler(), selectedInfo);
        }
    }

    @Nullable
    private PyFrameAccessor getFrameAccessor(@NotNull ProcessHandler handler) {
        if (handler == null) {
            PyDataView.$$$reportNull$$$0(5);
        }
        for (PyDebugProcess process2 : XDebuggerManager.getInstance((Project)this.myProject).getDebugProcesses(PyDebugProcess.class)) {
            if (!Comparing.equal((Object)handler, (Object)process2.getProcessHandler())) continue;
            return process2;
        }
        return null;
    }

    public void closeDisconnectedFromConsoleTabs() {
        this.closeTabs(frameAccessor -> frameAccessor instanceof PydevConsoleCommunication && !PyDataView.isConnected((PydevConsoleCommunication)frameAccessor));
    }

    private static boolean isConnected(PydevConsoleCommunication accessor) {
        return !accessor.isCommunicationClosed();
    }

    public static PyDataView getInstance(@NotNull Project project) {
        if (project == null) {
            PyDataView.$$$reportNull$$$0(6);
        }
        return (PyDataView)project.getService(PyDataView.class);
    }

    public void init(final @NotNull ToolWindow toolWindow) {
        if (toolWindow == null) {
            PyDataView.$$$reportNull$$$0(7);
        }
        this.myTabs = new JBRunnerTabs(this.myProject, PythonPluginDisposable.getInstance(this.myProject));
        this.myTabs.setDataProvider(dataId -> {
            if (PlatformCoreDataKeys.HELP_ID.is(dataId)) {
                return HELP_ID;
            }
            return null;
        });
        this.myTabs.getPresentation().setEmptyText(PyBundle.message("debugger.data.view.empty.text", new Object[0]));
        this.myTabs.setPopupGroup((ActionGroup)new DefaultActionGroup(new AnAction[]{new ColoredAction()}), "unknown", true);
        this.myTabs.setTabDraggingEnabled(true);
        Content content2 = ContentFactory.getInstance().createContent((JComponent)this.myTabs, PyBundle.message("debugger.data.view.data", new Object[0]), false);
        content2.setCloseable(true);
        toolWindow.getContentManager().addContent(content2);
        this.myProject.getMessageBus().connect().subscribe(ToolWindowManagerListener.TOPIC, (Object)new ToolWindowManagerListener(){

            public void stateChanged(@NotNull ToolWindowManager toolWindowManager) {
                ToolWindow window;
                if (toolWindowManager == null) {
                    1.$$$reportNull$$$0(0);
                }
                if ((window = toolWindowManager.getToolWindow(PyDataView.DATA_VIEWER_ID)) == null) {
                    return;
                }
                if (toolWindow.isAvailable() && toolWindow.getType().equals((Object)ToolWindowType.FLOATING) && !toolWindow.isVisible()) {
                    toolWindow.setShowStripeButton(false);
                    PyDataView.this.myTabs.removeAllTabs();
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "toolWindowManager", "com/jetbrains/python/debugger/containerview/PyDataView$1", "stateChanged"));
            }
        });
    }

    public TabInfo addTab(@NotNull PyFrameAccessor frameAccessor) {
        PyDataViewPanelFactory factory;
        if (frameAccessor == null) {
            PyDataView.$$$reportNull$$$0(8);
        }
        if (this.hasOnlyEmptyTab()) {
            this.myTabs.removeTab(this.myTabs.getSelectedInfo());
        }
        PyDataViewerPanel panel2 = null;
        Iterator iterator = PyDataViewPanelFactory.EP_NAME.getExtensionList().iterator();
        while (iterator.hasNext() && (panel2 = (factory = (PyDataViewPanelFactory)iterator.next()).createDataViewPanel(this.myProject, frameAccessor)) == null) {
        }
        if (panel2 == null) {
            panel2 = new PyDataViewerPanel(this.myProject, frameAccessor);
        }
        TabInfo info = new TabInfo(panel2);
        if (frameAccessor instanceof PydevConsoleCommunication) {
            info.setIcon(PythonIcons.Python.PythonConsole);
            info.setTooltipText(PyBundle.message("debugger.data.view.connected.to.python.console", new Object[0]));
        }
        if (frameAccessor instanceof PyDebugProcess) {
            info.setIcon(AllIcons.Toolwindows.ToolWindowDebugger);
            String name3 = ((PyDebugProcess)frameAccessor).getSession().getSessionName();
            info.setTooltipText(PyBundle.message("debugger.data.view.connected.to.debug.session", name3));
        }
        info.setText(PyBundle.message("debugger.data.view.empty.tab", new Object[0]));
        info.setPreferredFocusableComponent((JComponent)panel2.getSliceTextField());
        info.setActions((ActionGroup)new DefaultActionGroup(new AnAction[]{new NewViewerAction(frameAccessor)}), "EditorTab");
        info.setTabLabelActions((ActionGroup)new DefaultActionGroup(new AnAction[]{new CloseViewerAction(info, frameAccessor)}), "EditorTab");
        panel2.addListener(name2 -> info.setText(name2));
        this.myTabs.addTab(info);
        this.myTabs.select(info, true);
        return info;
    }

    private boolean hasOnlyEmptyTab() {
        if (this.getVisibleTabs().size() != 1) {
            return false;
        }
        TabInfo info = this.myTabs.getSelectedInfo();
        if (info == null) {
            return false;
        }
        return PyDataView.getPanel(info).getSliceTextField().getText().isEmpty();
    }

    public List<TabInfo> getVisibleTabs() {
        return ContainerUtil.filter((Collection)this.myTabs.getTabs(), tabInfo -> !tabInfo.isHidden());
    }

    public void changeAutoResize(boolean autoResize) {
        for (TabInfo info : this.myTabs.getTabs()) {
            PyDataView.getPanel(info).resize(autoResize);
        }
    }

    private static PyDataViewerPanel getPanel(TabInfo tabInfo) {
        return (PyDataViewerPanel)tabInfo.getComponent();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "handler";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toolWindow";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "frameAccessor";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/python/debugger/containerview/PyDataView";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "show";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "showInToolwindow";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "updateTabs";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "restoreSelectedInfo";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "getFrameAccessor";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "getInstance";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "init";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "addTab";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private class ColoredAction
    extends ToggleAction {
        ColoredAction() {
            super(PyBundle.messagePointer("debugger.data.view.colored", new Object[0]));
        }

        public boolean isSelected(@NotNull AnActionEvent e) {
            PyDataViewerPanel panel2;
            if (e == null) {
                ColoredAction.$$$reportNull$$$0(0);
            }
            if ((panel2 = this.getPanel()) == null) {
                return true;
            }
            return panel2.isColored();
        }

        @Nullable
        private PyDataViewerPanel getPanel() {
            TabInfo info = PyDataView.this.myTabs.getSelectedInfo();
            if (info == null) {
                return null;
            }
            return PyDataView.getPanel(info);
        }

        public void setSelected(@NotNull AnActionEvent e, boolean state2) {
            PyDataViewerPanel panel2;
            if (e == null) {
                ColoredAction.$$$reportNull$$$0(1);
            }
            if ((panel2 = this.getPanel()) != null) {
                panel2.setColored(state2);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "e";
            objectArray2[1] = "com/jetbrains/python/debugger/containerview/PyDataView$ColoredAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isSelected";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "setSelected";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private class CloseViewerAction
    extends AnAction {
        private final TabInfo myInfo;
        private final PyFrameAccessor myFrameAccessor;

        CloseViewerAction(TabInfo info, PyFrameAccessor frameAccessor) {
            super(PyBundle.message("debugger.data.view.close.viewer", new Object[0]), PyBundle.message("debugger.data.view.close.selected.viewer", new Object[0]), AllIcons.Actions.Close);
            this.myInfo = info;
            this.myFrameAccessor = frameAccessor;
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                CloseViewerAction.$$$reportNull$$$0(0);
            }
            PyDataView.this.myTabs.removeTab(this.myInfo);
            if (PyDataView.this.getVisibleTabs().isEmpty()) {
                PyDataView.this.addTab(this.myFrameAccessor);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/jetbrains/python/debugger/containerview/PyDataView$CloseViewerAction", "actionPerformed"));
        }
    }

    private class NewViewerAction
    extends AnAction {
        private final PyFrameAccessor myFrameAccessor;

        NewViewerAction(PyFrameAccessor frameAccessor) {
            super(PyBundle.message("debugger.data.view.view.new.container", new Object[0]), PyBundle.message("debugger.data.view.open.new.container.viewer", new Object[0]), AllIcons.General.Add);
            this.myFrameAccessor = frameAccessor;
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                NewViewerAction.$$$reportNull$$$0(0);
            }
            PyDataView.this.addTab(this.myFrameAccessor);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/jetbrains/python/debugger/containerview/PyDataView$NewViewerAction", "actionPerformed"));
        }
    }
}

