/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules.patterns;

import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.Nullable;
import org.languagetool.AnalyzedTokenReadings;
import org.languagetool.rules.RuleMatch;
import org.languagetool.rules.patterns.RuleFilter;

public class RuleFilterEvaluator {
    private final RuleFilter filter;

    public RuleFilterEvaluator(RuleFilter filter2) {
        this.filter = filter2;
    }

    @Nullable
    public RuleMatch runFilter(String filterArgs, RuleMatch ruleMatch, AnalyzedTokenReadings[] patternTokens, int patternTokenPos, List<Integer> tokenPositions) throws IOException {
        Map<String, String> args = this.getResolvedArguments(filterArgs, patternTokens, patternTokenPos, tokenPositions);
        return this.filter.acceptRuleMatch(ruleMatch, args, patternTokenPos, patternTokens);
    }

    public Map<String, String> getResolvedArguments(String filterArgs, AnalyzedTokenReadings[] patternTokens, int patternTokenPos, List<Integer> tokenPositions) {
        String[] arguments;
        HashMap<String, String> result = new HashMap<String, String>();
        for (String arg : arguments = filterArgs.split("\\s+")) {
            int delimPos = arg.indexOf(58);
            if (delimPos == -1) {
                throw new RuntimeException("Invalid syntax for key/value, expected 'key:value', got: '" + arg + "'");
            }
            String key = arg.substring(0, delimPos);
            String val = arg.substring(delimPos + 1);
            if (val.startsWith("\\")) {
                int refNumber = Integer.parseInt(val.replace("\\", ""));
                if (refNumber > tokenPositions.size()) {
                    throw new RuntimeException("Your reference number " + refNumber + " is bigger than the number of tokens: " + tokenPositions.size());
                }
                int correctedRef = this.getSkipCorrectedReference(tokenPositions, refNumber);
                if (correctedRef >= patternTokens.length) {
                    throw new RuntimeException("Your reference number " + refNumber + " is bigger than number of matching tokens: " + patternTokens.length);
                }
                if (result.containsKey(key)) {
                    throw new RuntimeException("Duplicate key '" + key + "'");
                }
                result.put(key, patternTokens[correctedRef].getToken());
                continue;
            }
            result.put(key, val);
        }
        return result;
    }

    private int getSkipCorrectedReference(List<Integer> tokenPositions, int refNumber) {
        int correctedRef = 0;
        int i2 = 0;
        for (int tokenPosition : tokenPositions) {
            if (i2++ >= refNumber) break;
            correctedRef += tokenPosition;
        }
        return correctedRef - 1;
    }
}

