/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules.neuralnetwork;

import java.io.InputStream;
import java.util.Arrays;
import java.util.List;
import org.languagetool.rules.neuralnetwork.ResourceReader;

public class Matrix {
    private float[][] m;

    public Matrix(InputStream stream) {
        List<String> rows = ResourceReader.readAllLines(stream);
        this.fromLines(rows);
    }

    Matrix(float[] row) {
        this.m = new float[][]{row};
    }

    Matrix(List<String> rows) {
        this.fromLines(rows);
    }

    Matrix(float[][] matrix) {
        this.m = matrix;
    }

    private void fromLines(List<String> rows) {
        int nRows = rows.size();
        int nCols = rows.get(0).split(" ").length;
        this.m = new float[nRows][nCols];
        for (int i2 = 0; i2 < nRows; ++i2) {
            String[] row = rows.get(i2).split(" ");
            for (int j = 0; j < nCols; ++j) {
                this.m[i2][j] = Float.parseFloat(row[j]);
            }
        }
    }

    float[] row(int n) {
        return Arrays.copyOf(this.m[n], this.m[n].length);
    }

    int rows() {
        return this.m.length;
    }

    int columns() {
        return this.m[0].length;
    }

    void printDimension() {
        System.out.println(this.m.length + "/" + this.m[0].length);
    }

    Matrix mul(Matrix that) {
        float[][] a2 = this.m;
        float[][] b2 = that.m;
        int rowsA = a2.length;
        int colsA = a2[0].length;
        int rowsB = b2.length;
        int colsB = b2[0].length;
        if (colsA != rowsB) {
            throw new ArithmeticException("Matrix with " + colsA + " columns cannot be multiplied with matrix with " + colsB + " rows");
        }
        float[][] c = new float[rowsA][colsB];
        for (int i2 = 0; i2 < rowsA; ++i2) {
            for (int j = 0; j < colsB; ++j) {
                for (int k = 0; k < colsA; ++k) {
                    float[] fArray = c[i2];
                    int n = j;
                    fArray[n] = fArray[n] + a2[i2][k] * b2[k][j];
                }
            }
        }
        return new Matrix(c);
    }

    Matrix add(Matrix that) {
        float[][] a2 = this.m;
        float[][] b2 = that.m;
        int rowsA = a2.length;
        int colsA = a2[0].length;
        int rowsB = b2.length;
        int colsB = b2[0].length;
        if (rowsA != rowsB) {
            throw new ArithmeticException("Matrix with " + rowsA + " rows cannot be added to a matrix with " + rowsB + " rows");
        }
        if (colsA != colsB) {
            throw new ArithmeticException("Matrix with " + colsA + " columns cannot be added to a matrix with " + colsB + " columns");
        }
        float[][] c = new float[rowsA][colsA];
        for (int i2 = 0; i2 < rowsA; ++i2) {
            for (int j = 0; j < colsB; ++j) {
                c[i2][j] = a2[i2][j] + b2[i2][j];
            }
        }
        return new Matrix(c);
    }

    public boolean equals(Object obj) {
        if (obj instanceof Matrix) {
            return Arrays.deepEquals((Object[])this.m, (Object[])((Matrix)obj).m);
        }
        return false;
    }

    public Matrix transpose() {
        int rows = this.m.length;
        int cols = this.m[0].length;
        float[][] b2 = new float[cols][rows];
        for (int i2 = 0; i2 < rows; ++i2) {
            for (int j = 0; j < cols; ++j) {
                b2[j][i2] = this.m[i2][j];
            }
        }
        return new Matrix(b2);
    }

    public Matrix relu() {
        int rows = this.m.length;
        int cols = this.m[0].length;
        float[][] b2 = new float[rows][cols];
        for (int i2 = 0; i2 < rows; ++i2) {
            for (int j = 0; j < cols; ++j) {
                b2[i2][j] = this.m[i2][j] < 0.0f ? 0.0f : this.m[i2][j];
            }
        }
        return new Matrix(b2);
    }
}

