/*
 * Decompiled with CFR 0.152.
 */
package net.loomchild.segment.srx.legacy;

public class Buffer
implements CharSequence {
    private char[] buffer;
    private int head;
    private int size;

    private Buffer(char[] buffer, int head2, int size) {
        this.buffer = buffer;
        this.head = head2;
        this.size = size;
    }

    public Buffer(int capacity) {
        this(new char[capacity], 0, 0);
    }

    public int getCapacity() {
        return this.buffer.length;
    }

    public void enqueue(char character) {
        if (this.isFull()) {
            throw new IllegalStateException("Not enough capacity to enqueue element");
        }
        this.buffer[(this.head + this.length()) % this.getCapacity()] = character;
        ++this.size;
    }

    public void dequeue() {
        if (this.isEmpty()) {
            throw new IllegalStateException("No element to dequeue");
        }
        this.head = (this.head + 1) % this.getCapacity();
        --this.size;
    }

    public void forceEnqueue(char character) {
        this.buffer[(this.head + this.length()) % this.getCapacity()] = character;
        if (this.isFull()) {
            this.head = (this.head + 1) % this.getCapacity();
        } else {
            ++this.size;
        }
    }

    public int length() {
        return this.size;
    }

    public char charAt(int index) {
        if (index < 0 || index >= this.length()) {
            throw new IndexOutOfBoundsException("Buffer index " + index + " not in <0, " + this.length() + ").");
        }
        char character = this.buffer[(this.head + index) % this.getCapacity()];
        return character;
    }

    public CharSequence subSequence(int start, int end) {
        if (start < 0 || start > end || end > this.length()) {
            throw new IndexOutOfBoundsException("Buffer subsequence <" + start + ", " + end + ") not in <0, " + this.length() + ").");
        }
        int subHead = (this.head + start) % this.getCapacity();
        int subSize = end - start;
        return new Buffer(this.buffer, subHead, subSize);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(this.size);
        int position = this.head;
        for (int i2 = 0; i2 < this.size; ++i2) {
            stringBuilder.append(this.buffer[position]);
            position = (position + 1) % this.getCapacity();
        }
        return stringBuilder.toString();
    }

    private boolean isEmpty() {
        return this.length() == 0;
    }

    private boolean isFull() {
        return this.length() == this.getCapacity();
    }
}

