/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.grazie.text;

import ai.grazie.nlp.tokenizer.sentence.SRXSentenceTokenizer;
import com.intellij.grazie.text.ProblemFilter;
import com.intellij.grazie.text.Rule;
import com.intellij.grazie.text.RuleGroup;
import com.intellij.grazie.text.TextContent;
import com.intellij.grazie.text.TextProblem;
import com.intellij.grazie.utils.Text;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.PsiTodoSearchHelper;
import com.intellij.psi.search.TodoItem;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\r\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0010\u0010\t\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u0018\u0010\n\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0010\u0010\r\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0018\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0007\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002\u00a8\u0006\u0012"}, d2={"Lcom/intellij/grazie/text/CommentProblemFilter;", "Lcom/intellij/grazie/text/ProblemFilter;", "()V", "isAboutIdentifierParts", "", "problem", "Lcom/intellij/grazie/text/TextProblem;", "text", "Lcom/intellij/grazie/text/TextContent;", "isInFirstSentence", "isTodoComment", "file", "Lcom/intellij/psi/PsiFile;", "shouldIgnore", "textAround", "", "range", "Lcom/intellij/openapi/util/TextRange;", "intellij.grazie.core"})
public final class CommentProblemFilter
extends ProblemFilter {
    @Override
    public boolean shouldIgnore(@NotNull TextProblem problem) {
        Intrinsics.checkNotNullParameter((Object)problem, (String)"problem");
        TextContent textContent = problem.getText();
        Intrinsics.checkNotNullExpressionValue((Object)textContent, (String)"problem.text");
        TextContent text2 = textContent;
        TextContent.TextDomain domain = text2.getDomain();
        if (domain == TextContent.TextDomain.COMMENTS || domain == TextContent.TextDomain.DOCUMENTATION) {
            PsiFile psiFile = text2.getContainingFile();
            Intrinsics.checkNotNullExpressionValue((Object)psiFile, (String)"text.containingFile");
            if (this.isTodoComment(psiFile, text2)) {
                return true;
            }
            Rule rule = problem.getRule();
            Intrinsics.checkNotNullExpressionValue((Object)rule, (String)"problem.rule");
            String string = rule.getGlobalId();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"problem.rule.globalId");
            if (StringsKt.startsWith$default((String)string, (String)"LanguageTool.", (boolean)false, (int)2, null) && this.isAboutIdentifierParts(problem, text2)) {
                return true;
            }
            if (this.isInFirstSentence(problem) && problem.fitsGroup(new RuleGroup("INCOMPLETE_SENTENCE"))) {
                return true;
            }
        }
        if (domain == TextContent.TextDomain.COMMENTS) {
            if (problem.fitsGroup(new RuleGroup("UNDECORATED_SENTENCE_SEPARATION"))) {
                return true;
            }
            if (Text.isSingleSentence(text2) && problem.fitsGroup(RuleGroup.UNDECORATED_SINGLE_SENTENCE)) {
                return true;
            }
        }
        return false;
    }

    private final CharSequence textAround(CharSequence text2, TextRange range) {
        return text2.subSequence(RangesKt.coerceAtLeast((int)(range.getStartOffset() - 20), (int)0), RangesKt.coerceAtMost((int)(range.getEndOffset() + 20), (int)text2.length()));
    }

    private final boolean isInFirstSentence(TextProblem problem) {
        TextContent textContent = problem.getText();
        Intrinsics.checkNotNullExpressionValue((Object)textContent, (String)"problem.text");
        CharSequence charSequence = textContent;
        int n = 0;
        TextRange textRange = problem.getHighlightRanges().get(0);
        Intrinsics.checkNotNullExpressionValue((Object)textRange, (String)"problem.highlightRanges[0]");
        int n2 = textRange.getStartOffset();
        return SRXSentenceTokenizer.INSTANCE.tokenize(((Object)charSequence.subSequence(n, n2)).toString()).size() <= 1;
    }

    private final boolean isAboutIdentifierParts(TextProblem problem, TextContent text2) {
        boolean bl;
        block3: {
            List<TextRange> list = problem.getHighlightRanges();
            Intrinsics.checkNotNullExpressionValue(list, (String)"problem.highlightRanges");
            List<TextRange> ranges = list;
            Iterable $this$any$iv = ranges;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    TextRange it = (TextRange)element$iv;
                    boolean bl2 = false;
                    TextRange textRange = it;
                    Intrinsics.checkNotNullExpressionValue((Object)textRange, (String)"it");
                    if (!(StringsKt.endsWith$default((CharSequence)text2.subSequence(0, textRange.getStartOffset()), (char)'_', (boolean)false, (int)2, null) || StringsKt.startsWith$default((CharSequence)text2.subSequence(it.getEndOffset(), text2.length()), (char)'_', (boolean)false, (int)2, null))) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    private final boolean isTodoComment(PsiFile file2, TextContent text2) {
        boolean bl;
        block1: {
            TodoItem[] todoItemArray = PsiTodoSearchHelper.getInstance((Project)file2.getProject()).findTodoItems(file2);
            Intrinsics.checkNotNullExpressionValue((Object)todoItemArray, (String)"PsiTodoSearchHelper.getI\u2026ject).findTodoItems(file)");
            TodoItem[] $this$any$iv = todoItemArray;
            boolean $i$f$any = false;
            int n = $this$any$iv.length;
            for (int j = 0; j < n; ++j) {
                TodoItem element$iv;
                TodoItem it = element$iv = $this$any$iv[j];
                boolean bl2 = false;
                TodoItem todoItem = it;
                Intrinsics.checkNotNullExpressionValue((Object)todoItem, (String)"it");
                if (!text2.intersectsRange(todoItem.getTextRange())) continue;
                bl = true;
                break block1;
            }
            bl = false;
        }
        return bl;
    }
}

