/*
 * Decompiled with CFR 0.152.
 */
package com.carrotsearch.hppc;

import com.carrotsearch.hppc.BitMixer;
import com.carrotsearch.hppc.CharIntHashMap;
import com.carrotsearch.hppc.HashOrderMixing;

public class CharIntScatterMap
extends CharIntHashMap {
    public CharIntScatterMap() {
        this(4);
    }

    public CharIntScatterMap(int expectedElements) {
        this(expectedElements, 0.75);
    }

    public CharIntScatterMap(int expectedElements, double loadFactor) {
        super(expectedElements, loadFactor, HashOrderMixing.none());
    }

    @Override
    protected int hashKey(char key) {
        return BitMixer.mixPhi(key);
    }

    public static CharIntScatterMap from(char[] keys, int[] values) {
        if (keys.length != values.length) {
            throw new IllegalArgumentException("Arrays of keys and values must have an identical length.");
        }
        CharIntScatterMap map2 = new CharIntScatterMap(keys.length);
        for (int i2 = 0; i2 < keys.length; ++i2) {
            map2.put(keys[i2], values[i2]);
        }
        return map2;
    }
}

