/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.markdown.editor;

import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionProvider;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.completion.InsertHandler;
import com.intellij.codeInsight.completion.InsertionContext;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.codeInsight.lookup.LookupElementDecorator;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageUtil;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.ui.DeferredIconImpl;
import com.intellij.util.Function;
import com.intellij.util.ProcessingContext;
import java.util.Iterator;
import java.util.List;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.intellij.plugins.markdown.editor.CodeFenceLanguageListCompletionProvider;
import org.intellij.plugins.markdown.injection.CodeFenceLanguageProvider;
import org.intellij.plugins.markdown.injection.aliases.CodeFenceLanguageAliases;
import org.intellij.plugins.markdown.injection.aliases.CodeFenceLanguageGuesser;
import org.intellij.plugins.markdown.lang.MarkdownElementTypes;
import org.intellij.plugins.markdown.lang.MarkdownTokenTypes;
import org.intellij.plugins.markdown.lang.psi.util.PsiUtilsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u000b2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0002\u000b\fB\u0005\u00a2\u0006\u0002\u0010\u0003J \u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00022\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0014\u00a8\u0006\r"}, d2={"Lorg/intellij/plugins/markdown/editor/CodeFenceLanguageListCompletionProvider;", "Lcom/intellij/codeInsight/completion/CompletionProvider;", "Lcom/intellij/codeInsight/completion/CompletionParameters;", "()V", "addCompletions", "", "parameters", "context", "Lcom/intellij/util/ProcessingContext;", "result", "Lcom/intellij/codeInsight/completion/CompletionResultSet;", "Companion", "MyInsertHandler", "intellij.markdown.core"})
public final class CodeFenceLanguageListCompletionProvider
extends CompletionProvider<CompletionParameters> {
    @NotNull
    public static final Companion Companion = new Companion(null);

    protected void addCompletions(@NotNull CompletionParameters parameters, @NotNull ProcessingContext context, @NotNull CompletionResultSet result2) {
        Intrinsics.checkNotNullParameter((Object)parameters, (String)"parameters");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)result2, (String)"result");
        for (CodeFenceLanguageProvider provider : CodeFenceLanguageGuesser.INSTANCE.getCustomProviders()) {
            List<LookupElement> lookups;
            Intrinsics.checkNotNullExpressionValue(provider.getCompletionVariantsForInfoString(parameters), (String)"provider.getCompletionVa\u2026ForInfoString(parameters)");
            for (LookupElement lookupElement : lookups) {
                LookupElementDecorator element2;
                Intrinsics.checkNotNullExpressionValue((Object)LookupElementDecorator.withInsertHandler((LookupElement)lookupElement, (InsertHandler)new InsertHandler(parameters, lookupElement){
                    final /* synthetic */ CompletionParameters $parameters;
                    final /* synthetic */ LookupElement $lookupElement;

                    public final void handleInsert(@NotNull InsertionContext context, @NotNull LookupElementDecorator<LookupElement> item) {
                        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
                        Intrinsics.checkNotNullParameter(item, (String)"item");
                        new MyInsertHandler(this.$parameters).handleInsert(context, (LookupElement)item);
                        this.$lookupElement.handleInsert(context);
                    }
                    {
                        this.$parameters = completionParameters;
                        this.$lookupElement = lookupElement;
                    }
                }), (String)"LookupElementDecorator.w\u2026Insert(context)\n        }");
                result2.addElement((LookupElement)element2);
            }
        }
        Iterator<CodeFenceLanguageProvider> iterator = LanguageUtil.getInjectableLanguages().iterator();
        while (iterator.hasNext()) {
            Language language;
            LookupElement lookupElement;
            Language language2 = language = (Language)iterator.next();
            Intrinsics.checkNotNullExpressionValue((Object)language2, (String)"language");
            String string = language2.getID();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"language.id");
            String alias = CodeFenceLanguageAliases.INSTANCE.findMainAlias(string);
            Intrinsics.checkNotNullExpressionValue((Object)LookupElementBuilder.create((String)alias).withIcon(Companion.createLanguageIcon(language)).withTypeText(language.getDisplayName(), true).withInsertHandler((InsertHandler)new MyInsertHandler(parameters)), (String)"LookupElementBuilder.cre\u2026nsertHandler(parameters))");
            result2.addElement(lookupElement);
        }
    }

    @JvmStatic
    @NotNull
    public static final Icon createLanguageIcon(@NotNull Language language) {
        return Companion.createLanguageIcon(language);
    }

    @JvmStatic
    public static final boolean isInMiddleOfUnCollapsedFence(@Nullable PsiElement element2, int offset) {
        return Companion.isInMiddleOfUnCollapsedFence(element2, offset);
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0018\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0002H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lorg/intellij/plugins/markdown/editor/CodeFenceLanguageListCompletionProvider$MyInsertHandler;", "Lcom/intellij/codeInsight/completion/InsertHandler;", "Lcom/intellij/codeInsight/lookup/LookupElement;", "parameters", "Lcom/intellij/codeInsight/completion/CompletionParameters;", "(Lcom/intellij/codeInsight/completion/CompletionParameters;)V", "handleInsert", "", "context", "Lcom/intellij/codeInsight/completion/InsertionContext;", "item", "intellij.markdown.core"})
    private static final class MyInsertHandler
    implements InsertHandler<LookupElement> {
        private final CompletionParameters parameters;

        public void handleInsert(@NotNull InsertionContext context, @NotNull LookupElement item) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Intrinsics.checkNotNullParameter((Object)item, (String)"item");
            if (Companion.isInMiddleOfUnCollapsedFence(this.parameters.getOriginalPosition(), context.getStartOffset())) {
                context.getDocument().insertString(context.getTailOffset(), (CharSequence)"\n\n");
                Editor editor2 = context.getEditor();
                Intrinsics.checkNotNullExpressionValue((Object)editor2, (String)"context.editor");
                editor2.getCaretModel().moveCaretRelatively(1, 0, false, false, false);
            }
        }

        public MyInsertHandler(@NotNull CompletionParameters parameters) {
            Intrinsics.checkNotNullParameter((Object)parameters, (String)"parameters");
            this.parameters = parameters;
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0007J\u001a\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\fH\u0007\u00a8\u0006\r"}, d2={"Lorg/intellij/plugins/markdown/editor/CodeFenceLanguageListCompletionProvider$Companion;", "", "()V", "createLanguageIcon", "Ljavax/swing/Icon;", "language", "Lcom/intellij/lang/Language;", "isInMiddleOfUnCollapsedFence", "", "element", "Lcom/intellij/psi/PsiElement;", "offset", "", "intellij.markdown.core"})
    public static final class Companion {
        @JvmStatic
        @NotNull
        public final Icon createLanguageIcon(@NotNull Language language) {
            Intrinsics.checkNotNullParameter((Object)language, (String)"language");
            return (Icon)new DeferredIconImpl(null, (Object)language, true, (Function)createLanguageIcon.1.INSTANCE);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @JvmStatic
        public final boolean isInMiddleOfUnCollapsedFence(@Nullable PsiElement element2, int offset) {
            if (element2 == null) {
                return false;
            }
            IElementType iElementType = MarkdownTokenTypes.CODE_FENCE_START;
            Intrinsics.checkNotNullExpressionValue((Object)iElementType, (String)"MarkdownTokenTypes.CODE_FENCE_START");
            if (PsiUtilsKt.hasType(element2, iElementType)) {
                TextRange range;
                TextRange textRange = range = element2.getTextRange();
                Intrinsics.checkNotNullExpressionValue((Object)textRange, (String)"range");
                if (textRange.getStartOffset() + range.getEndOffset() != offset * 2) return false;
                return true;
            }
            IElementType iElementType2 = MarkdownTokenTypes.TEXT;
            Intrinsics.checkNotNullExpressionValue((Object)iElementType2, (String)"MarkdownTokenTypes.TEXT");
            if (!PsiUtilsKt.hasType(element2, iElementType2)) return false;
            PsiElement psiElement = element2.getParent();
            Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"element.parent");
            IElementType iElementType3 = MarkdownElementTypes.CODE_SPAN;
            Intrinsics.checkNotNullExpressionValue((Object)iElementType3, (String)"MarkdownElementTypes.CODE_SPAN");
            if (!PsiUtilsKt.hasType(psiElement, iElementType3)) return false;
            TextRange range = element2.getTextRange();
            PsiElement psiElement2 = element2.getParent();
            Intrinsics.checkNotNullExpressionValue((Object)psiElement2, (String)"element.parent");
            TextRange parentRange = psiElement2.getTextRange();
            TextRange textRange = range;
            Intrinsics.checkNotNullExpressionValue((Object)textRange, (String)"range");
            int n = textRange.getStartOffset();
            TextRange textRange2 = parentRange;
            Intrinsics.checkNotNullExpressionValue((Object)textRange2, (String)"parentRange");
            if (n - textRange2.getStartOffset() != parentRange.getEndOffset() - range.getEndOffset()) return false;
            return true;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

