/*
 * Decompiled with CFR 0.152.
 */
package training.featuresSuggester;

import com.intellij.lang.Language;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.event.EditorEventMulticaster;
import com.intellij.openapi.editor.ex.EditorEventMulticasterEx;
import com.intellij.openapi.editor.ex.FocusChangeListener;
import com.intellij.openapi.project.Project;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import training.featuresSuggester.FeatureSuggestersManagerListener;
import training.featuresSuggester.PopupSuggestion;
import training.featuresSuggester.SuggestingUtils;
import training.featuresSuggester.Suggestion;
import training.featuresSuggester.actions.Action;
import training.featuresSuggester.actions.EditorFocusGainedAction;
import training.featuresSuggester.settings.FeatureSuggesterSettings;
import training.featuresSuggester.statistics.FeatureSuggesterStatistics;
import training.featuresSuggester.suggesters.FeatureSuggester;
import training.featuresSuggester.ui.NotificationSuggestionPresenter;
import training.featuresSuggester.ui.SuggestionPresenter;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fJ\b\u0010\r\u001a\u00020\nH\u0016J\u0010\u0010\u000e\u001a\u00020\n2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0010\u0010\u0011\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\b\u0010\u0012\u001a\u00020\nH\u0002J\u0018\u0010\u0013\u001a\u00020\n2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u000b\u001a\u00020\fH\u0002J\f\u0010\u0016\u001a\u00020\u0017*\u00020\u0015H\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Ltraining/featuresSuggester/FeatureSuggestersManager;", "Lcom/intellij/openapi/Disposable;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "suggestionPresenter", "Ltraining/featuresSuggester/ui/SuggestionPresenter;", "actionPerformed", "", "action", "Ltraining/featuresSuggester/actions/Action;", "dispose", "fireSuggestionFound", "suggestion", "Ltraining/featuresSuggester/PopupSuggestion;", "handleAction", "initFocusListener", "processSuggester", "suggester", "Ltraining/featuresSuggester/suggesters/FeatureSuggester;", "isEnabled", "", "intellij.featuresTrainer"})
public final class FeatureSuggestersManager
implements Disposable {
    private final SuggestionPresenter suggestionPresenter;
    @NotNull
    private final Project project;

    public final void actionPerformed(@NotNull Action action2) {
        Intrinsics.checkNotNullParameter((Object)action2, (String)"action");
        try {
            this.handleAction(action2);
        }
        catch (Throwable t) {
            FeatureSuggestersManager $this$thisLogger$iv = this;
            boolean $i$f$thisLogger = false;
            Logger logger = Logger.getInstance(FeatureSuggestersManager.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"Logger.getInstance(T::class.java)");
            logger.error("An error occurred during action processing: " + action2, t);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void handleAction(Action action2) {
        void $this$filterTo$iv$iv;
        void $this$filter$iv;
        Language language = action2.getLanguage();
        if (language == null) {
            return;
        }
        Language language2 = language;
        Iterable iterable = FeatureSuggester.Companion.getSuggesters();
        boolean $i$f$filter = false;
        void var6_6 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            Object v2;
            block4: {
                Iterable iterable2;
                FeatureSuggester it = (FeatureSuggester)element$iv$iv;
                boolean bl = false;
                Iterable iterable3 = iterable2 = (Iterable)it.getLanguages();
                for (Object t : iterable3) {
                    String id = (String)t;
                    boolean bl2 = false;
                    Language language3 = Language.ANY;
                    Intrinsics.checkNotNullExpressionValue((Object)language3, (String)"Language.ANY");
                    if (!(Intrinsics.areEqual((Object)id, (Object)language3.getID()) || Intrinsics.areEqual((Object)id, (Object)language2.getID()))) continue;
                    v2 = t;
                    break block4;
                }
                v2 = null;
            }
            if (!(v2 != null)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List suggesters = (List)destination$iv$iv;
        for (FeatureSuggester suggester : suggesters) {
            if (!this.isEnabled(suggester)) continue;
            this.processSuggester(suggester, action2);
        }
    }

    private final void processSuggester(FeatureSuggester suggester, Action action2) {
        Suggestion suggestion = suggester.getSuggestion(action2);
        if (suggestion instanceof PopupSuggestion) {
            FeatureSuggesterStatistics.Companion.logSuggestionFound(suggester.getId());
            if (SuggestingUtils.INSTANCE.getForceShowSuggestions() || suggester.isSuggestionNeeded()) {
                this.suggestionPresenter.showSuggestion(this.project, (PopupSuggestion)suggestion, this);
                this.fireSuggestionFound((PopupSuggestion)suggestion);
                FeatureSuggesterSettings.Companion.instance().updateSuggestionShownTime(((PopupSuggestion)suggestion).getSuggesterId());
            }
        }
    }

    private final void fireSuggestionFound(PopupSuggestion suggestion) {
        ((FeatureSuggestersManagerListener)this.project.getMessageBus().syncPublisher(FeatureSuggestersManagerListener.Companion.getTOPIC())).featureFound(suggestion);
    }

    private final void initFocusListener() {
        block1: {
            EditorEventMulticasterEx eventMulticaster;
            EditorFactory editorFactory = EditorFactory.getInstance();
            Intrinsics.checkNotNullExpressionValue((Object)editorFactory, (String)"EditorFactory.getInstance()");
            EditorEventMulticaster editorEventMulticaster = editorFactory.getEventMulticaster();
            if (!(editorEventMulticaster instanceof EditorEventMulticasterEx)) {
                editorEventMulticaster = null;
            }
            EditorEventMulticasterEx editorEventMulticasterEx = eventMulticaster = (EditorEventMulticasterEx)editorEventMulticaster;
            if (editorEventMulticasterEx == null) break block1;
            editorEventMulticasterEx.addFocusChangeListener(new FocusChangeListener(this){
                final /* synthetic */ FeatureSuggestersManager this$0;

                public void focusGained(@NotNull Editor editor) {
                    Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
                    if (Intrinsics.areEqual((Object)editor.getProject(), (Object)this.this$0.getProject()) ^ true || !SuggestingUtils.INSTANCE.isActionsProcessingEnabled(this.this$0.getProject())) {
                        return;
                    }
                    this.this$0.actionPerformed(new EditorFocusGainedAction(editor, System.currentTimeMillis()));
                }
                {
                    this.this$0 = this$0;
                }
            }, (Disposable)this);
        }
    }

    public void dispose() {
    }

    private final boolean isEnabled(FeatureSuggester $this$isEnabled) {
        return FeatureSuggesterSettings.Companion.instance().isEnabled($this$isEnabled.getId());
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    public FeatureSuggestersManager(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        this.suggestionPresenter = new NotificationSuggestionPresenter();
        if (!this.project.isDefault()) {
            this.initFocusListener();
        }
    }
}

