/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.properties.references;

import com.intellij.lang.properties.IProperty;
import com.intellij.lang.properties.PropertiesReferenceManager;
import com.intellij.lang.properties.psi.PropertiesFile;
import com.intellij.lang.properties.references.PropertyReferenceBase;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.vfs.VirtualFile;
import it.unimi.dsi.fastutil.Hash;
import it.unimi.dsi.fastutil.objects.ObjectOpenCustomHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.jetbrains.annotations.Nullable;

public final class PropertiesPsiCompletionUtil {
    public static void addVariantsFromFile(PropertyReferenceBase propertyReference, PropertiesFile propertiesFile, Set<Object> variants) {
        if (propertiesFile == null) {
            return;
        }
        VirtualFile virtualFile = propertiesFile.getVirtualFile();
        if (virtualFile == null || !ProjectRootManager.getInstance((Project)propertiesFile.getProject()).getFileIndex().isInContent(virtualFile)) {
            return;
        }
        List<IProperty> properties = propertiesFile.getProperties();
        for (IProperty property : properties) {
            propertyReference.addKey(property, variants);
        }
    }

    static Set<Object> getPropertiesKeys(PropertyReferenceBase propertyReference) {
        ObjectOpenCustomHashSet variants = new ObjectOpenCustomHashSet((Hash.Strategy)new Hash.Strategy<Object>(){

            public int hashCode(@Nullable Object object) {
                if (object instanceof IProperty) {
                    String key = ((IProperty)object).getKey();
                    return key == null ? 0 : key.hashCode();
                }
                return 0;
            }

            public boolean equals(@Nullable Object o1, @Nullable Object o2) {
                if (o1 == o2) {
                    return true;
                }
                return o1 instanceof IProperty && o2 instanceof IProperty && Objects.equals(((IProperty)o1).getKey(), ((IProperty)o2).getKey());
            }
        });
        List<PropertiesFile> propertiesFileList = propertyReference.getPropertiesFiles();
        if (propertiesFileList == null) {
            PropertiesReferenceManager.getInstance(propertyReference.getElement().getProject()).processAllPropertiesFiles((arg_0, arg_1) -> PropertiesPsiCompletionUtil.lambda$getPropertiesKeys$0(propertyReference, (Set)variants, arg_0, arg_1));
        } else {
            for (PropertiesFile propFile : propertiesFileList) {
                PropertiesPsiCompletionUtil.addVariantsFromFile(propertyReference, propFile, (Set<Object>)variants);
            }
        }
        return variants;
    }

    private static /* synthetic */ boolean lambda$getPropertiesKeys$0(PropertyReferenceBase propertyReference, Set variants, String baseName, PropertiesFile propertiesFile) {
        PropertiesPsiCompletionUtil.addVariantsFromFile(propertyReference, propertiesFile, variants);
        return true;
    }
}

