/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.owl.model.entity;

import java.util.Stack;
import org.protege.editor.owl.model.entity.AbstractIDGenerator;
import org.protege.editor.owl.model.entity.AutoIDException;
import org.protege.editor.owl.model.entity.EntityCreationPreferences;
import org.protege.editor.owl.model.entity.Revertable;
import org.semanticweb.owlapi.model.OWLEntity;

public class IterativeAutoIDGenerator
extends AbstractIDGenerator
implements Revertable {
    private long previousStartId;
    private long id;
    private Stack<Long> checkpoints = new Stack();

    public IterativeAutoIDGenerator() {
        this.previousStartId = this.id = (long)EntityCreationPreferences.getAutoIDStart();
    }

    @Override
    protected long getRawID(Class<? extends OWLEntity> type) throws AutoIDException {
        long end;
        if (this.previousStartId != (long)EntityCreationPreferences.getAutoIDStart()) {
            this.previousStartId = this.id = (long)EntityCreationPreferences.getAutoIDStart();
            this.checkpoints.removeAllElements();
            this.checkpoints.push(this.id);
        }
        if ((end = (long)EntityCreationPreferences.getAutoIDEnd()) != -1L && this.id > end) {
            throw new AutoIDException("You have run out of IDs for creating new entities - max = " + end);
        }
        if (EntityCreationPreferences.getSaveAutoIDStart()) {
            this.previousStartId = this.id + 1L;
            EntityCreationPreferences.setAutoIDStart((int)this.previousStartId);
        }
        return this.id++;
    }

    @Override
    public void checkpoint() {
        this.checkpoints.push(this.id);
    }

    @Override
    public void revert() {
        this.id = this.checkpoints.pop();
    }
}

