#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name:                 postgrest
version:              10.0.0
visibility:           public
id:                   postgrest-10.0.0-49EGrI3FWyIE3b9Xr4qZQK
key:                  postgrest-10.0.0-49EGrI3FWyIE3b9Xr4qZQK
license:              MIT
maintainer:           Steve Chavez <stevechavezast@gmail.com>
author:               Joe Nelson, Adam Baker, Steve Chavez
homepage:             https://postgrest.org
synopsis:             REST API for any Postgres database
description:
    Reads the schema of a PostgreSQL database and creates RESTful routes
    for tables, views, and functions, supporting all HTTP methods that security
    permits.

category:             Executable, PostgreSQL, Network APIs
abi:                  932497489df34b21a58b4fd061127690
exposed:              True
exposed-modules:
    PostgREST.Admin PostgREST.App PostgREST.AppState PostgREST.Auth
    PostgREST.CLI PostgREST.Config PostgREST.Config.Database
    PostgREST.Config.JSPath PostgREST.Config.PgVersion
    PostgREST.Config.Proxy PostgREST.Cors PostgREST.DbStructure
    PostgREST.DbStructure.Identifiers PostgREST.DbStructure.Proc
    PostgREST.DbStructure.Relationship PostgREST.DbStructure.Table
    PostgREST.Error PostgREST.GucHeader PostgREST.Logger
    PostgREST.MediaType PostgREST.Middleware PostgREST.OpenAPI
    PostgREST.Query.QueryBuilder PostgREST.Query.SqlFragment
    PostgREST.Query.Statements PostgREST.RangeQuery
    PostgREST.Request.ApiRequest PostgREST.Request.DbRequestBuilder
    PostgREST.Request.MutateQuery PostgREST.Request.Preferences
    PostgREST.Request.QueryParams PostgREST.Request.ReadQuery
    PostgREST.Request.Types PostgREST.Unix PostgREST.Version
    PostgREST.Workers

hidden-modules:       Paths_postgrest
import-dirs:          /usr/lib/ghc-9.0.2/site-local/postgrest-10.0.0
library-dirs:         /usr/lib/ghc-9.0.2/site-local/postgrest-10.0.0
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/postgrest
hs-libraries:         HSpostgrest-10.0.0-49EGrI3FWyIE3b9Xr4qZQK
depends:
    HTTP-4000.4.1-6XmgHAvKbTq50Nzeqdrv4P
    Ranged-sets-0.4.0-6wgOeAMARKx9UmxqcXpNb8
    aeson-2.1.0.0-3wSqLBA0fU13NhfXDmBpwT
    auto-update-0.1.6-9cQ3mPjkW1cBpQ3u2XrW6e base-4.15.1.0
    base64-bytestring-1.2.1.0-iG6YBGhLkRJagBsFqRAI2
    bytestring-0.10.12.1
    case-insensitive-1.2.1.0-9P0gl8mW2it6Cg0EClpHns
    cassava-0.5.3.0-HVRt9Yganpl4Iw2TRL91p
    configurator-pg-0.2.7-A2HBiqHMmpnJ0FTkjARBWA containers-0.6.4.1
    contravariant-extras-0.3.5.3-BGlPAAS49KHDJXTGlRLp3u
    cookie-0.4.5-B1GcTZOCb6yBzxFcoqFiFA directory-1.3.6.2
    either-5.0.2-CESQcB8iry59WM5GQWasBQ
    gitrev-1.3.1-1rbGTqrAtYS9ErCWqXvHZK
    hasql-1.5.0.4-8duhy22wZmW90v3JUTLLQO
    hasql-dynamic-statements-0.3.1-44Ca1cnxwfY3C2jFLfiXu0
    hasql-notifications-0.2.0.2-Hk8vfQvuiDkHP1dRAMQEJ9
    hasql-pool-0.5.2.2-4w6rICnWOht1Ei9zmVYhtZ
    hasql-transaction-1.0.1.1-66NTNFC4nohI7DhLnSU8UX
    heredoc-0.2.0.0-Vg50v7MniO6qfzQgR2euT
    http-types-0.12.3-L4VBkj9wBbpJhmiMCXrA05
    insert-ordered-containers-0.2.5.1-C3ubsjbphwUCYJw9UpPheu
    interpolatedstring-perl6-1.0.2-IDdp33wh4iA8FWAWwNOQoP
    jose-0.10-9kOJHSpKcVAHBC9N2Efo1m lens-5.1.1-8cVW77ucFRGIbO4yMEfpoM
    lens-aeson-1.2.2-JjCTfn87rOf53dCRTsG2uW mtl-2.2.2
    network-3.1.2.7-2x6X3kWddA03AmOITnySLy
    network-uri-2.6.4.1-CJy9K6CUGBYDMBcoIm8TMq
    optparse-applicative-0.17.0.0-5RAB8jXJau3LDHQVpRHOkD
    parsec-3.1.14.0 protolude-0.3.2-LjK5I3273sj7mcDH0jeZSp
    regex-tdfa-1.3.2-tNtR2SpOBLAbbzDX5vBu9
    retry-0.9.3.0-7i7QjWnu7kf2D2GMXsL0fh
    scientific-0.3.7.0-1l3L5iYBn9JD8GP8kLjgG7
    swagger2-2.8.6-Ln8NQuEatBP9UMxP0oeK3e text-1.2.5.0 time-1.9.3
    unix-2.7.2.2 unordered-containers-0.2.19.1-1t66PwyRMuzEgWVME6Xx4r
    vault-0.3.1.5-1kdlyNQeV32LWrYpRe1Io8
    vector-0.13.0.0-80dNWv5W93FGfZf7Ao5mAf
    wai-3.2.3-4BBvzsOByYiKnH9wzG1k6K
    wai-cors-0.2.7-GpfAcJbR0DQ3CKtE5ncD1W
    wai-extra-3.1.12.1-9ZhhaouWVJ9KdcrPtBJdXj
    wai-logger-2.4.0-D0lovsK5AjG9QhHoHMMSeA
    warp-3.3.23-5zUSWgy73EuKtltSqCMIpH

haddock-interfaces:   /usr/share/doc/postgrest/html/postgrest.haddock
haddock-html:         /usr/share/doc/postgrest/html
' | '/usr/bin/ghc-pkg' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

