/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.style;

import net.sourceforge.plantuml.SkinParam;
import net.sourceforge.plantuml.TitledDiagram;
import net.sourceforge.plantuml.command.BlocLines;
import net.sourceforge.plantuml.command.CommandExecutionResult;
import net.sourceforge.plantuml.command.CommandMultilines2;
import net.sourceforge.plantuml.command.MultilinesStrategy;
import net.sourceforge.plantuml.command.regex.IRegex;
import net.sourceforge.plantuml.command.regex.RegexConcat;
import net.sourceforge.plantuml.command.regex.RegexLeaf;
import net.sourceforge.plantuml.style.NoStyleAvailableException;
import net.sourceforge.plantuml.style.Style;
import net.sourceforge.plantuml.style.StyleBuilder;
import net.sourceforge.plantuml.style.StyleLoader;

public class CommandStyleMultilinesCSS
extends CommandMultilines2<TitledDiagram> {
    public CommandStyleMultilinesCSS() {
        super(CommandStyleMultilinesCSS.getRegexConcat(), MultilinesStrategy.REMOVE_STARTING_QUOTE);
    }

    @Override
    public String getPatternEnd() {
        return "^[%s]*\\</style\\>[%s]*$";
    }

    private static IRegex getRegexConcat() {
        return RegexConcat.build(CommandStyleMultilinesCSS.class.getName(), RegexLeaf.start(), new RegexLeaf("\\<style\\>"), RegexLeaf.end());
    }

    @Override
    protected CommandExecutionResult executeNow(TitledDiagram diagram, BlocLines lines) {
        try {
            StyleBuilder styleBuilder = diagram.getSkinParam().getCurrentStyleBuilder();
            for (Style modifiedStyle : StyleLoader.getDeclaredStyles(lines.subExtract(1, 1), styleBuilder)) {
                diagram.getSkinParam().muteStyle(modifiedStyle);
            }
            ((SkinParam)diagram.getSkinParam()).applyPendingStyleMigration();
            return CommandExecutionResult.ok();
        }
        catch (NoStyleAvailableException e) {
            return CommandExecutionResult.error("General failure: no style available.");
        }
    }
}

