/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.statediagram.command;

import net.sourceforge.plantuml.Direction;
import net.sourceforge.plantuml.LineLocation;
import net.sourceforge.plantuml.StringUtils;
import net.sourceforge.plantuml.UmlDiagramType;
import net.sourceforge.plantuml.command.CommandExecutionResult;
import net.sourceforge.plantuml.command.SingleLineCommand2;
import net.sourceforge.plantuml.command.regex.IRegex;
import net.sourceforge.plantuml.command.regex.RegexLeaf;
import net.sourceforge.plantuml.command.regex.RegexResult;
import net.sourceforge.plantuml.cucadiagram.Code;
import net.sourceforge.plantuml.cucadiagram.Display;
import net.sourceforge.plantuml.cucadiagram.IEntity;
import net.sourceforge.plantuml.cucadiagram.Ident;
import net.sourceforge.plantuml.cucadiagram.LeafType;
import net.sourceforge.plantuml.cucadiagram.Link;
import net.sourceforge.plantuml.cucadiagram.LinkDecor;
import net.sourceforge.plantuml.cucadiagram.LinkType;
import net.sourceforge.plantuml.cucadiagram.Stereotype;
import net.sourceforge.plantuml.graphic.color.ColorType;
import net.sourceforge.plantuml.statediagram.StateDiagram;
import net.sourceforge.plantuml.ugraphic.color.NoSuchColorException;

abstract class CommandLinkStateCommon
extends SingleLineCommand2<StateDiagram> {
    CommandLinkStateCommon(IRegex pattern) {
        super(pattern);
    }

    protected static RegexLeaf getStatePattern(String name) {
        return new RegexLeaf(name, "([%pLN_.:]+|[%pLN_.:]+\\[H\\*?\\]|\\[\\*\\]|\\[H\\*?\\]|(?:==+)(?:[%pLN_.:]+)(?:==+))[%s]*(\\<\\<.*\\>\\>)?[%s]*(#\\w+)?");
    }

    @Override
    protected CommandExecutionResult executeArg(StateDiagram diagram, LineLocation location, RegexResult arg) throws NoSuchColorException {
        String s;
        String ent1 = arg.get("ENT1", 0);
        String ent2 = arg.get("ENT2", 0);
        IEntity cl1 = this.getEntityStart(diagram, ent1);
        if (cl1 == null) {
            return CommandExecutionResult.error("The state " + ent1 + " has been created in a concurrent state : it cannot be used here.");
        }
        IEntity cl2 = this.getEntityEnd(diagram, ent2);
        if (cl2 == null) {
            return CommandExecutionResult.error("The state " + ent2 + " has been created in a concurrent state : it cannot be used here.");
        }
        if (arg.get("ENT1", 1) != null) {
            cl1.setStereotype(Stereotype.build(arg.get("ENT1", 1)));
        }
        if (arg.get("ENT1", 2) != null) {
            s = arg.get("ENT1", 2);
            cl1.setSpecificColorTOBEREMOVED(ColorType.BACK, diagram.getSkinParam().getIHtmlColorSet().getColor(diagram.getSkinParam().getThemeStyle(), s));
        }
        if (arg.get("ENT2", 1) != null) {
            cl2.setStereotype(Stereotype.build(arg.get("ENT2", 1)));
        }
        if (arg.get("ENT2", 2) != null) {
            s = arg.get("ENT2", 2);
            cl2.setSpecificColorTOBEREMOVED(ColorType.BACK, diagram.getSkinParam().getIHtmlColorSet().getColor(diagram.getSkinParam().getThemeStyle(), s));
        }
        String queue = arg.get("ARROW_BODY1", 0) + arg.get("ARROW_BODY2", 0);
        Direction dir = this.getDirection(arg);
        if (dir == Direction.LEFT || dir == Direction.RIGHT) {
            queue = "-";
        }
        int lenght = queue.length();
        boolean crossStart = arg.get("ARROW_CROSS_START", 0) != null;
        boolean circleEnd = arg.get("ARROW_CIRCLE_END", 0) != null;
        LinkType linkType = new LinkType(circleEnd ? LinkDecor.ARROW_AND_CIRCLE : LinkDecor.ARROW, crossStart ? LinkDecor.CIRCLE_CROSS : LinkDecor.NONE);
        Display label = Display.getWithNewlines(arg.get("LABEL", 0));
        Link link = new Link(diagram.getSkinParam().getCurrentStyleBuilder(), cl1, cl2, linkType, label, lenght);
        if (dir == Direction.LEFT || dir == Direction.UP) {
            link = link.getInv();
        }
        link.applyStyle(diagram.getSkinParam().getThemeStyle(), arg.getLazzy("ARROW_STYLE", 0));
        link.setUmlDiagramType(UmlDiagramType.STATE);
        diagram.addLink(link);
        return CommandExecutionResult.ok();
    }

    private Direction getDirection(RegexResult arg) {
        String arrowDirection = arg.get("ARROW_DIRECTION", 0);
        if (arrowDirection != null) {
            return StringUtils.getQueueDirection(arrowDirection);
        }
        return this.getDefaultDirection();
    }

    protected Direction getDefaultDirection() {
        return null;
    }

    private IEntity getEntityStart(StateDiagram diagram, String codeString) {
        if (codeString.startsWith("[*]")) {
            return diagram.getStart();
        }
        return this.getFoo1(diagram, codeString);
    }

    private IEntity getEntityEnd(StateDiagram diagram, String codeString) {
        if (codeString.startsWith("[*]")) {
            return diagram.getEnd();
        }
        return this.getFoo1(diagram, codeString);
    }

    private IEntity getFoo1(StateDiagram diagram, String codeString) {
        Ident code;
        if (codeString.equalsIgnoreCase("[H]")) {
            return diagram.getHistorical();
        }
        if (codeString.endsWith("[H]")) {
            return diagram.getHistorical(codeString.substring(0, codeString.length() - 3));
        }
        if (codeString.equalsIgnoreCase("[H*]")) {
            return diagram.getDeepHistory();
        }
        if (codeString.endsWith("[H*]")) {
            return diagram.getDeepHistory(codeString.substring(0, codeString.length() - 4));
        }
        if (codeString.startsWith("=") && codeString.endsWith("=")) {
            String codeString1 = this.removeEquals(codeString);
            Ident ident1 = diagram.buildLeafIdent(codeString1);
            Ident code1 = diagram.V1972() ? ident1 : diagram.buildCode(codeString1);
            return diagram.getOrCreateLeaf(ident1, code1, LeafType.SYNCHRO_BAR, null);
        }
        Ident ident = diagram.buildLeafIdent(codeString);
        Code code2 = code = diagram.V1972() ? ident : diagram.buildCode(codeString);
        if (!diagram.checkConcurrentStateOk(ident, code)) {
            return null;
        }
        return diagram.getOrCreateLeaf(ident, code, null, null);
    }

    private String removeEquals(String code) {
        while (code.startsWith("=")) {
            code = code.substring(1);
        }
        while (code.endsWith("=")) {
            code = code.substring(0, code.length() - 1);
        }
        return code;
    }
}

