/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.ppl.parser;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.antlr.v4.runtime.ParserRuleContext;
import org.antlr.v4.runtime.RuleContext;
import org.antlr.v4.runtime.tree.ParseTree;
import org.opensearch.sql.ast.dsl.AstDSL;
import org.opensearch.sql.ast.expression.AggregateFunction;
import org.opensearch.sql.ast.expression.Alias;
import org.opensearch.sql.ast.expression.AllFields;
import org.opensearch.sql.ast.expression.And;
import org.opensearch.sql.ast.expression.Argument;
import org.opensearch.sql.ast.expression.Cast;
import org.opensearch.sql.ast.expression.Compare;
import org.opensearch.sql.ast.expression.DataType;
import org.opensearch.sql.ast.expression.Field;
import org.opensearch.sql.ast.expression.Function;
import org.opensearch.sql.ast.expression.In;
import org.opensearch.sql.ast.expression.Interval;
import org.opensearch.sql.ast.expression.IntervalUnit;
import org.opensearch.sql.ast.expression.Let;
import org.opensearch.sql.ast.expression.Literal;
import org.opensearch.sql.ast.expression.Not;
import org.opensearch.sql.ast.expression.Or;
import org.opensearch.sql.ast.expression.QualifiedName;
import org.opensearch.sql.ast.expression.RelevanceFieldList;
import org.opensearch.sql.ast.expression.Span;
import org.opensearch.sql.ast.expression.SpanUnit;
import org.opensearch.sql.ast.expression.UnresolvedArgument;
import org.opensearch.sql.ast.expression.UnresolvedExpression;
import org.opensearch.sql.ast.expression.Xor;
import org.opensearch.sql.common.utils.StringUtils;
import org.opensearch.sql.expression.function.BuiltinFunctionName;
import org.opensearch.sql.ppl.antlr.parser.OpenSearchPPLParser;
import org.opensearch.sql.ppl.antlr.parser.OpenSearchPPLParserBaseVisitor;
import org.opensearch.sql.ppl.utils.ArgumentFactory;

public class AstExpressionBuilder
extends OpenSearchPPLParserBaseVisitor<UnresolvedExpression> {
    private static Map<String, String> FUNCTION_NAME_MAPPING = new ImmutableMap.Builder().put((Object)"isnull", (Object)BuiltinFunctionName.IS_NULL.getName().getFunctionName()).put((Object)"isnotnull", (Object)BuiltinFunctionName.IS_NOT_NULL.getName().getFunctionName()).build();

    @Override
    public UnresolvedExpression visitEvalClause(OpenSearchPPLParser.EvalClauseContext ctx) {
        return new Let((Field)this.visit((ParseTree)ctx.fieldExpression()), (UnresolvedExpression)this.visit((ParseTree)ctx.expression()));
    }

    @Override
    public UnresolvedExpression visitLogicalNot(OpenSearchPPLParser.LogicalNotContext ctx) {
        return new Not((UnresolvedExpression)this.visit((ParseTree)ctx.logicalExpression()));
    }

    @Override
    public UnresolvedExpression visitLogicalOr(OpenSearchPPLParser.LogicalOrContext ctx) {
        return new Or((UnresolvedExpression)this.visit((ParseTree)ctx.left), (UnresolvedExpression)this.visit((ParseTree)ctx.right));
    }

    @Override
    public UnresolvedExpression visitLogicalAnd(OpenSearchPPLParser.LogicalAndContext ctx) {
        return new And((UnresolvedExpression)this.visit((ParseTree)ctx.left), (UnresolvedExpression)this.visit((ParseTree)ctx.right));
    }

    @Override
    public UnresolvedExpression visitLogicalXor(OpenSearchPPLParser.LogicalXorContext ctx) {
        return new Xor((UnresolvedExpression)this.visit((ParseTree)ctx.left), (UnresolvedExpression)this.visit((ParseTree)ctx.right));
    }

    @Override
    public UnresolvedExpression visitCompareExpr(OpenSearchPPLParser.CompareExprContext ctx) {
        return new Compare(ctx.comparisonOperator().getText(), (UnresolvedExpression)this.visit((ParseTree)ctx.left), (UnresolvedExpression)this.visit((ParseTree)ctx.right));
    }

    @Override
    public UnresolvedExpression visitInExpr(OpenSearchPPLParser.InExprContext ctx) {
        return new In((UnresolvedExpression)this.visit((ParseTree)ctx.valueExpression()), ctx.valueList().literalValue().stream().map(this::visitLiteralValue).collect(Collectors.toList()));
    }

    @Override
    public UnresolvedExpression visitBinaryArithmetic(OpenSearchPPLParser.BinaryArithmeticContext ctx) {
        return new Function(ctx.binaryOperator().getText(), Arrays.asList((UnresolvedExpression)this.visit((ParseTree)ctx.left), (UnresolvedExpression)this.visit((ParseTree)ctx.right)));
    }

    @Override
    public UnresolvedExpression visitParentheticBinaryArithmetic(OpenSearchPPLParser.ParentheticBinaryArithmeticContext ctx) {
        return new Function(ctx.binaryOperator().getText(), Arrays.asList((UnresolvedExpression)this.visit((ParseTree)ctx.left), (UnresolvedExpression)this.visit((ParseTree)ctx.right)));
    }

    @Override
    public UnresolvedExpression visitFieldExpression(OpenSearchPPLParser.FieldExpressionContext ctx) {
        return new Field((UnresolvedExpression)((QualifiedName)this.visit((ParseTree)ctx.qualifiedName())));
    }

    @Override
    public UnresolvedExpression visitWcFieldExpression(OpenSearchPPLParser.WcFieldExpressionContext ctx) {
        return new Field((UnresolvedExpression)((QualifiedName)this.visit((ParseTree)ctx.wcQualifiedName())));
    }

    @Override
    public UnresolvedExpression visitSortField(OpenSearchPPLParser.SortFieldContext ctx) {
        return new Field((UnresolvedExpression)AstDSL.qualifiedName((String[])new String[]{ctx.sortFieldExpression().fieldExpression().getText()}), ArgumentFactory.getArgumentList(ctx));
    }

    @Override
    public UnresolvedExpression visitStatsFunctionCall(OpenSearchPPLParser.StatsFunctionCallContext ctx) {
        return new AggregateFunction(ctx.statsFunctionName().getText(), (UnresolvedExpression)this.visit((ParseTree)ctx.valueExpression()));
    }

    @Override
    public UnresolvedExpression visitCountAllFunctionCall(OpenSearchPPLParser.CountAllFunctionCallContext ctx) {
        return new AggregateFunction("count", (UnresolvedExpression)AllFields.of());
    }

    @Override
    public UnresolvedExpression visitDistinctCountFunctionCall(OpenSearchPPLParser.DistinctCountFunctionCallContext ctx) {
        return new AggregateFunction("count", (UnresolvedExpression)this.visit((ParseTree)ctx.valueExpression()), Boolean.valueOf(true));
    }

    @Override
    public UnresolvedExpression visitPercentileAggFunction(OpenSearchPPLParser.PercentileAggFunctionContext ctx) {
        return new AggregateFunction(ctx.PERCENTILE().getText(), (UnresolvedExpression)this.visit((ParseTree)ctx.aggField), Collections.singletonList(new Argument("rank", (Literal)this.visit((ParseTree)ctx.value))));
    }

    @Override
    public UnresolvedExpression visitBooleanFunctionCall(OpenSearchPPLParser.BooleanFunctionCallContext ctx) {
        String functionName = ctx.conditionFunctionBase().getText();
        return new Function(FUNCTION_NAME_MAPPING.getOrDefault(functionName, functionName), ctx.functionArgs().functionArg().stream().map(this::visitFunctionArg).collect(Collectors.toList()));
    }

    @Override
    public UnresolvedExpression visitEvalFunctionCall(OpenSearchPPLParser.EvalFunctionCallContext ctx) {
        return new Function(ctx.evalFunctionName().getText(), ctx.functionArgs().functionArg().stream().map(this::visitFunctionArg).collect(Collectors.toList()));
    }

    @Override
    public UnresolvedExpression visitDataTypeFunctionCall(OpenSearchPPLParser.DataTypeFunctionCallContext ctx) {
        return new Cast((UnresolvedExpression)this.visit((ParseTree)ctx.expression()), (UnresolvedExpression)this.visit((ParseTree)ctx.convertedDataType()));
    }

    @Override
    public UnresolvedExpression visitConvertedDataType(OpenSearchPPLParser.ConvertedDataTypeContext ctx) {
        return AstDSL.stringLiteral((String)ctx.getText());
    }

    @Override
    public UnresolvedExpression visitSingleFieldRelevanceFunction(OpenSearchPPLParser.SingleFieldRelevanceFunctionContext ctx) {
        return new Function(ctx.singleFieldRelevanceFunctionName().getText().toLowerCase(), this.singleFieldRelevanceArguments(ctx));
    }

    @Override
    public UnresolvedExpression visitMultiFieldRelevanceFunction(OpenSearchPPLParser.MultiFieldRelevanceFunctionContext ctx) {
        return new Function(ctx.multiFieldRelevanceFunctionName().getText().toLowerCase(), this.multiFieldRelevanceArguments(ctx));
    }

    @Override
    public UnresolvedExpression visitTableSource(OpenSearchPPLParser.TableSourceContext ctx) {
        return this.visitIdentifiers(Arrays.asList(ctx));
    }

    @Override
    public UnresolvedExpression visitIdentsAsQualifiedName(OpenSearchPPLParser.IdentsAsQualifiedNameContext ctx) {
        return this.visitIdentifiers(ctx.ident());
    }

    @Override
    public UnresolvedExpression visitIdentsAsWildcardQualifiedName(OpenSearchPPLParser.IdentsAsWildcardQualifiedNameContext ctx) {
        return this.visitIdentifiers(ctx.wildcard());
    }

    @Override
    public UnresolvedExpression visitIntervalLiteral(OpenSearchPPLParser.IntervalLiteralContext ctx) {
        return new Interval((UnresolvedExpression)this.visit((ParseTree)ctx.valueExpression()), IntervalUnit.of((String)ctx.intervalUnit().getText()));
    }

    @Override
    public UnresolvedExpression visitStringLiteral(OpenSearchPPLParser.StringLiteralContext ctx) {
        return new Literal((Object)StringUtils.unquoteText((String)ctx.getText()), DataType.STRING);
    }

    @Override
    public UnresolvedExpression visitIntegerLiteral(OpenSearchPPLParser.IntegerLiteralContext ctx) {
        long number = Long.parseLong(ctx.getText());
        if (Integer.MIN_VALUE <= number && number <= Integer.MAX_VALUE) {
            return new Literal((Object)((int)number), DataType.INTEGER);
        }
        return new Literal((Object)number, DataType.LONG);
    }

    @Override
    public UnresolvedExpression visitDecimalLiteral(OpenSearchPPLParser.DecimalLiteralContext ctx) {
        return new Literal((Object)Double.valueOf(ctx.getText()), DataType.DOUBLE);
    }

    @Override
    public UnresolvedExpression visitBooleanLiteral(OpenSearchPPLParser.BooleanLiteralContext ctx) {
        return new Literal((Object)Boolean.valueOf(ctx.getText()), DataType.BOOLEAN);
    }

    @Override
    public UnresolvedExpression visitBySpanClause(OpenSearchPPLParser.BySpanClauseContext ctx) {
        String name = ctx.spanClause().getText();
        return ctx.alias != null ? new Alias(name, (UnresolvedExpression)this.visit((ParseTree)ctx.spanClause()), StringUtils.unquoteIdentifier((String)ctx.alias.getText())) : new Alias(name, (UnresolvedExpression)this.visit((ParseTree)ctx.spanClause()));
    }

    @Override
    public UnresolvedExpression visitSpanClause(OpenSearchPPLParser.SpanClauseContext ctx) {
        String unit = ctx.unit != null ? ctx.unit.getText() : "";
        return new Span((UnresolvedExpression)this.visit((ParseTree)ctx.fieldExpression()), (UnresolvedExpression)this.visit((ParseTree)ctx.value), SpanUnit.of((String)unit));
    }

    private QualifiedName visitIdentifiers(List<? extends ParserRuleContext> ctx) {
        return new QualifiedName((Iterable)ctx.stream().map(RuleContext::getText).map(StringUtils::unquoteIdentifier).collect(Collectors.toList()));
    }

    private List<UnresolvedExpression> singleFieldRelevanceArguments(OpenSearchPPLParser.SingleFieldRelevanceFunctionContext ctx) {
        ImmutableList.Builder builder = ImmutableList.builder();
        builder.add((Object)new UnresolvedArgument("field", (UnresolvedExpression)new Literal((Object)StringUtils.unquoteText((String)ctx.field.getText()), DataType.STRING)));
        builder.add((Object)new UnresolvedArgument("query", (UnresolvedExpression)new Literal((Object)StringUtils.unquoteText((String)ctx.query.getText()), DataType.STRING)));
        ctx.relevanceArg().forEach(v -> builder.add((Object)new UnresolvedArgument(v.relevanceArgName().getText().toLowerCase(), (UnresolvedExpression)new Literal((Object)StringUtils.unquoteText((String)v.relevanceArgValue().getText()), DataType.STRING))));
        return builder.build();
    }

    private List<UnresolvedExpression> multiFieldRelevanceArguments(OpenSearchPPLParser.MultiFieldRelevanceFunctionContext ctx) {
        ImmutableList.Builder builder = ImmutableList.builder();
        RelevanceFieldList fields = new RelevanceFieldList(ctx.getRuleContexts(OpenSearchPPLParser.RelevanceFieldAndWeightContext.class).stream().collect(Collectors.toMap(f -> StringUtils.unquoteText((String)f.field.getText()), f -> Float.valueOf(f.weight == null ? 1.0f : Float.parseFloat(f.weight.getText())))));
        builder.add((Object)new UnresolvedArgument("fields", (UnresolvedExpression)fields));
        builder.add((Object)new UnresolvedArgument("query", (UnresolvedExpression)new Literal((Object)StringUtils.unquoteText((String)ctx.query.getText()), DataType.STRING)));
        ctx.relevanceArg().forEach(v -> builder.add((Object)new UnresolvedArgument(v.relevanceArgName().getText().toLowerCase(), (UnresolvedExpression)new Literal((Object)StringUtils.unquoteText((String)v.relevanceArgValue().getText()), DataType.STRING))));
        return builder.build();
    }
}

