/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.opensearch.storage.script.filter.lucene.relevance;

import java.util.HashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiFunction;
import lombok.Generated;
import org.opensearch.index.query.QueryBuilder;
import org.opensearch.sql.common.antlr.SyntaxCheckException;
import org.opensearch.sql.data.model.ExprValue;
import org.opensearch.sql.exception.SemanticCheckException;
import org.opensearch.sql.expression.FunctionExpression;
import org.opensearch.sql.expression.NamedArgumentExpression;
import org.opensearch.sql.opensearch.storage.script.filter.lucene.LuceneQuery;

public abstract class RelevanceQuery<T extends QueryBuilder>
extends LuceneQuery {
    private final Map<String, QueryBuilderStep<T>> queryBuildActions;

    @Override
    public QueryBuilder build(FunctionExpression func) {
        List arguments = func.getArguments();
        if (arguments.size() < 2) {
            throw new SyntaxCheckException(String.format("%s requires at least two parameters", this.getQueryName()));
        }
        NamedArgumentExpression field = (NamedArgumentExpression)arguments.get(0);
        NamedArgumentExpression query = (NamedArgumentExpression)arguments.get(1);
        T queryBuilder = this.createQueryBuilder(field, query);
        ListIterator iterator = arguments.listIterator(2);
        HashSet<String> visitedParms = new HashSet<String>();
        while (iterator.hasNext()) {
            NamedArgumentExpression arg = (NamedArgumentExpression)iterator.next();
            String argNormalized = arg.getArgName().toLowerCase();
            if (visitedParms.contains(argNormalized)) {
                throw new SemanticCheckException(String.format("Parameter '%s' can only be specified once.", argNormalized));
            }
            visitedParms.add(argNormalized);
            if (!this.queryBuildActions.containsKey(argNormalized)) {
                throw new SemanticCheckException(String.format("Parameter %s is invalid for %s function.", argNormalized, queryBuilder.getWriteableName()));
            }
            Objects.requireNonNull(this.queryBuildActions.get(argNormalized)).apply(queryBuilder, arg.getValue().valueOf(null));
        }
        return queryBuilder;
    }

    protected abstract T createQueryBuilder(NamedArgumentExpression var1, NamedArgumentExpression var2);

    protected abstract String getQueryName();

    public static String valueOfToUpper(ExprValue v) {
        return v.stringValue().toUpperCase();
    }

    public static String valueOfToLower(ExprValue v) {
        return v.stringValue().toLowerCase();
    }

    @Generated
    public RelevanceQuery(Map<String, QueryBuilderStep<T>> queryBuildActions) {
        this.queryBuildActions = queryBuildActions;
    }

    protected static interface QueryBuilderStep<T extends QueryBuilder>
    extends BiFunction<T, ExprValue, T> {
    }
}

