/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.utils;

import lombok.Generated;

public final class SystemIndexUtils {
    private static final String SYS_TABLES_PREFIX = "_ODFE_SYS_TABLE";
    private static final String SYS_META_PREFIX = "_ODFE_SYS_TABLE_META";
    private static final String SYS_MAPPINGS_PREFIX = "_ODFE_SYS_TABLE_MAPPINGS";
    public static final String TABLE_INFO = "_ODFE_SYS_TABLE_META.ALL";

    public static Boolean isSystemIndex(String indexName) {
        return indexName.startsWith(SYS_TABLES_PREFIX);
    }

    public static String mappingTable(String indexName) {
        return String.join((CharSequence)".", SYS_MAPPINGS_PREFIX, indexName);
    }

    public static SystemTable systemTable(String indexName) {
        int lastDot = indexName.indexOf(".");
        String prefix = indexName.substring(0, lastDot);
        String tableName = indexName.substring(lastDot + 1).replace("%", "*");
        if (prefix.equalsIgnoreCase(SYS_META_PREFIX)) {
            return new SystemInfoTable(tableName);
        }
        if (prefix.equalsIgnoreCase(SYS_MAPPINGS_PREFIX)) {
            return new MetaInfoTable(tableName);
        }
        throw new IllegalStateException("Invalid system index name: " + indexName);
    }

    @Generated
    private SystemIndexUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    public static class MetaInfoTable
    implements SystemTable {
        private final String tableName;

        @Override
        public boolean isMetaInfoTable() {
            return true;
        }

        @Override
        @Generated
        public String getTableName() {
            return this.tableName;
        }

        @Generated
        public MetaInfoTable(String tableName) {
            this.tableName = tableName;
        }
    }

    public static class SystemInfoTable
    implements SystemTable {
        private final String tableName;

        @Override
        public boolean isSystemInfoTable() {
            return true;
        }

        @Override
        @Generated
        public String getTableName() {
            return this.tableName;
        }

        @Generated
        public SystemInfoTable(String tableName) {
            this.tableName = tableName;
        }
    }

    public static interface SystemTable {
        public String getTableName();

        default public boolean isSystemInfoTable() {
            return false;
        }

        default public boolean isMetaInfoTable() {
            return false;
        }
    }
}

