/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.expression.operator.predicate;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.lang3.tuple.Pair;
import org.opensearch.sql.data.model.ExprBooleanValue;
import org.opensearch.sql.data.model.ExprValue;
import org.opensearch.sql.data.model.ExprValueUtils;
import org.opensearch.sql.data.type.ExprCoreType;
import org.opensearch.sql.expression.function.BuiltinFunctionName;
import org.opensearch.sql.expression.function.BuiltinFunctionRepository;
import org.opensearch.sql.expression.function.DefaultFunctionResolver;
import org.opensearch.sql.expression.function.FunctionBuilder;
import org.opensearch.sql.expression.function.FunctionDSL;
import org.opensearch.sql.expression.function.FunctionName;
import org.opensearch.sql.expression.function.FunctionSignature;
import org.opensearch.sql.expression.function.SerializableFunction;

public final class UnaryPredicateOperator {
    public static void register(BuiltinFunctionRepository repository) {
        repository.register(UnaryPredicateOperator.not());
        repository.register(UnaryPredicateOperator.isNotNull());
        repository.register(UnaryPredicateOperator.ifNull());
        repository.register(UnaryPredicateOperator.nullIf());
        repository.register(UnaryPredicateOperator.isNull(BuiltinFunctionName.IS_NULL));
        repository.register(UnaryPredicateOperator.isNull(BuiltinFunctionName.ISNULL));
        repository.register(UnaryPredicateOperator.ifFunction());
    }

    private static DefaultFunctionResolver not() {
        return FunctionDSL.define(BuiltinFunctionName.NOT.getName(), FunctionDSL.impl(UnaryPredicateOperator::not, ExprCoreType.BOOLEAN, ExprCoreType.BOOLEAN));
    }

    public static ExprValue not(ExprValue v) {
        if (v.isMissing() || v.isNull()) {
            return v;
        }
        return ExprBooleanValue.of(v.booleanValue() == false);
    }

    private static DefaultFunctionResolver isNull(BuiltinFunctionName funcName) {
        return FunctionDSL.define(funcName.getName(), Arrays.stream(ExprCoreType.values()).map(type -> FunctionDSL.impl(v -> ExprBooleanValue.of(v.isNull()), ExprCoreType.BOOLEAN, type)).collect(Collectors.toList()));
    }

    private static DefaultFunctionResolver isNotNull() {
        return FunctionDSL.define(BuiltinFunctionName.IS_NOT_NULL.getName(), Arrays.stream(ExprCoreType.values()).map(type -> FunctionDSL.impl(v -> ExprBooleanValue.of(!v.isNull()), ExprCoreType.BOOLEAN, type)).collect(Collectors.toList()));
    }

    private static DefaultFunctionResolver ifFunction() {
        FunctionName functionName = BuiltinFunctionName.IF.getName();
        List<ExprCoreType> typeList = ExprCoreType.coreTypes();
        List<SerializableFunction<FunctionName, Pair<FunctionSignature, FunctionBuilder>>> functionsOne = typeList.stream().map(v -> FunctionDSL.impl(UnaryPredicateOperator::exprIf, v, ExprCoreType.BOOLEAN, v, v)).collect(Collectors.toList());
        DefaultFunctionResolver functionResolver = FunctionDSL.define(functionName, functionsOne);
        return functionResolver;
    }

    private static DefaultFunctionResolver ifNull() {
        FunctionName functionName = BuiltinFunctionName.IFNULL.getName();
        List<ExprCoreType> typeList = ExprCoreType.coreTypes();
        List<SerializableFunction<FunctionName, Pair<FunctionSignature, FunctionBuilder>>> functionsOne = typeList.stream().map(v -> FunctionDSL.impl(UnaryPredicateOperator::exprIfNull, v, v, v)).collect(Collectors.toList());
        DefaultFunctionResolver functionResolver = FunctionDSL.define(functionName, functionsOne);
        return functionResolver;
    }

    private static DefaultFunctionResolver nullIf() {
        FunctionName functionName = BuiltinFunctionName.NULLIF.getName();
        List<ExprCoreType> typeList = ExprCoreType.coreTypes();
        DefaultFunctionResolver functionResolver = FunctionDSL.define(functionName, typeList.stream().map(v -> FunctionDSL.impl(UnaryPredicateOperator::exprNullIf, v, v, v)).collect(Collectors.toList()));
        return functionResolver;
    }

    public static ExprValue exprIfNull(ExprValue v1, ExprValue v2) {
        return v1.isNull() || v1.isMissing() ? v2 : v1;
    }

    public static ExprValue exprNullIf(ExprValue v1, ExprValue v2) {
        return v1.equals(v2) ? ExprValueUtils.LITERAL_NULL : v1;
    }

    public static ExprValue exprIf(ExprValue v1, ExprValue v2, ExprValue v3) {
        return !v1.isNull() && !v1.isMissing() && ExprValueUtils.LITERAL_TRUE.equals(v1) ? v2 : v3;
    }

    @Generated
    private UnaryPredicateOperator() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

