/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.analysis.symbol;

import java.util.Collections;
import java.util.EnumMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Optional;
import java.util.TreeMap;
import org.opensearch.sql.analysis.symbol.Namespace;
import org.opensearch.sql.analysis.symbol.Symbol;
import org.opensearch.sql.data.type.ExprType;

public class SymbolTable {
    private Map<Namespace, NavigableMap<String, ExprType>> tableByNamespace = new EnumMap<Namespace, NavigableMap<String, ExprType>>(Namespace.class);
    private Map<Namespace, LinkedHashMap<String, ExprType>> orderedTable = new EnumMap<Namespace, LinkedHashMap<String, ExprType>>(Namespace.class);

    public void store(Symbol symbol, ExprType type) {
        this.tableByNamespace.computeIfAbsent(symbol.getNamespace(), ns -> new TreeMap()).put(symbol.getName(), type);
        this.orderedTable.computeIfAbsent(symbol.getNamespace(), ns -> new LinkedHashMap()).put(symbol.getName(), type);
    }

    public void remove(Symbol symbol) {
        this.tableByNamespace.computeIfPresent(symbol.getNamespace(), (k, v) -> {
            v.remove(symbol.getName());
            return v;
        });
        this.orderedTable.computeIfPresent(symbol.getNamespace(), (k, v) -> {
            v.remove(symbol.getName());
            return v;
        });
    }

    public Optional<ExprType> lookup(Symbol symbol) {
        Map table = this.tableByNamespace.get((Object)symbol.getNamespace());
        ExprType type = null;
        if (table != null) {
            type = (ExprType)table.get(symbol.getName());
        }
        return Optional.ofNullable(type);
    }

    public Map<String, ExprType> lookupByPrefix(Symbol prefix) {
        NavigableMap<String, ExprType> table = this.tableByNamespace.get((Object)prefix.getNamespace());
        if (table != null) {
            return table.subMap(prefix.getName(), prefix.getName() + "\uffff");
        }
        return Collections.emptyMap();
    }

    public Map<String, ExprType> lookupAllFields(Namespace namespace) {
        LinkedHashMap allSymbols = this.orderedTable.getOrDefault((Object)namespace, new LinkedHashMap());
        LinkedHashMap<String, ExprType> results = new LinkedHashMap<String, ExprType>();
        allSymbols.entrySet().stream().filter(entry -> {
            String symbolName = (String)entry.getKey();
            int lastDot = symbolName.lastIndexOf(".");
            return -1 == lastDot || !allSymbols.containsKey(symbolName.substring(0, lastDot));
        }).forEach(entry -> results.put((String)entry.getKey(), (ExprType)entry.getValue()));
        return results;
    }

    public boolean isEmpty(Namespace namespace) {
        return this.tableByNamespace.getOrDefault((Object)namespace, Collections.emptyNavigableMap()).isEmpty();
    }
}

