/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.performanceanalyzer.rca.net.tasks;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.performanceanalyzer.PerformanceAnalyzerApp;
import org.opensearch.performanceanalyzer.grpc.FlowUnitMessage;
import org.opensearch.performanceanalyzer.rca.framework.metrics.RcaGraphMetrics;
import org.opensearch.performanceanalyzer.rca.framework.util.InstanceDetails;
import org.opensearch.performanceanalyzer.rca.net.NodeStateManager;
import org.opensearch.performanceanalyzer.rca.net.ReceivedFlowUnitStore;

public class FlowUnitRxTask
implements Runnable {
    private static final Logger LOG = LogManager.getLogger(FlowUnitRxTask.class);
    private final NodeStateManager nodeStateManager;
    private final ReceivedFlowUnitStore receivedFlowUnitStore;
    private final FlowUnitMessage flowUnitMessage;

    public FlowUnitRxTask(NodeStateManager nodeStateManager, ReceivedFlowUnitStore receivedFlowUnitStore, FlowUnitMessage flowUnitMessage) {
        this.nodeStateManager = nodeStateManager;
        this.receivedFlowUnitStore = receivedFlowUnitStore;
        this.flowUnitMessage = flowUnitMessage;
    }

    @Override
    public void run() {
        InstanceDetails.Id host = new InstanceDetails.Id(this.flowUnitMessage.getNode());
        String vertex = this.flowUnitMessage.getGraphNode();
        this.nodeStateManager.updateReceiveTime(host, vertex, System.currentTimeMillis());
        LOG.debug("rca: [pub-rx]: {} <- {}", (Object)vertex, (Object)host);
        if (!this.receivedFlowUnitStore.enqueue(vertex, this.flowUnitMessage)) {
            LOG.warn("Dropped a flow unit because the vertex buffer was full for vertex: {}", (Object)vertex);
        }
        PerformanceAnalyzerApp.RCA_GRAPH_METRICS_AGGREGATOR.updateStat(RcaGraphMetrics.RCA_NODES_FU_CONSUME_COUNT, vertex, 1);
    }
}

